/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.extraction;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextPane;
import jd.controlling.TaskQueue;
import jd.controlling.packagecontroller.AbstractPackageNode;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import org.appwork.swing.MigPanel;
import org.appwork.uio.UIOManager;
import org.appwork.uio.UserIODefinition;
import org.appwork.utils.BinaryLogic;
import org.appwork.utils.StringUtils;
import org.appwork.utils.event.DefaultEvent;
import org.appwork.utils.event.queue.QueueAction;
import org.appwork.utils.formatter.SizeFormatter;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.swing.SwingUtils;
import org.appwork.utils.swing.dialog.InputDialog;
import org.jdownloader.controlling.FileCreationEvent;
import org.jdownloader.controlling.FileCreationManager;
import org.jdownloader.extensions.extraction.Archive;
import org.jdownloader.extensions.extraction.ArchiveFile;
import org.jdownloader.extensions.extraction.ArchiveLinkStructure;
import org.jdownloader.extensions.extraction.CFG_EXTRACTION;
import org.jdownloader.extensions.extraction.ExtractPasswordDialogInterface;
import org.jdownloader.extensions.extraction.ExtractionConfig;
import org.jdownloader.extensions.extraction.ExtractionController;
import org.jdownloader.extensions.extraction.ExtractionEvent;
import org.jdownloader.extensions.extraction.ExtractionException;
import org.jdownloader.extensions.extraction.ExtractionExtension;
import org.jdownloader.extensions.extraction.ExtractionListener;
import org.jdownloader.extensions.extraction.ExtractionStatus;
import org.jdownloader.extensions.extraction.bindings.downloadlink.DownloadLinkArchiveFile;
import org.jdownloader.extensions.extraction.translate.T;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.downloads.table.DownloadsTableModel;
import org.jdownloader.images.NewTheme;

public class ExtractionListenerList
implements ExtractionListener {
    private final ExtractionExtension ex;
    private final Color green = Color.GREEN.darker();
    private final Color yellow = Color.YELLOW.darker();

    protected ExtractionListenerList() {
        this.ex = ExtractionExtension.getInstance();
    }

    private void setStatus(ExtractionController controller, Archive archive, ExtractionStatus status) {
        for (ArchiveFile archiveFile : archive.getArchiveFiles()) {
            archiveFile.setStatus(controller, status);
        }
    }

    private void setMessage(ExtractionController controller, Archive archive, String message) {
        for (ArchiveFile archiveFile : archive.getArchiveFiles()) {
            archiveFile.setMessage(controller, message);
        }
    }

    private void setProgress(ExtractionController controller, Archive archive, long value, long max, Color color) {
        for (ArchiveFile archiveFile : archive.getArchiveFiles()) {
            archiveFile.setProgress(controller, value, max, color);
        }
    }

    private void removePluginProgress(ExtractionController controller, Archive archive) {
        for (ArchiveFile archiveFile : archive.getArchiveFiles()) {
            archiveFile.removePluginProgress(controller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onExtractionEvent(ExtractionEvent event) {
        ExtractionController controller = (ExtractionController)((Object)event.getCaller());
        LogSource logger = controller.getLogger();
        Archive currentArchive = controller.getArchive();
        Archive rootArchive = currentArchive.getRootArchive();
        switch ((ExtractionEvent.Type)((Object)event.getType())) {
            case QUEUED: {
                this.setStatus(controller, rootArchive, ExtractionStatus.IDLE);
                this.setMessage(controller, rootArchive, T.T.plugins_optional_extraction_status_queued());
                break;
            }
            case EXTRACTION_FAILED: {
                logger.warning("Extraction failed");
                this.setStatus(controller, rootArchive, ExtractionStatus.ERROR);
                String errorMsg = T.T.failed_no_details();
                ArchiveFile lastAccessArchiveFile = null;
                if (controller.getException() != null) {
                    errorMsg = T.T.failed(controller.getException().getMessage());
                    if (controller.getException() instanceof ExtractionException) {
                        lastAccessArchiveFile = ((ExtractionException)controller.getException()).getLatestAccessedArchiveFile();
                    }
                }
                if (currentArchive == rootArchive) {
                    for (ArchiveFile archiveFile : currentArchive.getArchiveFiles()) {
                        if (lastAccessArchiveFile != null && lastAccessArchiveFile == archiveFile) {
                            lastAccessArchiveFile.setStatus(controller, ExtractionStatus.ERROR_CRC);
                            continue;
                        }
                        if (currentArchive.getCrcError().contains(archiveFile)) {
                            archiveFile.setStatus(controller, ExtractionStatus.ERROR_CRC);
                            continue;
                        }
                        archiveFile.setMessage(controller, errorMsg);
                    }
                } else {
                    for (ArchiveFile archiveFile : rootArchive.getArchiveFiles()) {
                        archiveFile.setMessage(controller, errorMsg);
                    }
                }
                this.cleanupIncompleteExtraction(controller, currentArchive);
                break;
            }
            case PASSWORD_NEEDED_TO_CONTINUE: {
                if (!((ExtractionConfig)this.ex.getSettings()).isAskForUnknownPasswordsEnabled() && !controller.isAskForUnknownPassword()) break;
                ExtractPasswordDialog id = new ExtractPasswordDialog(4, T.T.ask_for_password(), T.T.plugins_optional_extraction_askForPassword2(), "", NewTheme.I().getIcon("rar", 32), null, null, controller);
                String pass = ((ExtractPasswordDialogInterface)UIOManager.I().show(ExtractPasswordDialogInterface.class, (UserIODefinition)id)).getText();
                if (StringUtils.isEmpty((String)pass)) {
                    this.setStatus(controller, rootArchive, ExtractionStatus.ERROR_PW);
                    break;
                }
                currentArchive.setFinalPassword(pass);
                break;
            }
            case START_CRACK_PASSWORD: {
                try {
                    this.setMessage(controller, rootArchive, T.T.plugins_optional_extraction_status_crackingpass_progress((double)(10000 * controller.getCrackProgress() / Math.max(1, controller.getPasswordListSize())) / 100.0));
                }
                catch (Throwable e) {
                    this.setMessage(controller, rootArchive, T.T.plugins_optional_extraction_status_crackingpass_progress(0.0));
                }
                break;
            }
            case START: {
                this.setStatus(controller, rootArchive, ExtractionStatus.RUNNING);
                break;
            }
            case OPEN_ARCHIVE_SUCCESS: {
                break;
            }
            case PASSWORD_FOUND: {
                this.setMessage(controller, rootArchive, T.T.plugins_optional_extraction_status_passfound());
                this.setProgress(controller, rootArchive, 0L, 0L, this.green);
                break;
            }
            case PASSWORT_CRACKING: {
                int x = controller.getCrackProgress();
                int y = Math.max(1, controller.getPasswordListSize());
                try {
                    this.setMessage(controller, rootArchive, T.T.plugins_optional_extraction_status_crackingpass_progress((double)(10000 * x / y) / 100.0));
                }
                catch (Throwable e) {
                    this.setMessage(controller, rootArchive, T.T.plugins_optional_extraction_status_crackingpass_progress(0.0));
                }
                this.setProgress(controller, rootArchive, x, y, this.yellow);
                break;
            }
            case EXTRACTING: {
                switch (controller.getIOModeForCrcHashing()) {
                    case PAUSE: {
                        this.setMessage(controller, rootArchive, T.T.plugins_optional_extraction_status_pausedForOtherCrc());
                        break;
                    }
                    default: {
                        this.setMessage(controller, rootArchive, T.T.plugins_optional_extraction_status_extracting2());
                    }
                }
                this.setProgress(controller, rootArchive, controller.getProcessedBytes(), controller.getCompleteBytes(), this.green);
                break;
            }
            case EXTRACTION_FAILED_CRC: {
                logger.warning("Extraction failed(CRC)");
                this.setStatus(controller, rootArchive, ExtractionStatus.ERROR);
                if (currentArchive == rootArchive) {
                    if (currentArchive.getCrcError().size() != 0) {
                        for (ArchiveFile archiveFile : currentArchive.getCrcError()) {
                            archiveFile.setStatus(controller, ExtractionStatus.ERROR_CRC);
                        }
                    } else {
                        String message = T.T.plugins_optional_extraction_error_extrfailedcrc();
                        for (ArchiveFile archiveFile : currentArchive.getArchiveFiles()) {
                            archiveFile.setMessage(controller, message);
                        }
                    }
                } else {
                    String message = T.T.plugins_optional_extraction_error_extrfailedcrc();
                    for (ArchiveFile archiveFile : rootArchive.getArchiveFiles()) {
                        archiveFile.setMessage(controller, message);
                    }
                }
                this.cleanupIncompleteExtraction(controller, currentArchive);
                break;
            }
            case FINISHED: {
                File fileOutput;
                File infoFiles;
                this.setStatus(controller, rootArchive, ExtractionStatus.SUCCESSFUL);
                ArrayList<File> files = new ArrayList<File>(currentArchive.getExtractedFiles());
                files.addAll(currentArchive.getSkippedFiles());
                FileCreationManager.getInstance().getEventSender().fireEvent((DefaultEvent)new FileCreationEvent((Object)controller, FileCreationEvent.Type.NEW_FILES, files.toArray(new File[files.size()])));
                if (!((ExtractionConfig)this.ex.getSettings()).isDeleteInfoFilesAfterExtraction() || currentArchive.getArchiveType() == null || !currentArchive.getArchiveType().name().startsWith("RAR") || !(infoFiles = new File((fileOutput = new File(currentArchive.getArchiveFiles().get(0).getFilePath())).getParentFile(), fileOutput.getName().replaceFirst("(?i)(\\.pa?r?t?\\.?[0-9]+\\.rar|\\.rar)$", "") + ".info")).exists() || !infoFiles.delete()) break;
                logger.info(infoFiles.getName() + " removed");
                break;
            }
            case NOT_ENOUGH_SPACE: {
                this.setStatus(controller, rootArchive, ExtractionStatus.ERROR_NOT_ENOUGH_SPACE);
                break;
            }
            case CLEANUP: {
                try {
                    logger.warning("Cleanup");
                    if (controller.gotKilled()) {
                        this.setStatus(controller, rootArchive, null);
                        this.cleanupIncompleteExtraction(controller, currentArchive);
                    }
                    this.removePluginProgress(controller, rootArchive);
                }
                catch (Throwable throwable) {
                    this.removePluginProgress(controller, rootArchive);
                    if (controller.gotKilled()) {
                        this.setStatus(controller, rootArchive, null);
                    } else if (controller.isSuccessful()) {
                        for (ArchiveFile archiveLink : currentArchive.getArchiveFiles()) {
                            archiveLink.onCleanedUp(controller);
                        }
                        controller.removeArchiveFiles();
                    }
                    throw throwable;
                }
                if (controller.gotKilled()) {
                    this.setStatus(controller, rootArchive, null);
                    break;
                }
                if (!controller.isSuccessful()) break;
                for (ArchiveFile archiveLink : currentArchive.getArchiveFiles()) {
                    archiveLink.onCleanedUp(controller);
                }
                controller.removeArchiveFiles();
                break;
            }
            case FILE_NOT_FOUND: {
                logger.warning("FileNotFound");
                if (currentArchive.getCrcError().size() != 0) {
                    this.setStatus(controller, rootArchive, ExtractionStatus.ERROR_CRC);
                } else if (currentArchive.getMissingFiles().size() > 0) {
                    this.setStatus(controller, rootArchive, ExtractionStatus.ERRROR_FILE_NOT_FOUND);
                } else {
                    this.setStatus(controller, rootArchive, ExtractionStatus.ERROR);
                }
                this.cleanupIncompleteExtraction(controller, currentArchive);
            }
        }
    }

    private void cleanupIncompleteExtraction(ExtractionController controller, Archive archive) {
        LogSource logger = controller.getLogger();
        for (File extractedFile : archive.getExtractedFiles()) {
            if (!extractedFile.exists()) continue;
            if (!FileCreationManager.getInstance().delete(extractedFile, null)) {
                logger.warning("Could not delete file " + extractedFile.getAbsolutePath());
                continue;
            }
            logger.warning("Deleted file " + extractedFile.getAbsolutePath());
        }
    }

    public static final class ExtractPasswordDialog
    extends InputDialog
    implements ExtractPasswordDialogInterface {
        private final ExtractionController controller;

        public ExtractPasswordDialog(int flag, String title, String message, String defaultMessage, Icon icon, String okOption, String cancelOption, ExtractionController controller) {
            super(flag, title, message, defaultMessage, icon, okOption, cancelOption);
            this.controller = controller;
            this.setTimeout(Math.max(1000, CFG_EXTRACTION.CFG.getAskForPasswordDialogTimeoutInMS()));
        }

        protected String createReturnValue() {
            return super.createReturnValue();
        }

        public boolean isCountdownPausable() {
            return false;
        }

        public JComponent layoutDialogContent() {
            MigPanel p = new MigPanel("ins 0,wrap 1", "[]", "[][]");
            if (!StringUtils.isEmpty((String)this.message)) {
                this.textField = new JTextPane(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public boolean getScrollableTracksViewportWidth() {
                        return !BinaryLogic.containsAll((int)ExtractPasswordDialog.this.flagMask, (int[])new int[]{64});
                    }

                    @Override
                    public boolean getScrollableTracksViewportHeight() {
                        return true;
                    }
                };
                Font font = this.textField.getFont();
                this.textField.setContentType("text/plain");
                this.textField.setFont(font);
                this.textField.setText(this.message);
                this.textField.setEditable(false);
                this.textField.setBackground(null);
                this.textField.setOpaque(false);
                this.textField.putClientProperty("Synthetica.opaque", Boolean.FALSE);
                this.textField.setCaretPosition(0);
                p.add((Component)this.textField, "pushx, growx");
                this.textField.setPreferredSize(this.textField.getPreferredSize());
            }
            try {
                p.add((Component)SwingUtils.toBold((JLabel)new JLabel(_GUI.T.ExtractionListenerList_layoutDialogContent_archivename())), "split 2,sizegroup left,alignx left");
                p.add(this.leftLabel(this.controller.getArchive().getName()));
                p.add((Component)SwingUtils.toBold((JLabel)new JLabel(_GUI.T.ExtractionListenerList_layoutDialogContent_filename())), "split 2,sizegroup left,alignx left");
                p.add(this.leftLabel(this.controller.getArchive().getArchiveFiles().get(0).getName()));
                p.add((Component)SwingUtils.toBold((JLabel)new JLabel(_GUI.T.IfFileExistsDialog_layoutDialogContent_filesize2())), "split 2,sizegroup left,alignx left");
                long archiveSize = 0L;
                for (ArchiveFile af : this.controller.getArchive().getArchiveFiles()) {
                    archiveSize += Math.max(0L, af.getFileSize());
                }
                p.add(this.leftLabel(SizeFormatter.formatBytes((long)archiveSize)));
                for (ArchiveFile archiveFile : this.controller.getArchive().getRootArchive().getArchiveFiles()) {
                    FilePackage parentNode;
                    if (!(archiveFile instanceof DownloadLinkArchiveFile) || FilePackage.isDefaultFilePackage((AbstractPackageNode)(parentNode = ((DownloadLinkArchiveFile)archiveFile).getDownloadLinks().get(0).getParentNode()))) continue;
                    p.add((Component)SwingUtils.toBold((JLabel)new JLabel(_GUI.T.IfFileExistsDialog_layoutDialogContent_package())), "split 2,sizegroup left,alignx left");
                    p.add(this.leftLabel(parentNode.getName()));
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.input = this.getSmallInputComponent();
            this.input.setText(this.defaultMessage);
            p.add((Component)SwingUtils.toBold((JLabel)new JLabel(_GUI.T.ExtractionListenerList_layoutDialogContent_password())), "split 2,sizegroup left,alignx left");
            p.add((Component)((JComponent)this.input), "w 450,pushx,growx");
            this.getDialog().addWindowFocusListener(new WindowFocusListener(){

                @Override
                public void windowLostFocus(WindowEvent e) {
                }

                @Override
                public void windowGainedFocus(WindowEvent e) {
                    TaskQueue.getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

                        protected Void run() throws RuntimeException {
                            ArrayList<DownloadLink> selection = new ArrayList<DownloadLink>();
                            for (ArchiveFile faf : ExtractPasswordDialog.this.controller.getArchive().getRootArchive().getArchiveFiles()) {
                                if (!(faf instanceof DownloadLinkArchiveFile)) continue;
                                selection.addAll(((DownloadLinkArchiveFile)faf).getDownloadLinks());
                            }
                            DownloadsTableModel.getInstance().setSelectedObjects(selection);
                            return null;
                        }
                    });
                }
            });
            return p;
        }

        private Component leftLabel(String name) {
            JLabel ret = new JLabel(name);
            ret.setHorizontalAlignment(2);
            return ret;
        }

        protected void packed() {
            super.packed();
        }

        public Dialog.ModalityType getModalityType() {
            return Dialog.ModalityType.MODELESS;
        }

        @Override
        public String getArchiveName() {
            return this.controller.getArchive().getName();
        }

        @Override
        public ArchiveLinkStructure getArchiveLinkIds() {
            ArchiveLinkStructure ret = new ArchiveLinkStructure();
            ArrayList<long[]> allFiles = new ArrayList<long[]>();
            for (ArchiveFile archiveFile : this.controller.getArchive().getRootArchive().getArchiveFiles()) {
                if (!(archiveFile instanceof DownloadLinkArchiveFile)) continue;
                List<DownloadLink> downloadLinks = ((DownloadLinkArchiveFile)archiveFile).getDownloadLinks();
                long[] array = new long[downloadLinks.size()];
                for (int i = 0; i < downloadLinks.size(); ++i) {
                    DownloadLink downloadLink = downloadLinks.get(i);
                    array[i] = downloadLink.getUniqueID().getID();
                }
                allFiles.add(array);
            }
            ret.setAllFiles((long[][])allFiles.toArray((T[])new long[0][]));
            ret.setFirstFile((long[])allFiles.get(0));
            return ret;
        }
    }
}

