/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.extraction;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.regex.Pattern;
import org.appwork.utils.Application;
import org.appwork.utils.IO;
import org.appwork.utils.Regex;
import org.jdownloader.extensions.extraction.Signature;
import org.jdownloader.logging.LogController;

public class FileSignatures {
    private final Signature SIG_TXT = new Signature("TXTfile", null, "Plaintext", ".*\\.(txt|doc|nfo|html|htm|xml)");
    private volatile Signature[] SIGNATURES;

    public static String readFileSignature(File f) throws IOException {
        return FileSignatures.readFileSignature(f, 10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileSignature(File f, int length) throws IOException {
        FileInputStream reader = null;
        try {
            StringBuilder sig = new StringBuilder();
            if (length > 0 && f.exists()) {
                int h;
                reader = new FileInputStream(f);
                for (int i = 0; i < length && (h = reader.read()) != -1; ++i) {
                    String s = Integer.toHexString(h);
                    if (s.length() < 2) {
                        sig.append('0');
                    }
                    sig.append(s);
                }
            }
            String string = sig.toString();
            return string;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Signature[] getSignatureList() {
        if (this.SIGNATURES != null) {
            return this.SIGNATURES;
        }
        FileSignatures fileSignatures = this;
        synchronized (fileSignatures) {
            String[] mimes;
            if (this.SIGNATURES != null) {
                return this.SIGNATURES;
            }
            try {
                mimes = Regex.getLines((String)IO.readURLToString((URL)Application.getRessourceURL((String)"org/jdownloader/extensions/extraction/mime.type")));
            }
            catch (IOException e1) {
                LogController.CL().log((Throwable)e1);
                return new Signature[0];
            }
            Signature[] ret = new Signature[mimes.length];
            int i = 0;
            for (String mime : mimes) {
                String[] entry = mime.split(":::");
                if (entry.length >= 5) {
                    ret[i++] = new Signature(entry[0], entry[1], entry[2], entry[3], entry[4]);
                    continue;
                }
                if (entry.length >= 4) {
                    ret[i++] = new Signature(entry[0], entry[1], entry[2], entry[3]);
                    continue;
                }
                LogController.CL().warning("Signature " + mime + " invalid!");
            }
            this.SIGNATURES = ret;
        }
        return this.SIGNATURES;
    }

    public Signature getSignature(CharSequence sig) {
        if (sig != null) {
            Signature[] db;
            for (Signature entry : db = this.getSignatureList()) {
                if (entry == null || !entry.matches(sig)) continue;
                return entry;
            }
            return this.checkTxt(sig);
        }
        return null;
    }

    public Signature getSignature(CharSequence signature, String fileName) {
        if (signature != null) {
            Signature[] db;
            if (fileName == null) {
                return this.getSignature(signature);
            }
            Signature ret = null;
            for (Signature sig : db = this.getSignatureList()) {
                if (sig == null || !sig.matches(signature)) continue;
                Pattern extensionSure = sig.getExtensionSure();
                Pattern extensionUnSure = sig.getExtensionUnsure();
                if (extensionSure != null && extensionSure.matcher(fileName).matches()) {
                    return sig;
                }
                if (extensionUnSure == null || !extensionUnSure.matcher(fileName).matches()) continue;
                ret = sig;
            }
            if (ret == null) {
                return this.checkTxt(signature);
            }
            return ret;
        }
        return null;
    }

    private Signature checkTxt(CharSequence sig) {
        for (int i = 0; i < sig.length(); i += 2) {
            if (i + 2 > sig.length()) {
                return null;
            }
            CharSequence b = sig.subSequence(i, i + 2);
            int ch = Integer.parseInt(b.toString(), 16);
            if (ch >= 32 && ch <= 126) continue;
            return null;
        }
        return this.SIG_TXT;
    }
}

