/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.extraction.bindings.crawledlink;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledPackage;
import jd.controlling.packagecontroller.AbstractNode;
import jd.plugins.PluginForHost;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.ModifyLock;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.appwork.utils.os.CrossSystem;
import org.jdownloader.extensions.extraction.Archive;
import org.jdownloader.extensions.extraction.ArchiveFactory;
import org.jdownloader.extensions.extraction.ArchiveFile;
import org.jdownloader.extensions.extraction.BooleanStatus;
import org.jdownloader.extensions.extraction.bindings.crawledlink.CrawledLinkArchiveFile;
import org.jdownloader.extensions.extraction.bindings.file.FileArchiveFactory;
import org.jdownloader.extensions.extraction.multi.ArchiveType;
import org.jdownloader.extensions.extraction.split.SplitType;
import org.jdownloader.gui.views.components.packagetable.LinkTreeUtils;
import org.jdownloader.settings.GeneralSettings;

public class CrawledLinkFactory
extends CrawledLinkArchiveFile
implements ArchiveFactory {
    public CrawledLinkFactory(CrawledLink l) {
        super(l);
    }

    private CrawledLink getFirstPart() {
        return this.getLinks().get(0);
    }

    @Override
    public boolean isDeepExtraction() {
        return false;
    }

    private static CrawledLink getFirstCrawledLink(Archive archive) {
        for (ArchiveFile af : archive.getArchiveFiles()) {
            if (!(af instanceof CrawledLinkArchiveFile)) continue;
            return ((CrawledLinkArchiveFile)af).getLinks().get(0);
        }
        throw new WTFException("Archive should always have at least one link");
    }

    protected String modifyPartFilePattern(String pattern) {
        HashSet<Character> unsafeChars = new HashSet<Character>();
        for (CrawledLink crawledLink : this.getLinks()) {
            char[] fileNameReplaceMap;
            PluginForHost defaultPlugin = crawledLink.gethPlugin();
            if (defaultPlugin == null || (fileNameReplaceMap = defaultPlugin.getFilenameReplaceMap()) == null) continue;
            for (char replace : fileNameReplaceMap) {
                unsafeChars.add(Character.valueOf(replace));
            }
        }
        if (unsafeChars.size() > 0) {
            String fileNamePattern;
            String filePathPattern = new Regex(pattern, "\\^\\\\Q(.*?)\\\\E").getMatch(0);
            File filePath = new File(filePathPattern);
            String modifiedFilaNamePattern = fileNamePattern = filePath.getName();
            Object object = unsafeChars.iterator();
            while (object.hasNext()) {
                Character unsafeChar = (Character)object.next();
                modifiedFilaNamePattern = modifiedFilaNamePattern.replace(unsafeChar.toString(), "\\\\E.\\\\Q");
            }
            modifiedFilaNamePattern = modifiedFilaNamePattern.replace("$", "\\$");
            String modifiedFilePathPattern = filePathPattern.replaceFirst(Pattern.quote(fileNamePattern) + "$", modifiedFilaNamePattern);
            String ret = pattern.replace("^\\Q" + filePathPattern + "\\E", "^\\Q" + modifiedFilePathPattern + "\\E");
            return ret;
        }
        return pattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ArchiveFile> createPartFileList(String file, String archivePartFilePattern) {
        String pattern = this.modifyPartFilePattern(archivePartFilePattern);
        Pattern pat = Pattern.compile(pattern, CrossSystem.isWindows() ? 2 : 0);
        CrawledPackage parentNode = this.getFirstPart().getParentNode();
        if (parentNode == null) {
            ArrayList<ArchiveFile> ret = new ArrayList<ArchiveFile>();
            ret.add(this);
            return ret;
        }
        HashMap<String, ArchiveFile> map = new HashMap<String, ArchiveFile>();
        ModifyLock modifyLock = parentNode.getModifyLock();
        boolean readL = modifyLock.readLock();
        try {
            for (CrawledLink link : parentNode.getChildren()) {
                String linkName = link.getName();
                if (!pat.matcher(linkName).matches()) continue;
                CrawledLinkArchiveFile af = (CrawledLinkArchiveFile)map.get(linkName);
                if (af == null) {
                    af = new CrawledLinkArchiveFile(link);
                    map.put(linkName, af);
                    continue;
                }
                af.addMirror(link);
            }
        }
        finally {
            modifyLock.readUnlock(readL);
        }
        File directory = LinkTreeUtils.getDownloadDirectory((AbstractNode)parentNode);
        if (directory != null) {
            List<ArchiveFile> localFiles = new FileArchiveFactory(directory).createPartFileList(file, pattern);
            for (ArchiveFile localFile : localFiles) {
                ArchiveFile archiveFile = (ArchiveFile)map.get(localFile.getName());
                if (archiveFile == null) {
                    map.put(localFile.getName(), localFile);
                    continue;
                }
                if (!(archiveFile instanceof CrawledLinkArchiveFile)) continue;
                CrawledLinkArchiveFile af = (CrawledLinkArchiveFile)archiveFile;
                af.setFileArchiveFileExists(true);
            }
        }
        return new ArrayList<ArchiveFile>(map.values());
    }

    @Override
    public Collection<? extends String> getGuessedPasswordList(Archive archive) {
        return new HashSet();
    }

    @Override
    public void fireArchiveAddedToQueue(Archive archive) {
    }

    @Override
    public String createDefaultExtractToPath(Archive archive) {
        try {
            CrawledLink firstLink = CrawledLinkFactory.getFirstCrawledLink(archive);
            return LinkTreeUtils.getDownloadDirectory((AbstractNode)firstLink).getAbsolutePath();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Override
    public String createExtractSubPath(String path, Archive archive) {
        CrawledLink link = CrawledLinkFactory.getFirstCrawledLink(archive);
        try {
            if (path.contains("%PACKAGENAME%")) {
                CrawledPackage fp = link.getParentNode();
                String packageName = null;
                if (fp != null) {
                    packageName = CrossSystem.alleviatePathParts((String)fp.getName());
                }
                path = !StringUtils.isEmpty(packageName) ? path.replace("%PACKAGENAME%", packageName) : path.replace("%PACKAGENAME%", "");
            }
            if (path.contains("%ARCHIVENAME%")) {
                String archiveName = CrossSystem.alleviatePathParts((String)archive.getName());
                path = !StringUtils.isEmpty((String)archiveName) ? path.replace("%ARCHIVENAME%", archiveName) : path.replace("%ARCHIVENAME%", "");
            }
            if (path.contains("%HOSTER%")) {
                String hostName = CrossSystem.alleviatePathParts((String)link.getHost());
                path = !StringUtils.isEmpty((String)hostName) ? path.replace("%HOSTER%", hostName) : path.replace("%HOSTER%", "");
            }
            if (path.contains("$DATE:")) {
                int end;
                int start = path.indexOf("$DATE:");
                for (end = start + 6; end < path.length() && path.charAt(end) != '$'; ++end) {
                }
                try {
                    SimpleDateFormat format = new SimpleDateFormat(path.substring(start + 6, end));
                    path = path.replace(path.substring(start, end + 1), format.format(new Date()));
                }
                catch (Throwable e) {
                    path = path.replace(path.substring(start, end + 1), "");
                }
            }
            if (path.contains("%SUBFOLDER%")) {
                String dif;
                String defaultDest = this.createDefaultExtractToPath(archive);
                path = !StringUtils.isEmpty((String)defaultDest) ? (StringUtils.isEmpty((String)(dif = new File(((GeneralSettings)JsonConfig.create(GeneralSettings.class)).getDefaultDownloadFolder()).getAbsolutePath().replace(defaultDest, ""))) || new File(dif).isAbsolute() ? path.replace("%SUBFOLDER%", "") : path.replace("%SUBFOLDER%", CrossSystem.alleviatePathParts((String)dif))) : path.replace("%SUBFOLDER%", "");
            }
            return CrossSystem.fixPathSeparators((String)path);
        }
        catch (Exception e) {
            LoggerFactory.getDefaultLogger().log((Throwable)e);
            return null;
        }
    }

    @Override
    public Archive createArchive(ArchiveType archiveType) {
        return new Archive((ArchiveFactory)this, archiveType);
    }

    @Override
    public Archive createArchive(SplitType splitType) {
        return new Archive((ArchiveFactory)this, splitType);
    }

    @Override
    public File toFile(String path) {
        return new File(path);
    }

    @Override
    public File getFolder() {
        try {
            return LinkTreeUtils.getDownloadDirectory((AbstractNode)this.getFirstPart());
        }
        catch (Throwable e) {
            return new File(((GeneralSettings)JsonConfig.create(GeneralSettings.class)).getDefaultDownloadFolder());
        }
    }

    @Override
    public void setArchive(Archive archive) {
        super.setArchive(archive);
        if (BooleanStatus.UNSET != this.getDefaultAutoExtract()) {
            archive.getSettings();
        }
    }

    @Override
    public BooleanStatus getDefaultAutoExtract() {
        CrawledLink first = this.getLinks().get(0);
        if (first.hasArchiveInfo()) {
            return first.getArchiveInfo().getAutoExtract();
        }
        return BooleanStatus.UNSET;
    }
}

