/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.extraction.bindings.downloadlink;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Pattern;
import jd.controlling.downloadcontroller.DownloadController;
import jd.controlling.packagecontroller.AbstractNodeVisitor;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import jd.plugins.PluginForHost;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.appwork.utils.os.CrossSystem;
import org.jdownloader.extensions.extraction.Archive;
import org.jdownloader.extensions.extraction.ArchiveFactory;
import org.jdownloader.extensions.extraction.ArchiveFile;
import org.jdownloader.extensions.extraction.BooleanStatus;
import org.jdownloader.extensions.extraction.bindings.downloadlink.DownloadLinkArchive;
import org.jdownloader.extensions.extraction.bindings.downloadlink.DownloadLinkArchiveFile;
import org.jdownloader.extensions.extraction.bindings.file.FileArchiveFactory;
import org.jdownloader.extensions.extraction.multi.ArchiveType;
import org.jdownloader.extensions.extraction.split.SplitType;
import org.jdownloader.settings.GeneralSettings;

public class DownloadLinkArchiveFactory
extends DownloadLinkArchiveFile
implements ArchiveFactory {
    public static final String DOWNLOADLINK_KEY_EXTRACTEDPATH = "EXTRACTEDPATH";

    public DownloadLinkArchiveFactory(DownloadLink link) {
        super(link);
    }

    @Override
    public boolean isDeepExtraction() {
        return false;
    }

    @Override
    public String createExtractSubPath(String path, Archive archive) {
        DownloadLink link = DownloadLinkArchiveFactory.getFirstDownloadLinkPart(archive);
        try {
            if (path.contains("%PACKAGENAME%")) {
                String packageName = link == null ? null : CrossSystem.alleviatePathParts((String)link.getLastValidFilePackage().getName());
                path = !StringUtils.isEmpty((String)packageName) ? path.replace("%PACKAGENAME%", packageName) : path.replace("%PACKAGENAME%", "");
            }
            if (path.contains("%ARCHIVENAME%")) {
                String archiveName = CrossSystem.alleviatePathParts((String)archive.getName());
                path = !StringUtils.isEmpty((String)archiveName) ? path.replace("%ARCHIVENAME%", archiveName) : path.replace("%ARCHIVENAME%", "");
            }
            if (path.contains("%HOSTER%")) {
                String hostName = link == null ? null : CrossSystem.alleviatePathParts((String)link.getHost());
                path = !StringUtils.isEmpty((String)hostName) ? path.replace("%HOSTER%", hostName) : path.replace("%HOSTER%", "");
            }
            if (path.contains("$DATE:")) {
                int end;
                int start = path.indexOf("$DATE:");
                for (end = start + 6; end < path.length() && path.charAt(end) != '$'; ++end) {
                }
                try {
                    SimpleDateFormat format = new SimpleDateFormat(path.substring(start + 6, end));
                    path = path.replace(path.substring(start, end + 1), format.format(new Date()));
                }
                catch (Throwable e) {
                    path = path.replace(path.substring(start, end + 1), "");
                }
            }
            if (path.contains("%SUBFOLDER%")) {
                String dif = link == null ? null : new File(((GeneralSettings)JsonConfig.create(GeneralSettings.class)).getDefaultDownloadFolder()).getAbsolutePath().replace(new File(link.getFileOutput(false, true)).getParent(), "");
                path = StringUtils.isEmpty(dif) || new File(dif).isAbsolute() ? path.replace("%SUBFOLDER%", "") : path.replace("%SUBFOLDER%", CrossSystem.alleviatePathParts(dif));
            }
            return CrossSystem.fixPathSeparators((String)path);
        }
        catch (Exception e) {
            LoggerFactory.getDefaultLogger().log((Throwable)e);
            return null;
        }
    }

    private String modifyPartFilePattern(String pattern) {
        String fileNamePattern;
        HashSet<Character> unsafeChars = new HashSet<Character>();
        for (DownloadLink downloadLink : this.getDownloadLinks()) {
            char[] fileNameReplaceMap;
            PluginForHost defaultPlugin = downloadLink.getDefaultPlugin();
            if (defaultPlugin == null || (fileNameReplaceMap = defaultPlugin.getFilenameReplaceMap()) == null) continue;
            for (char replace : fileNameReplaceMap) {
                unsafeChars.add(Character.valueOf(replace));
            }
        }
        if (unsafeChars.isEmpty()) {
            return pattern;
        }
        String filePathPattern = new Regex(pattern, "\\^\\\\Q(.*?)\\\\E").getMatch(0);
        File filePath = new File(filePathPattern);
        String modifiedFilaNamePattern = fileNamePattern = filePath.getName();
        Object object = unsafeChars.iterator();
        while (object.hasNext()) {
            Character unsafeChar = (Character)object.next();
            modifiedFilaNamePattern = modifiedFilaNamePattern.replace(unsafeChar.toString(), "\\\\E.\\\\Q");
        }
        modifiedFilaNamePattern = modifiedFilaNamePattern.replace("$", "\\$");
        String modifiedFilePathPattern = filePathPattern.replaceFirst(Pattern.quote(fileNamePattern) + "$", modifiedFilaNamePattern);
        String ret = pattern.replace("^\\Q" + filePathPattern + "\\E", "^\\Q" + modifiedFilePathPattern + "\\E");
        return ret;
    }

    @Override
    public List<ArchiveFile> createPartFileList(String file, String archivePartFilePattern) {
        String pattern = this.modifyPartFilePattern(archivePartFilePattern);
        final Pattern pat = Pattern.compile(pattern, CrossSystem.isWindows() ? 2 : 0);
        final String fileParent = new File(file).getParent();
        final HashMap<String, ArchiveFile> map = new HashMap<String, ArchiveFile>();
        DownloadController.getInstance().visitNodes((AbstractNodeVisitor)new AbstractNodeVisitor<DownloadLink, FilePackage>(){

            public Boolean visitPackageNode(FilePackage pkg) {
                if (CrossSystem.isWindows()) {
                    String downloadDirectory = CrossSystem.fixPathSeparators((String)pkg.getDownloadDirectory());
                    return StringUtils.equalsIgnoreCase((String)fileParent, (String)downloadDirectory);
                }
                String downloadDirectory = CrossSystem.fixPathSeparators((String)pkg.getDownloadDirectory());
                if (downloadDirectory.endsWith("/")) {
                    return StringUtils.equals((String)fileParent.concat("/"), (String)downloadDirectory);
                }
                return StringUtils.equals((String)fileParent, (String)downloadDirectory);
            }

            public Boolean visitChildrenNode(DownloadLink node) {
                String nodeFile = node.getFileOutput(false, true);
                if (nodeFile == null) {
                    return false;
                }
                if (pat.matcher(nodeFile).matches()) {
                    String nodeName = node.getView().getDisplayName();
                    DownloadLinkArchiveFile af = (DownloadLinkArchiveFile)map.get(nodeName);
                    if (af == null) {
                        af = new DownloadLinkArchiveFile(node);
                        map.put(nodeName, af);
                    } else {
                        af.addMirror(node);
                    }
                }
                return true;
            }
        }, true);
        List<ArchiveFile> localFiles = new FileArchiveFactory(new File(this.getFilePath())).createPartFileList(file, pattern);
        for (ArchiveFile localFile : localFiles) {
            ArchiveFile archiveFile = (ArchiveFile)map.get(localFile.getName());
            if (archiveFile == null) {
                map.put(localFile.getName(), localFile);
                continue;
            }
            if (!(archiveFile instanceof DownloadLinkArchiveFile)) continue;
            DownloadLinkArchiveFile af = (DownloadLinkArchiveFile)archiveFile;
            af.setFileArchiveFileExists(localFile.exists());
        }
        return new ArrayList<ArchiveFile>(map.values());
    }

    @Override
    public File toFile(String path) {
        return new File(path);
    }

    @Override
    public Collection<? extends String> getGuessedPasswordList(Archive archive) {
        LinkedHashSet<String> ret = new LinkedHashSet<String>();
        for (ArchiveFile archiveFile : archive.getArchiveFiles()) {
            if (!(archiveFile instanceof DownloadLinkArchiveFile)) continue;
            for (DownloadLink downloadLink : ((DownloadLinkArchiveFile)archiveFile).getDownloadLinks()) {
                String pw = downloadLink.getDownloadPassword();
                if (StringUtils.isEmpty((String)pw)) continue;
                ret.add(pw);
            }
        }
        return ret;
    }

    @Override
    public void fireArchiveAddedToQueue(Archive archive) {
        for (ArchiveFile archiveFile : archive.getArchiveFiles()) {
            if (!(archiveFile instanceof DownloadLinkArchiveFile)) continue;
            for (DownloadLink downloadLink : ((DownloadLinkArchiveFile)archiveFile).getDownloadLinks()) {
                downloadLink.setExtractionStatus(null);
            }
        }
    }

    public static DownloadLink getFirstDownloadLinkPart(Archive archive) {
        for (ArchiveFile archiveFile : archive.getArchiveFiles()) {
            if (!(archiveFile instanceof DownloadLinkArchiveFile)) continue;
            return ((DownloadLinkArchiveFile)archiveFile).getDownloadLinks().get(0);
        }
        return null;
    }

    @Override
    public String createDefaultExtractToPath(Archive archive) {
        try {
            return new File(archive.getArchiveFiles().get(0).getFilePath()).getParent();
        }
        catch (Throwable throwable) {
            return new File(this.getFilePath()).getParent();
        }
    }

    @Override
    public Archive createArchive(ArchiveType archiveType) {
        return new DownloadLinkArchive((ArchiveFactory)this, archiveType);
    }

    @Override
    public Archive createArchive(SplitType splitType) {
        return new DownloadLinkArchive((ArchiveFactory)this, splitType);
    }

    @Override
    public File getFolder() {
        return new File(this.getFilePath()).getParentFile();
    }

    @Override
    public BooleanStatus getDefaultAutoExtract() {
        return BooleanStatus.UNSET;
    }
}

