/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.extraction.content;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdownloader.extensions.extraction.content.ContentNode;

public class PackedFile
implements ContentNode {
    private final long size;
    private final String path;
    private final boolean directory;
    private final Map<String, PackedFile> children = new HashMap<String, PackedFile>();
    private volatile long directorySize = 0L;
    private volatile int fileCount = 0;
    private int directoryCount = 0;

    public long getSize() {
        return this.size;
    }

    @Override
    public synchronized List<PackedFile> list() {
        return new ArrayList<PackedFile>(this.children.values());
    }

    @Override
    public Map<String, PackedFile> getChildren() {
        return this.children;
    }

    public int getFileCount() {
        return this.fileCount;
    }

    public int getDirectoryCount() {
        return this.directoryCount;
    }

    @Override
    public long getDirectorySize() {
        return this.directorySize;
    }

    public PackedFile(boolean folder, String path, Long size) {
        this.size = size != null ? size : -1L;
        this.directorySize = 0L;
        this.path = path;
        this.directory = folder;
    }

    public boolean isDirectory() {
        return this.directory;
    }

    public String getParent() {
        return new File(this.path).getParent();
    }

    @Override
    public synchronized void add(PackedFile packedFile) {
        this.children.put(packedFile.getName(), packedFile);
        if (!packedFile.isDirectory()) {
            this.directorySize += Math.max(0L, packedFile.getSize());
            ++this.fileCount;
        } else {
            ++this.directoryCount;
        }
    }

    public String getName() {
        return new File(this.path).getName();
    }
}

