/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.extraction.gui.bubble;

import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import jd.gui.swing.jdgui.components.IconedProcessIndicator;
import net.miginfocom.swing.MigLayout;
import org.appwork.utils.formatter.TimeFormatter;
import org.jdownloader.extensions.extraction.ArchiveFile;
import org.jdownloader.extensions.extraction.CFG_EXTRACTION;
import org.jdownloader.extensions.extraction.ExtractionController;
import org.jdownloader.extensions.extraction.ExtractionEvent;
import org.jdownloader.extensions.extraction.Item;
import org.jdownloader.extensions.extraction.translate.T;
import org.jdownloader.gui.notify.AbstractBubbleContentPanel;
import org.jdownloader.gui.notify.Element;
import org.jdownloader.gui.translate._GUI;

public class ExtractionBubbleContent
extends AbstractBubbleContentPanel {
    private long startTime = System.currentTimeMillis();
    private AbstractBubbleContentPanel.Pair duration;
    private AbstractBubbleContentPanel.Pair archive;
    private AbstractBubbleContentPanel.Pair status;
    private AbstractBubbleContentPanel.Pair file;
    private AbstractBubbleContentPanel.Pair extractTo;
    protected IconedProcessIndicator progressCircle = null;

    public ExtractionBubbleContent() {
        super("rar");
        this.layoutComponents();
    }

    public void stop() {
        IconedProcessIndicator progressCircle = this.progressCircle;
        if (progressCircle != null) {
            progressCircle.setIndeterminate(false);
            progressCircle.setMaximum(100);
            progressCircle.setValue(100);
        }
        super.stop();
    }

    public void update(ExtractionController caller, ExtractionEvent event) {
        double prog = caller.getProgress();
        IconedProcessIndicator progressCircle = this.progressCircle;
        if (progressCircle != null) {
            boolean indeterminate = prog < 0.01;
            progressCircle.setValue((int)prog);
            progressCircle.setStringPainted(true);
            if (progressCircle.isIndeterminate() != indeterminate) {
                progressCircle.setIndeterminate(indeterminate);
            }
        }
        if (this.duration != null) {
            this.duration.setText((Object)TimeFormatter.formatMilliSeconds((long)(System.currentTimeMillis() - this.startTime), (int)0));
        }
        if (event != null) {
            if (this.archive != null) {
                ArchiveFile firstArchiveFile = caller.getArchive().getArchiveFiles().get(0);
                this.archive.setText((Object)firstArchiveFile.getName());
                this.archive.setTooltip(firstArchiveFile.getFilePath());
            }
            switch ((ExtractionEvent.Type)((Object)event.getType())) {
                case PASSWORD_NEEDED_TO_CONTINUE: {
                    if (this.status == null) break;
                    this.status.setText((Object)T.T.password_required());
                    break;
                }
                case START_CRACK_PASSWORD: {
                    if (this.status == null) break;
                    this.status.setText((Object)T.T.password_search());
                    break;
                }
                case FINISHED: 
                case CLEANUP: {
                    if (this.status == null) break;
                    if (caller.isSuccessful()) {
                        this.status.setText((Object)_GUI.T.lit_successfull());
                        break;
                    }
                    this.status.setText((Object)_GUI.T.lit_failed());
                    break;
                }
                case EXTRACTION_FAILED: 
                case EXTRACTION_FAILED_CRC: 
                case NOT_ENOUGH_SPACE: {
                    if (this.status == null) break;
                    this.status.setText((Object)_GUI.T.lit_failed());
                    break;
                }
                case EXTRACTING: 
                case ACTIVE_ITEM: {
                    Item item;
                    if (this.status != null) {
                        this.status.setText((Object)T.T.extracting_in_progress());
                    }
                    if ((item = caller.getCurrentActiveItem()) == null || item.getFile() == null) break;
                    if (this.file != null) {
                        this.file.setText((Object)caller.getCurrentActiveItem().getFile().getName());
                    }
                    if (this.extractTo == null) break;
                    this.extractTo.setText((Object)caller.getCurrentActiveItem().getFile().getParent());
                }
            }
        }
    }

    protected void layoutComponents() {
        if (CFG_EXTRACTION.BUBBLE_CONTENT_CIRCLE_PROGRESS_VISIBLE.isEnabled()) {
            this.setLayout((LayoutManager)new MigLayout("ins 3 3 0 3,wrap 3", "[][fill][grow,fill]", "[]"));
            this.progressCircle = this.createProgress("rar");
            this.add((Component)this.progressCircle, "width 32!,height 32!,pushx,growx,pushy,growy,spany,aligny top");
        } else {
            this.progressCircle = null;
            this.setLayout((LayoutManager)new MigLayout("ins 3 3 0 3,wrap 2", "[fill][grow,fill]", "[]"));
        }
        if (CFG_EXTRACTION.BUBBLE_CONTENT_DURATION_VISIBLE.isEnabled()) {
            this.duration = this.addPair(this.duration, _GUI.T.ReconnectDialog_layoutDialogContent_duration(), "wait");
        }
        if (CFG_EXTRACTION.BUBBLE_CONTENT_ARCHIVENAME_VISIBLE.isEnabled()) {
            this.archive = this.addPair(this.archive, T.T.archive(), "extract");
        }
        if (CFG_EXTRACTION.BUBBLE_CONTENT_EXTRACT_TO_FOLDER_VISIBLE.isEnabled()) {
            this.extractTo = this.addPair(this.extractTo, T.T.archive_folder(), "folder");
        }
        if (CFG_EXTRACTION.BUBBLE_CONTENT_CURRENT_FILE_VISIBLE.isEnabled()) {
            this.file = this.addPair(this.file, T.T.archive_file(), "file");
        }
        if (CFG_EXTRACTION.BUBBLE_CONTENT_STATUS_VISIBLE.isEnabled()) {
            this.status = this.addPair(this.status, T.T.archive_status(), "media-playback-start");
        }
    }

    public static void fillElements(ArrayList<Element> elements) {
        elements.add(new Element(CFG_EXTRACTION.BUBBLE_CONTENT_CIRCLE_PROGRESS_VISIBLE, T.T.bubblecontent_progress(), "rar"));
        elements.add(new Element(CFG_EXTRACTION.BUBBLE_CONTENT_DURATION_VISIBLE, _GUI.T.ReconnectDialog_layoutDialogContent_duration(), "wait"));
        elements.add(new Element(CFG_EXTRACTION.BUBBLE_CONTENT_ARCHIVENAME_VISIBLE, T.T.archive(), "extract"));
        elements.add(new Element(CFG_EXTRACTION.BUBBLE_CONTENT_EXTRACT_TO_FOLDER_VISIBLE, T.T.archive_folder(), "folder"));
        elements.add(new Element(CFG_EXTRACTION.BUBBLE_CONTENT_CURRENT_FILE_VISIBLE, T.T.archive_file(), "file"));
        elements.add(new Element(CFG_EXTRACTION.BUBBLE_CONTENT_STATUS_VISIBLE, T.T.archive_status(), "media-playback-start"));
    }

    public void updateLayout() {
        this.removeAll();
        this.layoutComponents();
        this.revalidate();
        this.repaint();
    }
}

