/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.extraction.multi;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import jd.controlling.downloadcontroller.IfFileExistsDialogInterface;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import net.sf.sevenzipjbinding.ArchiveFormat;
import net.sf.sevenzipjbinding.ExtractOperationResult;
import net.sf.sevenzipjbinding.IArchiveExtractCallback;
import net.sf.sevenzipjbinding.IArchiveOpenCallback;
import net.sf.sevenzipjbinding.IInStream;
import net.sf.sevenzipjbinding.ISequentialOutStream;
import net.sf.sevenzipjbinding.PropID;
import net.sf.sevenzipjbinding.SevenZip;
import net.sf.sevenzipjbinding.SevenZipException;
import net.sf.sevenzipjbinding.impl.RandomAccessFileInStream;
import net.sf.sevenzipjbinding.simple.ISimpleInArchive;
import net.sf.sevenzipjbinding.simple.ISimpleInArchiveItem;
import org.appwork.utils.Application;
import org.appwork.utils.BinaryLogic;
import org.appwork.utils.DebugMode;
import org.appwork.utils.Files;
import org.appwork.utils.ReflectionUtils;
import org.appwork.utils.Regex;
import org.appwork.utils.ReusableByteArrayOutputStream;
import org.appwork.utils.StringUtils;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.os.LibCDetector;
import org.appwork.utils.os.hardware.HardwareType;
import org.appwork.utils.os.hardware.HardwareTypeInterface;
import org.appwork.utils.os.hardware.RaspberryPi;
import org.appwork.utils.swing.dialog.DialogNoAnswerException;
import org.jdownloader.controlling.FileCreationManager;
import org.jdownloader.extensions.extraction.Archive;
import org.jdownloader.extensions.extraction.ArchiveFactory;
import org.jdownloader.extensions.extraction.ArchiveFile;
import org.jdownloader.extensions.extraction.DummyArchive;
import org.jdownloader.extensions.extraction.DummyArchiveFile;
import org.jdownloader.extensions.extraction.ExtractionConfig;
import org.jdownloader.extensions.extraction.ExtractionController;
import org.jdownloader.extensions.extraction.ExtractionException;
import org.jdownloader.extensions.extraction.ExtractionExtension;
import org.jdownloader.extensions.extraction.FileSignatures;
import org.jdownloader.extensions.extraction.IExtraction;
import org.jdownloader.extensions.extraction.Item;
import org.jdownloader.extensions.extraction.MissingArchiveFile;
import org.jdownloader.extensions.extraction.Signature;
import org.jdownloader.extensions.extraction.bindings.downloadlink.DownloadLinkArchiveFactory;
import org.jdownloader.extensions.extraction.content.ContentView;
import org.jdownloader.extensions.extraction.content.PackedFile;
import org.jdownloader.extensions.extraction.gui.iffileexistsdialog.IfFileExistsDialog;
import org.jdownloader.extensions.extraction.multi.ArchiveException;
import org.jdownloader.extensions.extraction.multi.ArchiveType;
import org.jdownloader.extensions.extraction.multi.CheckException;
import org.jdownloader.extensions.extraction.multi.DummyOpener;
import org.jdownloader.extensions.extraction.multi.FilePermission17;
import org.jdownloader.extensions.extraction.multi.FilePermissionSet;
import org.jdownloader.extensions.extraction.multi.ModdedVolumedArchiveInStream;
import org.jdownloader.extensions.extraction.multi.MultiCallback;
import org.jdownloader.extensions.extraction.multi.MultiOpener;
import org.jdownloader.extensions.extraction.multi.MultiSevenZipException;
import org.jdownloader.extensions.extraction.multi.RarOpener;
import org.jdownloader.extensions.extraction.multi.Seven7ExtractCallback;
import org.jdownloader.extensions.extraction.multi.Seven7PWCallback;
import org.jdownloader.extensions.extraction.multi.SevenZipArchiveWrapper;
import org.jdownloader.extensions.extraction.multi.SignatureCheckingOutStream;
import org.jdownloader.settings.IfFileExistsAction;
import org.jdownloader.updatev2.UpdateController;

public class Multi
extends IExtraction {
    private volatile int crack = 0;
    private SevenZipArchiveWrapper inArchive;
    private IInStream inStream;
    private Closeable closable;
    private final ExtractionExtension extension;
    private static final ArchiveType[] SUPPORTED_ARCHIVE_TYPES;

    public Multi(ExtractionExtension extension) {
        this.extension = extension;
        if (extension != null) {
            this.setLogger(extension.getLogger());
        }
        this.inArchive = null;
    }

    @Override
    public Archive buildArchive(ArchiveFactory link, boolean allowDeepInspection) throws ArchiveException {
        return ArchiveType.createArchive(link, allowDeepInspection, SUPPORTED_ARCHIVE_TYPES);
    }

    public void setPermissions(ISimpleInArchiveItem item, File extractTo) {
        if (item == null) {
            return;
        }
        if (extractTo == null) {
            return;
        }
        if (!extractTo.exists()) {
            return;
        }
        if (!this.getConfig().isRestoreFilePermissions()) {
            return;
        }
        if (CrossSystem.isUnix() || CrossSystem.isMac()) {
            try {
                Integer attributesInteger = item.getAttributes();
                if (attributesInteger == null) {
                    return;
                }
                int attributes = attributesInteger;
                if (attributes == 0) {
                    return;
                }
                String hostOS = item.getHostOS();
                if (!StringUtils.equalsIgnoreCase((String)"Unix", (String)hostOS)) {
                    return;
                }
                FilePermissionSet filePermissionSet = new FilePermissionSet();
                int attributeIndex = 16;
                filePermissionSet.setOtherExecute((attributes & 1 << attributeIndex++) != 0);
                filePermissionSet.setOtherWrite((attributes & 1 << attributeIndex++) != 0);
                filePermissionSet.setOtherRead((attributes & 1 << attributeIndex++) != 0);
                filePermissionSet.setGroupExecute((attributes & 1 << attributeIndex++) != 0);
                filePermissionSet.setGroupWrite((attributes & 1 << attributeIndex++) != 0);
                filePermissionSet.setGroupRead((attributes & 1 << attributeIndex++) != 0);
                filePermissionSet.setUserExecute((attributes & 1 << attributeIndex++) != 0);
                filePermissionSet.setUserWrite((attributes & 1 << attributeIndex++) != 0);
                filePermissionSet.setUserRead((attributes & 1 << attributeIndex++) != 0);
                if (Application.getJavaVersion() >= Application.JAVA17) {
                    FilePermission17.setFilePermission(extractTo, filePermissionSet);
                } else if (filePermissionSet.isUserExecute() && !extractTo.setExecutable(true, !filePermissionSet.isOtherExecute() && !filePermissionSet.isOtherExecute())) {
                    throw new IOException("Failed to set " + filePermissionSet + " to " + extractTo);
                }
            }
            catch (Throwable e) {
                this.logger.log(e);
            }
        }
    }

    public void setLastModifiedDate(ISimpleInArchiveItem item, File extractTo) {
        try {
            Date date;
            long modified = this.getConfig().isUseOriginalFileDate() ? ((date = item.getLastWriteTime()) != null && date.getTime() >= 0L ? date.getTime() : -1L) : System.currentTimeMillis();
            if (modified == 0L) {
                return;
            }
            if (!extractTo.setLastModified(modified)) {
                this.logger.warning("Could not set last write/modified time(" + modified + "/" + new Date(modified) + ") for " + item.getPath());
            } else {
                this.logger.warning("Set last write/modified time(" + modified + "/" + new Date(modified) + ")  for " + item.getPath());
            }
        }
        catch (Throwable e) {
            this.logger.log(e);
        }
    }

    private boolean initLibrary(String libID) {
        if (Multi.class.getResource("/" + libID + "/sevenzipjbinding-lib.properties") == null) {
            this.logger.finer("LibID not found: " + libID);
            return false;
        }
        this.logger.finer("LibID found: " + libID);
        ArrayList<File> directories = new ArrayList<File>();
        directories.add(Application.getTempResource((String)"7zip"));
        String tmpdir = System.getProperty("java.io.tmpdir");
        if (StringUtils.isNotEmpty((String)tmpdir) && new File(tmpdir).isDirectory()) {
            directories.add(new File(tmpdir, "7zip"));
        }
        for (File directory : directories) {
            try {
                try {
                    if (directory.isDirectory()) {
                        Files.deleteRecursiv((File)directory);
                    }
                }
                catch (Throwable e) {
                    this.logger.log(e);
                }
                this.logger.finer("Try LibID(" + libID + ") Path: " + directory + "->" + (directory.isDirectory() || directory.mkdirs()));
                SevenZip.initSevenZipFromPlatformJAR((String)libID, (File)directory);
                if (!SevenZip.isInitializedSuccessfully()) continue;
                return true;
            }
            catch (Throwable e) {
                if (e.getCause() != null) {
                    UpdateController.getInstance().setExtractionError(libID + "_" + e.getCause().getMessage());
                } else {
                    UpdateController.getInstance().setExtractionError(libID + "_" + e.getMessage());
                }
                this.logger.log(e);
            }
        }
        return false;
    }

    private String checkLibraries(ExtractionExtension extractionExtension, List<String> libIDs) {
        this.logger.finer("Try LibIDs: " + libIDs);
        if (libIDs.size() > 0) {
            for (String libID : libIDs) {
                if (!this.initLibrary(libID)) continue;
                ((ExtractionConfig)extractionExtension.getSettings()).setLastWorkingLibID(libID);
                return libID;
            }
        }
        try {
            this.logger.info("Available LibIDs:" + SevenZip.getPlatformList());
        }
        catch (Throwable e) {
            this.logger.log(e);
        }
        return null;
    }

    private List<String> filter(List<String> values) {
        ArrayList<String> ret = new ArrayList<String>();
        CrossSystem.OperatingSystem os = CrossSystem.getOS();
        block6: for (String value : values) {
            switch (os.getFamily()) {
                case BSD: {
                    if (StringUtils.containsIgnoreCase((String)value, (String)"BSD")) break;
                    continue block6;
                }
                case MAC: {
                    if (StringUtils.startsWithCaseInsensitive((String)value, (String)"Mac-")) break;
                    continue block6;
                }
                case LINUX: {
                    if (StringUtils.startsWithCaseInsensitive((String)value, (String)"Linux-")) break;
                    continue block6;
                }
                case WINDOWS: {
                    if (StringUtils.startsWithCaseInsensitive((String)value, (String)"Windows-")) break;
                    continue block6;
                }
            }
            ret.add(value);
        }
        return ret;
    }

    private String hasLibrarySupport(ExtractionExtension extractionExtension) {
        String lastWorkingLibID;
        String customLibID = System.getProperty("sevenzipLibID");
        if (StringUtils.isNotEmpty((String)customLibID)) {
            if (this.initLibrary(customLibID)) {
                if (CrossSystem.isLinux() && CrossSystem.ARCHFamily.ARM.equals((Object)CrossSystem.getARCHFamily())) {
                    ((ExtractionConfig)extractionExtension.getSettings()).setLastWorkingLibID(customLibID);
                }
                return customLibID;
            }
            return null;
        }
        ArrayList<String> libIDs = new ArrayList<String>();
        CrossSystem.OperatingSystem os = CrossSystem.getOS();
        CrossSystem.ARCHFamily arch = CrossSystem.getARCHFamily();
        boolean is64BitJvm = Application.is64BitJvm();
        block0 : switch (os.getFamily()) {
            case BSD: {
                switch (arch) {
                    case ARM: {
                        switch (os) {
                            case FREEBSD: {
                                if (!is64BitJvm) break block0;
                                libIDs.add("FreeBSD-arm64");
                                libIDs.add("FreeBSD-aarch64");
                                break block0;
                            }
                        }
                        break block0;
                    }
                    case RISCV: {
                        switch (os) {
                            case FREEBSD: {
                                if (is64BitJvm) {
                                    libIDs.add("FreeBSD-riscv64");
                                    break block0;
                                }
                                libIDs.add("FreeBSD-riscv32");
                                libIDs.add("FreeBSD-riscv");
                                break block0;
                            }
                        }
                        break block0;
                    }
                    case X86: {
                        switch (os) {
                            case DRAGONFLYBSD: {
                                if (!is64BitJvm) break block0;
                                libIDs.add("DragonFlyBSD-amd64");
                                break block0;
                            }
                            case FREEBSD: {
                                if (is64BitJvm) {
                                    libIDs.add("FreeBSD-amd64");
                                    break block0;
                                }
                                libIDs.add("FreeBSD-i386");
                                break block0;
                            }
                            case NETBSD: {
                                if (is64BitJvm) {
                                    libIDs.add("NetBSD-amd64");
                                    break block0;
                                }
                                libIDs.add("NetBSD-i386");
                                break block0;
                            }
                        }
                        break block0;
                    }
                }
                break;
            }
            case LINUX: {
                switch (arch) {
                    case RISCV: {
                        if (is64BitJvm) {
                            libIDs.add("Linux-riscv64");
                            break block0;
                        }
                        libIDs.add("Linux-riscv32");
                        libIDs.add("Linux-riscv");
                        break block0;
                    }
                    case ARM: {
                        if (is64BitJvm) {
                            if (LibCDetector.isMuslSupported()) {
                                libIDs.add("Linux-arm64-musl");
                                libIDs.add("Linux-aarch64-musl");
                            }
                            libIDs.add("Linux-arm64");
                            libIDs.add("Linux-aarch64");
                            break block0;
                        }
                        if (LibCDetector.isMuslSupported()) {
                            libIDs.add("Linux-armhf-musl");
                            libIDs.add("Linux-armv7-musl");
                        }
                        libIDs.add("Linux-armv5");
                        if (HardwareType.getHardware() != null && HardwareTypeInterface.ID.QNAP.equals((Object)HardwareType.getHardware().getHardwareType())) {
                            libIDs.add("Linux-armv5-qnap");
                        }
                        libIDs.add("Linux-armv6");
                        libIDs.add("Linux-armv71");
                        if (RaspberryPi.getRaspberryPiDetails() != null) {
                            libIDs.add("Linux-armpi");
                            libIDs.add("Linux-armpi2");
                        }
                        libIDs.add("Linux-arm2");
                        libIDs.add("Linux-arm");
                        libIDs.add("Linux-arm3");
                        break block0;
                    }
                    case X86: {
                        if (is64BitJvm) {
                            if (LibCDetector.isMuslSupported()) {
                                libIDs.add("Linux-amd64-musl");
                            }
                            libIDs.add("Linux-amd64");
                            break block0;
                        }
                        if (LibCDetector.isMuslSupported()) {
                            libIDs.add("Linux-i386-musl");
                        }
                        libIDs.add("Linux-i386");
                        break block0;
                    }
                    case PPC: {
                        libIDs.add("Linux-ppc");
                        break block0;
                    }
                }
                break;
            }
            case MAC: {
                if (is64BitJvm) {
                    if (CrossSystem.ARCHFamily.ARM.equals((Object)arch)) {
                        libIDs.add("Mac-arm64");
                        break;
                    }
                    libIDs.add("Mac-x86_64");
                    break;
                }
                libIDs.add("Mac-i386");
                break;
            }
            case WINDOWS: {
                if (is64BitJvm) {
                    if (CrossSystem.ARCHFamily.ARM.equals((Object)arch)) {
                        libIDs.add("Windows-arm64");
                        break;
                    }
                    libIDs.add("Windows-amd64");
                    break;
                }
                libIDs.add("Windows-x86");
                break;
            }
        }
        if (!DebugMode.TRUE_IN_IDE_ELSE_FALSE && StringUtils.isNotEmpty((String)(lastWorkingLibID = ((ExtractionConfig)extractionExtension.getSettings()).getLastWorkingLibID()))) {
            libIDs.remove(lastWorkingLibID);
            libIDs.add(0, lastWorkingLibID);
            ((ExtractionConfig)extractionExtension.getSettings()).setLastWorkingLibID(null);
            ((ExtractionConfig)extractionExtension.getSettings())._getStorageHandler().write();
        }
        return this.checkLibraries(extractionExtension, this.filter(libIDs));
    }

    public static final String getSevenZipJBindingVersion() {
        try {
            return (String)ReflectionUtils.invoke((String)SevenZip.class.getName(), (String)"getSevenZipJBindingVersion", null, String.class, (Object[])new Object[0]);
        }
        catch (Throwable e) {
            return "4.65";
        }
    }

    public static boolean isRAR5Supported() {
        try {
            return ArchiveFormat.valueOf((String)"RAR5") != null;
        }
        catch (Throwable e) {
            return false;
        }
    }

    @Override
    public boolean isAvailable(ExtractionExtension extractionExtension) {
        String libID = this.hasLibrarySupport(extractionExtension);
        if (libID == null) {
            this.logger.info("Unsupported SevenZipJBinding|Version=" + Multi.getSevenZipJBindingVersion() + "|CPU_ARCH=" + CrossSystem.getARCHFamily() + "|OS_FAM=" + CrossSystem.getOSFamily() + "|OS=" + CrossSystem.getOS() + "|64Bit_JVM=" + Application.is64BitJvm() + "|64Bit_ARCH=" + CrossSystem.is64BitArch() + "|HW:" + HardwareType.getHardware());
            UpdateController.getInstance().setExtractionLibrary(Boolean.valueOf(false));
            return false;
        }
        this.logger.info("Supported SevenZipJBinding|LibID=" + libID + "|Version=" + Multi.getSevenZipJBindingVersion() + "|RAR5=" + Multi.isRAR5Supported() + "|CPU_ARCH=" + CrossSystem.getARCHFamily() + "|OS_FAM=" + CrossSystem.getOSFamily() + "|OS=" + CrossSystem.getOS() + "|64Bit_JVM=" + Application.is64BitJvm() + "|64Bit_ARCH=" + CrossSystem.is64BitArch() + "|HW:" + HardwareType.getHardware());
        UpdateController.getInstance().setExtractionLibrary(Boolean.valueOf(true));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DummyArchive checkComplete(Archive archive) throws CheckException {
        if (archive.getArchiveType() == null) {
            return null;
        }
        try {
            DummyArchive dummyArchive = new DummyArchive(archive, archive.getArchiveType());
            for (ArchiveFile archiveFile : archive.getArchiveFiles()) {
                dummyArchive.add(new DummyArchiveFile(archiveFile));
            }
            if (!dummyArchive.isComplete()) {
                return dummyArchive;
            }
            ArchiveType archiveType = archive.getArchiveType();
            String firstArchiveFile = archive.getArchiveFiles().get(0).getFilePath();
            String partNumberOfFirstArchiveFile = archiveType.getPartNumberString(firstArchiveFile);
            if (archiveType.getFirstPartIndex() != archiveType.getPartNumber(partNumberOfFirstArchiveFile)) {
                throw new CheckException("Wrong firstArchiveFile(" + firstArchiveFile + ") for Archive(" + archive.getName() + ")");
            }
            ArchiveFile lastArchiveFile = archive.getLastArchiveFile();
            if (lastArchiveFile == null) {
                return dummyArchive;
            }
            DownloadLinkArchiveFactory factory = archive.getFactory() instanceof DownloadLinkArchiveFactory ? (DownloadLinkArchiveFactory)archive.getFactory() : (archive.getParentArchive() != null && archive.getParentArchive().getFactory() instanceof DownloadLinkArchiveFactory ? (DownloadLinkArchiveFactory)archive.getParentArchive().getFactory() : null);
            if (factory == null) {
                return dummyArchive;
            }
            int nextIndex = archiveType.getPartNumber(archiveType.getPartNumberString(lastArchiveFile.getFilePath())) + 1;
            List<ArchiveFile> maybeMissingArchiveFiles = ArchiveType.getMissingArchiveFiles(archive, archiveType, nextIndex);
            if (maybeMissingArchiveFiles.isEmpty()) {
                return dummyArchive;
            }
            HashSet<String> archiveIDs = new HashSet<String>();
            block8: for (DownloadLink downloadLink : factory.getDownloadLinks()) {
                FilePackage fp = downloadLink.getFilePackage();
                boolean readL = fp.getModifyLock().readLock();
                try {
                    List<Archive> searchArchives = this.extension.getArchivesFromPackageChildren(fp.getChildren(), archiveIDs, -1);
                    if (searchArchives == null) continue;
                    for (Archive searchArchive : searchArchives) {
                        if (!archiveIDs.add(searchArchive.getArchiveID())) continue;
                        for (ArchiveFile maybeMissingArchiveFile : maybeMissingArchiveFiles) {
                            if (!StringUtils.equals((String)maybeMissingArchiveFile.getName(), (String)searchArchive.getName())) continue;
                            dummyArchive.add(new DummyArchiveFile(new MissingArchiveFile(searchArchive, maybeMissingArchiveFile.getFilePath())));
                            break block8;
                        }
                    }
                }
                finally {
                    fp.getModifyLock().readUnlock(readL);
                }
            }
            return dummyArchive;
        }
        catch (CheckException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new CheckException("Cannot check Archive(" + archive.getName() + ")", e);
        }
    }

    @Override
    public void close() {
        if (this.inArchive != null) {
            try {
                this.inArchive.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.closable != null) {
            try {
                this.closable.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void extract(final ExtractionController ctrl) {
        block38: {
            archive = this.getExtractionController().getArchive();
            try {
                format = archive.getArchiveFormat();
                ctrl.setCompleteBytes(archive.getContentView().getTotalSize());
                ctrl.setProcessedBytes(0L);
                isSolid = Boolean.TRUE.equals(this.inArchive.getArchiveProperty(PropID.SOLID));
                if (ArchiveFormat.SEVEN_ZIP == format || ArchiveFormat.BZIP2 == format || isSolid) {
                    allItems = new ArrayList<Integer>();
                    for (i = 0; i < this.inArchive.getNumberOfItems(); ++i) {
                        isFolder = this.inArchive.isFolder(i);
                        if (Boolean.TRUE.equals(isFolder)) continue;
                        allItems.add(i);
                    }
                    maxItemsRound = isSolid != false ? -1 : 50;
                    round = new ArrayList<Integer>();
                    it = allItems.iterator();
                    while (it.hasNext()) {
                        next = (Integer)it.next();
                        round.add(next);
                        if (round.size() != maxItemsRound && it.hasNext()) continue;
                        items = new int[round.size()];
                        index = 0;
                        for (Integer item : round) {
                            items[index++] = item;
                        }
                        round.clear();
                        callback = new Seven7ExtractCallback(this, this.inArchive, ctrl, archive, this.getConfig());
                        try {
                            this.inArchive.extract(items, false, callback);
                        }
                        catch (SevenZipException e) {
                            this.logger.log((Throwable)e);
                            throw e;
                        }
                        finally {
                            callback.close();
                            ctrl.setCurrentActiveItem(null);
                        }
                        if (ctrl.gotKilled()) {
                            throw new MultiSevenZipException("Extraction has been aborted", 255);
                        }
                        if (callback.hasError()) {
                            throw new SevenZipException("callback encountered an error!", callback.getError());
                        }
                        if (!callback.isResultMissing()) continue;
                        throw new SevenZipException("callback is missing results!");
                    }
                    break block38;
                }
                block26: for (ISimpleInArchiveItem item : this.inArchive.getSimpleInterface().getArchiveItems()) {
                    if (item == null || item.isFolder()) continue;
                    if (ctrl.gotKilled()) {
                        throw new MultiSevenZipException("Extraction has been aborted", 255);
                    }
                    skippedFlag = new AtomicBoolean(false);
                    size = item.getSize();
                    extractTo = this.getExtractFilePath(item, ctrl, skippedFlag);
                    if (skippedFlag.get()) {
                        if (size == null || size < 0L) continue;
                        ctrl.addProcessedBytesAndPauseIfNeeded(size);
                        continue;
                    }
                    if (extractTo == null) {
                        throw new SevenZipException("Extraction error, extractTo == null");
                    }
                    ctrl.setCurrentActiveItem(new Item(item.getPath(), size, extractTo));
                    try {
                        call = new MultiCallback(extractTo, this.getExtractionController(), this.getConfig()){

                            @Override
                            public int write(byte[] data) throws SevenZipException {
                                if (ctrl.gotKilled()) {
                                    throw new MultiSevenZipException("Extraction has been aborted", 255);
                                }
                                int ret = super.write(data);
                                ctrl.addProcessedBytesAndPauseIfNeeded(ret);
                                return ret;
                            }
                        };
                        archive.addExtractedFiles(extractTo);
                        try {
                            if (item.isEncrypted()) {
                                pw = archive.getFinalPassword();
                                if (pw == null) {
                                    throw new IOException("Password is null!");
                                }
                                res = item.extractSlow((ISequentialOutStream)call, pw);
                            } else {
                                res = item.extractSlow((ISequentialOutStream)call);
                            }
                        }
                        finally {
                            call.close();
                        }
                        this.logger.info("Extracted:" + item.getPath() + "|BytesWritten:" + call.getWritten() + "|FileSize(OnDisk):" + extractTo.length() + "|FileSize(InArchive):" + size + "|Result:" + res);
                        this.setLastModifiedDate(item, extractTo);
                        this.setPermissions(item, extractTo);
                        switch (3.$SwitchMap$net$sf$sevenzipjbinding$ExtractOperationResult[res.ordinal()]) {
                            case 1: {
                                if (size == null || size >= extractTo.length()) continue block26;
                                if (extractTo.length() < size) {
                                    this.logger.info("Size missmatch for " + item.getPath() + "(" + extractTo.length() + "<" + size + ")");
                                    archive.setExitCode(4);
                                    return;
                                }
                                if (extractTo.length() <= size) continue block26;
                                this.logger.info("Ignore Size missmatch for " + item.getPath() + "(" + extractTo.length() + ">" + size + ")");
                                ** break;
lbl91:
                                // 1 sources

                                continue block26;
                            }
                            case 2: {
                                this.logger.info("CRC Error for " + item.getPath());
                                archive.setExitCode(3);
                                return;
                            }
                            case 3: {
                                this.logger.info("Unsupported Method " + item.getMethod() + " in " + item.getPath());
                                archive.setExitCode(2);
                                return;
                            }
                            default: {
                                archive.setExitCode(2);
                                return;
                            }
                        }
                    }
                    finally {
                        ctrl.setCurrentActiveItem(null);
                    }
                }
            }
            catch (MultiSevenZipException e) {
                this.logger.log((Throwable)e);
                this.setException((Exception)e);
                archive.setExitCode(e.getExitCode());
                return;
            }
            catch (SevenZipException e) {
                this.logger.log((Throwable)e);
                this.setException((Exception)e);
                archive.setExitCode(2);
                return;
            }
            catch (IOException e) {
                this.logger.log((Throwable)e);
                this.setException(e);
                archive.setExitCode(9);
                return;
            }
        }
        archive.setExitCode(0);
    }

    public File getExtractFilePath(ISimpleInArchiveItem item, ExtractionController ctrl, AtomicBoolean skipped) throws SevenZipException {
        Matcher filter;
        Archive archive = this.getExtractionController().getArchive();
        String itemPath = item.getPath();
        ArchiveFile firstArchiveFile = archive.getArchiveFiles().get(0);
        if (StringUtils.isEmpty((String)itemPath)) {
            String firstPartFileName = firstArchiveFile.getName();
            int in = firstPartFileName.lastIndexOf(".");
            String newItemPath = in > 0 ? firstPartFileName.substring(0, in) : (StringUtils.isNotEmpty((String)firstPartFileName) ? firstPartFileName : "UnknownExtractionFilename");
            itemPath = ArchiveType.TGZ_SINGLE.equals((Object)archive.getArchiveType()) && !StringUtils.endsWithCaseInsensitive((String)newItemPath, (String)".tar") ? newItemPath + ".tar" : newItemPath;
        }
        if ((filter = this.isFiltered(itemPath)) != null) {
            this.logger.info("Filtering item:" + itemPath + " from " + firstArchiveFile + "|pattern:" + filter.pattern());
            skipped.set(true);
            return null;
        }
        itemPath = ctrl.getCleanedExtractionPath(itemPath);
        Long size = item.getSize();
        String extractToRoot = this.getExtractionController().getExtractToFolder().getAbsoluteFile() + File.separator;
        File extractToFile = new File(extractToRoot + itemPath);
        this.logger.info("Extract " + extractToFile);
        if (extractToFile.exists()) {
            IfFileExistsAction action = this.getExtractionController().getIfFileExistsAction();
            while (action == null || action == IfFileExistsAction.ASK_FOR_EACH_FILE) {
                if (ctrl.gotKilled()) {
                    throw new MultiSevenZipException("Extraction has been aborted", 255);
                }
                IfFileExistsDialog dialog = new IfFileExistsDialog(extractToFile, new Item(itemPath, size, extractToFile), archive);
                IfFileExistsDialogInterface dialogInterface = dialog.show();
                try {
                    dialogInterface.throwCloseExceptions();
                }
                catch (DialogNoAnswerException e) {
                    throw new SevenZipException((Throwable)e);
                }
                action = dialogInterface.getAction();
                if (action == null) {
                    throw new SevenZipException("cannot handle if file exists: " + extractToFile);
                }
                if (dialogInterface.isDontShowAgainSelected()) {
                    this.logger.info("Remember IfFileExistsAction:" + action + " for current archive");
                    this.getExtractionController().setIfFileExistsAction(action);
                }
                if (action != IfFileExistsAction.AUTO_RENAME || dialogInterface != dialog) continue;
                String newName = dialog.getNewName();
                if (StringUtils.equals((String)extractToFile.getName(), (String)newName)) continue;
                if ((extractToFile = new File(extractToFile.getParentFile(), newName)).exists()) {
                    action = IfFileExistsAction.ASK_FOR_EACH_FILE;
                    continue;
                }
                action = null;
                break;
            }
            if (extractToFile.exists() && action != null) {
                block2 : switch (action) {
                    case OVERWRITE_FILE: {
                        if (FileCreationManager.getInstance().delete(extractToFile, null)) break;
                        throw new MultiSevenZipException("Could not overwrite(delete) " + extractToFile, 9);
                    }
                    case SKIP_FILE: {
                        archive.addSkippedFiles(extractToFile);
                        skipped.set(true);
                        return null;
                    }
                    case AUTO_RENAME: {
                        String sourceFileName;
                        String[] splitName = CrossSystem.splitFileName((String)extractToFile.getName());
                        String fileRoot = extractToFile.getParent();
                        String extension = StringUtils.isEmpty((String)splitName[1]) ? "" : "." + splitName[1];
                        long duplicateFilenameCounter = 2L;
                        String alreadyDuplicated = new Regex(splitName[0], ".*_(\\d+)$").getMatch(0);
                        if (alreadyDuplicated != null) {
                            duplicateFilenameCounter = Long.parseLong(alreadyDuplicated) + 1L;
                            sourceFileName = new Regex(splitName[0], "(.*)_\\d+$").getMatch(0);
                        } else {
                            sourceFileName = splitName[0];
                        }
                        do {
                            String newFileName;
                            File checkFileExists;
                            if ((checkFileExists = new File(fileRoot, newFileName = sourceFileName + "_" + duplicateFilenameCounter++ + extension)).exists()) continue;
                            extractToFile = checkFileExists;
                            break block2;
                        } while (!ctrl.gotKilled());
                        throw new SevenZipException("Extraction has been aborted");
                    }
                }
            }
        }
        if (!extractToFile.getParentFile().exists() && !extractToFile.getParentFile().mkdirs()) {
            throw new MultiSevenZipException("could not create folder for file:" + extractToFile, 9);
        }
        while (true) {
            try {
                if (!extractToFile.createNewFile()) {
                    throw new MultiSevenZipException("could not create file:" + extractToFile, 9);
                }
                extractToFile.delete();
                return extractToFile;
            }
            catch (IOException e) {
                this.logger.log((Throwable)e);
                File parent = extractToFile.getParentFile();
                String brokenFilename = extractToFile.getName();
                String fixedFilename = new String(brokenFilename.replaceAll("[^\\w\\s\\.\\(\\)\\[\\],]", ""));
                if (!StringUtils.equals((String)brokenFilename, (String)fixedFilename)) {
                    this.logger.severe("Invalid Chars could have occured, try to remove them");
                    this.logger.severe("Replaced " + brokenFilename + " with " + fixedFilename);
                    extractToFile = new File(parent, fixedFilename);
                    continue;
                }
                throw new MultiSevenZipException(e, 9);
            }
            break;
        }
    }

    private SevenZipArchiveWrapper createSevenZipArchiveWrapper(ArchiveFormat format, IInStream inStream, IArchiveOpenCallback callBackformat) throws SevenZipException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        try {
            Method createArchive = SevenZip.class.getMethod("openInArchive", ArchiveFormat.class, IInStream.class, IArchiveOpenCallback.class);
            final Object archive = createArchive.invoke(null, format, inStream, callBackformat);
            final Method getArchiveFormat = archive.getClass().getMethod("getArchiveFormat", new Class[0]);
            final Method getNumberOfItems = archive.getClass().getMethod("getNumberOfItems", new Class[0]);
            final Method getArchiveProperty = archive.getClass().getMethod("getArchiveProperty", PropID.class);
            final Method getProperty = archive.getClass().getMethod("getProperty", Integer.TYPE, PropID.class);
            final Method getSimpleInterface = archive.getClass().getMethod("getSimpleInterface", new Class[0]);
            final Method close = archive.getClass().getMethod("close", new Class[0]);
            PropID propID = null;
            try {
                propID = PropID.valueOf((String)"LAST_WRITE_TIME");
            }
            catch (IllegalArgumentException e) {
                try {
                    propID = PropID.valueOf((String)"LAST_MODIFICATION_TIME");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            final PropID propIDLastWriteTime = propID;
            final boolean slowDownWorkaroundNeeded = propID != null && !"LAST_MODIFICATION_TIME".equals(propID.name());
            final Method extract = archive.getClass().getMethod("extract", int[].class, Boolean.TYPE, IArchiveExtractCallback.class);
            return new SevenZipArchiveWrapper(){
                private final AtomicBoolean closedFlag = new AtomicBoolean(false);

                @Override
                public int getNumberOfItems() {
                    Number ret = (Number)this.invoke(getNumberOfItems, new Object[0]);
                    if (ret == null) {
                        return 0;
                    }
                    return ret.intValue();
                }

                @Override
                public ArchiveFormat getArchiveFormat() {
                    return (ArchiveFormat)this.invoke(getArchiveFormat, new Object[0]);
                }

                @Override
                public Boolean isEncrypted(int index) {
                    return (Boolean)this.invoke(getProperty, index, PropID.ENCRYPTED);
                }

                protected Object invoke(Method method, Object ... args) {
                    try {
                        return method.invoke(archive, args);
                    }
                    catch (IllegalAccessException e) {
                        Multi.this.logger.log((Throwable)e);
                    }
                    catch (IllegalArgumentException e) {
                        Multi.this.logger.log((Throwable)e);
                    }
                    catch (InvocationTargetException e) {
                        Multi.this.logger.log((Throwable)e);
                    }
                    return null;
                }

                @Override
                public Boolean isFolder(int index) {
                    return (Boolean)this.invoke(getProperty, index, PropID.IS_FOLDER);
                }

                @Override
                public Long getSize(int index) {
                    Number ret = (Number)this.invoke(getProperty, index, PropID.SIZE);
                    if (ret != null) {
                        return ret.longValue();
                    }
                    return null;
                }

                @Override
                public Long getPackedSize(int index) {
                    Number ret = (Number)this.invoke(getProperty, index, PropID.PACKED_SIZE);
                    if (ret != null) {
                        return ret.longValue();
                    }
                    return null;
                }

                @Override
                public String getPath(int index) {
                    return (String)this.invoke(getProperty, index, PropID.PATH);
                }

                @Override
                public String getMethod(int index) {
                    return (String)this.invoke(getProperty, index, PropID.METHOD);
                }

                @Override
                public Integer getAttributes(int index) {
                    Number ret = (Number)this.invoke(getProperty, index, PropID.ATTRIBUTES);
                    if (ret != null) {
                        return ret.intValue();
                    }
                    return 0;
                }

                @Override
                public Date getLastWriteTime(int index) {
                    if (propIDLastWriteTime != null) {
                        return (Date)this.invoke(getProperty, index, propIDLastWriteTime);
                    }
                    return null;
                }

                @Override
                public void close() throws SevenZipException {
                    if (this.closedFlag.compareAndSet(false, true)) {
                        try {
                            if (archive instanceof Closeable) {
                                ((Closeable)archive).close();
                            } else {
                                this.invoke(close, new Object[0]);
                            }
                        }
                        catch (IOException e) {
                            throw new SevenZipException((Throwable)e);
                        }
                    }
                }

                @Override
                public void extract(int[] indices, boolean testMode, IArchiveExtractCallback extractCallback) throws SevenZipException {
                    this.invoke(extract, indices, testMode, extractCallback);
                }

                @Override
                public ISimpleInArchive getSimpleInterface() {
                    return (ISimpleInArchive)this.invoke(getSimpleInterface, new Object[0]);
                }

                @Override
                public boolean isSlowDownWorkaroundNeeded() {
                    return slowDownWorkaroundNeeded && ArchiveFormat.SEVEN_ZIP == this.getArchiveFormat();
                }

                @Override
                public Object getArchiveProperty(PropID propID) {
                    return this.invoke(getArchiveProperty, propID);
                }
            };
        }
        catch (NoSuchMethodException e) {
            throw new SevenZipException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean findPassword(ExtractionController ctl, String password, boolean optimized) throws ExtractionException {
        Archive archive = this.getExtractionController().getArchive();
        ++this.crack;
        if (StringUtils.isEmpty((String)password)) {
            password = "";
        }
        AtomicReference<Object> passwordFound = new AtomicReference<Object>(null);
        try {
            Object callBack;
            ArchiveFile firstArchiveFile = archive.getArchiveFiles().get(0);
            ArchiveFormat format = archive.getArchiveFormat();
            ReusableByteArrayOutputStream buffer = new ReusableByteArrayOutputStream(65536);
            try {
                if (this.inArchive != null) {
                    this.inArchive.close();
                    this.inArchive = null;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                if (this.closable != null) {
                    this.closable.close();
                    this.closable = null;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (archive.getArchiveFiles().size() == 1) {
                RandomAccessFile raf = new RandomAccessFile(firstArchiveFile.getFilePath(), "r");
                this.closable = raf;
                callBack = new DummyOpener(password);
                this.inStream = new RandomAccessFileInStream(raf);
            } else {
                switch (archive.getArchiveType()) {
                    case RAR_MULTI: {
                        RarOpener rarOpener = new RarOpener(archive, password, (LogInterface)this.logger);
                        this.closable = rarOpener;
                        callBack = rarOpener;
                        this.inStream = rarOpener.getStream(firstArchiveFile);
                        break;
                    }
                    case SEVENZIP_PARTS: {
                        MultiOpener sevenZipPartsOpener = new MultiOpener(archive, password, (LogInterface)this.getLogger());
                        this.closable = sevenZipPartsOpener;
                        callBack = sevenZipPartsOpener;
                        this.inStream = new ModdedVolumedArchiveInStream(firstArchiveFile.getFilePath(), sevenZipPartsOpener);
                        break;
                    }
                    default: {
                        MultiOpener multiOpener = new MultiOpener(archive, password, (LogInterface)this.getLogger());
                        this.closable = multiOpener;
                        callBack = multiOpener;
                        this.inStream = multiOpener.getStream(firstArchiveFile);
                    }
                }
            }
            if (this.inStream == null) {
                this.logger.info("Failed to open Stream: " + firstArchiveFile);
            }
            if (this.inStream != null && this.closable != null) {
                try {
                    this.inArchive = this.createSevenZipArchiveWrapper(format, this.inStream, (IArchiveOpenCallback)callBack);
                }
                catch (InvocationTargetException e) {
                    if (e.getTargetException() != null) {
                        throw e.getTargetException();
                    }
                    throw e;
                }
            } else {
                boolean e = false;
                return e;
            }
            HashSet<String> checkedExtensions = new HashSet<String>();
            if (ArchiveFormat.SEVEN_ZIP == format) {
                int numberOfItems = this.inArchive.getNumberOfItems();
                if (archive.isPasswordRequiredToOpen() && numberOfItems > 0) {
                    passwordFound.set(new Signature("UNKNOWN:ArchiveOpen:" + numberOfItems, null, null, null));
                    boolean multiOpener = true;
                    return multiOpener;
                }
                ArrayList<Integer> allItems = new ArrayList<Integer>();
                for (int i = 0; i < numberOfItems; ++i) {
                    Boolean isFolder = this.inArchive.isFolder(i);
                    Boolean itemEncrypted = this.inArchive.isEncrypted(i);
                    Long size = this.inArchive.getSize(i);
                    Long packedSize = this.inArchive.getPackedSize(i);
                    if (!itemEncrypted.booleanValue() || isFolder.booleanValue() || size == null || size == 0L && (packedSize == null || packedSize == 0L)) continue;
                    allItems.add(i);
                }
                int[] items = new int[allItems.size()];
                int index = 0;
                for (Integer item : allItems) {
                    items[index++] = item;
                }
                try {
                    this.inArchive.extract(items, false, new Seven7PWCallback(ctl, this.inArchive, passwordFound, password, buffer, this.getConfig().getMaxCheckedFileSizeDuringOptimizedPasswordFindingInBytes(), ctl.getFileSignatures(), optimized));
                }
                catch (SevenZipException e) {
                    e.printStackTrace();
                }
            } else {
                SignatureCheckingOutStream signatureOutStream = new SignatureCheckingOutStream(ctl, passwordFound, ctl.getFileSignatures(), buffer, this.getConfig().getMaxCheckedFileSizeDuringOptimizedPasswordFindingInBytes(), optimized);
                ISimpleInArchiveItem[] items = this.inArchive.getSimpleInterface().getArchiveItems();
                if (archive.isPasswordRequiredToOpen() && items != null && items.length > 0) {
                    ISimpleInArchiveItem itemWithPassword = null;
                    ISimpleInArchiveItem[] iSimpleInArchiveItemArray = items;
                    int n = iSimpleInArchiveItemArray.length;
                    for (int item = 0; item < n; ++item) {
                        ISimpleInArchiveItem item2 = iSimpleInArchiveItemArray[item];
                        if (!item2.isEncrypted()) continue;
                        itemWithPassword = item2;
                        break;
                    }
                    if (itemWithPassword == null) {
                        passwordFound.set(new Signature("UNKNOWN:ArchiveOpen:" + items.length, null, null, null));
                        boolean bl = true;
                        return bl;
                    }
                }
                for (ISimpleInArchiveItem item : items) {
                    Long size = item.getSize();
                    Long packedSize = item.getPackedSize();
                    boolean isEncrypted = item.isEncrypted();
                    if (!isEncrypted || item.isFolder() || size == null || size == 0L && (packedSize == null || packedSize == 0L)) continue;
                    if (ctl.gotKilled() || passwordFound.get() != null) break;
                    String path = item.getPath();
                    String ext = Files.getExtension((String)path);
                    if (!checkedExtensions.add(ext) && optimized) continue;
                    if (passwordFound.get() != null) break;
                    try {
                        signatureOutStream.reset();
                        signatureOutStream.setSignatureLength(path, size);
                        this.logger.fine("Validating password: " + path);
                        ExtractOperationResult result = item.extractSlow((ISequentialOutStream)signatureOutStream, password);
                        this.logger.fine("Validation result: " + path + "|" + result);
                        if (ExtractOperationResult.DATAERROR.equals((Object)result)) {
                            boolean bl = false;
                            return bl;
                        }
                        if (!ExtractOperationResult.OK.equals((Object)result)) continue;
                        passwordFound.set(new Signature("UNKNOWN:Extraction:" + result, null, null, ext));
                    }
                    catch (SevenZipException e) {
                        e.printStackTrace();
                    }
                    finally {
                        if (passwordFound.get() != null) {
                            this.logger.info("Verified Password:" + password + "|" + path + "|" + passwordFound.get());
                        }
                    }
                }
            }
            boolean bl = passwordFound.get() != null;
            return bl;
        }
        catch (SevenZipException e) {
            if (e.getMessage().contains("HRESULT: 0x80004005") || e.getMessage().contains("HRESULT: 0x1 (FALSE)") || e.getMessage().contains("can't be opened") || e.getMessage().contains("No password was provided")) {
                this.logger.info("SevenZipException: " + e.getMessage());
                archive.setProtected(true);
                archive.setPasswordRequiredToOpen(true);
                boolean bl = false;
                return bl;
            }
            throw new ExtractionException(e, null);
        }
        catch (Throwable e) {
            throw new ExtractionException(e, null);
        }
        finally {
            if (passwordFound.get() != null) {
                archive.setFinalPassword(password);
                if (this.inArchive != null) {
                    this.updateContentView(this.inArchive.getSimpleInterface());
                }
            }
        }
    }

    @Override
    public int getCrackProgress() {
        return this.crack;
    }

    @Override
    public boolean prepare() throws ExtractionException {
        Archive archive = this.getExtractionController().getArchive();
        try {
            Object callBack;
            ArchiveFile firstArchiveFile = archive.getArchiveFiles().get(0);
            ArchiveFormat format = archive.getArchiveFormat();
            if (format.name().startsWith("RAR")) {
                try {
                    String headerBitFlags1;
                    int headerByte1;
                    String signatureString = FileSignatures.readFileSignature(new File(firstArchiveFile.getFilePath()), 14);
                    if (signatureString.length() >= 16 && StringUtils.startsWithCaseInsensitive((String)signatureString, (String)"526172211a070100")) {
                        if (Multi.isRAR5Supported()) {
                            this.logger.severe("RAR5 is supported:" + signatureString);
                        } else {
                            this.logger.severe("RAR5 is not supported:" + signatureString);
                            return false;
                        }
                    }
                    if (signatureString.length() >= 24 && BinaryLogic.containsAll((int)(headerByte1 = Integer.parseInt(headerBitFlags1 = "" + signatureString.charAt(20) + signatureString.charAt(21), 16)), (int[])new int[]{128}) && !format.name().startsWith("RAR5")) {
                        this.logger.severe("Encrypted RAR headers:" + signatureString);
                        archive.setProtected(true);
                        archive.setPasswordRequiredToOpen(true);
                        return true;
                    }
                }
                catch (IOException e) {
                    this.logger.log((Throwable)e);
                }
            }
            try {
                String signatureFormat;
                String sig = FileSignatures.readFileSignature(new File(firstArchiveFile.getFilePath()));
                Signature signature = new FileSignatures().getSignature(sig);
                if (signature != null && (signatureFormat = "7Z".equalsIgnoreCase(signature.getId()) ? ArchiveFormat.SEVEN_ZIP.name() : ("RAR".equalsIgnoreCase(signature.getId()) ? ArchiveFormat.RAR.name() : ("ZIP".equalsIgnoreCase(signature.getId()) ? ArchiveFormat.ZIP.name() : ("GZ".equalsIgnoreCase(signature.getId()) ? ArchiveFormat.GZIP.name() : ("BZ2".equalsIgnoreCase(signature.getId()) ? ArchiveFormat.BZIP2.name() : null))))) != null && !format.name().startsWith(signatureFormat)) {
                    this.logger.warning("Format missmatch:" + format + "!=" + signatureFormat);
                }
            }
            catch (Throwable e) {
                this.getLogger().log(e);
            }
            if (archive.getArchiveFiles().size() == 1) {
                RandomAccessFile raf = new RandomAccessFile(firstArchiveFile.getFilePath(), "r");
                this.closable = raf;
                callBack = new DummyOpener();
                this.inStream = new RandomAccessFileInStream(raf);
            } else {
                switch (archive.getArchiveType()) {
                    case RAR_MULTI: {
                        RarOpener rarOpener = new RarOpener(archive, (LogInterface)this.logger);
                        this.closable = rarOpener;
                        callBack = rarOpener;
                        this.inStream = rarOpener.getStream(firstArchiveFile);
                        break;
                    }
                    case SEVENZIP_PARTS: 
                    case ZIP_MULTI: {
                        MultiOpener sevenZipPartsOpener = new MultiOpener(archive, (LogInterface)this.getLogger());
                        this.closable = sevenZipPartsOpener;
                        callBack = sevenZipPartsOpener;
                        this.inStream = new ModdedVolumedArchiveInStream(firstArchiveFile.getFilePath(), sevenZipPartsOpener);
                        break;
                    }
                    default: {
                        MultiOpener multiOpener = new MultiOpener(archive, (LogInterface)this.getLogger());
                        this.closable = multiOpener;
                        callBack = multiOpener;
                        this.inStream = multiOpener.getStream(firstArchiveFile);
                    }
                }
            }
            if (this.inStream != null && this.closable != null) {
                try {
                    this.inArchive = this.createSevenZipArchiveWrapper(format, this.inStream, (IArchiveOpenCallback)callBack);
                }
                catch (InvocationTargetException e) {
                    if (e.getTargetException() != null) {
                        throw e.getTargetException();
                    }
                    throw e;
                }
            } else {
                return false;
            }
            for (ISimpleInArchiveItem item : this.inArchive.getSimpleInterface().getArchiveItems()) {
                if (!item.isEncrypted()) continue;
                archive.setProtected(true);
                break;
            }
            if (this.inArchive.getNumberOfItems() == 0) {
                throw new SevenZipException("No Items found in \"" + firstArchiveFile.getFilePath() + "\"! Maybe unsupported archive type?");
            }
            this.updateContentView(this.inArchive.getSimpleInterface());
        }
        catch (SevenZipException e) {
            if (StringUtils.containsIgnoreCase((String)e.getMessage(), (String)"can't be opened")) {
                try {
                    if (!this.validateArchiveParts(archive)) {
                        if (archive.getCrcError().size() > 0) {
                            archive.setExitCode(3);
                        } else if (archive.getMissingFiles().size() > 0) {
                            archive.setExitCode(4);
                        }
                        return false;
                    }
                }
                catch (IOException e2) {
                    this.logger.log((Throwable)e);
                    throw new ExtractionException(e2, null);
                }
            }
            if (e.getMessage() != null && (e.getMessage().contains("HRESULT: 0x80004005") || e.getMessage().contains("HRESULT: 0x1 (FALSE)") || e.getMessage().contains("can't be opened") || e.getMessage().contains("No password was provided"))) {
                archive.setProtected(true);
                archive.setPasswordRequiredToOpen(true);
                return true;
            }
            this.logger.log((Throwable)e);
            throw new ExtractionException(e, null);
        }
        catch (Throwable e) {
            this.logger.log(e);
            throw new ExtractionException(e, null);
        }
        return true;
    }

    private boolean validateArchiveParts(Archive archive) throws IOException {
        ArchiveType type = archive.getArchiveType();
        switch (type) {
            case RAR_MULTI: 
            case RAR_SINGLE: 
            case RAR_MULTI2: 
            case RAR_MULTI3: 
            case RAR_MULTI4: {
                for (ArchiveFile archiveFile : archive.getArchiveFiles()) {
                    if (Boolean.TRUE.equals(ArchiveType.RAR_SINGLE.isValidPart(0, archiveFile, true))) continue;
                    archive.addCrcError(archiveFile);
                    this.logger.severe("Missing/Broken" + (Object)((Object)type) + " Signature: " + archiveFile + "|Exists:" + archiveFile.exists(true));
                }
                break;
            }
            case ZIP_SINGLE: {
                for (ArchiveFile archiveFile : archive.getArchiveFiles()) {
                    String sig = FileSignatures.readFileSignature(new File(archiveFile.getFilePath()));
                    Signature signature = new FileSignatures().getSignature(sig);
                    if (signature != null && "ZIP".equalsIgnoreCase(signature.getId())) continue;
                    archive.addCrcError(archiveFile);
                    this.logger.severe("Missing/Broken" + (Object)((Object)type) + " Signature: " + archiveFile + "|Exists:" + archiveFile.exists(true));
                }
                break;
            }
            case GZIP_SINGLE: {
                for (ArchiveFile archiveFile : archive.getArchiveFiles()) {
                    String sig = FileSignatures.readFileSignature(new File(archiveFile.getFilePath()));
                    Signature signature = new FileSignatures().getSignature(sig);
                    if (signature != null && "GZ".equalsIgnoreCase(signature.getId())) continue;
                    archive.addCrcError(archiveFile);
                    this.logger.severe("Missing/Broken" + (Object)((Object)type) + " Signature: " + archiveFile + "|Exists:" + archiveFile.exists(true));
                }
                break;
            }
            case BZIP2_SINGLE: {
                for (ArchiveFile archiveFile : archive.getArchiveFiles()) {
                    String sig = FileSignatures.readFileSignature(new File(archiveFile.getFilePath()));
                    Signature signature = new FileSignatures().getSignature(sig);
                    if (signature != null && "BZ2".equalsIgnoreCase(signature.getId())) continue;
                    archive.addCrcError(archiveFile);
                    this.logger.severe("Missing/Broken" + (Object)((Object)type) + " Signature: " + archiveFile + "|Exists:" + archiveFile.exists(true));
                }
                break;
            }
            case SEVENZIP_SINGLE: {
                for (ArchiveFile archiveFile : archive.getArchiveFiles()) {
                    String sig = FileSignatures.readFileSignature(new File(archiveFile.getFilePath()));
                    Signature signature = new FileSignatures().getSignature(sig);
                    if (signature != null && "7Z".equalsIgnoreCase(signature.getId())) continue;
                    archive.addCrcError(archiveFile);
                    this.logger.severe("Missing/Broken" + (Object)((Object)type) + " Signature: " + archiveFile + "|Exists:" + archiveFile.exists(true));
                }
                break;
            }
        }
        return archive.getCrcError().size() == 0;
    }

    private void updateContentView(ISimpleInArchive simpleInterface) {
        Archive archive = this.getExtractionController().getArchive();
        if (archive == null) {
            return;
        }
        try {
            this.initFilters();
            ContentView newView = new ContentView();
            for (ISimpleInArchiveItem item : simpleInterface.getArchiveItems()) {
                try {
                    String itemPath = item.getPath();
                    if (StringUtils.isEmpty((String)itemPath) || this.isFiltered(itemPath) != null) continue;
                    newView.add(new PackedFile(item.isFolder(), itemPath, item.getSize()));
                }
                catch (SevenZipException e) {
                    this.getLogger().log((Throwable)e);
                }
            }
            archive.setContentView(newView);
        }
        catch (SevenZipException e) {
            this.getLogger().log((Throwable)e);
        }
    }

    @Override
    public Boolean isSupported(ArchiveFactory factory, boolean allowDeepInspection) {
        if (allowDeepInspection) {
            try {
                return this.buildArchive(factory, allowDeepInspection) != null;
            }
            catch (ArchiveException e) {
                this.getLogger().log((Throwable)e);
                return false;
            }
        }
        for (ArchiveType archiveType : ArchiveType.values()) {
            if (!archiveType.matches(factory.getFilePath())) continue;
            return null;
        }
        return false;
    }

    static {
        ArrayList<ArchiveType> archiveTypes = new ArrayList<ArchiveType>();
        for (ArchiveType archiveType : ArchiveType.values()) {
            if (archiveType.name().startsWith("ZIP_MULTI2")) continue;
            archiveTypes.add(archiveType);
        }
        SUPPORTED_ARCHIVE_TYPES = archiveTypes.toArray(new ArchiveType[0]);
    }
}

