/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.extraction.multi;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import jd.plugins.download.raf.FileBytesCache;
import jd.plugins.download.raf.FileBytesCacheFlusher;
import net.sf.sevenzipjbinding.ISequentialOutStream;
import net.sf.sevenzipjbinding.SevenZipException;
import org.appwork.utils.IO;
import org.jdownloader.extensions.extraction.CPUPriority;
import org.jdownloader.extensions.extraction.ExtractionConfig;
import org.jdownloader.extensions.extraction.ExtractionController;
import org.jdownloader.extensions.extraction.FLUSH_MODE;
import org.jdownloader.extensions.extraction.multi.MultiSevenZipException;

class MultiCallback
implements ISequentialOutStream,
FileBytesCacheFlusher {
    protected final RandomAccessFile fos;
    protected final CPUPriority priority;
    protected final AtomicLong fileWritePosition = new AtomicLong(0L);
    protected final AtomicLong flushedBytes = new AtomicLong(0L);
    protected final File file;
    private final FileBytesCache cache;
    private final AtomicBoolean fileOpen = new AtomicBoolean(true);
    private volatile IOException ioException = null;
    private final ExtractionController con;
    private final FLUSH_MODE flushMode;

    MultiCallback(File file, ExtractionController con, ExtractionConfig config) throws IOException {
        CPUPriority priority = config.getCPUPriority();
        this.priority = priority == null || CPUPriority.HIGH.equals((Object)priority) ? null : priority;
        FLUSH_MODE flushMode = config.getFlushMode();
        this.flushMode = flushMode == null ? FLUSH_MODE.NONE : flushMode;
        this.con = con;
        this.file = file;
        this.fos = IO.open((File)file, (String)"rw");
        this.cache = con.getFileBytesCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitCPUPriority() throws SevenZipException {
        if (this.priority != null) {
            MultiCallback multiCallback = this;
            synchronized (multiCallback) {
                try {
                    this.wait(this.priority.getTime());
                }
                catch (InterruptedException e) {
                    throw new MultiSevenZipException(e, 2);
                }
            }
        }
    }

    public int write(byte[] data) throws SevenZipException {
        if (this.fileOpen.get()) {
            this.cache.write((FileBytesCacheFlusher)this, this.fileWritePosition.get(), data, data.length);
            this.fileWritePosition.addAndGet(data.length);
            this.waitCPUPriority();
            return data.length;
        }
        IOException lIoException = this.ioException;
        if (lIoException != null) {
            throw new MultiSevenZipException(lIoException, 5);
        }
        throw new MultiSevenZipException(5);
    }

    public File getFile() {
        return this.file;
    }

    public long getWritten() {
        return this.flushedBytes.get();
    }

    /*
     * Unable to fully structure code
     */
    void close() throws IOException {
        try {
            this.cache.execute(new Runnable(){

                @Override
                public void run() {
                    if (MultiCallback.this.fileOpen.get()) {
                        try {
                            MultiCallback.this.cache.flushIfContains((FileBytesCacheFlusher)MultiCallback.this);
                        }
                        finally {
                            MultiCallback.this.fileOpen.set(false);
                        }
                    }
                }
            });
        }
        finally {
            block21: {
                try {
                    if (this.fos == null) break block21;
                    try {
                        switch (2.$SwitchMap$org$jdownloader$extensions$extraction$FLUSH_MODE[this.flushMode.ordinal()]) {
                            case 1: {
                                this.fos.getChannel().force(true);
                                ** break;
lbl12:
                                // 1 sources

                                break;
                            }
                            case 2: {
                                this.fos.getChannel().force(false);
                                ** break;
lbl16:
                                // 1 sources

                                break;
                            }
                            ** default:
lbl18:
                            // 1 sources

                            break;
                        }
                    }
                    finally {
                        this.fos.close();
                    }
                }
                catch (Throwable e) {
                    this.con.getLogger().log(e);
                }
            }
        }
    }

    public void flush(byte[] writeCache, int writeCachePosition, int length, long fileWritePosition) {
        if (this.fileOpen.get()) {
            try {
                this.fos.seek(fileWritePosition);
                this.fos.write(writeCache, writeCachePosition, length);
                this.flushedBytes.addAndGet(length);
            }
            catch (IOException e) {
                this.con.getLogger().log((Throwable)e);
                this.ioException = e;
                this.fileOpen.set(false);
            }
        }
    }

    public void flushed() {
    }
}

