/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.extraction.multi;

import java.io.File;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.sf.sevenzipjbinding.ExtractAskMode;
import net.sf.sevenzipjbinding.ExtractOperationResult;
import net.sf.sevenzipjbinding.IArchiveExtractCallback;
import net.sf.sevenzipjbinding.ICryptoGetTextPassword;
import net.sf.sevenzipjbinding.ISequentialOutStream;
import net.sf.sevenzipjbinding.SevenZipException;
import net.sf.sevenzipjbinding.simple.ISimpleInArchiveItem;
import org.appwork.utils.StringUtils;
import org.appwork.utils.logging2.LogSource;
import org.jdownloader.extensions.extraction.Archive;
import org.jdownloader.extensions.extraction.ExtractionConfig;
import org.jdownloader.extensions.extraction.ExtractionController;
import org.jdownloader.extensions.extraction.Item;
import org.jdownloader.extensions.extraction.multi.Multi;
import org.jdownloader.extensions.extraction.multi.MultiCallback;
import org.jdownloader.extensions.extraction.multi.MultiSevenZipException;
import org.jdownloader.extensions.extraction.multi.SevenZipArchiveWrapper;

public class Seven7ExtractCallback
implements IArchiveExtractCallback,
ICryptoGetTextPassword {
    protected final ISequentialOutStream[] outStreams;
    protected final ExtractionController ctrl;
    protected final SevenZipArchiveWrapper archiveWrapper;
    protected final String password;
    protected final Archive archive;
    protected final ExtractionConfig config;
    protected int lastIndex = -1;
    protected final ExtractOperationResult[] results;
    protected final Multi multi;
    protected final ISimpleInArchiveItem[] items;
    protected final AtomicReference<Throwable> error = new AtomicReference();
    protected final LogSource logger;
    protected final boolean slowDownWorkaroundNeeded;
    protected static final long SLOWDOWNWORKAROUNDTIMEOUT = 150L;

    public ExtractOperationResult getResult(int index) {
        return this.results[index];
    }

    public boolean isResultMissing() {
        for (int index = 0; index < this.results.length; ++index) {
            ExtractOperationResult result = this.results[index];
            if (result != null) continue;
            ISimpleInArchiveItem item = this.items[index];
            try {
                if (item == null || item.isFolder()) {
                    continue;
                }
            }
            catch (SevenZipException e) {
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }

    public Seven7ExtractCallback(Multi multi, SevenZipArchiveWrapper archiveWrapper, ExtractionController ctrl, Archive archive, ExtractionConfig config) throws SevenZipException {
        int numberOfItems = archiveWrapper.getNumberOfItems();
        this.outStreams = new ISequentialOutStream[numberOfItems];
        this.results = new ExtractOperationResult[numberOfItems];
        this.items = new ISimpleInArchiveItem[numberOfItems];
        this.archiveWrapper = archiveWrapper;
        this.slowDownWorkaroundNeeded = archiveWrapper.isSlowDownWorkaroundNeeded();
        this.ctrl = ctrl;
        this.archive = archive;
        this.password = StringUtils.isEmpty((String)archive.getFinalPassword()) ? "" : archive.getFinalPassword();
        this.config = config;
        this.multi = multi;
        this.logger = multi.getLogger();
    }

    public void setCompleted(long arg0) throws SevenZipException {
    }

    public void setTotal(long arg0) throws SevenZipException {
    }

    public String cryptoGetTextPassword() throws SevenZipException {
        return this.password;
    }

    public ISequentialOutStream getStream(final int index, ExtractAskMode extractaskmode) throws SevenZipException {
        ISequentialOutStream ret;
        if (this.lastIndex >= 0) {
            ret = this.outStreams[this.lastIndex];
            if (this.lastIndex == index) {
                return ret;
            }
            if (ret != null) {
                this.outStreams[this.lastIndex] = null;
                try {
                    if (ret instanceof MultiCallback) {
                        ((MultiCallback)ret).close();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        this.lastIndex = index;
        if (this.ctrl.gotKilled()) {
            throw new MultiSevenZipException("Extraction has been aborted", 255);
        }
        if (this.error.get() != null) {
            throw new SevenZipException(this.error.get());
        }
        ret = this.outStreams[index];
        if (ret == null) {
            ISimpleInArchiveItem item;
            final Integer attributes = this.archiveWrapper.getAttributes(index);
            final Boolean isFolder = this.archiveWrapper.isFolder(index);
            final String path = this.archiveWrapper.getPath(index);
            final Long itemSize = this.archiveWrapper.getSize(index);
            final Date lastWriteTime = this.archiveWrapper.getLastWriteTime(index);
            final Boolean itemEncrypted = this.archiveWrapper.isEncrypted(index);
            final String method = this.archiveWrapper.getMethod(index);
            this.items[index] = item = new ISimpleInArchiveItem(){

                public String getPath() throws SevenZipException {
                    return path;
                }

                public Long getSize() throws SevenZipException {
                    return itemSize;
                }

                public Long getPackedSize() throws SevenZipException {
                    return null;
                }

                public boolean isFolder() throws SevenZipException {
                    return Boolean.TRUE.equals(isFolder);
                }

                public Integer getAttributes() throws SevenZipException {
                    return attributes;
                }

                public Date getCreationTime() throws SevenZipException {
                    return null;
                }

                public Date getLastAccessTime() throws SevenZipException {
                    return null;
                }

                public Date getLastWriteTime() throws SevenZipException {
                    return lastWriteTime;
                }

                public boolean isEncrypted() throws SevenZipException {
                    return Boolean.TRUE.equals(itemEncrypted);
                }

                public Boolean isCommented() throws SevenZipException {
                    return null;
                }

                public Integer getCRC() throws SevenZipException {
                    return null;
                }

                public String getMethod() throws SevenZipException {
                    return method;
                }

                public Integer getPosition() throws SevenZipException {
                    return null;
                }

                public String getHostOS() throws SevenZipException {
                    return null;
                }

                public String getUser() throws SevenZipException {
                    return null;
                }

                public String getGroup() throws SevenZipException {
                    return null;
                }

                public String getComment() throws SevenZipException {
                    return null;
                }

                public ExtractOperationResult extractSlow(ISequentialOutStream isequentialoutstream) throws SevenZipException {
                    return null;
                }

                public ExtractOperationResult extractSlow(ISequentialOutStream isequentialoutstream, String s) throws SevenZipException {
                    return null;
                }

                public int getItemIndex() {
                    return index;
                }
            };
            try {
                if (Boolean.TRUE.equals(isFolder) || extractaskmode != ExtractAskMode.EXTRACT) {
                    ret = this.getNullOutputStream(false);
                } else {
                    AtomicBoolean skippedFlag = new AtomicBoolean(false);
                    File extractTo = this.multi.getExtractFilePath(item, this.ctrl, skippedFlag);
                    this.ctrl.setCurrentActiveItem(new Item(path, item.getSize(), extractTo));
                    if (skippedFlag.get()) {
                        ret = this.getNullOutputStream(true);
                    } else {
                        if (extractTo == null) {
                            throw new SevenZipException("Extraction error, extractTo == null");
                        }
                        ret = new MultiCallback(extractTo, this.ctrl, this.config){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            protected void waitCPUPriority() throws SevenZipException {
                                if (!Seven7ExtractCallback.this.slowDownWorkaroundNeeded) {
                                    super.waitCPUPriority();
                                } else {
                                    2 var1_1 = this;
                                    synchronized (var1_1) {
                                        try {
                                            this.wait(150L);
                                        }
                                        catch (InterruptedException e) {
                                            throw new SevenZipException((Throwable)e);
                                        }
                                    }
                                }
                            }

                            @Override
                            public int write(byte[] data) throws SevenZipException {
                                if (Seven7ExtractCallback.this.ctrl.gotKilled()) {
                                    throw new MultiSevenZipException("Extraction has been aborted", 255);
                                }
                                int ret = super.write(data);
                                Seven7ExtractCallback.this.ctrl.addProcessedBytesAndPauseIfNeeded(ret);
                                return ret;
                            }
                        };
                        this.archive.addExtractedFiles(extractTo);
                    }
                }
                this.outStreams[index] = ret;
            }
            catch (Throwable e) {
                this.error.set(e);
                if (e instanceof SevenZipException) {
                    throw (SevenZipException)e;
                }
                throw new SevenZipException(e);
            }
        }
        return ret;
    }

    protected ISequentialOutStream getNullOutputStream(final boolean countBytesAsProcessed) {
        if (this.slowDownWorkaroundNeeded) {
            return new ISequentialOutStream(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public int write(byte[] data) throws SevenZipException {
                    3 var2_2 = this;
                    synchronized (var2_2) {
                        try {
                            this.wait(150L);
                        }
                        catch (InterruptedException e) {
                            throw new SevenZipException((Throwable)e);
                        }
                    }
                    if (Seven7ExtractCallback.this.ctrl.gotKilled()) {
                        throw new MultiSevenZipException("Extraction has been aborted", 255);
                    }
                    if (countBytesAsProcessed) {
                        Seven7ExtractCallback.this.ctrl.addProcessedBytesAndPauseIfNeeded(data.length);
                    }
                    return data.length;
                }
            };
        }
        return new ISequentialOutStream(){

            public int write(byte[] data) throws SevenZipException {
                if (Seven7ExtractCallback.this.ctrl.gotKilled()) {
                    throw new MultiSevenZipException("Extraction has been aborted", 255);
                }
                if (countBytesAsProcessed) {
                    Seven7ExtractCallback.this.ctrl.addProcessedBytesAndPauseIfNeeded(data.length);
                }
                return data.length;
            }
        };
    }

    public boolean hasError() {
        return this.getError() != null;
    }

    public Throwable getError() {
        return this.error.get();
    }

    public void prepareOperation(ExtractAskMode arg0) throws SevenZipException {
    }

    public void setOperationResult(ExtractOperationResult res) throws SevenZipException {
        block21: {
            try {
                if (this.lastIndex < 0) break block21;
                ISequentialOutStream ret = this.outStreams[this.lastIndex];
                if (ret != null) {
                    this.outStreams[this.lastIndex] = null;
                    try {
                        if (ret instanceof MultiCallback) {
                            ((MultiCallback)ret).close();
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                this.results[this.lastIndex] = res;
                ISimpleInArchiveItem item = this.items[this.lastIndex];
                MultiCallback callback = null;
                if (item != null && ret != null) {
                    if (ret instanceof MultiCallback) {
                        callback = (MultiCallback)ret;
                    }
                    Long size = item.getSize();
                    if (callback != null && size != null && size.longValue() != callback.getWritten()) {
                        this.logger.info("Size missmatch for " + item.getPath() + " is " + callback.getWritten() + " but should be " + size);
                        if (ExtractOperationResult.OK == res) {
                            this.logger.info("Size missmatch for " + item.getPath() + ", but Extraction returned OK?! Archive seems incomplete");
                            this.archive.setExitCode(4);
                            throw new SevenZipException("Extraction error");
                        }
                    }
                }
                switch (res) {
                    case OK: {
                        if (callback != null) {
                            this.multi.setLastModifiedDate(item, callback.getFile());
                            this.multi.setPermissions(item, callback.getFile());
                        }
                        break;
                    }
                    case CRCERROR: {
                        if (item != null) {
                            this.logger.info("CRC Error in " + item.getPath());
                        }
                        this.archive.setExitCode(3);
                        if (item != null) {
                            throw new SevenZipException("CRC-Extraction error in " + item.getPath());
                        }
                        throw new SevenZipException("CRC-Extraction error");
                    }
                    case UNSUPPORTEDMETHOD: {
                        if (item != null) {
                            this.logger.info("Unsupported Method " + item.getMethod() + " in " + item.getPath());
                        }
                        this.archive.setExitCode(2);
                        if (item != null) {
                            throw new SevenZipException("Unsupported Method " + item.getMethod() + " in " + item.getPath());
                        }
                        throw new SevenZipException("Unsupported Method");
                    }
                    default: {
                        this.archive.setExitCode(2);
                        throw new SevenZipException("Extraction error");
                    }
                }
            }
            catch (Throwable e) {
                this.error.set(e);
                if (e instanceof SevenZipException) {
                    throw (SevenZipException)e;
                }
                throw new SevenZipException(e);
            }
        }
    }

    public void close() {
        if (this.outStreams != null) {
            for (ISequentialOutStream outStream : this.outStreams) {
                if (outStream == null) continue;
                try {
                    if (!(outStream instanceof MultiCallback)) continue;
                    ((MultiCallback)outStream).close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }
}

