/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jd.gui.UserIO;
import jd.nutils.io.JDIO;
import jd.utils.JDUtilities;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.os.CrossSystem;
import org.jdownloader.captcha.v2.solver.solver9kw.Captcha9kwSettings;
import org.jdownloader.logging.LogController;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JACMethod
implements Comparable<JACMethod> {
    private static List<JACMethod> methods = null;
    private String filename;
    private String servicename;

    public static JACMethod forServiceName(String service) {
        for (JACMethod method : JACMethod.getMethods()) {
            if (!service.equalsIgnoreCase(method.getServiceName())) continue;
            if (((Captcha9kwSettings)JsonConfig.create(Captcha9kwSettings.class)).isEnabled() && method.getFileName().equalsIgnoreCase("captcha9kw")) {
                if (((Captcha9kwSettings)JsonConfig.create(Captcha9kwSettings.class)).isEnabled() && method.getFileName().equalsIgnoreCase("captcha9kw")) {
                    UserIO.getInstance().requestMessageDialog("9kw old method captcha9kw ", "Please delete old method captcha9kw and use jd2 with 9kw.\n");
                }
                LogController.CL().info("Inactive JAC method for the service " + service + " in directory " + method.getFileName());
                continue;
            }
            LogController.CL().info("Found JAC method for the service " + service + " in directory " + method.getFileName());
            return method;
        }
        LogController.CL().info("There is no JAC method for the service " + service + "!");
        return null;
    }

    public static synchronized List<JACMethod> getMethods() {
        if (methods != null) {
            return methods;
        }
        ArrayList<JACMethod> methods = new ArrayList<JACMethod>();
        for (File methodDir : JACMethod.getMethodDirs()) {
            List<JACMethod> meths = JACMethod.parseJACInfo(methodDir);
            if (meths == null) continue;
            methods.addAll(meths);
        }
        Collections.sort(methods);
        JACMethod.methods = methods;
        return methods;
    }

    private static File[] getMethodDirs() {
        File dir = JDUtilities.getResourceFile((String)JDUtilities.getJACMethodsDirectory());
        if (dir == null || !dir.exists()) {
            LogController.CL().severe("Konnte Methodenordner nicht finden: " + dir);
            return new File[0];
        }
        File[] entries = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (!pathname.isDirectory()) {
                    return false;
                }
                File method = new File(pathname.getAbsoluteFile() + "/jacinfo.xml");
                return method.exists() && JACMethod.isAvailableExternMethod(method);
            }
        });
        return entries;
    }

    public static List<JACMethod> parseJACInfo(File dir) {
        String filecontent = JDIO.readFileToString((File)new File(dir.getAbsolutePath() + "/jacinfo.xml"));
        Document doc = JDUtilities.parseXmlString((String)filecontent);
        if (doc == null) {
            return null;
        }
        String[] services = null;
        NodeList nl = doc.getFirstChild().getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node childNode = nl.item(i);
            if (!childNode.getNodeName().equals("method")) continue;
            String servicelist = JDUtilities.getAttribute((Node)childNode, (String)"services");
            if (servicelist != null) {
                services = servicelist.split(";");
                break;
            }
            services = new String[]{JDUtilities.getAttribute((Node)childNode, (String)"name")};
            break;
        }
        ArrayList<JACMethod> methods = new ArrayList<JACMethod>();
        if (services != null) {
            for (String service : services) {
                LogController.CL().info("Method " + dir.getName() + " supports " + service);
                methods.add(new JACMethod(dir.getName(), service));
            }
        }
        return methods;
    }

    public static boolean hasMethod(String service) {
        if (service == null) {
            return false;
        }
        JACMethod methodName = JACMethod.forServiceName(service);
        if (methodName == null) {
            return false;
        }
        File method = JDUtilities.getResourceFile((String)(JDUtilities.getJACMethodsDirectory() + "/" + methodName.getFileName() + "/jacinfo.xml"));
        return method.exists() && JACMethod.isAvailableExternMethod(method);
    }

    private static boolean isAvailableExternMethod(File jacinfo) {
        return JACMethod.isAvailableExternMethod(JDIO.readFileToString((File)jacinfo));
    }

    private static boolean isAvailableExternMethod(String content) {
        if (content != null && content.contains("extern")) {
            if (CrossSystem.isLinux() && !content.contains("linux")) {
                return false;
            }
            if (CrossSystem.isMac() && !content.contains("mac")) {
                return false;
            }
            if (CrossSystem.isWindows() && !content.contains("windows")) {
                return false;
            }
        }
        return true;
    }

    public JACMethod(String filename, String servicename) {
        this.filename = filename;
        if (servicename != null) {
            this.servicename = servicename.toLowerCase();
        }
    }

    public String getFileName() {
        return this.filename;
    }

    public String getServiceName() {
        return this.servicename;
    }

    @Override
    public int compareTo(JACMethod o) {
        return (this.servicename + " " + this.filename).compareToIgnoreCase(o.getServiceName() + " " + o.getFileName());
    }
}

