/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha.easy;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import jd.captcha.easy.BackGroundImage;
import jd.captcha.easy.BackGroundImageManager;
import jd.captcha.easy.BackgroundFilterCreater;
import jd.captcha.easy.ColorMode;
import jd.captcha.gui.ImageComponent;
import jd.captcha.translate.T;
import jd.captcha.utils.Utilities;
import jd.nutils.JDHash;
import jd.nutils.io.JDIO;
import org.appwork.utils.Files;
import org.appwork.utils.StringUtils;
import org.appwork.utils.swing.EDTHelper;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.appwork.utils.swing.dialog.ExtFileChooserDialog;
import org.appwork.utils.swing.dialog.FileChooserSelectionMode;
import org.appwork.utils.swing.dialog.FileChooserType;

public class BackGroundImageDialog
implements ActionListener {
    private final JFrame owner;
    public BackGroundImage workingImage;
    private final BackGroundImageManager bgim;
    private ImageComponent bg1;
    private ImageComponent bgv;
    private ImageComponent bgmask;
    private BackGroundImage ret = null;
    private JDialog dialog;
    private JButton btColorChoose;
    private JButton btPreview;
    private JButton btFinished;
    private JButton btLoadBackgroundImage;
    private JButton btCreateBackgroundFilter;
    private JComboBox colorModeBox;
    private JSpinner thresholdSpinner;
    private JColorChooser colorChooser;
    private int threshold = 2;
    private byte colorMode = (byte)11;
    private JPanel imagePanel;

    public BackGroundImageDialog(BackGroundImageManager bgim, JFrame owner) {
        this.bgim = bgim;
        this.owner = owner;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        new EDTHelper<Object>(){

            public Object edtRun() {
                BackGroundImageDialog.this.dialog.setAlwaysOnTop(false);
                return null;
            }
        }.waitForEDT();
        if (e.getSource() == this.btPreview) {
            try {
                this.workingImage.setDistance((Integer)this.thresholdSpinner.getValue());
                this.workingImage.setColorDistanceMode(this.colorMode);
                this.workingImage.setColor(this.colorChooser.getColor().getRGB());
                this.bgim.clearCaptchaPreview(this.workingImage);
                final Image image2 = this.bgim.getScaledCaptchaImage();
                new EDTHelper<Object>(){

                    public Object edtRun() {
                        ((BackGroundImageDialog)BackGroundImageDialog.this).bgv.image = image2;
                        BackGroundImageDialog.this.bgv.repaint();
                        return null;
                    }
                }.waitForEDT();
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
        } else if (e.getSource() == this.btColorChoose) {
            new EDTHelper<Object>(){

                public Object edtRun() {
                    JDialog dialog = JColorChooser.createDialog(BackGroundImageDialog.this.colorChooser, T.T.easycaptcha_addbackgroundimagedialog_deletecolor(), true, BackGroundImageDialog.this.colorChooser, null, null);
                    dialog.setDefaultCloseOperation(2);
                    dialog.setAlwaysOnTop(true);
                    dialog.setVisible(true);
                    return null;
                }
            }.waitForEDT();
        } else {
            if (e.getSource() == this.btFinished) {
                new EDTHelper<Object>(){

                    public Object edtRun() {
                        BackGroundImageDialog.this.dialog.dispose();
                        return null;
                    }
                }.waitForEDT();
                this.workingImage.setColor(this.colorChooser.getColor().getRGB());
                this.workingImage.setDistance((Integer)this.thresholdSpinner.getValue());
                this.workingImage.setColorDistanceMode(this.colorMode);
                this.ret = this.workingImage;
                return;
            }
            if (e.getSource() == this.btLoadBackgroundImage) {
                ExtFileChooserDialog d = new ExtFileChooserDialog(0, "Choose Background Image", null, null);
                d.setFileSelectionMode(FileChooserSelectionMode.FILES_ONLY);
                d.setFileFilter(new FileFilter[]{new FileFilter(){

                    @Override
                    public String getDescription() {
                        return "png";
                    }

                    @Override
                    public boolean accept(File f) {
                        return f.isDirectory() || StringUtils.endsWithCaseInsensitive((String)f.getName(), (String)".png");
                    }
                }});
                d.setType(FileChooserType.OPEN_DIALOG);
                d.setMultiSelection(false);
                try {
                    Dialog.I().showDialog((AbstractDialog)d);
                }
                catch (DialogClosedException e2) {
                    return;
                }
                catch (DialogCanceledException e2) {
                    return;
                }
                File fout = new File(this.bgim.methode.file, "mask_" + JDHash.getMD5((File)d.getSelectedFile()) + "." + Files.getExtension((String)d.getSelectedFile().getName()));
                JDIO.copyFile((File)d.getSelectedFile(), (File)fout);
                this.workingImage = new BackGroundImage();
                this.workingImage.setBackgroundImage(fout.getName());
                this.workingImage.setColor(this.colorChooser.getColor().getRGB());
                this.workingImage.setDistance((Integer)this.thresholdSpinner.getValue());
                this.workingImage.setColorDistanceMode(this.colorMode);
                try {
                    this.bgim.clearCaptchaPreview(this.workingImage);
                    this.btPreview.setEnabled(true);
                    final Image image2 = this.bgim.getScaledCaptchaImage();
                    new EDTHelper<Object>(){

                        public Object edtRun() {
                            ((BackGroundImageDialog)BackGroundImageDialog.this).bgv.image = image2;
                            ((BackGroundImageDialog)BackGroundImageDialog.this).bgmask.image = BackGroundImageDialog.this.workingImage.getImage(((BackGroundImageDialog)BackGroundImageDialog.this).bgim.methode);
                            BackGroundImageDialog.this.bgmask.repaint();
                            BackGroundImageDialog.this.bgv.repaint();
                            return null;
                        }
                    }.waitForEDT();
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            } else if (e.getSource() == this.btCreateBackgroundFilter) {
                try {
                    File fout = BackgroundFilterCreater.create(this.bgim.methode);
                    if (fout != null && fout.exists()) {
                        this.workingImage = new BackGroundImage();
                        this.workingImage.setBackgroundImage(fout.getName());
                        this.workingImage.setColor(this.colorChooser.getColor().getRGB());
                        this.workingImage.setDistance((Integer)this.thresholdSpinner.getValue());
                        this.workingImage.setColorDistanceMode(this.colorMode);
                        this.bgim.clearCaptchaPreview(this.workingImage);
                        this.btPreview.setEnabled(true);
                        final Image image2 = this.bgim.getScaledCaptchaImage();
                        new EDTHelper<Object>(){

                            public Object edtRun() {
                                ((BackGroundImageDialog)BackGroundImageDialog.this).bgv.image = image2;
                                ((BackGroundImageDialog)BackGroundImageDialog.this).bgmask.image = BackGroundImageDialog.this.workingImage.getImage(((BackGroundImageDialog)BackGroundImageDialog.this).bgim.methode);
                                BackGroundImageDialog.this.bgmask.repaint();
                                BackGroundImageDialog.this.bgv.repaint();
                                return null;
                            }
                        }.waitForEDT();
                    }
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            } else if (e.getSource() == this.colorModeBox) {
                this.colorMode = ((ColorMode)this.colorModeBox.getSelectedItem()).mode;
            }
        }
        new EDTHelper<Object>(){

            public Object edtRun() {
                BackGroundImageDialog.this.dialog.setAlwaysOnTop(true);
                return null;
            }
        }.waitForEDT();
    }

    private void addActionListeners() {
        this.btColorChoose.addActionListener(this);
        this.btPreview.addActionListener(this);
        this.btFinished.addActionListener(this);
        this.btLoadBackgroundImage.addActionListener(this);
        this.btCreateBackgroundFilter.addActionListener(this);
        this.colorModeBox.addActionListener(this);
    }

    private void addComponentsToDialog() {
        new EDTHelper<Object>(){

            public Object edtRun() {
                JPanel box = new JPanel();
                box.setLayout(new GridBagLayout());
                GridBagConstraints gbc = Utilities.getGBC(0, 0, 1, 1);
                gbc.anchor = 11;
                gbc.fill = 1;
                gbc.weighty = 1.0;
                gbc.weightx = 1.0;
                box.add((Component)BackGroundImageDialog.this.imagePanel, gbc);
                Box menu = new Box(0);
                menu.add(BackGroundImageDialog.this.btLoadBackgroundImage);
                menu.add(BackGroundImageDialog.this.btCreateBackgroundFilter);
                menu.add(BackGroundImageDialog.this.btColorChoose);
                menu.add(BackGroundImageDialog.this.btPreview);
                menu.add(BackGroundImageDialog.this.thresholdSpinner);
                menu.add(BackGroundImageDialog.this.colorModeBox);
                menu.add(BackGroundImageDialog.this.btFinished);
                gbc.gridy = 1;
                box.add((Component)menu, gbc);
                BackGroundImageDialog.this.dialog.add(box);
                BackGroundImageDialog.this.dialog.pack();
                BackGroundImageDialog.this.addActionListeners();
                BackGroundImageDialog.this.dialog.setVisible(true);
                return null;
            }
        }.waitForEDT();
    }

    public BackGroundImage getNewBackGroundImage() {
        this.init();
        return this.ret;
    }

    private void init() {
        this.initDialog();
        this.initCaptchaImages();
        this.initComponents();
        this.addComponentsToDialog();
    }

    private void initCaptchaImages() {
        this.bgim.resetCaptcha();
        final Image image = this.bgim.getScaledCaptchaImage();
        new EDTHelper<Object>(){

            public Object edtRun() {
                try {
                    BackGroundImageDialog.this.imagePanel = new JPanel();
                    BackGroundImageDialog.this.imagePanel.setBorder(new TitledBorder(T.T.easycaptcha_images()));
                    BackGroundImageDialog.this.imagePanel.setLayout(new BoxLayout(BackGroundImageDialog.this.imagePanel, 1));
                    BackGroundImageDialog.this.imagePanel.add(new JLabel(T.T.easycaptcha_mask()));
                    if (BackGroundImageDialog.this.workingImage != null) {
                        BackGroundImageDialog.this.bgmask = new ImageComponent(BackGroundImageDialog.this.workingImage.getImage(((BackGroundImageDialog)BackGroundImageDialog.this).bgim.methode));
                    } else {
                        BufferedImage bi = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
                        Graphics2D ig2 = bi.createGraphics();
                        ig2.fillRect(0, 0, image.getWidth(null) - 1, image.getHeight(null) - 1);
                        BackGroundImageDialog.this.bgmask = new ImageComponent(bi);
                    }
                    BackGroundImageDialog.this.imagePanel.add(BackGroundImageDialog.this.bgmask);
                    BackGroundImageDialog.this.imagePanel.add(Box.createRigidArea(new Dimension(0, 10)));
                    BackGroundImageDialog.this.imagePanel.add(new JLabel(T.T.easycaptcha_orginal()));
                    BackGroundImageDialog.this.bg1 = new ImageComponent(image);
                    BackGroundImageDialog.this.imagePanel.add(BackGroundImageDialog.this.bg1);
                    BackGroundImageDialog.this.imagePanel.add(Box.createRigidArea(new Dimension(0, 10)));
                    BackGroundImageDialog.this.imagePanel.add(new JLabel(T.T.easycaptcha_addbackgroundimagedialog_imagepreview() + ":"));
                    if (BackGroundImageDialog.this.workingImage != null) {
                        BackGroundImageDialog.this.threshold = BackGroundImageDialog.this.workingImage.getDistance();
                        BackGroundImageDialog.this.colorMode = BackGroundImageDialog.this.workingImage.getColorDistanceMode();
                        BackGroundImageDialog.this.bgim.clearCaptchaPreview(BackGroundImageDialog.this.workingImage);
                    }
                    BackGroundImageDialog.this.bgv = new ImageComponent(BackGroundImageDialog.this.bgim.getScaledCaptchaImage());
                    BackGroundImageDialog.this.imagePanel.add(BackGroundImageDialog.this.bgv);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                return null;
            }
        }.waitForEDT();
    }

    private void initComponents() {
        new EDTHelper<Object>(){

            public Object edtRun() {
                BackGroundImageDialog.this.thresholdSpinner = new JSpinner(new SpinnerNumberModel(BackGroundImageDialog.this.threshold, 0, 360, 1));
                BackGroundImageDialog.this.thresholdSpinner.setToolTipText("Threshold");
                BackGroundImageDialog.this.btLoadBackgroundImage = new JButton(T.T.easycaptcha_addbackgroundimagedialog_loadimage());
                BackGroundImageDialog.this.btCreateBackgroundFilter = new JButton(T.T.easycaptcha_addbackgroundimagedialog_generate());
                Color defColor = Color.WHITE;
                if (BackGroundImageDialog.this.workingImage != null) {
                    defColor = new Color(BackGroundImageDialog.this.workingImage.getColor());
                }
                BackGroundImageDialog.this.colorChooser = new JColorChooser(defColor);
                BackGroundImageDialog.this.btColorChoose = new JButton(T.T.easycaptcha_addbackgroundimagedialog_deletecolor());
                BackGroundImageDialog.this.btPreview = new JButton(T.T.easycaptcha_addbackgroundimagedialog_imagepreview());
                if (BackGroundImageDialog.this.workingImage == null) {
                    BackGroundImageDialog.this.btPreview.setEnabled(false);
                }
                BackGroundImageDialog.this.colorModeBox = new JComboBox<ColorMode>(ColorMode.cModes);
                BackGroundImageDialog.this.colorModeBox.setSelectedItem(new ColorMode(BackGroundImageDialog.this.colorMode));
                BackGroundImageDialog.this.btFinished = new JButton(T.T.easycaptcha_finished());
                return null;
            }
        }.waitForEDT();
    }

    private void initDialog() {
        new EDTHelper<Object>(){

            public Object edtRun() {
                BackGroundImageDialog.this.dialog = new JDialog(BackGroundImageDialog.this.owner);
                BackGroundImageDialog.this.dialog.setTitle(T.T.easycaptcha_addbackgroundimagedialog_title());
                BackGroundImageDialog.this.dialog.setDefaultCloseOperation(2);
                BackGroundImageDialog.this.dialog.setModal(true);
                BackGroundImageDialog.this.dialog.setAlwaysOnTop(true);
                return null;
            }
        }.waitForEDT();
    }
}

