/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha.easy;

import java.awt.Image;
import java.io.File;
import java.util.Iterator;
import java.util.Vector;
import jd.captcha.easy.BackGroundImage;
import jd.captcha.easy.EasyMethodFile;
import jd.captcha.pixelgrid.Captcha;
import jd.captcha.pixelgrid.PixelGrid;
import jd.nutils.io.JDIO;
import org.jdownloader.controlling.FileCreationManager;
import org.jdownloader.logging.LogController;

public class BackGroundImageManager {
    private Vector<BackGroundImage> backgroundList = null;
    protected EasyMethodFile methode;
    private Captcha captchaImage;
    public int zoom;
    protected int[][] backupGrid;
    private String fileName = "bgimages.xml";

    private void autoSetZoomFaktor() {
        this.zoom = this.captchaImage.getWidth() > 200 || this.captchaImage.getHeight() > 100 ? 100 : (this.captchaImage.getWidth() > 100 || this.captchaImage.getHeight() > 50 ? 200 : 400);
    }

    public BackGroundImageManager(EasyMethodFile methode) throws InterruptedException {
        this(methode.getRandomCaptcha());
    }

    public BackGroundImageManager(String hoster) throws InterruptedException {
        this(new EasyMethodFile(hoster));
    }

    public BackGroundImageManager(Captcha captcha) {
        this.captchaImage = captcha;
        this.backupGrid = PixelGrid.getGridCopy(captcha.getGrid());
        this.autoSetZoomFaktor();
        this.methode = new EasyMethodFile(this.captchaImage.owner.getResourceFile("jacinfo.xml").getParentFile());
        this.load();
    }

    public Image getScaledCaptchaImage() {
        return this.captchaImage.getImage().getScaledInstance(this.captchaImage.getWidth() * this.zoom / 100, this.captchaImage.getHeight() * this.zoom / 100, 1);
    }

    public Vector<BackGroundImage> getBackgroundList() {
        return this.backgroundList;
    }

    public void setBackgroundList(Vector<BackGroundImage> backgroundList) {
        this.backgroundList = backgroundList;
    }

    public void add(BackGroundImage bgi) {
        this.backgroundList.add(bgi);
    }

    public Captcha getCaptchaImage() {
        return this.captchaImage;
    }

    public void setCaptchaImage(Captcha captchaImage) {
        this.captchaImage = captchaImage;
    }

    public void setBackGroundImageListFileName(String name) {
        this.fileName = name;
        this.load();
    }

    private File getBgImagesXmlFile() {
        return new File(this.methode.getJacinfoXml().getParent(), this.fileName);
    }

    private void load() {
        File file = this.getBgImagesXmlFile();
        this.backgroundList = file.exists() ? (Vector)JDIO.loadObject((File)file, (boolean)true) : new Vector();
    }

    public void save() {
        File file = this.getBgImagesXmlFile();
        FileCreationManager.getInstance().mkdir(file.getParentFile());
        Iterator<BackGroundImage> iter = this.backgroundList.iterator();
        while (iter.hasNext()) {
            BackGroundImage bgi = iter.next();
            if (bgi != null && bgi.getBackgroundImage() != null && !bgi.getBackgroundImage().matches("\\s*")) continue;
            iter.remove();
        }
        if (this.backgroundList.isEmpty()) {
            FileCreationManager.getInstance().delete(file, null);
        } else {
            JDIO.saveObject(this.backgroundList, (File)file, (boolean)true);
        }
    }

    public void clearCaptchaAll() throws InterruptedException {
        this.clearCaptchaAll(this.backgroundList);
    }

    public void clearCaptchaPreview(BackGroundImage preview) throws InterruptedException {
        this.captchaImage.grid = PixelGrid.getGridCopy(this.backupGrid);
        preview.clearCaptcha(this.captchaImage);
    }

    public void resetCaptcha() {
        this.captchaImage.grid = PixelGrid.getGridCopy(this.backupGrid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCaptchaAll(final Vector<BackGroundImage> preview) throws InterruptedException {
        Thread th;
        int i;
        Captcha best = null;
        BackGroundImage bestBgi = null;
        int bestVal = -1;
        final Captcha[] bgic = new Captcha[preview.size()];
        Thread[] cths = new Thread[bgic.length];
        for (i = 0; i < cths.length; ++i) {
            final int c = i;
            cths[i] = th = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        BackGroundImage bgi = (BackGroundImage)preview.get(c);
                        Image bImage = bgi.getImage(BackGroundImageManager.this.methode);
                        if (bImage == null || bImage.getWidth(null) != BackGroundImageManager.this.captchaImage.getWidth() || bImage.getHeight(null) != BackGroundImageManager.this.captchaImage.getHeight()) {
                            LogController.CL().severe("ERROR Maske und Bild passen nicht zusammmen");
                            1 var3_4 = this;
                            synchronized (var3_4) {
                                this.notify();
                            }
                            bgic[c] = null;
                            return;
                        }
                        bgic[c] = ((BackGroundImageManager)BackGroundImageManager.this).captchaImage.owner.createCaptcha(bImage);
                    }
                    catch (Exception e) {
                        bgic[c] = null;
                    }
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        this.notify();
                    }
                }
            });
            th.start();
        }
        for (i = 0; i < cths.length; ++i) {
            BackGroundImage bgi = preview.get(i);
            while (cths[i].isAlive()) {
                th = cths[i];
                synchronized (th) {
                    try {
                        cths[i].wait(3000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            Captcha captcha2 = bgic[i];
            if (captcha2 == null) continue;
            int color = bgi.getColor();
            int val = 0;
            block8: for (int x = 0; x < this.captchaImage.getWidth(); ++x) {
                for (int y = 0; y < this.captchaImage.getHeight(); ++y) {
                    bgi.setColor(captcha2.getPixelValue(x, y));
                    if (x == this.captchaImage.getWidth() / 3 && val < bestVal / 4) break block8;
                    if (!(bgi.getColorDifference(this.backupGrid[x][y]) < (double)bgi.getDistance())) continue;
                    ++val;
                }
            }
            bgi.setColor(color);
            if (val <= bestVal) continue;
            best = captcha2;
            bestVal = val;
            bestBgi = bgi;
        }
        if (best != null) {
            this.resetCaptcha();
            bestBgi.clearCaptcha(this.captchaImage);
        }
    }

    public void remove(BackGroundImage dialogImage) {
        this.backgroundList.remove(dialogImage);
    }
}

