/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha.easy.load;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URI;
import jd.captcha.JAntiCaptcha;
import jd.captcha.easy.load.LoadCaptchas;
import jd.captcha.easy.load.LoadInfo;
import jd.captcha.pixelgrid.Captcha;
import jd.http.Browser;
import jd.http.URLConnectionAdapter;
import jd.nutils.JDHash;
import jd.nutils.io.JDIO;
import jd.parser.html.HTMLParser;
import jd.utils.JDUtilities;
import org.appwork.utils.ImageProvider.ImageProvider;
import org.jdownloader.controlling.FileCreationManager;

public class LoadImage {
    public String baseUrl;
    protected int followUrl = -1;
    public transient String imageUrl;
    protected int form = -1;
    protected String fileType = null;
    protected int location = 0;
    public transient Browser br;
    public transient File file;
    public transient boolean clearCookies = true;

    public LoadImage(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public LoadImage() {
        this.br = new Browser();
        this.br.setFollowRedirects(true);
    }

    public LoadImage(LoadInfo loadInfo) {
        this.baseUrl = loadInfo.link;
        this.br = new Browser();
        this.br.setFollowRedirects(true);
    }

    public LoadImage(LoadInfo loadInfo, String imageUrl, Browser br) {
        this.baseUrl = loadInfo.link;
        this.imageUrl = imageUrl;
        this.br = br.cloneBrowser();
    }

    public int getFollowUrl() {
        return this.followUrl;
    }

    public void setFollowUrl(int followUrl) {
        this.followUrl = followUrl;
    }

    public int getForm() {
        return this.form;
    }

    public void setForm(int form) {
        this.form = form;
    }

    public int getLocation() {
        return this.location;
    }

    public void setLocation(int location) {
        this.location = location;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof LoadImage) {
            String url = ((LoadImage)obj).imageUrl;
            if (this.imageUrl == url) {
                return true;
            }
            if (url == null) {
                return false;
            }
            return url.equals(this.imageUrl);
        }
        return false;
    }

    public int hashCode() {
        return this.imageUrl == null ? 0 : this.imageUrl.hashCode();
    }

    public boolean renameCaptcha(File file, String destination) {
        File dest;
        long b = 0L;
        try {
            BufferedImage ret = ImageProvider.read((File)file);
            Captcha captcha = new JAntiCaptcha("easycaptcha").createCaptcha(ret);
            for (int x = 0; x < captcha.getWidth(); ++x) {
                for (int y = 0; y < captcha.getHeight(); ++y) {
                    Color c = new Color(captcha.grid[x][y]);
                    b += (long)c.getBlue();
                }
            }
        }
        catch (Exception ret) {
            // empty catch block
        }
        if ((dest = new File(destination, b + "_" + JDHash.getMD5((File)file) + this.getFileType())).exists()) {
            FileCreationManager.getInstance().delete(file, null);
            return false;
        }
        file.renameTo(dest);
        this.file = dest;
        return true;
    }

    public boolean directCaptchaLoad(String destination) {
        this.file = new File(destination, System.currentTimeMillis() + this.getFileType());
        try {
            URLConnectionAdapter urlc = this.br.cloneBrowser().openGetConnection(this.imageUrl);
            Browser.download((File)this.file, (URLConnectionAdapter)urlc);
            return this.renameCaptcha(this.file, destination);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public LoadImage load(String host) throws Exception {
        if (host == null) {
            host = new URI(this.baseUrl).getHost();
        }
        String destination = JDUtilities.getJDHomeDirectoryFromEnvironment().getAbsolutePath() + "/captchas/" + host + "/";
        FileCreationManager.getInstance().mkdir(new File(destination));
        this.br.clearCookies(this.baseUrl);
        this.br.getPage(this.baseUrl);
        if (this.followUrl != -1) {
            String[] links = HTMLParser.getHttpLinks((String)this.br.toString(), (String)this.br.getURL());
            this.br.getPage(links[this.followUrl]);
        }
        if (this.form != -1) {
            this.br.submitForm(LoadCaptchas.getForms(this.br)[this.form]);
        }
        this.imageUrl = LoadCaptchas.getImages(this.br)[this.location];
        this.directCaptchaLoad(destination);
        return this;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public String getFileType() {
        if (this.fileType != null) {
            return this.fileType;
        }
        if (this.imageUrl == null) {
            return ".jpg";
        }
        this.fileType = ".jpg";
        if (this.imageUrl.toLowerCase().contains("\\.png")) {
            this.fileType = ".png";
        } else if (this.imageUrl.toLowerCase().contains("\\.png")) {
            this.fileType = ".gif";
        } else {
            try {
                Browser bc = this.br.cloneBrowser();
                bc.getPage(this.imageUrl);
                String ct2 = bc.getHttpConnection().getContentType().toLowerCase();
                if (ct2 != null && ct2.contains("image")) {
                    this.fileType = ct2.equals("image/jpeg") ? ".jpg" : ct2.replaceFirst("image/", ".");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.fileType;
    }

    public static String getFileType(String imageUrl, String conentType) {
        String fileType = ".jpg";
        if (imageUrl == null) {
            return ".jpg";
        }
        fileType = ".jpg";
        if (imageUrl.toLowerCase().contains("\\.png")) {
            fileType = ".png";
        } else if (imageUrl.toLowerCase().contains("\\.png")) {
            fileType = ".gif";
        } else if (conentType != null && conentType.contains("image")) {
            fileType = conentType.equals("image/jpeg") ? ".jpg" : conentType.replaceFirst("image/", ".");
        }
        return fileType;
    }

    public String toString() {
        return this.imageUrl;
    }

    public String toLowerCase() {
        return this.toString().toLowerCase();
    }

    public static LoadImage loadFile(File file) {
        if (file.exists()) {
            return (LoadImage)JDIO.loadObject((File)file, (boolean)true);
        }
        return null;
    }

    public static LoadImage loadFile(String host) {
        File file = new File(JDUtilities.getJDHomeDirectoryFromEnvironment() + "/" + JDUtilities.getJACMethodsDirectory() + host + "/LoadImage.xml");
        return LoadImage.loadFile(file);
    }

    public static void save(LoadImage li, File file) {
        FileCreationManager.getInstance().mkdir(file.getParentFile());
        System.out.println("LoadImage has beens saved under: " + file);
        JDIO.saveObject((Object)li, (File)file, (boolean)true);
    }

    public static void save(LoadImage selectedImage, String host) {
        File file = new File(JDUtilities.getJDHomeDirectoryFromEnvironment() + "/" + JDUtilities.getJACMethodsDirectory() + host + "/LoadImage.xml");
        LoadImage.save(selectedImage, file);
    }
}

