/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha.specials;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import jd.captcha.JAntiCaptcha;
import jd.captcha.pixelgrid.Captcha;
import jd.captcha.utils.GifDecoder;
import jd.nutils.Colors;
import jd.utils.JDUtilities;
import org.appwork.utils.ImageProvider.ImageProvider;
import org.jdownloader.logging.LogController;

public class Linksave {
    public static void main(String[] args) throws IOException {
        String hoster = "linksave.in";
        File[] list = JDUtilities.getResourceFile((String)("/captchas/" + hoster)).listFiles();
        int id = (int)(Math.random() * (double)(list.length - 1));
        id = 3;
        File f = list[id];
        for (File file : list) {
            Linksave.prepareCaptcha(file);
        }
        System.out.println(id);
        System.out.println(f);
    }

    private static void cleanBlack(int x, int y, int[][] grid) {
        for (int x1 = Math.max(x - 2, 0); x1 < Math.min(x + 2, grid.length); ++x1) {
            for (int y1 = Math.max(y - 2, 0); y1 < Math.min(y + 2, grid[0].length); ++y1) {
                if (grid[x1][y1] != 0) continue;
                grid[x1][y1] = 0xFFFFFF;
                Linksave.cleanBlack(x1, y1, grid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void prepareCaptcha(File file) {
        FileOutputStream fos = null;
        try {
            int i;
            int bl1;
            int y;
            JAntiCaptcha jac = new JAntiCaptcha("linksave.in");
            jac.getJas().setColorType("RGB");
            GifDecoder d = new GifDecoder();
            d.read(file.getAbsolutePath());
            int n = d.getFrameCount();
            Captcha[] frames = new Captcha[d.getFrameCount()];
            for (int i2 = 0; i2 < n; ++i2) {
                BufferedImage frame = d.getFrame(i2);
                frames[i2] = jac.createCaptcha(frame);
            }
            int[][] grid = new int[frames[0].getWidth()][frames[0].getHeight()];
            for (int x = 0; x < grid.length; ++x) {
                for (y = 0; y < grid[0].length; ++y) {
                    int max = 0;
                    HashMap<Integer, Integer> colors = new HashMap<Integer, Integer>();
                    int colorsCount = 0;
                    for (int i3 = 0; i3 < frames.length; ++i3) {
                        float[] hsb = Colors.rgb2hsb((int)frames[i3].getGrid()[x][y]);
                        int distance = Colors.getRGBDistance((int)frames[i3].getGrid()[x][y]);
                        if (!colors.containsKey(frames[i3].getGrid()[x][y])) {
                            colors.put(frames[i3].getGrid()[x][y], 1);
                            ++colorsCount;
                        } else {
                            colors.put(frames[i3].getGrid()[x][y], (Integer)colors.get(frames[i3].getGrid()[x][y]) + 1);
                        }
                        if ((double)hsb[2] < 0.2 && distance < 100) continue;
                        max = Math.max(max, frames[i3].getGrid()[x][y]);
                    }
                    int mainColor = 0;
                    int mainCount = 0;
                    for (Map.Entry col : colors.entrySet()) {
                        if ((Integer)col.getValue() <= mainCount || (Integer)col.getKey() <= 10) continue;
                        mainCount = (Integer)col.getValue();
                        mainColor = (Integer)col.getKey();
                    }
                    grid[x][y] = mainColor;
                }
            }
            int gl1 = grid[0].length - 1;
            for (int x = 0; x < grid.length; ++x) {
                bl1 = 0;
                int bl2 = 0;
                for (i = Math.max(0, x - 6); i < Math.min(grid.length, x + 6); ++i) {
                    if (grid[i][0] == 0) {
                        ++bl1;
                    }
                    if (grid[i][gl1] != 0) continue;
                    ++bl2;
                }
                if (bl1 == 12) {
                    Linksave.cleanBlack(x, 0, grid);
                }
                if (bl2 != 12) continue;
                Linksave.cleanBlack(x, gl1, grid);
            }
            gl1 = grid.length - 1;
            for (y = 0; y < grid.length; ++y) {
                bl1 = 0;
                int bl2 = 0;
                for (i = Math.max(0, y - 6); i < Math.min(grid[0].length, y + 6); ++i) {
                    if (grid[0][i] == 0) {
                        ++bl1;
                    }
                    if (grid[gl1][i] != 0) continue;
                    ++bl2;
                }
                if (bl1 == 12) {
                    Linksave.cleanBlack(0, y, grid);
                }
                if (bl2 != 12) continue;
                Linksave.cleanBlack(gl1, y, grid);
            }
            frames[0].setGrid(grid);
            fos = new FileOutputStream(file);
            ImageProvider.writeImage((RenderedImage)frames[0].getImage(1), (String)"png", (OutputStream)fos);
        }
        catch (Exception e) {
            LogController.CL().log((Throwable)e);
        }
        finally {
            try {
                fos.close();
            }
            catch (Throwable throwable) {}
        }
    }
}

