/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha.specials;

import jd.captcha.pixelgrid.Captcha;
import jd.captcha.pixelgrid.Letter;
import jd.captcha.pixelgrid.PixelGrid;
import jd.captcha.specials.EasyCaptcha;
import jd.nutils.Colors;

public class NtLdN {
    static boolean isRgb(int color) {
        return Colors.getRGBDistance((int)color) > 70;
    }

    static void setDotsInDigits(Captcha captcha) {
        int[][] grid = PixelGrid.getGridCopy(captcha.grid);
        for (int x = 1; x < captcha.getWidth() - 1; ++x) {
            for (int y = 1; y < captcha.getHeight() - 1; ++y) {
                if (!NtLdN.isRgb(captcha.grid[x][y])) continue;
                int co = captcha.grid[x + 1][y];
                int w = co != 0xFFFFFF && !NtLdN.isRgb(co) ? 1 : 0;
                co = captcha.grid[x + 1][y + 1];
                w += co != 0xFFFFFF && !NtLdN.isRgb(co) ? 1 : 0;
                co = captcha.grid[x][y + 1];
                w += co != 0xFFFFFF && !NtLdN.isRgb(co) ? 1 : 0;
                co = captcha.grid[x - 1][y + 1];
                w += co != 0xFFFFFF && !NtLdN.isRgb(co) ? 1 : 0;
                co = captcha.grid[x - 1][y - 1];
                w += co != 0xFFFFFF && !NtLdN.isRgb(co) ? 1 : 0;
                co = captcha.grid[x + 1][y - 1];
                w += co != 0xFFFFFF && !NtLdN.isRgb(co) ? 1 : 0;
                co = captcha.grid[x - 1][y];
                w += co != 0xFFFFFF && !NtLdN.isRgb(co) ? 1 : 0;
                co = captcha.grid[x][y - 1];
                if ((w += co != 0xFFFFFF && !NtLdN.isRgb(co) ? 1 : 0) <= 4) continue;
                grid[x][y] = 0;
            }
        }
        captcha.grid = grid;
    }

    static void toBlack(Captcha captcha) {
        for (int x = 0; x < captcha.getWidth(); ++x) {
            for (int y = 0; y < captcha.getHeight(); ++y) {
                if (captcha.grid[x][y] == 0xFFFFFF) continue;
                captcha.grid[x][y] = 0;
            }
        }
    }

    public static Letter[] getLetters(Captcha captcha) throws InterruptedException {
        Letter[] lets;
        NtLdN.setDotsInDigits(captcha);
        captcha.cleanByRGBDistance(1, 70);
        NtLdN.toBlack(captcha);
        captcha.removeSmallObjects(0.5, 0.5, 25);
        for (Letter letter : lets = EasyCaptcha.getLetters(captcha)) {
            letter.resizetoHeight(15);
        }
        return lets;
    }
}

