/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg.util;

import com.kitfox.svg.Font;
import com.kitfox.svg.FontFace;
import com.kitfox.svg.Glyph;
import com.kitfox.svg.MissingGlyph;
import java.awt.GraphicsEnvironment;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;

public class FontSystem
extends Font {
    java.awt.Font sysFont;
    HashMap<String, Glyph> glyphCache = new HashMap();
    static HashSet<String> sysFontNames = new HashSet();

    public static boolean checkIfSystemFontExists(String fontName) {
        if (sysFontNames.isEmpty()) {
            String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames(Locale.ENGLISH);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                sysFontNames.add(name);
                ++n2;
            }
        }
        return sysFontNames.contains(fontName);
    }

    public static FontSystem createFont(String[] fontFamilies, int fontStyle, int fontWeight, float fontSize) {
        String[] stringArray = fontFamilies;
        int n = fontFamilies.length;
        int n2 = 0;
        while (n2 < n) {
            String fontName = stringArray[n2];
            String javaFontName = FontSystem.mapJavaFontName(fontName);
            if (FontSystem.checkIfSystemFontExists(javaFontName)) {
                return new FontSystem(javaFontName, fontStyle, fontWeight, fontSize);
            }
            ++n2;
        }
        return null;
    }

    private static String mapJavaFontName(String fontName) {
        if ("serif".equals(fontName)) {
            return "Serif";
        }
        if ("sans-serif".equals(fontName)) {
            return "SansSerif";
        }
        if ("monospace".equals(fontName)) {
            return "Monospaced";
        }
        return fontName;
    }

    private FontSystem(String fontFamily, int fontStyle, int fontWeight, float fontSize) {
        int weight;
        int style;
        switch (fontStyle) {
            case 1: {
                style = 2;
                break;
            }
            default: {
                style = 0;
            }
        }
        switch (fontWeight) {
            case 1: 
            case 2: {
                weight = 1;
                break;
            }
            default: {
                weight = 0;
            }
        }
        this.sysFont = new java.awt.Font(fontFamily, style | weight, 1).deriveFont(fontSize);
        FontRenderContext fontRenderContext = new FontRenderContext(null, true, true);
        LineMetrics lineMetrics = this.sysFont.getLineMetrics("M", fontRenderContext);
        FontFace face = new FontFace();
        face.setAscent((int)lineMetrics.getAscent());
        face.setDescent((int)lineMetrics.getDescent());
        face.setUnitsPerEm((int)this.sysFont.getStringBounds("M", fontRenderContext).getWidth());
        this.setFontFace(face);
    }

    @Override
    public MissingGlyph getGlyph(String unicode) {
        FontRenderContext frc = new FontRenderContext(null, true, true);
        GlyphVector vec = this.sysFont.createGlyphVector(frc, unicode);
        Glyph glyph = this.glyphCache.get(unicode);
        if (glyph == null) {
            glyph = new Glyph();
            glyph.setPath(vec.getGlyphOutline(0));
            GlyphMetrics gm = vec.getGlyphMetrics(0);
            glyph.setHorizAdvX(gm.getAdvanceX());
            glyph.setVertAdvY(gm.getAdvanceY());
            glyph.setVertOriginX(0.0f);
            glyph.setVertOriginY(0.0f);
            this.glyphCache.put(unicode, glyph);
        }
        return glyph;
    }
}

