/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui;

import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.EventListener;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jd.gui.swing.jdgui.DonateTabHeader;
import jd.gui.swing.jdgui.JDGui;
import jd.gui.swing.jdgui.PromotionTabHeader;
import jd.gui.swing.jdgui.TopRightPainter;
import jd.gui.swing.jdgui.interfaces.SwitchPanelEvent;
import jd.gui.swing.jdgui.interfaces.View;
import jd.gui.swing.jdgui.maintab.ClosableTabHeader;
import jd.gui.swing.jdgui.maintab.CustomTabHeader;
import jd.gui.swing.jdgui.maintab.TabHeader;
import jd.gui.swing.jdgui.views.ClosableView;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.utils.event.DefaultEvent;
import org.appwork.utils.swing.EDTRunner;
import org.jdownloader.donate.DonationManager;
import org.jdownloader.gui.event.GUIEvent;
import org.jdownloader.gui.event.GUIEventSender;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.downloads.DownloadsView;
import org.jdownloader.gui.views.linkgrabber.LinkGrabberView;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.settings.staticreferences.CFG_GUI;
import org.jdownloader.updatev2.gui.LAFOptions;

public class MainTabbedPane
extends JTabbedPane
implements MouseMotionListener,
MouseListener {
    private static final long serialVersionUID = -1531827591735215594L;
    private static MainTabbedPane INSTANCE;
    protected View latestSelection;
    protected Component latestSelectionTabHeader;
    public static AtomicBoolean SPECIAL_DEALS_ENABLED;
    public static AtomicBoolean SPECIAL_DEALS_REMINDER_ENABLED;
    private Rectangle specialDealBounds = null;
    private boolean specialDealMouseOver = false;
    private View donatePanel;
    private DonateTabHeader donateHeader;
    protected int rightest = -1;
    private TopRightPainter topRightPainter = null;

    public static synchronized MainTabbedPane getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MainTabbedPane();
        }
        return INSTANCE;
    }

    @Override
    public void remove(Component component) {
        if (component instanceof View) {
            this.remove((View)component);
        } else {
            super.remove(component);
        }
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        boolean ret = super.processKeyBinding(ks, e, condition, pressed);
        if (this.getRootPane().getInputMap(2).get(ks) != null) {
            return false;
        }
        if (this.getRootPane().getInputMap(1).get(ks) != null) {
            return false;
        }
        return ret;
    }

    public void remove(View view) {
        if (!this.contains(view)) {
            return;
        }
        boolean selected = this.getSelectedView() == view;
        int index = -1;
        for (int i = 0; i < this.getTabCount(); ++i) {
            if (this.getComponentAt(i) != view) continue;
            index = i;
            break;
        }
        this.removeTabAt(index);
        if (view != null) {
            view.getBroadcaster().fireEvent((DefaultEvent)new SwitchPanelEvent(view, 3));
        }
        if (selected && this.getTabCount() > 0) {
            this.setSelectedComponent(this.getComponentAt(0));
        }
    }

    public void addTab(View view) {
        if (this.contains(view)) {
            return;
        }
        if (view instanceof ClosableView) {
            this.addClosableTab((ClosableView)view);
        } else {
            int index;
            for (index = this.getTabCount(); index > 0 && this.getTabComponentAt(index - 1) instanceof PromotionTabHeader; --index) {
            }
            super.insertTab(view.getTitle(), view.getIcon(), view, view.getTooltip(), index);
            this.setFocusable(false);
            TabHeader header = new TabHeader(view);
            this.setTabComponentAt(index, header);
            if (this.getTabCount() == 1) {
                this.latestSelectionTabHeader = header;
                header.setShown();
            }
            view.getBroadcaster().fireEvent((DefaultEvent)new SwitchPanelEvent(view, 2));
        }
    }

    private void setupTabTraversalKeys() {
        KeyStroke ctrlTab = KeyStroke.getKeyStroke("ctrl TAB");
        KeyStroke ctrlShiftTab = KeyStroke.getKeyStroke("ctrl shift TAB");
        HashSet<AWTKeyStroke> forwardKeys = new HashSet<AWTKeyStroke>(this.getFocusTraversalKeys(0));
        forwardKeys.remove(ctrlTab);
        this.setFocusTraversalKeys(0, forwardKeys);
        HashSet<AWTKeyStroke> backwardKeys = new HashSet<AWTKeyStroke>(this.getFocusTraversalKeys(1));
        backwardKeys.remove(ctrlShiftTab);
        this.setFocusTraversalKeys(1, backwardKeys);
        InputMap inputMap = this.getInputMap(1);
        inputMap.put(ctrlTab, "navigateNext");
        inputMap.put(ctrlShiftTab, "navigatePrevious");
        this.getActionMap().put("navigatePrevious", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = MainTabbedPane.this.getSelectedIndex();
                if (--index < 0) {
                    index = MainTabbedPane.this.getTabCount() - 1;
                }
                while (index > 0 && MainTabbedPane.this.getTabComponentAt(index) instanceof PromotionTabHeader) {
                    --index;
                }
                MainTabbedPane.this.setSelectedIndex(index);
            }
        });
        this.getActionMap().put("navigateNext", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = MainTabbedPane.this.getSelectedIndex();
                if (++index > MainTabbedPane.this.getTabCount() - 1 || MainTabbedPane.this.getTabComponentAt(index) instanceof PromotionTabHeader) {
                    index = 0;
                }
                MainTabbedPane.this.setSelectedIndex(index);
            }
        });
    }

    private void addClosableTab(ClosableView view) {
        int index;
        for (index = this.getTabCount(); index > 0 && this.getTabComponentAt(index - 1) instanceof PromotionTabHeader; --index) {
        }
        super.insertTab(view.getTitle(), view.getIcon(), view, view.getTooltip(), index);
        ClosableTabHeader header = new ClosableTabHeader(view);
        this.setTabComponentAt(index, header);
        this.setFocusable(false);
        view.getBroadcaster().fireEvent((DefaultEvent)new SwitchPanelEvent(view, 2));
    }

    private void updateDonateButton() {
        boolean isVisible = DonationManager.getInstance().isButtonVisible();
        if (isVisible) {
            if (this.donatePanel == null) {
                this.donatePanel = new View(){

                    @Override
                    protected void onShow() {
                    }

                    @Override
                    protected void onHide() {
                    }

                    @Override
                    public String getTooltip() {
                        return null;
                    }

                    @Override
                    public String getTitle() {
                        return _GUI.T.DonateAction();
                    }

                    @Override
                    public Icon getIcon() {
                        return new AbstractIcon("heart", 16);
                    }

                    @Override
                    public String getID() {
                        return "DONATE";
                    }
                };
            }
            super.addTab("DONATE", null, this.donatePanel, null);
            this.donateHeader = new DonateTabHeader(this.donatePanel);
            this.setTabComponentAt(this.getTabCount() - 1, this.donateHeader);
        } else if (this.donatePanel != null) {
            this.remove(this.donatePanel);
            this.donatePanel = null;
        }
    }

    private MainTabbedPane() {
        this.setMinimumSize(new Dimension(300, 100));
        this.setTabLayoutPolicy(1);
        this.setOpaque(false);
        this.setupTabTraversalKeys();
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        DonationManager.getInstance();
        CFG_GUI.DONATE_BUTTON_STATE.getEventSender().addListener((EventListener)new GenericConfigEventListener<Enum>(){

            public void onConfigValueModified(KeyHandler<Enum> keyHandler, Enum newValue) {
                new EDTRunner(){

                    protected void runInEDT() {
                        MainTabbedPane.this.updateDonateButton();
                    }
                };
            }

            public void onConfigValidatorError(KeyHandler<Enum> keyHandler, Enum invalidValue, ValidationException validateException) {
            }
        });
        this.updateDonateButton();
        this.setFocusable(false);
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (JDGui.getInstance() != null) {
                    JDGui.getInstance().setWaiting(true);
                }
                try {
                    View comp = (View)MainTabbedPane.this.getSelectedComponent();
                    if (comp == MainTabbedPane.this.donatePanel && MainTabbedPane.this.latestSelection != null) {
                        MainTabbedPane.this.setSelectedComponent(MainTabbedPane.this.latestSelection);
                        return;
                    }
                    Component tabComp = MainTabbedPane.this.getTabComponentAt(MainTabbedPane.this.getSelectedIndex());
                    if (comp == MainTabbedPane.this.latestSelection) {
                        return;
                    }
                    if (MainTabbedPane.this.latestSelection != null) {
                        MainTabbedPane.this.latestSelection.setHidden();
                    }
                    if (MainTabbedPane.this.latestSelectionTabHeader != null && MainTabbedPane.this.latestSelectionTabHeader instanceof CustomTabHeader) {
                        ((CustomTabHeader)((Object)MainTabbedPane.this.latestSelectionTabHeader)).setHidden();
                    }
                    GUIEventSender.getInstance().fireEvent((DefaultEvent)new GUIEvent((Object)MainTabbedPane.this, GUIEvent.Type.TAB_SWITCH, new Object[]{MainTabbedPane.this.latestSelection, comp}));
                    MainTabbedPane.this.latestSelection = comp;
                    MainTabbedPane.this.latestSelectionTabHeader = tabComp;
                    if (tabComp != null && tabComp instanceof CustomTabHeader) {
                        ((CustomTabHeader)((Object)tabComp)).setShown();
                    }
                    comp.setShown();
                    MainTabbedPane.this.revalidate();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        });
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent e) {
                MainTabbedPane.this.update();
            }

            @Override
            public void componentResized(ComponentEvent e) {
                MainTabbedPane.this.update();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                MainTabbedPane.this.update();
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        this.addContainerListener(new ContainerListener(){

            @Override
            public void componentRemoved(ContainerEvent e) {
                MainTabbedPane.this.update();
            }

            @Override
            public void componentAdded(ContainerEvent e) {
                MainTabbedPane.this.update();
            }
        });
        LAFOptions.getInstance().getExtension().customizeMainTabbedPane((JTabbedPane)this);
    }

    private void update() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int rightest = Integer.MIN_VALUE;
                for (int t = 0; t < MainTabbedPane.this.getTabCount(); ++t) {
                    Rectangle bounds = MainTabbedPane.this.getUI().getTabBounds(MainTabbedPane.this, t);
                    int right = bounds.x + bounds.width;
                    if (right <= rightest) continue;
                    rightest = right;
                }
                MainTabbedPane.this.rightest = rightest;
            }
        });
    }

    public void notifyCurrentTab() {
        new EDTRunner(){

            protected void runInEDT() {
                View comp = (View)MainTabbedPane.this.getSelectedComponent();
                GUIEventSender.getInstance().fireEvent((DefaultEvent)new GUIEvent((Object)MainTabbedPane.this, GUIEvent.Type.TAB_SWITCH, new Object[]{MainTabbedPane.this.latestSelection, comp}));
            }
        };
    }

    public TopRightPainter getTopRightPainter() {
        return this.topRightPainter;
    }

    public void setTopRightPainter(TopRightPainter topRightPainter) {
        this.topRightPainter = topRightPainter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        TopRightPainter topRightPainter;
        super.paint(g);
        if (JDGui.getInstance() != null) {
            JDGui.getInstance().setWaiting(false);
        }
        if ((topRightPainter = this.getTopRightPainter()) != null && this.rightest > 0) {
            Shape clip = g.getClip();
            try {
                g.setClip(this.rightest, 0, this.getWidth() - this.rightest, 32);
                this.specialDealBounds = topRightPainter.paint((Graphics2D)g);
            }
            finally {
                g.setClip(clip);
            }
        }
    }

    public void onClose() {
        this.getSelectedView().setHidden();
    }

    public View getSelectedView() {
        return (View)super.getSelectedComponent();
    }

    @Override
    public void setSelectedComponent(Component e) {
        View c = this.getComponentEquals((View)e);
        int index = this.indexOfComponent(c);
        if (index < 0) {
            this.setSelectedIndex(0);
            return;
        }
        super.setSelectedIndex(index);
    }

    public View getComponentEquals(View view) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            Component c = this.getComponentAt(i);
            if (!c.equals(view)) continue;
            return (View)c;
        }
        return null;
    }

    public boolean contains(View view) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            Component c = this.getComponentAt(i);
            if (!c.equals(view)) continue;
            return true;
        }
        return false;
    }

    public boolean isLinkgrabberView() {
        return this.getSelectedView() instanceof LinkGrabberView;
    }

    public boolean isDownloadView() {
        return this.getSelectedView() instanceof DownloadsView;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        TopRightPainter topRightPainter = this.getTopRightPainter();
        Rectangle specialDealBounds = this.specialDealBounds;
        if (topRightPainter != null && topRightPainter.isVisible()) {
            boolean repaint;
            if (specialDealBounds != null && specialDealBounds.contains(e.getPoint()) && !this.specialDealMouseOver) {
                this.specialDealMouseOver = true;
                topRightPainter.onMouseOver(e);
                repaint = true;
            } else if (this.specialDealMouseOver && (specialDealBounds == null || !specialDealBounds.contains(e.getPoint()))) {
                this.specialDealMouseOver = false;
                topRightPainter.onMouseOut(e);
                repaint = true;
            } else {
                repaint = false;
            }
            if (repaint && specialDealBounds != null) {
                this.repaint(specialDealBounds.x - 4, specialDealBounds.y, specialDealBounds.width + 6, specialDealBounds.height);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        TopRightPainter topRightPainter = this.getTopRightPainter();
        if (this.specialDealMouseOver && topRightPainter != null && topRightPainter.isVisible()) {
            topRightPainter.onClicked(e);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    static {
        SPECIAL_DEALS_ENABLED = new AtomicBoolean(false);
        SPECIAL_DEALS_REMINDER_ENABLED = new AtomicBoolean(false);
    }
}

