/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.components;

import javax.swing.JProgressBar;

public class JDProgressBar
extends JProgressBar {
    private static final long serialVersionUID = 7787146508749392032L;
    private int scale = 1;
    private long realMax = 0L;
    private long realCur = 0L;
    private boolean autofaktor = true;

    public JDProgressBar() {
        this.setIndeterminate(false);
    }

    @Override
    public void setMaximum(int value) {
        this.setMaximum((long)value);
    }

    public void setMaximum(long value) {
        this.realMax = value;
        this.update();
    }

    public void setAutoScaling(boolean b) {
        this.autofaktor = b;
    }

    public void setScale(int f) {
        this.scale = f;
    }

    public int getScale() {
        return this.scale;
    }

    private void update() {
        long biggest = Math.max(this.realMax, this.realCur);
        if (this.autofaktor) {
            this.scale = 1;
            while (biggest / (long)this.scale >= Integer.MAX_VALUE) {
                this.scale *= 2;
            }
        }
        super.setMaximum((int)(this.realMax / (long)this.scale));
        super.setValue((int)(this.realCur / (long)this.scale));
    }

    @Override
    public void setValue(int value) {
        this.setValue((long)value);
    }

    public void setValue(long value) {
        this.realCur = value;
        this.update();
    }

    public long getRealValue() {
        return this.realCur;
    }

    public long getRealMax() {
        return this.realMax;
    }
}

