/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.components;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import java.util.EventListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import jd.controlling.linkchecker.LinkChecker;
import jd.controlling.linkchecker.LinkCheckerEvent;
import jd.controlling.linkchecker.LinkCheckerListener;
import jd.gui.swing.jdgui.components.IconedProcessIndicator;
import jd.gui.swing.jdgui.components.StatusBarImpl;
import org.appwork.utils.swing.EDTRunner;
import org.jdownloader.actions.AppAction;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;

public class LinkCheckerIndicator
extends IconedProcessIndicator
implements LinkCheckerListener {
    private static final long serialVersionUID = -7267364376253248300L;
    private final WeakReference<LinkChecker<?>> linkChecker;
    private final StatusBarImpl statusBar;

    public LinkCheckerIndicator(StatusBarImpl statusBar, LinkChecker<?> linkChecker) {
        super((Icon)new AbstractIcon("search", 16));
        this.linkChecker = new WeakReference(linkChecker);
        this.statusBar = statusBar;
        this.setTitle(_GUI.T.StatusBarImpl_initGUI_linkchecker());
        this.setDescription(_GUI.T.StatusBarImpl_initGUI_linkgrabber_desc_inactive());
        LinkChecker.getEventSender().addListener((EventListener)this, true);
        this.setEnabled(true);
        if (linkChecker.isRunning()) {
            this.setIndeterminate(true);
            this.setDescription(_GUI.T.StatusBarImpl_initGUI_linkchecker_left());
            statusBar.addProcessIndicator((JComponent)((Object)this));
        }
    }

    private LinkChecker<?> getLinkChecker() {
        return (LinkChecker)this.linkChecker.get();
    }

    public void onLinkCheckerEvent(LinkCheckerEvent event) {
        boolean stopEvent;
        LinkChecker<?> linkChecker = this.getLinkChecker();
        boolean bl = stopEvent = linkChecker == null || event.getCaller() == linkChecker && LinkCheckerEvent.Type.STOPPED.equals(event.getType());
        if (stopEvent) {
            new EDTRunner(){

                protected void runInEDT() {
                    LinkCheckerIndicator.this.setIndeterminate(false);
                    LinkCheckerIndicator.this.statusBar.removeProcessIndicator((JComponent)((Object)LinkCheckerIndicator.this));
                }
            };
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger() || e.getButton() == 3) {
            JPopupMenu popup = new JPopupMenu();
            popup.add((Action)new AppAction(){
                private static final long serialVersionUID = -968768342263254431L;
                {
                    this.setIconKey("cancel");
                    this.setName(_GUI.T.StatusBarImpl_initGUI_abort_linkchecker());
                    LinkChecker linkChecker = LinkCheckerIndicator.this.getLinkChecker();
                    this.setEnabled(linkChecker != null && linkChecker.isRunning());
                }

                public void actionPerformed(ActionEvent e) {
                    LinkChecker linkChecker = LinkCheckerIndicator.this.getLinkChecker();
                    if (linkChecker != null) {
                        linkChecker.stopChecking();
                    }
                }
            });
            popup.show((Component)((Object)this), e.getPoint().x, 0 - popup.getPreferredSize().height);
        }
    }
}

