/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.maintab;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jd.gui.swing.jdgui.MainTabbedPane;
import jd.gui.swing.jdgui.interfaces.JDMouseAdapter;
import jd.gui.swing.jdgui.maintab.CustomTabHeader;
import jd.gui.swing.jdgui.views.ClosableView;
import net.miginfocom.swing.MigLayout;
import org.appwork.utils.swing.SwingUtils;

public class ClosableTabHeader
extends JPanel
implements CustomTabHeader {
    private static final long serialVersionUID = 4463352125800695922L;
    private boolean selected;
    private JLabel label;
    private Font fontUnselected;
    private Font fontSelected;
    private JLabel labelIcon;

    @Override
    public void setBounds(int x, int y, int width, int height) {
        if (this.selected) {
            super.setBounds(x - 2, y + 1, width + 2, height - 1);
        } else {
            super.setBounds(x - 2, y - 1, width + 2, height + 1);
        }
    }

    public ClosableTabHeader(final ClosableView view) {
        this.setLayout((LayoutManager)new MigLayout("ins 0", "[][grow]push[]", "[]"));
        this.setOpaque(false);
        this.setToolTipText(view.getTooltip());
        this.addMouseListener(new JDMouseAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                JDMouseAdapter.forwardEvent(e, MainTabbedPane.getInstance());
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                JDMouseAdapter.forwardEvent(e, MainTabbedPane.getInstance());
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                JDMouseAdapter.forwardEvent(e, MainTabbedPane.getInstance());
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                JDMouseAdapter.forwardEvent(e, MainTabbedPane.getInstance());
            }

            @Override
            public void mouseExited(MouseEvent e) {
                JDMouseAdapter.forwardEvent(e, MainTabbedPane.getInstance());
            }

            @Override
            public void mousePressed(MouseEvent e) {
                JDMouseAdapter.forwardEvent(e, MainTabbedPane.getInstance());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 2 || e.getButton() == 1 && e.getClickCount() == 2) {
                    view.close();
                } else {
                    JDMouseAdapter.forwardEvent(e, MainTabbedPane.getInstance());
                }
            }
        });
        this.putClientProperty("paintActive", Boolean.TRUE);
        this.labelIcon = new JLabel();
        this.labelIcon.setIcon(view.getIcon());
        SwingUtils.setOpaque((JComponent)this.labelIcon, (boolean)false);
        this.label = new JLabel(view.getTitle());
        SwingUtils.setOpaque((JComponent)this.label, (boolean)false);
        this.fontUnselected = this.label.getFont();
        this.fontSelected = this.fontUnselected.deriveFont(this.fontUnselected.getStyle() ^ 1);
        this.add(this.labelIcon);
        this.add((Component)this.label, "alignx center");
        this.add((Component)view.getCloseButton(), "aligny center,gapleft 5,width 16!,height 16!,gaptop 3");
        view.getCloseButton().setOpaque(false);
        this.label.setFont(this.fontSelected);
        Dimension pref = this.getPreferredSize();
        int maxWidth = pref.width;
        this.setPreferredSize(new Dimension(maxWidth, pref.height));
        this.label.setFont(this.fontUnselected);
    }

    @Override
    public void setHidden() {
        this.selected = false;
        this.label.setFont(this.fontUnselected);
        this.repaint();
    }

    @Override
    public void setShown() {
        this.selected = true;
        this.label.setFont(this.fontSelected);
        this.repaint();
    }
}

