/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.views.settings.panels.accountmanager;

import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventListener;
import java.util.concurrent.ScheduledExecutorService;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import jd.SecondLevelLaunch;
import jd.controlling.AccountController;
import jd.controlling.AccountControllerEvent;
import jd.controlling.AccountControllerListener;
import jd.controlling.accountchecker.AccountChecker;
import jd.controlling.accountchecker.AccountCheckerEventListener;
import jd.gui.swing.jdgui.GUIUtils;
import jd.gui.swing.jdgui.interfaces.SwitchPanelEvent;
import jd.gui.swing.jdgui.interfaces.SwitchPanelListener;
import jd.gui.swing.jdgui.views.settings.panels.accountmanager.AccountEntry;
import jd.gui.swing.jdgui.views.settings.panels.accountmanager.AccountListPanel;
import jd.gui.swing.jdgui.views.settings.panels.accountmanager.RefreshAction;
import jd.plugins.Account;
import jd.plugins.AccountInfo;
import jd.plugins.AccountTrafficView;
import jd.plugins.PluginForHost;
import org.appwork.scheduler.DelayedRunnable;
import org.appwork.storage.config.JsonConfig;
import org.appwork.sunwrapper.sun.swing.SwingUtilities2Wrapper;
import org.appwork.swing.components.ExtMergedIcon;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.ExtDefaultRowSorter;
import org.appwork.swing.exttable.ExtTableHeaderRenderer;
import org.appwork.swing.exttable.ExtTableModel;
import org.appwork.swing.exttable.columns.ExtCheckColumn;
import org.appwork.swing.exttable.columns.ExtComponentColumn;
import org.appwork.swing.exttable.columns.ExtDateColumn;
import org.appwork.swing.exttable.columns.ExtPasswordEditorColumn;
import org.appwork.swing.exttable.columns.ExtProgressColumn;
import org.appwork.swing.exttable.columns.ExtTextColumn;
import org.appwork.utils.StringUtils;
import org.appwork.utils.formatter.TimeFormatter;
import org.appwork.utils.swing.EDTRunner;
import org.jdownloader.DomainInfo;
import org.jdownloader.gui.components.ColumnButton;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.images.NewTheme;
import org.jdownloader.settings.GraphicalUserInterfaceSettings;
import org.jdownloader.settings.staticreferences.CFG_GUI;

public class PremiumAccountTableModel
extends ExtTableModel<AccountEntry>
implements AccountCheckerEventListener {
    private static final long serialVersionUID = 3120481189794897020L;
    private AccountListPanel accountManagerSettings = null;
    private DelayedRunnable delayedFill;
    private volatile boolean checkRunning = false;
    private DelayedRunnable delayedUpdate;
    static final Icon REFRESH = new AbstractIcon("refresh", 16);
    static final Icon OKAY = new AbstractIcon("ok", 16);
    static final Icon WAIT = new AbstractIcon("wait", 16);
    static final Icon ERROR = new AbstractIcon("error", 16);
    static final Icon EXPIRED = new ExtMergedIcon((Icon)new AbstractIcon("error", 18)).add((Icon)new AbstractIcon("wait", 12), 6, 6);

    public PremiumAccountTableModel(AccountListPanel accountListPanel) {
        super("PremiumAccountTableModel2");
        this.accountManagerSettings = accountListPanel;
        ScheduledExecutorService scheduler = DelayedRunnable.getNewScheduledExecutorService();
        this.delayedFill = new DelayedRunnable(scheduler, 250L){

            public String getID() {
                return "PremiumAccountTableFill";
            }

            public void delayedrun() {
                System.out.println("Refill");
                PremiumAccountTableModel.this._refill();
            }
        };
        this.delayedUpdate = new DelayedRunnable(scheduler, 250L){

            public String getID() {
                return "PremiumAccountTableUpdate";
            }

            public void delayedrun() {
                System.out.println("Update");
                PremiumAccountTableModel.this._update();
            }
        };
        this.initListeners(accountListPanel);
    }

    protected void initListeners(final AccountListPanel accountListPanel) {
        SecondLevelLaunch.ACCOUNTLIST_LOADED.executeWhenReached(new Runnable(){

            @Override
            public void run() {
                AccountController.getInstance().getEventSender().addListener((EventListener)new AccountControllerListener(){

                    public void onAccountControllerEvent(AccountControllerEvent event) {
                        if (accountListPanel.isShown()) {
                            switch ((AccountControllerEvent.Types)event.getType()) {
                                case ACCOUNT_CHECKED: 
                                case ACCOUNT_PROPERTY_UPDATE: {
                                    PremiumAccountTableModel.this.delayedUpdate.run();
                                    break;
                                }
                                default: {
                                    PremiumAccountTableModel.this.delayedFill.run();
                                }
                            }
                        }
                    }
                });
                AccountChecker.getInstance().getEventSender().addListener((EventListener)((Object)PremiumAccountTableModel.this));
                PremiumAccountTableModel.this.accountManagerSettings.getBroadcaster().addListener((EventListener)new SwitchPanelListener(){

                    @Override
                    public void onPanelEvent(SwitchPanelEvent event) {
                        if (event.getEventID() == 0) {
                            PremiumAccountTableModel.this._refill();
                        }
                    }
                });
                if (AccountChecker.getInstance().isRunning()) {
                    PremiumAccountTableModel.this.onCheckStarted();
                }
                PremiumAccountTableModel.this._refill();
            }
        });
    }

    public void fill() {
        this.delayedFill.run();
    }

    protected void initColumns() {
        this.addEnabledColumn();
        this.addColumnHoster();
        this.addStatusColumn();
        this.addUsernameColumn();
        this.addPasswordColumn();
        this.addExpireColumn();
        this.addTrafficColumn();
        this.addColumnSettingsButton();
    }

    protected void addTrafficColumn() {
        this.addColumn((ExtColumn)new TrafficColumn(this, _GUI.T.premiumaccounttablemodel_column_trafficleft()));
    }

    protected void addExpireColumn() {
        this.addColumn((ExtColumn)new ExpireColumn(this, _GUI.T.premiumaccounttablemodel_column_expiredate()));
    }

    protected void addUsernameColumn() {
        this.addColumn((ExtColumn)new ExtTextColumn<AccountEntry>(_GUI.T.premiumaccounttablemodel_column_user()){
            private static final long serialVersionUID = -8070328156326837828L;
            {
                PremiumAccountTableModel.replaceSorter((ExtColumn<AccountEntry>)this);
            }

            public boolean isSortable(AccountEntry obj) {
                return PremiumAccountTableModel.this.isSortable();
            }

            public boolean isHidable() {
                return false;
            }

            public boolean isAutoWidthEnabled() {
                return true;
            }

            protected boolean isDefaultResizable() {
                return true;
            }

            public int getDefaultWidth() {
                return this.getMinWidth() + 10;
            }

            public int getMinWidth() {
                return 70;
            }

            public boolean isEnabled(AccountEntry obj) {
                return obj.getAccount().isEnabled() || this.isEditable(obj);
            }

            public boolean isEditable(AccountEntry obj) {
                if (CFG_GUI.CFG.isPresentationModeEnabled()) {
                    return false;
                }
                return PremiumAccountTableModel.this.isEditable();
            }

            protected void setStringValue(String value, AccountEntry object) {
                object.getAccount().setUser(value);
            }

            public String getStringValue(AccountEntry value) {
                return GUIUtils.getAccountName(value.getAccount().getUser());
            }
        });
    }

    protected void addStatusColumn() {
        this.addColumn((ExtColumn)new ExtTextColumn<AccountEntry>(_GUI.T.premiumaccounttablemodel_column_status()){
            private static final long serialVersionUID = -3693931358975303164L;
            {
                PremiumAccountTableModel.replaceSorter((ExtColumn<AccountEntry>)this);
            }

            public boolean isEnabled(AccountEntry obj) {
                return obj.getAccount().isEnabled();
            }

            public boolean isSortable(AccountEntry obj) {
                return PremiumAccountTableModel.this.isSortable();
            }

            public boolean isHidable() {
                return true;
            }

            protected Icon getIcon(AccountEntry value) {
                return PremiumAccountTableModel.accountToStatusIcon(value.getAccount());
            }

            public int getDefaultWidth() {
                return 160;
            }

            public int getMinWidth() {
                return 24;
            }

            public String getStringValue(AccountEntry value) {
                return PremiumAccountTableModel.accountToStatusString(value.getAccount());
            }
        });
    }

    protected void addPasswordColumn() {
        this.addColumn((ExtColumn)new ExtPasswordEditorColumn<AccountEntry>(_GUI.T.premiumaccounttablemodel_column_password()){
            private static final long serialVersionUID = 3180414754658474808L;

            public boolean isHidable() {
                return true;
            }

            public boolean isSortable(AccountEntry obj) {
                return PremiumAccountTableModel.this.isSortable();
            }

            public int getMaxWidth() {
                return 140;
            }

            public int getDefaultWidth() {
                return 110;
            }

            public int getMinWidth() {
                return 70;
            }

            protected String getPlainStringValue(AccountEntry value) {
                return value.getAccount().getPass();
            }

            protected void setStringValue(String value, AccountEntry object) {
                object.getAccount().setPass(value);
            }
        });
    }

    protected boolean isEditable() {
        return true;
    }

    protected void addEnabledColumn() {
        this.addColumn((ExtColumn)new ExtCheckColumn<AccountEntry>(_GUI.T.premiumaccounttablemodel_column_enabled()){
            private static final long serialVersionUID = 1515656228974789237L;

            public ExtTableHeaderRenderer getHeaderRenderer(JTableHeader jTableHeader) {
                ExtTableHeaderRenderer ret = new ExtTableHeaderRenderer((ExtColumn)this, jTableHeader){
                    private final Icon ok;
                    private static final long serialVersionUID = 3224931991570756349L;
                    {
                        this.ok = NewTheme.I().getIcon("ok", 14);
                    }

                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                        this.setIcon(this.ok);
                        this.setHorizontalAlignment(0);
                        this.setText(null);
                        return this;
                    }
                };
                return ret;
            }

            public int getMaxWidth() {
                return 30;
            }

            protected boolean getBooleanValue(AccountEntry value) {
                return value.getAccount().isEnabled();
            }

            public boolean isSortable(AccountEntry obj) {
                return PremiumAccountTableModel.this.isSortable();
            }

            public boolean isEditable(AccountEntry obj) {
                return true;
            }

            protected void setBooleanValue(boolean enabled, AccountEntry object) {
                object.getAccount().setEnabled(enabled);
                if (enabled && object.getAccount().isMultiHost()) {
                    RefreshAction.displayMultihosterDetailOverviewHelpDialog();
                }
            }
        });
    }

    protected void addColumnSettingsButton() {
        this.addColumn((ExtColumn)new ExtComponentColumn<AccountEntry>(_GUI.T.lit_settings()){
            private ColumnButton button;
            private ColumnButton rbutton;
            private AccountEntry editing;
            {
                this.button = new ColumnButton((Icon)new AbstractIcon("settings", 16));
                this.rbutton = new ColumnButton((Icon)new AbstractIcon("settings", 16));
                this.rbutton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (editing != null) {
                            editing.showConfiguration();
                        }
                    }
                });
            }

            public ExtTableHeaderRenderer getHeaderRenderer(JTableHeader jTableHeader) {
                ExtTableHeaderRenderer ret = new ExtTableHeaderRenderer((ExtColumn)this, jTableHeader){

                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                        if (PremiumAccountTableModel.this.isSettingsColumnHeaderIconVisible()) {
                            this.setIcon((Icon)new AbstractIcon("settings", 16));
                        }
                        this.setHorizontalAlignment(0);
                        this.setText(null);
                        return this;
                    }
                };
                return ret;
            }

            public boolean isAutoWidthEnabled() {
                return true;
            }

            protected boolean isDefaultResizable() {
                return true;
            }

            public boolean isEnabled(AccountEntry obj) {
                return true;
            }

            public boolean isHidable() {
                return false;
            }

            public boolean isEditable(AccountEntry obj) {
                return super.isEditable((Object)obj);
            }

            public boolean onSingleClick(MouseEvent e, AccountEntry obj) {
                return super.onSingleClick(e, (Object)obj);
            }

            protected JComponent getInternalEditorComponent(AccountEntry value, boolean isSelected, int row, int column) {
                return this.rbutton;
            }

            protected JComponent getInternalRendererComponent(AccountEntry value, boolean isSelected, boolean hasFocus, int row, int column) {
                return this.button;
            }

            public void configureEditorComponent(AccountEntry value, boolean isSelected, int row, int column) {
                this.editing = value;
            }

            public void configureRendererComponent(AccountEntry value, boolean isSelected, boolean hasFocus, int row, int column) {
            }

            public void resetEditor() {
            }

            public void resetRenderer() {
            }
        });
    }

    protected boolean isSettingsColumnHeaderIconVisible() {
        return true;
    }

    protected void addColumnHoster() {
        this.addColumn((ExtColumn)new ExtTextColumn<AccountEntry>(_GUI.T.premiumaccounttablemodel_column_hoster()){
            private static final long serialVersionUID = -3693931358975303164L;
            {
                PremiumAccountTableModel.replaceSorter((ExtColumn<AccountEntry>)this);
            }

            public boolean isEnabled(AccountEntry obj) {
                return obj.getAccount().isEnabled();
            }

            public boolean isSortable(AccountEntry obj) {
                return PremiumAccountTableModel.this.isSortable();
            }

            protected Icon getIcon(AccountEntry value) {
                PluginForHost plugin = value.getAccount().getPlugin();
                DomainInfo domainInfo = plugin != null ? DomainInfo.getInstance((String)plugin.getHost(null, value.getAccount(), false)) : DomainInfo.getInstance((String)value.getAccount().getHoster());
                if (domainInfo != null) {
                    return domainInfo.getFavIcon();
                }
                return null;
            }

            public int getDefaultWidth() {
                return 120;
            }

            public int getMinWidth() {
                return 30;
            }

            protected String getTooltipText(AccountEntry obj) {
                return obj.getAccount().getHoster();
            }

            public void configureRendererComponent(AccountEntry value, boolean isSelected, boolean hasFocus, int row, int column) {
                this.rendererIcon.setIcon(this.getIcon(value));
                String str = null;
                if (this.getWidth() > 60) {
                    str = this.getStringValue(value);
                }
                if (str == null) {
                    str = "";
                }
                if (this.getTableColumn() != null) {
                    this.rendererField.setText(SwingUtilities2Wrapper.clipStringIfNecessary((JComponent)this.rendererField, (FontMetrics)this.rendererField.getFontMetrics(this.rendererField.getFont()), (String)str, (int)(this.getTableColumn().getWidth() - this.rendererIcon.getPreferredSize().width - 5)));
                } else {
                    this.rendererField.setText(str);
                }
            }

            public String getStringValue(AccountEntry value) {
                return value.getAccount().getHosterByPlugin();
            }
        });
    }

    protected boolean isSortable() {
        return true;
    }

    public static void replaceSorter(ExtColumn<AccountEntry> column) {
        if (column != null) {
            final ExtDefaultRowSorter oldSorter = column.getRowSorter();
            column.setRowSorter((ExtDefaultRowSorter)new ExtDefaultRowSorter<AccountEntry>(){

                public int compare(boolean x, boolean y) {
                    return x == y ? 0 : (x ? -1 : 1);
                }

                public int compare(AccountEntry o1, AccountEntry o2) {
                    boolean b2;
                    boolean b1 = o1.getAccount().isEnabled();
                    if (b1 == (b2 = o2.getAccount().isEnabled())) {
                        if (this.getSortOrderIdentifier() != "ASC") {
                            return oldSorter.compare((Object)o1, (Object)o2);
                        }
                        return -oldSorter.compare((Object)o1, (Object)o2);
                    }
                    return this.compare(b1, b2);
                }
            });
        }
    }

    public void onCheckStarted() {
        this.checkRunning = true;
    }

    public void onCheckStopped() {
        this.checkRunning = false;
        this._update();
    }

    protected void _update() {
        if (this.accountManagerSettings.isShown()) {
            new EDTRunner(){

                protected void runInEDT() {
                    PremiumAccountTableModel.this.getTable().repaint();
                }
            };
        }
    }

    protected void _refill() {
        if (this.accountManagerSettings.isShown()) {
            ArrayList<AccountEntry> newtableData = new ArrayList<AccountEntry>(this.getRowCount());
            ArrayList accs = AccountController.getInstance().list(null);
            if (accs != null) {
                for (Account acc : accs) {
                    PluginForHost plugin = acc.getPlugin();
                    if (plugin == null) continue;
                    AccountEntry ae = new AccountEntry(acc);
                    newtableData.add(ae);
                }
            }
            this._fireTableStructureChanged(newtableData, true);
        }
    }

    public static String accountToStatusString(Account value) {
        if (value.isChecking()) {
            return _GUI.T.PremiumAccountTableModel_refresh();
        }
        String errString = value.getErrorString();
        if (value.getError() == null) {
            String ret;
            AccountInfo ai = value.getAccountInfo();
            String string = ret = ai == null ? null : ai.getStatus();
            if (StringUtils.isEmpty((String)ret)) {
                if (value.isTempDisabled()) {
                    ret = errString;
                    if (StringUtils.isEmpty((String)ret)) {
                        ret = _GUI.T.PremiumAccountTableModel_getStringValue_temp_disabled();
                    }
                } else {
                    ret = _GUI.T.PremiumAccountTableModel_getStringValue_account_ok_();
                }
            } else if (value.isTempDisabled()) {
                if (StringUtils.isNotEmpty((String)errString)) {
                    return errString;
                }
                ret = _GUI.T.PremiumAccountTableModel_getStringValue_temp_disabled2(ret);
            } else {
                ret = _GUI.T.PremiumAccountTableModel_getStringValue_account_ok_2(ret);
            }
            return ret;
        }
        if (StringUtils.isNotEmpty((String)errString)) {
            return errString;
        }
        switch (value.getError()) {
            case TEMP_DISABLED: {
                return _GUI.T.PremiumAccountTableModel_getStringValue_temp_disabled();
            }
            case EXPIRED: {
                return _GUI.T.PremiumAccountTableModel_getStringValue_status_expired();
            }
            case INVALID: {
                return _GUI.T.PremiumAccountTableModel_getStringValue_status_invalid();
            }
            case PLUGIN_ERROR: {
                return _GUI.T.PremiumAccountTableModel_getStringValue_status_plugin_error();
            }
        }
        return _GUI.T.PremiumAccountTableModel_getStringValue_status_unknown_error();
    }

    public static Icon accountToStatusIcon(Account value) {
        if (value.isChecking()) {
            return REFRESH;
        }
        if (value.getError() == null) {
            if (value.isTempDisabled()) {
                return WAIT;
            }
            return OKAY;
        }
        switch (value.getError()) {
            case EXPIRED: {
                return EXPIRED;
            }
            case INVALID: {
                return ERROR;
            }
            case PLUGIN_ERROR: {
                return ERROR;
            }
            case TEMP_DISABLED: {
                return WAIT;
            }
        }
        return OKAY;
    }

    public static class ExpireColumn
    extends ExtDateColumn<AccountEntry> {
        private static final long serialVersionUID = 5067606909520874358L;
        private PremiumAccountTableModel tableModel;

        public ExpireColumn(PremiumAccountTableModel model, String string) {
            super(string);
            PremiumAccountTableModel.replaceSorter((ExtColumn<AccountEntry>)this);
            this.tableModel = model;
        }

        public boolean isSortable(AccountEntry obj) {
            return this.tableModel.isSortable();
        }

        public boolean isEnabled(AccountEntry obj) {
            return obj.getAccount().isEnabled();
        }

        public boolean isAutoWidthEnabled() {
            return true;
        }

        protected boolean isDefaultResizable() {
            return true;
        }

        public int getDefaultWidth() {
            return 120;
        }

        public int getMinWidth() {
            return 50;
        }

        protected String getDateFormatString() {
            return Account.getExpireDateFormatString((Object)((Object)this));
        }

        protected Date getDate(AccountEntry o2, Date date) {
            AccountInfo ai = o2.getAccount().getAccountInfo();
            if (ai == null) {
                return null;
            }
            if (ai.getValidUntil() <= 0L) {
                return null;
            }
            return new Date(ai.getValidUntil());
        }
    }

    public static class TrafficColumn
    extends ExtProgressColumn<AccountEntry> {
        private static final long serialVersionUID = -8376056840172682617L;
        private final PremiumAccountTableModel tableModel;
        private final DecimalFormat formatter;
        private final GraphicalUserInterfaceSettings.SIZEUNIT maxSizeUnit;

        public TrafficColumn(PremiumAccountTableModel tableModel, String title) {
            super(title);
            this.setRowSorter((ExtDefaultRowSorter)new ExtDefaultRowSorter<AccountEntry>(){

                private int compareLong(long x, long y) {
                    return x < y ? -1 : (x == y ? 0 : 1);
                }

                private int compareTraffic(AccountEntry o1, AccountEntry o2) {
                    long t1 = TrafficColumn.this.getValue(o1);
                    long t2 = TrafficColumn.this.getValue(o2);
                    return this.compareLong(t1, t2);
                }

                private int compareEnabled(boolean x, boolean y) {
                    return x == y ? 0 : (x ? -1 : 1);
                }

                public int compare(AccountEntry o1, AccountEntry o2) {
                    boolean b2;
                    boolean b1 = o1.getAccount().isEnabled();
                    if (b1 == (b2 = o2.getAccount().isEnabled())) {
                        if (this.getSortOrderIdentifier() != "ASC") {
                            return this.compareTraffic(o1, o2);
                        }
                        return -this.compareTraffic(o1, o2);
                    }
                    return this.compareEnabled(b1, b2);
                }
            });
            this.tableModel = tableModel;
            this.maxSizeUnit = ((GraphicalUserInterfaceSettings)JsonConfig.create(GraphicalUserInterfaceSettings.class)).getMaxSizeUnit();
            this.formatter = new DecimalFormat(){
                final StringBuffer sb = new StringBuffer();
                private static final long serialVersionUID = 1L;

                @Override
                public StringBuffer format(double number, StringBuffer result, FieldPosition pos) {
                    this.sb.setLength(0);
                    return super.format(number, this.sb, pos);
                }
            };
        }

        public boolean isEnabled(AccountEntry obj) {
            return obj.getAccount().isEnabled();
        }

        public boolean isSortable(AccountEntry obj) {
            return this.tableModel.isSortable();
        }

        public int getMinWidth() {
            return 120;
        }

        protected boolean isIndeterminated(AccountEntry value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (this.tableModel != null && this.tableModel.checkRunning) {
                return AccountChecker.getInstance().contains(value.getAccount());
            }
            return value.getAccount().isValid() && value.getAccount().isEnabled() && value.getAccount().isTempDisabled();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected String getString(AccountEntry ac, long current, long total) {
            if (!ac.getAccount().isValid()) {
                return "";
            }
            long timeout = -1L;
            if (ac.getAccount().isEnabled() && ac.getAccount().isTempDisabled() && (timeout = ac.getAccount().getTmpDisabledTimeout() - System.currentTimeMillis()) > 0L) {
                return _GUI.T.premiumaccounttablemodel_column_trafficleft_tempdisabled(TimeFormatter.formatMilliSeconds((long)timeout, (int)0));
            }
            AccountTrafficView accountTrafficView = ac.getAccount().getAccountTrafficView();
            if (accountTrafficView == null) {
                return "";
            }
            if (accountTrafficView.isUnlimitedTraffic()) {
                return _GUI.T.premiumaccounttablemodel_column_trafficleft_unlimited();
            }
            DecimalFormat decimalFormat = this.formatter;
            synchronized (decimalFormat) {
                return _GUI.T.premiumaccounttablemodel_column_trafficleft_left_(GraphicalUserInterfaceSettings.SIZEUNIT.formatValue((GraphicalUserInterfaceSettings.SIZEUNIT)this.maxSizeUnit, (DecimalFormat)this.formatter, (long)accountTrafficView.getTrafficLeft()), GraphicalUserInterfaceSettings.SIZEUNIT.formatValue((GraphicalUserInterfaceSettings.SIZEUNIT)this.maxSizeUnit, (DecimalFormat)this.formatter, (long)accountTrafficView.getTrafficMax()));
            }
        }

        protected long getMax(AccountEntry ac) {
            if (!ac.getAccount().isValid()) {
                return 0L;
            }
            AccountTrafficView accountTrafficView = ac.getAccount().getAccountTrafficView();
            if (accountTrafficView == null) {
                return 0L;
            }
            if (accountTrafficView.isUnlimitedTraffic()) {
                return Long.MAX_VALUE;
            }
            return accountTrafficView.getTrafficMax();
        }

        protected long getValue(AccountEntry ac) {
            if (!ac.getAccount().isValid()) {
                return 0L;
            }
            AccountTrafficView accountTrafficView = ac.getAccount().getAccountTrafficView();
            if (accountTrafficView == null) {
                return 0L;
            }
            if (accountTrafficView.isUnlimitedTraffic()) {
                return Long.MAX_VALUE;
            }
            return accountTrafficView.getTrafficLeft();
        }
    }
}

