/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.views.settings.panels.accountmanager;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import jd.controlling.AccountController;
import jd.controlling.TaskQueue;
import jd.controlling.accountchecker.AccountChecker;
import jd.gui.swing.jdgui.views.settings.panels.accountmanager.AccountEntry;
import jd.plugins.Account;
import org.appwork.utils.event.queue.QueueAction;
import org.jdownloader.gui.helpdialogs.HelpDialog;
import org.jdownloader.gui.helpdialogs.MessageConfig;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;

public class RefreshAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private final List<AccountEntry> selection;

    public RefreshAction() {
        this.selection = null;
        this.putValue("Name", _GUI.T.settings_accountmanager_refresh());
        this.putValue("SmallIcon", new AbstractIcon("refresh", 16));
    }

    public RefreshAction(List<AccountEntry> selectedObjects) {
        this.selection = selectedObjects != null ? selectedObjects : new ArrayList();
        this.putValue("Name", _GUI.T.settings_accountmanager_refresh());
        this.putValue("SmallIcon", new AbstractIcon("refresh", 16));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        TaskQueue.getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

            protected Void run() throws RuntimeException {
                List accountsToCheck = RefreshAction.this.getAccountsToCheck();
                if (accountsToCheck == null || accountsToCheck.isEmpty()) {
                    return null;
                }
                boolean containedCheckedMultihosterAccount = false;
                for (Account acc : accountsToCheck) {
                    AccountChecker.getInstance().check(acc, true);
                    containedCheckedMultihosterAccount |= acc.isMultiHost();
                }
                if (containedCheckedMultihosterAccount) {
                    RefreshAction.displayMultihosterDetailOverviewHelpDialog();
                }
                return null;
            }
        });
    }

    private List<Account> getAccountsToCheck() {
        ArrayList<Account> accountsToCheck = new ArrayList<Account>();
        if (this.selection == null) {
            for (Account acc : AccountController.getInstance().list()) {
                if (!acc.isEnabled() || !acc.isValid()) continue;
                accountsToCheck.add(acc);
            }
        } else {
            for (AccountEntry accEntry : this.selection) {
                Account acc = accEntry.getAccount();
                if (acc == null) continue;
                accountsToCheck.add(acc);
            }
        }
        if (accountsToCheck.isEmpty()) {
            return null;
        }
        return accountsToCheck;
    }

    public static void displayMultihosterDetailOverviewHelpDialog() {
        HelpDialog.showIfAllowed((MessageConfig)new MessageConfig(null, "multihoster_table_detail_overview_hint", 32, _GUI.T.multihost_detailed_host_do_not_show_again_info_about_multi_host_overview_table_title(), _GUI.T.multihost_detailed_host_do_not_show_again_info_about_multi_host_overview_table_message(), (Icon)new AbstractIcon("sort", 32)));
    }

    @Override
    public boolean isEnabled() {
        return this.selection == null || this.selection.size() > 0;
    }
}

