/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.views.settings.panels.advanced;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.EventListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import jd.gui.swing.jdgui.JDGui;
import jd.gui.swing.jdgui.views.settings.panels.advanced.AdvancedTable;
import org.appwork.scheduler.DelayedRunnable;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.HelpNotifier;
import org.appwork.utils.swing.HelpNotifierCallbackListener;
import org.jdownloader.gui.settings.AbstractConfigPanel;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.images.NewTheme;
import org.jdownloader.settings.advanced.AdvancedConfigEventListener;
import org.jdownloader.settings.advanced.AdvancedConfigManager;
import org.jdownloader.translate._JDT;

public class AdvancedSettings
extends AbstractConfigPanel
implements DocumentListener,
AdvancedConfigEventListener {
    private static final long serialVersionUID = 1L;
    private final JTextField filterText;
    private final String filterHelp;
    private final AdvancedTable table;
    private final DelayedRunnable delayedRefresh;

    protected void onShow() {
        super.onShow();
        AdvancedConfigManager.getInstance().getEventSender().addListener((EventListener)this);
        JDGui.help(_GUI.T.AdvancedSettings_onShow_title_(), _GUI.T.AdvancedSettings_onShow_msg_(), (Icon)new AbstractIcon("warning", 32));
    }

    protected void onHide() {
        super.onHide();
        AdvancedConfigManager.getInstance().getEventSender().removeListener((EventListener)this);
    }

    public String getTitle() {
        return _GUI.T.gui_settings_advanced_title();
    }

    public AdvancedSettings() {
        this.addHeader(this.getTitle(), NewTheme.I().getIcon("advancedConfig", 32));
        this.addDescription(_JDT.T.gui_settings_advanced_description());
        this.filterHelp = _GUI.T.AdvancedSettings_AdvancedSettings_filter_();
        this.filterText = new JTextField(){
            private static final long serialVersionUID = 1L;
            private boolean drawReset = false;
            final Image close;
            final AbstractIcon search;
            private int closeXPos;
            {
                this.getDocument().addDocumentListener(new DocumentListener(){

                    private boolean hasText() {
                        String text = this.getText();
                        return text != null && text.length() > 0 && !text.equals(AdvancedSettings.this.filterHelp);
                    }

                    @Override
                    public void removeUpdate(DocumentEvent e) {
                        drawReset = this.hasText();
                    }

                    @Override
                    public void insertUpdate(DocumentEvent e) {
                        drawReset = this.hasText();
                    }

                    @Override
                    public void changedUpdate(DocumentEvent e) {
                        drawReset = this.hasText();
                    }
                });
                this.addMouseMotionListener(new MouseMotionListener(){

                    @Override
                    public void mouseMoved(MouseEvent e) {
                        if (!this.hasFocus()) {
                            return;
                        }
                        if (drawReset && closeXPos > 0 && e.getX() > closeXPos) {
                            this.setCursor(Cursor.getPredefinedCursor(12));
                            this.setCaretColor(this.getBackground());
                        } else {
                            this.setCursor(Cursor.getPredefinedCursor(2));
                            this.setCaretColor(null);
                        }
                    }

                    @Override
                    public void mouseDragged(MouseEvent e) {
                    }
                });
                this.addMouseListener(new MouseListener(){

                    @Override
                    public void mouseReleased(MouseEvent e) {
                    }

                    @Override
                    public void mousePressed(MouseEvent e) {
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                    }

                    @Override
                    public void mouseEntered(MouseEvent e) {
                    }

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        if (drawReset && closeXPos > 0 && e.getX() > closeXPos) {
                            this.setText("");
                        }
                    }
                });
                this.close = NewTheme.I().getImage("close", -1);
                this.search = new AbstractIcon("search", 16);
                this.closeXPos = -1;
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2 = (Graphics2D)g;
                Composite comp = g2.getComposite();
                g2.setComposite(AlphaComposite.getInstance(3, 0.6f));
                this.search.paintIcon((Component)this, (Graphics)g2, 3, 3);
                g2.setComposite(comp);
                if (this.drawReset) {
                    this.closeXPos = this.getWidth() - this.close.getWidth(null) - (this.getHeight() - this.close.getHeight(null)) / 2;
                    g2.drawImage(this.close, this.closeXPos, (this.getHeight() - this.close.getHeight(null)) / 2, this.close.getWidth(null), this.close.getHeight(null), null);
                }
            }
        };
        HelpNotifier.register((JTextComponent)this.filterText, (HelpNotifierCallbackListener)new HelpNotifierCallbackListener(){

            public void onHelpNotifyShown(JComponent c) {
            }

            public void onHelpNotifyHidden(JComponent c) {
            }
        }, (String)this.filterHelp);
        this.filterText.setBorder(BorderFactory.createCompoundBorder(this.filterText.getBorder(), BorderFactory.createEmptyBorder(0, 20, 0, 0)));
        this.add(this.filterText, "gapleft " + this.getLeftGap() + ",spanx,growx,pushx");
        this.filterText.getDocument().addDocumentListener(this);
        this.table = new AdvancedTable();
        this.add(new JScrollPane((Component)((Object)this.table)));
        this.delayedRefresh = new DelayedRunnable(200L, 1000L){

            public String getID() {
                return "AdvancedSettings";
            }

            public void delayedrun() {
                new EDTRunner(){

                    protected void runInEDT() {
                        String text = AdvancedSettings.this.filterText.getText();
                        if (text != null && !text.equals(AdvancedSettings.this.filterHelp)) {
                            AdvancedSettings.this.table.filter(text);
                        } else {
                            AdvancedSettings.this.table.filter(null);
                        }
                    }
                };
            }
        };
    }

    public Icon getIcon() {
        return NewTheme.I().getIcon("advancedConfig", 20);
    }

    public void save() {
    }

    public void updateContents() {
        this.delayedRefresh.resetAndStart();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.delayedRefresh.resetAndStart();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.delayedRefresh.resetAndStart();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.delayedRefresh.resetAndStart();
    }

    public void onAdvancedConfigUpdate() {
        this.delayedRefresh.resetAndStart();
    }
}

