/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.views.settings.panels.packagizer;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.Action;
import javax.swing.DropMode;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import jd.gui.swing.jdgui.BasicJDTable;
import jd.gui.swing.jdgui.views.settings.panels.packagizer.DuplicateAction;
import jd.gui.swing.jdgui.views.settings.panels.packagizer.ExportAction;
import jd.gui.swing.jdgui.views.settings.panels.packagizer.FilterTableModel;
import jd.gui.swing.jdgui.views.settings.panels.packagizer.NewAction;
import jd.gui.swing.jdgui.views.settings.panels.packagizer.PackagizerFilter;
import jd.gui.swing.jdgui.views.settings.panels.packagizer.PackagizerFilterRuleDialog;
import jd.gui.swing.jdgui.views.settings.panels.packagizer.RemoveAction;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.ExtTransferHandler;
import org.appwork.utils.Application;
import org.appwork.utils.swing.EDTRunner;
import org.jdownloader.controlling.packagizer.PackagizerController;
import org.jdownloader.controlling.packagizer.PackagizerRule;

public class PackagizerFilterTable
extends BasicJDTable<PackagizerRule> {
    private static final long serialVersionUID = 4698030718806607175L;
    private final PackagizerFilter packagizer;

    public PackagizerFilterTable(PackagizerFilter packagizer) {
        super(new FilterTableModel("PackagizerFilterTable"));
        this.setSearchEnabled(true);
        this.getTableHeader().setReorderingAllowed(false);
        this.setDragEnabled(true);
        this.setTransferHandler(new ExtTransferHandler());
        if (Application.getJavaVersion() >= Application.JAVA16) {
            this.setDropMode(DropMode.INSERT_ROWS);
        }
        this.setSelectionMode(2);
        this.packagizer = packagizer;
    }

    protected JPopupMenu onContextMenu(JPopupMenu popup, PackagizerRule contextObject, List<PackagizerRule> selection, ExtColumn<PackagizerRule> column, MouseEvent ev) {
        popup.add(new JMenuItem((Action)((Object)new NewAction(this))));
        popup.add(new JMenuItem((Action)((Object)new RemoveAction(this, selection, false))));
        popup.add(new JMenuItem((Action)((Object)new DuplicateAction(contextObject, this))));
        popup.addSeparator();
        popup.add((Action)((Object)new ExportAction(this.packagizer, selection)));
        return popup;
    }

    protected boolean onDoubleClick(MouseEvent e, PackagizerRule obj) {
        PackagizerFilterRuleDialog.showDialog(obj, new Runnable(){

            @Override
            public void run() {
                PackagizerController.getInstance().update();
                new EDTRunner(){

                    protected void runInEDT() {
                        PackagizerFilterTable.this.getModel().fireTableDataChanged();
                    }
                };
            }
        });
        return false;
    }

    protected boolean onShortcutDelete(List<PackagizerRule> selectedObjects, KeyEvent evt, boolean direct) {
        new RemoveAction(this, selectedObjects, direct).actionPerformed(null);
        return true;
    }
}

