/*
 * Decompiled with CFR 0.152.
 */
package jd.gui.swing.jdgui.views.settings.panels.proxy;

import com.btr.proxy.search.ProxySearchStrategy;
import com.btr.proxy.search.browser.firefox.FirefoxProxySearchStrategy;
import com.btr.proxy.search.desktop.DesktopProxySearchStrategy;
import com.btr.proxy.search.env.EnvProxySearchStrategy;
import com.btr.proxy.search.java.JavaProxySearchStrategy;
import com.btr.proxy.selector.pac.PacProxySelector;
import com.btr.proxy.selector.pac.PacScriptParser;
import com.btr.proxy.selector.pac.PacScriptSource;
import com.btr.proxy.selector.pac.UrlPacScriptSource;
import com.btr.proxy.selector.whitelist.ProxyBypassListSelector;
import java.awt.event.ActionEvent;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import jd.controlling.TaskQueue;
import jd.controlling.proxy.AbstractProxySelectorImpl;
import jd.controlling.proxy.NoProxySelector;
import jd.controlling.proxy.PacProxySelectorImpl;
import jd.controlling.proxy.ProxyController;
import jd.controlling.proxy.SingleBasicProxySelectorImpl;
import jd.controlling.proxy.SingleDirectGatewaySelector;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.StringUtils;
import org.appwork.utils.event.queue.QueueAction;
import org.appwork.utils.net.httpconnection.HTTPProxy;
import org.appwork.utils.net.socketconnection.SocketConnection;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.dialog.MessageDialogImpl;
import org.jdownloader.actions.AppAction;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.updatev2.InternetConnectionSettings;

public class ProxyAutoAction
extends AppAction {
    private static final long serialVersionUID = -197136045388327528L;

    public ProxyAutoAction() {
        this.setName(_GUI.T.ProxyAutoAction_actionPerformed_d_title());
        this.setIconKey("plugin");
        this.setEnabled(((InternetConnectionSettings)JsonConfig.create((String)"cfg/org.jdownloader.settings.InternetConnectionSettings", InternetConnectionSettings.class)).isProxyVoleAutodetectionEnabled());
    }

    public void actionPerformed(ActionEvent e) {
        TaskQueue.getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

            protected Void run() throws RuntimeException {
                ArrayList<Object> strategies = new ArrayList<Object>();
                try {
                    strategies.add(new DesktopProxySearchStrategy());
                    strategies.add(new FirefoxProxySearchStrategy());
                    strategies.add(new EnvProxySearchStrategy());
                    strategies.add(new JavaProxySearchStrategy());
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                int pre = ProxyController.getInstance().getList().size();
                for (ProxySearchStrategy proxySearchStrategy : strategies) {
                    try {
                        Field field;
                        ProxySelector selector = proxySearchStrategy.getProxySelector();
                        if (selector == null) continue;
                        if (selector instanceof ProxyBypassListSelector) {
                            field = ProxyBypassListSelector.class.getDeclaredField("delegate");
                            field.setAccessible(true);
                            selector = (ProxySelector)field.get(selector);
                        }
                        if (selector instanceof PacProxySelector) {
                            field = PacProxySelector.class.getDeclaredField("pacScriptParser");
                            field.setAccessible(true);
                            PacScriptParser source = (PacScriptParser)field.get(selector);
                            PacScriptSource pacSource = source.getScriptSource();
                            if (pacSource == null || !(pacSource instanceof UrlPacScriptSource)) continue;
                            field = UrlPacScriptSource.class.getDeclaredField("scriptUrl");
                            field.setAccessible(true);
                            Object pacURL = field.get(pacSource);
                            if (!StringUtils.isNotEmpty((String)((String)pacURL))) continue;
                            ProxyAutoAction.this.setProxy((AbstractProxySelectorImpl)new PacProxySelectorImpl((String)pacURL, null, null));
                            continue;
                        }
                        List<Proxy> proxies = selector.select(new URI("http://google.com"));
                        if (proxies == null) continue;
                        for (Proxy p : proxies) {
                            switch (p.type()) {
                                case DIRECT: {
                                    if (p.address() == null) {
                                        ProxyAutoAction.this.setProxy((AbstractProxySelectorImpl)new NoProxySelector());
                                        break;
                                    }
                                    HTTPProxy httpProxy = new HTTPProxy(((InetSocketAddress)p.address()).getAddress());
                                    ProxyAutoAction.this.setProxy((AbstractProxySelectorImpl)new SingleDirectGatewaySelector(httpProxy));
                                    break;
                                }
                                case HTTP: {
                                    if (p.address() == null) break;
                                    HTTPProxy httpProxy = new HTTPProxy(HTTPProxy.TYPE.HTTP, SocketConnection.getHostName((SocketAddress)p.address()), ((InetSocketAddress)p.address()).getPort());
                                    ProxyAutoAction.this.setProxy((AbstractProxySelectorImpl)new SingleBasicProxySelectorImpl(httpProxy));
                                    break;
                                }
                                case SOCKS: {
                                    if (p.address() == null) break;
                                    HTTPProxy httpProxy = new HTTPProxy(HTTPProxy.convertNativeProxyType((Proxy)p), SocketConnection.getHostName((SocketAddress)p.address()), ((InetSocketAddress)p.address()).getPort());
                                    ProxyAutoAction.this.setProxy((AbstractProxySelectorImpl)new SingleBasicProxySelectorImpl(httpProxy));
                                }
                            }
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
                final int diff = ProxyController.getInstance().getList().size() - pre;
                if (diff >= 0) {
                    new EDTRunner(){

                        protected void runInEDT() {
                            new MessageDialogImpl(0, _GUI.T.ProxyAutoAction_run_added_proxies_(diff)).show();
                        }
                    };
                }
                return null;
            }
        });
    }

    protected void setProxy(AbstractProxySelectorImpl proxy) {
        proxy.setEnabled(true);
        ProxyController.getInstance().setProxy(proxy);
    }
}

