/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.container.sft;

import java.util.ArrayList;

public class DelphiFormEntry {
    protected final int itemType;
    protected final DelphiFormEntry parent;
    protected final boolean accept_childs;
    protected String itemName;
    protected ArrayList<DelphiFormEntry> childs;

    public DelphiFormEntry(DelphiFormEntry parent, int itemType, boolean accept_childs) {
        this.accept_childs = accept_childs;
        this.itemType = itemType;
        this.parent = parent;
        this.childs = null;
        if (parent != null) {
            parent.addChild(this);
        }
    }

    public final DelphiFormEntry getParent() {
        return this.parent;
    }

    public final int getChildLength() {
        if (this.childs == null) {
            return 0;
        }
        return this.childs.size();
    }

    public final DelphiFormEntry getChildAt(int index) {
        if (this.childs == null) {
            return null;
        }
        return this.childs.get(index);
    }

    public final boolean removeChild(DelphiFormEntry child) {
        if (this.childs == null) {
            return false;
        }
        return this.childs.remove(child);
    }

    public final void remove() {
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
    }

    public final void addChild(DelphiFormEntry child) {
        if (this.accept_childs) {
            if (this.childs == null) {
                this.childs = new ArrayList();
            }
            this.childs.add(child);
        }
    }

    public final DelphiFormEntry get(int index) {
        return this.childs.get(index);
    }

    public final String getName() {
        return this.itemName;
    }

    public final void setName(String name) {
        this.itemName = new String(name);
    }

    public final int getType() {
        return this.itemType;
    }

    public final boolean isRoot() {
        return null == this.parent;
    }

    public final DelphiFormEntry find(String itemName) {
        for (DelphiFormEntry element : this.childs) {
            if (!element.getName().equals(itemName)) continue;
            return element;
        }
        return null;
    }

    public String getValue() {
        return null;
    }

    public void buildString(StringBuilder builder, String prepend) {
        if (this.childs == null) {
            return;
        }
        for (DelphiFormEntry element : this.childs) {
            element.buildString(builder, prepend);
        }
    }
}

