/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.container.sft;

public class RCx {
    private byte[] pD = new byte[256];
    private int pI;
    private int pJ;
    private int pF;
    private byte[] key;

    public RCx(byte[] key) {
        if (key != null) {
            this.init(key);
        }
    }

    public void init(byte[] key) {
        this.key = key;
        this.reset();
    }

    public void reset() {
        byte[] M = new byte[256];
        int L = 0;
        for (int S = 0; S < 256; ++S) {
            this.pD[S] = (byte)S;
            M[S] = (byte)(this.key[S % this.key.length] ^ L);
            L = (int)(((long)L + ((long)M[S] & 0xFFL) * 257L) % Integer.MAX_VALUE) + 1;
        }
        this.pJ = 0;
        this.pI = 0;
        int R2 = L & 0xFF;
        this.pF = L >> 8 & 0xFFFFFFFF;
        for (int S = 0; S < 256; ++S) {
            R2 = R2 + (this.pD[S] & 0xFF) + (M[S] & 0xFF) & 0xFF;
            byte T = this.pD[S];
            this.pD[S] = this.pD[R2];
            this.pD[R2] = T;
        }
    }

    public void init2(byte[] key) {
        this.key = key;
        this.reset2();
    }

    public void reset2() {
        byte[] M = new byte[256];
        int L = 0;
        for (int S = 0; S < 256; ++S) {
            this.pD[S] = (byte)S;
            M[S] = (byte)(this.key[S % this.key.length] ^ L);
            L = (int)(((long)L + ((long)M[S] & 0xFFL) * 331L) % Integer.MAX_VALUE) + 1;
        }
        this.pJ = 0;
        this.pI = 0;
        byte R2 = (byte)(L >> 4);
        this.pF = L >> 8 & 0xFFFFFFFF;
        byte DL = (byte)(L & 0xFF);
        for (int S = 0; S < 256; ++S) {
            DL = (byte)((R2 & 0xFF) + (this.pD[S] & 0xFF) + (M[S] & 0xFF) + (DL & 0xFF));
            R2 = this.pD[S];
            this.pD[S] = this.pD[DL & 0xFF];
            this.pD[DL & 0xFF] = R2;
        }
    }

    public void encode2(byte[] data) {
        if (data == null) {
            return;
        }
        int n = data.length;
        int p = 0;
        while (n-- != 0) {
            ++this.pI;
            this.pJ = this.pJ + (this.pD[this.pI & 0xFF] & 0xFF) & 0xFF;
            byte swap = this.pD[this.pI & 0xFF];
            this.pD[this.pI & 0xFF] = (byte)(this.pD[this.pJ & 0xFF] ^ this.pF);
            this.pD[this.pJ & 0xFF] = (byte)((swap & 0xFF) - this.pF);
            swap = (byte)((swap & 0xFF) + (this.pD[this.pI & 0xFF] & 0xFF));
            data[p] = swap = (byte)(this.pD[swap & 0xFF] ^ data[p]);
            this.pF ^= swap;
            ++p;
        }
    }

    public void encode(byte[] data) {
        if (data == null) {
            return;
        }
        for (int C2 = 0; C2 < data.length; ++C2) {
            ++this.pI;
            byte T = this.pD[this.pI];
            this.pJ = this.pJ + T & 0xFF;
            this.pD[this.pI] = (byte)(this.pD[this.pJ] ^ this.pF);
            this.pD[this.pJ] = (byte)(T - this.pF);
            T = (byte)(T + this.pD[this.pI]);
            byte K = data[C2];
            data[C2] = (byte)(K ^ this.pD[T & 0xFF]);
            this.pF ^= K;
        }
    }

    public void decode(byte[] data) {
        for (int C2 = 0; C2 < data.length; ++C2) {
            byte K;
            ++this.pI;
            byte T = this.pD[this.pI];
            this.pJ = this.pJ + T & 0xFF;
            this.pD[this.pI] = (byte)(this.pD[this.pJ] ^ this.pF);
            this.pD[this.pJ] = (byte)(T - this.pF);
            T = (byte)(T + this.pD[this.pI]);
            data[C2] = K = (byte)(data[C2] ^ this.pD[T & 0xFF]);
            this.pF ^= K;
        }
    }
}

