/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.container.sft;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.appwork.utils.encoding.Base64;
import org.appwork.utils.formatter.HexFormatter;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.BlowfishEngine;
import org.bouncycastle.crypto.params.KeyParameter;
import org.jdownloader.container.sft.DelphiFormBinLoader;
import org.jdownloader.container.sft.DelphiFormEntry;
import org.jdownloader.container.sft.RC4;
import org.jdownloader.container.sft.RCx;
import org.jdownloader.container.sft.sftBinary;
import org.jdownloader.container.sft.sftContainer;

public class sftContainerV8
extends sftContainer {
    public static final byte[] SENSITIVPASSWORD = "memory".getBytes();
    protected byte[] bHeader;
    protected boolean decryptedState;
    protected final DelphiFormEntry sft_root;
    protected final byte[] magicDecryptionKey;
    protected ArrayList<String> linkList;

    public sftContainerV8(DelphiFormBinLoader dfm, byte[] magicDecryptionKey) throws IOException, NoSuchAlgorithmException {
        super(dfm);
        this.sft_root = dfm.getRoot().find(NODE_ITEMS).get(0);
        byte[] eHeader = Base64.decode((String)this.sft_root.find(NODE_HEADER).getValue());
        RC4 rc = new RC4(Arrays.copyOf(magicDecryptionKey, 128));
        rc.encode(eHeader);
        this.bHeader = eHeader;
        this.magicDecryptionKey = magicDecryptionKey;
        this.setPassword(null);
    }

    @Override
    public boolean setPassword(char[] cs) {
        char[] MAGIC_SN = MAGIC_SERIAL.toCharArray();
        try {
            int i;
            byte[] password;
            this.decryptedState = false;
            if (cs == null) {
                password = new byte[MAGIC_SN.length];
                for (i = 0; i < password.length; ++i) {
                    password[i] = (byte)MAGIC_SN[i];
                }
            } else {
                password = new byte[MAGIC_SN.length < cs.length ? cs.length : MAGIC_SN.length];
                for (i = 0; i < cs.length; ++i) {
                    password[i] = (byte)cs[i];
                }
                while (i < password.length) {
                    password[i] = (byte)MAGIC_SN[i];
                    ++i;
                }
            }
            byte[] headerCheck = new byte[this.bHeader.length];
            headerCheck[0] = this.bHeader[0];
            for (int i2 = 1; i2 < headerCheck.length; ++i2) {
                byte xor = password[i2];
                xor = (byte)(xor ^ this.bHeader[i2]);
                headerCheck[i2] = xor = (byte)(xor ^ this.bHeader[i2 - 1]);
            }
            Pattern decryptPattern = Pattern.compile("^SFT#(\\d)#(\\d+)#SFT##$");
            Matcher decryptMatcher = decryptPattern.matcher(new String(headerCheck));
            if (decryptMatcher.matches()) {
                byte[] bFilename;
                byte[] bDirname;
                byte[] bPassword;
                byte[] bUsername;
                byte[] bHost;
                int i3;
                byte[] bValue;
                int passwordNeeded = Integer.parseInt(decryptMatcher.group(1));
                this.passwordNeeded = passwordNeeded > 0;
                byte[] sha256 = MessageDigest.getInstance(CRYPT_SHA256).digest(password);
                RC4 rc = new RC4(sha256);
                DelphiFormEntry node = this.sft_root.find(NODE_DESCRIPT);
                if (node != null) {
                    bValue = Base64.decode((String)node.getValue());
                    rc.encode(bValue);
                    this.strDescription = new String(bValue, "ISO-8859-1");
                }
                if ((node = this.sft_root.find(NODE_UPLOADER)) != null) {
                    bValue = Base64.decode((String)node.getValue());
                    rc.encode(bValue);
                    this.strUploader = new String(bValue, "ISO-8859-1");
                }
                if ((node = this.sft_root.find(NODE_COMMENT)) != null) {
                    bValue = Base64.decode((String)node.getValue());
                    rc.encode(bValue);
                    this.strComment = new String(bValue, "ISO-8859-1");
                }
                byte[] magicStringCopy = null;
                if (passwordNeeded > 0) {
                    magicStringCopy = new byte[cs.length];
                    for (int i4 = 0; i4 < magicStringCopy.length; ++i4) {
                        magicStringCopy[i4] = (byte)cs[i4];
                    }
                } else {
                    magicStringCopy = Arrays.copyOfRange(sftBinary.MAGIC, 1, sftBinary.MAGIC.length);
                }
                ArrayList<byte[]> HostList = new ArrayList<byte[]>();
                ArrayList<byte[]> UsernameList = new ArrayList<byte[]>();
                ArrayList<byte[]> PasswordList = new ArrayList<byte[]>();
                ArrayList<byte[]> DirList = new ArrayList<byte[]>();
                ArrayList<byte[]> FileList = new ArrayList<byte[]>();
                this.linkList = new ArrayList();
                node = this.sft_root.find(NODE_FTPDOWNLOAD);
                for (i3 = node.getChildLength() - 1; i3 >= 0; --i3) {
                    String Filename;
                    bHost = null;
                    bUsername = null;
                    bPassword = null;
                    bDirname = null;
                    bFilename = null;
                    DelphiFormEntry eHost = node.get(i3);
                    DelphiFormEntry eDir = eHost.find(NODE_DIRS).get(0);
                    DelphiFormEntry eFile = eDir.find(NODE_FILES).get(0);
                    DelphiFormEntry neHost = eHost.find(NODE_HOST);
                    DelphiFormEntry neUsername = eHost.find(NODE_USERNAME);
                    DelphiFormEntry nePassword = eHost.find(NODE_PASSWORD);
                    DelphiFormEntry neDirname = eDir.find(NODE_DIRNAME);
                    DelphiFormEntry neFilename = eFile.find(NODE_FILENAME);
                    String Host = neHost == null ? null : neHost.getValue();
                    String Username = neUsername == null ? null : neUsername.getValue();
                    String Password = nePassword == null ? null : nePassword.getValue();
                    String Dirname = neDirname == null ? null : neDirname.getValue();
                    String string = Filename = neFilename == null ? null : neFilename.getValue();
                    if (Host != null) {
                        bHost = HexFormatter.hexToByteArray((String)Host);
                    }
                    if (Username != null) {
                        bUsername = HexFormatter.hexToByteArray((String)Username);
                    }
                    if (Password != null) {
                        bPassword = HexFormatter.hexToByteArray((String)Password);
                    }
                    if (Dirname != null) {
                        bDirname = HexFormatter.hexToByteArray((String)Dirname);
                    }
                    if (Filename != null) {
                        bFilename = Filename.getBytes("UTF-8");
                    }
                    RCx rcx = new RCx(null);
                    rcx.init2(this.magicDecryptionKey);
                    rcx.encode2(bHost);
                    rcx.init2(this.magicDecryptionKey);
                    rcx.encode2(bUsername);
                    rcx.init2(this.magicDecryptionKey);
                    rcx.encode2(bPassword);
                    rcx.init2(this.magicDecryptionKey);
                    rcx.encode2(bDirname);
                    HostList.add(bHost);
                    UsernameList.add(bUsername);
                    PasswordList.add(bPassword);
                    DirList.add(bDirname);
                    FileList.add(bFilename);
                    if (bHost != null) {
                        this.manipulateMagicString(magicStringCopy, bHost[bHost.length - 1]);
                    }
                    if (bUsername != null) {
                        this.manipulateMagicString(magicStringCopy, bUsername[bUsername.length - 1]);
                    }
                    if (bPassword != null) {
                        this.manipulateMagicString(magicStringCopy, bPassword[bPassword.length - 1]);
                    }
                    if (bDirname == null) continue;
                    this.manipulateMagicString(magicStringCopy, bDirname[bDirname.length - 1]);
                }
                for (i3 = 0; i3 < node.getChildLength(); ++i3) {
                    bHost = (byte[])HostList.get(i3);
                    bUsername = (byte[])UsernameList.get(i3);
                    bPassword = (byte[])PasswordList.get(i3);
                    bDirname = (byte[])DirList.get(i3);
                    bFilename = (byte[])FileList.get(i3);
                    this.decodeFilename(magicStringCopy, bFilename);
                    if (bDirname != null && !this.toBase64String(magicStringCopy, bDirname)) {
                        return false;
                    }
                    if (bPassword != null && !this.toBase64String(magicStringCopy, bPassword)) {
                        return false;
                    }
                    if (bUsername != null && !this.toBase64String(magicStringCopy, bUsername)) {
                        return false;
                    }
                    if (bHost != null && !this.toBase64String(magicStringCopy, bHost)) {
                        return false;
                    }
                    if (bHost != null) {
                        bHost = this.decodeCoreInformation(bHost);
                    }
                    if (bUsername != null) {
                        bUsername = this.decodeCoreInformation(bUsername);
                    }
                    if (bPassword != null) {
                        bPassword = this.decodeCoreInformation(bPassword);
                    }
                    if (bDirname != null) {
                        bDirname = this.decodeCoreInformation(bDirname);
                    }
                    String link = sftContainerV8.buildFTPLink(bHost, (short)0, bUsername, bPassword, bDirname, bFilename);
                    this.linkList.add(link);
                }
                this.decryptedState = true;
                return true;
            }
            this.passwordNeeded = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.decryptedState = false;
        }
        return false;
    }

    private byte[] decodeCoreInformation(byte[] encrypted) throws NoSuchAlgorithmException, IOException, Exception {
        byte[] sha256 = MessageDigest.getInstance(CRYPT_SHA256).digest(SENSITIVPASSWORD);
        byte[] data = Base64.decode((String)new String(encrypted));
        byte[] IV = new byte[8];
        BlowfishEngine cipher = new BlowfishEngine();
        cipher.init(true, (CipherParameters)new KeyParameter(sha256));
        cipher.processBlock(IV, 0, IV, 0);
        for (int i = 0; i < data.length; ++i) {
            byte[] BlowFishRound = new byte[IV.length];
            cipher.init(true, (CipherParameters)new KeyParameter(sha256));
            cipher.processBlock(IV, 0, BlowFishRound, 0);
            byte temp = data[i];
            int n = i;
            data[n] = (byte)(data[n] ^ BlowFishRound[0]);
            for (int q = 1; q < 8; ++q) {
                IV[q - 1] = IV[q];
            }
            IV[7] = temp;
        }
        return data;
    }

    private boolean isBase64(byte[] data) {
        for (int i = 0; i < data.length; ++i) {
            boolean valid;
            char chr = (char)data[i];
            boolean bl = valid = chr >= 'A' && chr <= 'Z' || chr >= 'a' && chr <= 'z' || chr >= '0' && chr <= '9' || chr == '+' || chr == '/' || chr == '=';
            if (valid) continue;
            return false;
        }
        return true;
    }

    private boolean toBase64String(byte[] magicString, byte[] encrypted) {
        int magicLen = magicString.length;
        byte a = encrypted[encrypted.length - 1];
        int n = a % magicLen;
        magicString[n] = (byte)(magicString[n] ^ a);
        for (int i = 1; i < encrypted.length; ++i) {
            a = magicString[i % magicString.length];
            a = (byte)(a | sftBinary.MAGIC[i % 255 + 1]);
            int n2 = i - 1;
            encrypted[n2] = (byte)(encrypted[n2] ^ a);
        }
        return this.isBase64(encrypted);
    }

    private void decodeFilename(byte[] key, byte[] filename) {
        int keyLength = key.length;
        for (int i = 1; i <= filename.length; ++i) {
            byte a = key[i % keyLength];
            byte b = sftBinary.MAGIC[i % 255 + 1];
            filename[i - 1] = (byte)((a | b) ^ filename[i - 1]);
        }
    }

    private void manipulateMagicString(byte[] magicStringCopy, byte lastByte) {
        int p;
        int n = p = (lastByte & 0xFF) % magicStringCopy.length;
        magicStringCopy[n] = (byte)(magicStringCopy[n] ^ lastByte);
    }

    @Override
    public boolean isDecrypted() {
        return this.decryptedState;
    }

    @Override
    public ArrayList<String> getFormatedLinks() {
        return this.linkList;
    }
}

