/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.styles;

import de.javasoft.plaf.synthetica.StyleFactory;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.styles.StyleWrapper;
import de.javasoft.util.JavaVersion;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;

public class ScrollPaneStyle
extends StyleWrapper {
    private static ScrollPaneStyle instance = new ScrollPaneStyle();
    private static String comboBoxViewportInsetsKey = "Synthetica.comboBox.viewport.border.insets";

    private ScrollPaneStyle() {
    }

    public static SynthStyle getStyle(SynthStyle synthStyle, JComponent jComponent, Region region) {
        Object object;
        String string = (String)SyntheticaLookAndFeel.get("Synthetica.scrollPane.layoutManager.className", jComponent);
        if (string != null && jComponent.getLayout() != null) {
            try {
                object = Class.forName(string);
                if (!((Class)object).isAssignableFrom(jComponent.getLayout().getClass())) {
                    ((StyleFactory)SynthLookAndFeel.getStyleFactory()).getComponentPropertyStore().storeComponentProperty(jComponent, "SYCP_LAYOUT_MANAGER");
                    jComponent.setLayout((LayoutManager)((Class)object).newInstance());
                }
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        if (SyntheticaLookAndFeel.getStyleName(jComponent) == null) {
            instance.setStyle(synthStyle);
            return instance;
        }
        object = new ScrollPaneStyle();
        ((StyleWrapper)object).setStyle(synthStyle);
        return object;
    }

    public Object get(SynthContext synthContext, Object object) {
        JScrollPane jScrollPane = (JScrollPane)synthContext.getComponent();
        if (!JavaVersion.JAVA5 && "ScrollPane.viewportBorderInsets".equals(object) && UIManager.get(comboBoxViewportInsetsKey) != null && jScrollPane.getViewport().getView() != null && "ComboBox.list".equals(jScrollPane.getViewport().getView().getName())) {
            return UIManager.getInsets(comboBoxViewportInsetsKey);
        }
        return super.get(synthContext, object);
    }

    public Color getColor(SynthContext synthContext, ColorType colorType) {
        JScrollPane jScrollPane = (JScrollPane)synthContext.getComponent();
        Component component = jScrollPane.getViewport().getView();
        if (component == null) {
            return this.synthStyle.getColor(synthContext, colorType);
        }
        Color color = component.getBackground();
        if (component.getBackground() == null || component.getBackground() instanceof ColorUIResource) {
            color = Color.WHITE;
        }
        if (component instanceof JEditorPane && component.getBackground() instanceof ColorUIResource) {
            JEditorPane jEditorPane = (JEditorPane)component;
            if (!jEditorPane.isEditable()) {
                color = UIManager.getColor("Synthetica.editorPane.lockedColor");
            }
            if (!jEditorPane.isEnabled()) {
                color = UIManager.getColor("Synthetica.editorPane.disabledColor");
            }
        } else if (component instanceof JTextArea && component.getBackground() instanceof ColorUIResource) {
            JTextArea jTextArea = (JTextArea)component;
            if (!jTextArea.isEditable()) {
                color = UIManager.getColor("Synthetica.textArea.lockedColor");
            } else if (!jTextArea.isEnabled()) {
                color = UIManager.getColor("Synthetica.textArea.disabledColor");
            }
        }
        if (color != null) {
            return new ColorUIResource(color);
        }
        return super.getColor(synthContext, colorType);
    }
}

