/*
 * Decompiled with CFR 0.152.
 */
package jd.http;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import jd.http.Authentication;
import jd.http.AuthenticationFactory;
import jd.http.BlockLevelType;
import jd.http.BlockSourceType;
import jd.http.BlockedTypeInterface;
import jd.http.BrowserSettings;
import jd.http.ClonedProxy;
import jd.http.Cookie;
import jd.http.Cookies;
import jd.http.NoGateWayException;
import jd.http.ProxySelectorInterface;
import jd.http.Request;
import jd.http.RequestHeader;
import jd.http.StaticProxySelector;
import jd.http.URLConnectionAdapter;
import jd.http.URLUserInfoAuthentication;
import jd.http.requests.FormData;
import jd.http.requests.GetRequest;
import jd.http.requests.HeadRequest;
import jd.http.requests.PostFormDataRequest;
import jd.http.requests.PostRequest;
import jd.parser.Regex;
import jd.parser.html.Form;
import jd.parser.html.InputField;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.config.annotations.LabelInterface;
import org.appwork.utils.DebugMode;
import org.appwork.utils.Exceptions;
import org.appwork.utils.KeyValueStringEntry;
import org.appwork.utils.StringUtils;
import org.appwork.utils.formatter.TimeFormatter;
import org.appwork.utils.logging2.ConsoleLogImpl;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.net.HTTPHeader;
import org.appwork.utils.net.PublicSuffixList;
import org.appwork.utils.net.URLHelper;
import org.appwork.utils.net.httpconnection.HTTPConnectionUtils;
import org.appwork.utils.net.httpconnection.HTTPProxy;
import org.appwork.utils.net.httpconnection.ProxyAuthException;
import org.appwork.utils.net.httpconnection.SSLSocketStreamOptionsModifier;
import org.appwork.utils.parser.UrlQuery;

public class Browser {
    private static final HashMap<String, Cookies> COOKIES = new HashMap();
    private static ProxySelectorInterface GLOBAL_PROXY = null;
    private static LogInterface LOGGER = new ConsoleLogImpl();
    private static int TIMEOUT_CONNECT = 30000;
    private static int TIMEOUT_READ = 30000;
    private Boolean defaultSSLTrustALL = null;
    protected static HTTPConnectionUtils.IPVERSION GLOBAL_IPVERSION = null;
    protected HTTPConnectionUtils.IPVERSION ipVersion = null;
    private boolean throwExceptionOnBlockedBy = true;
    private static final Pattern HOST_IP_PATTERN1 = Pattern.compile("^(?:[a-z0-9]{2,64}://)?[a-z0-9]{2,64}://(?:[^\\s@/]+?@)?(\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3})(?::\\d+)?(?:/|/.+|)$", 34);
    private static final Pattern HOST_IP_PATTERN2 = Pattern.compile("^(\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3})(?::\\d+)?(?:/|/.+|)$", 34);
    private static final Pattern HOST_DOMAIN_PATTERN = Pattern.compile("^(?:[a-z0-9]{2,64}://)?[a-z0-9]{2,64}://(?:[^\\s@/]+?@)?([a-z0-9\\-\\.]+?)(/|$|:\\d+$|:\\d+/)", 34);
    private static final Pattern HOST_DOMAIN_PATTERN2 = Pattern.compile("^(?:[^\\s@/]+?@)?([a-z0-9\\-\\.]+?)(/|$|:\\d+$|:\\d+/)", 34);
    private boolean keepResponseContentBytes = false;
    private int[] allowedResponseCodes = new int[0];
    private static boolean VERBOSE = false;
    private static final HashMap<String, Integer> REQUEST_INTERVAL_MAP = new HashMap();
    private static final HashMap<String, AtomicLong> REQUESTTIME_MAP = new HashMap();
    private static final HashMap<String, List<Request>> REQUEST_INTERVAL_QUEUE = new HashMap();
    private static final HashMap<String, Integer> REQUESTS_BURST_INTERVAL_MAP = new HashMap();
    private static final HashMap<String, Vector<Long>> REQUESTS_BURST_REQUESTS_MAP = new HashMap();
    private String acceptLanguage = "de, en-gb;q=0.9, en;q=0.8";
    private int connectTimeout = -1;
    private HashMap<String, Cookies> cookies = new HashMap();
    private boolean cookiesExclusive = true;
    private Object currentURL = null;
    private String customCharset = null;
    private boolean debug = false;
    private boolean doRedirects = false;
    private RequestHeader headers;
    private int limit = -1;
    private LogInterface logger = null;
    private ProxySelectorInterface proxy;
    private int readTimeout = -1;
    private Request request;
    private boolean verbose = false;
    private volatile List<BlockedTypeInterface> blockedTypeInterfaces = null;
    protected SSLSocketStreamOptionsModifier sslSocketStreamOptionsModifier = null;
    private final List<Object[]> LOCATION_MAP = new ArrayList<Object[]>();
    private static final AtomicLong BROWSERIDS = new AtomicLong(0L);
    private final AtomicLong requestID = new AtomicLong(0L);
    protected static AuthenticationFactory DEFAULTAUTHENTICATIONFACTORY = new URLUserInfoAuthentication();
    protected volatile AuthenticationFactory authenticationFactory = null;
    private long browserID = -1L;
    private long browserParentID = -1L;
    protected CopyOnWriteArrayList<Authentication> authentications = new CopyOnWriteArrayList();

    public static HTTPConnectionUtils.IPVERSION getGlobalIPVersion() {
        return GLOBAL_IPVERSION;
    }

    public static void setGlobalIPVersion(HTTPConnectionUtils.IPVERSION ipVersion) {
        GLOBAL_IPVERSION = ipVersion;
    }

    public HTTPConnectionUtils.IPVERSION getIPVersion() {
        HTTPConnectionUtils.IPVERSION ipVersion = this.ipVersion;
        if (ipVersion != null) {
            return ipVersion;
        }
        return Browser.getGlobalIPVersion();
    }

    public void setIPVersion(HTTPConnectionUtils.IPVERSION ipVersion) {
        this.ipVersion = ipVersion;
    }

    public boolean getThrowExceptionOnBlockedBy(Request request) {
        return this.throwExceptionOnBlockedBy && request != null;
    }

    public void setThrowExceptionOnBlockedBy(boolean b) {
        this.throwExceptionOnBlockedBy = b;
    }

    public static ProxySelectorInterface _getGlobalProxy() {
        return GLOBAL_PROXY;
    }

    public static int getGlobalReadTimeout() {
        return TIMEOUT_READ;
    }

    public static String getHost(String url) {
        return Browser.getHost(url, false);
    }

    public static String getHost(URL url) {
        return Browser.getHost(url, false);
    }

    public static String getHost(String url, boolean includeSubDomains) {
        if (url == null) {
            return null;
        }
        String trimURL = url.trim();
        try {
            return Browser.getHost(new URL(trimURL), includeSubDomains);
        }
        catch (Throwable throwable) {
            String ret = new Regex((Object)trimURL, HOST_IP_PATTERN1).getMatch(0);
            if (ret == null) {
                ret = new Regex((Object)trimURL, HOST_IP_PATTERN2).getMatch(0);
            }
            if (ret != null) {
                return ret;
            }
            ret = new Regex((Object)trimURL, HOST_DOMAIN_PATTERN).getMatch(0);
            if (ret == null) {
                ret = new Regex((Object)trimURL, HOST_DOMAIN_PATTERN2).getMatch(0);
            }
            if (ret != null && !includeSubDomains) {
                String domain;
                PublicSuffixList psl = PublicSuffixList.getInstance();
                if (psl != null && (domain = psl.getDomain(ret.toLowerCase(Locale.ENGLISH))) != null) {
                    return domain;
                }
                int indexPoint = ret.lastIndexOf(".");
                if ((indexPoint = ret.lastIndexOf(".", indexPoint - 1)) >= 0) {
                    ret = ret.substring(indexPoint + 1);
                }
            }
            if (ret != null) {
                return ret.toLowerCase(Locale.ENGLISH);
            }
            return url;
        }
    }

    public static String getSubdomain(URL uri, boolean removeTrailingDelimiter) {
        String withSubdomain;
        String withoutSubdomain = Browser.getHost(uri, false);
        if (StringUtils.equals((String)withoutSubdomain, (String)(withSubdomain = Browser.getHost(uri, true)))) {
            return null;
        }
        return withSubdomain.replaceFirst((removeTrailingDelimiter ? "\\." : "") + Pattern.quote(withoutSubdomain) + "$", "");
    }

    public static String getSubdomain(String url, boolean removeTrailingDelimiter) throws MalformedURLException {
        return Browser.getSubdomain(new URL(url), removeTrailingDelimiter);
    }

    public static String getHost(URL uri, boolean includeSubDomains) {
        if (uri == null) {
            return null;
        }
        String ret = uri.getHost();
        if (HOST_IP_PATTERN2.matcher(ret).matches()) {
            return ret;
        }
        if (ret != null && !includeSubDomains) {
            String domain;
            PublicSuffixList psl = PublicSuffixList.getInstance();
            if (psl != null && (domain = psl.getDomain(ret.toLowerCase(Locale.ENGLISH))) != null) {
                return domain;
            }
            int indexPoint = ret.lastIndexOf(".");
            if ((indexPoint = ret.lastIndexOf(".", indexPoint - 1)) >= 0) {
                ret = ret.substring(indexPoint + 1);
            }
        }
        if (ret != null) {
            return ret.toLowerCase(Locale.ENGLISH);
        }
        return ret;
    }

    public static void setGlobalConnectTimeout(int valueMS) {
        TIMEOUT_CONNECT = valueMS;
    }

    public static void setGlobalLogger(LogInterface logger) {
        LOGGER = logger;
    }

    public static void setGlobalProxy(ProxySelectorInterface p) {
        GLOBAL_PROXY = p;
    }

    public static void setGlobalReadTimeout(int valueMS) {
        TIMEOUT_READ = valueMS;
    }

    public static void setGlobalVerbose(boolean b) {
        VERBOSE = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void download(File file, URLConnectionAdapter con) throws IOException {
        if (con == null) {
            throw new IOException("con is null");
        }
        if (file.isFile() && file.exists() && !file.delete()) {
            throw new IOException("Could not overwrite file: " + file);
        }
        File parentFile = file.getParentFile();
        if (parentFile != null && !parentFile.exists()) {
            parentFile.mkdirs();
        }
        FileOutputStream fos = null;
        InputStream input = null;
        boolean okay = false;
        try {
            int len;
            input = con.getInputStream();
            file.createNewFile();
            fos = new FileOutputStream(file, false);
            long length = con.isContentDecoded() ? -1L : con.getCompleteContentLength();
            byte[] b = new byte[Short.MAX_VALUE];
            long done = 0L;
            while ((len = input.read(b)) != -1) {
                fos.write(b, 0, len);
                done += (long)len;
            }
            if (length > 0L && length != done) {
                throw new IOException("Incomplete:" + length + "<=>" + done);
            }
            okay = true;
        }
        finally {
            try {
                input.close();
            }
            catch (Throwable throwable) {}
            try {
                fos.close();
            }
            catch (Throwable throwable) {}
            if (!okay) {
                file.delete();
            }
        }
    }

    public static int getGlobalConnectTimeout() {
        return TIMEOUT_CONNECT;
    }

    public static LogInterface getGlobalLogger() {
        return LOGGER;
    }

    public static void setRequestIntervalLimitGlobal(String host, int requestInterval) {
        Browser.setRequestIntervalLimitGlobal(host, false, requestInterval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setRequestIntervalLimitGlobal(String host, boolean includeSubdomain, int requestInterval) {
        String domain = Browser.getHost(host, includeSubdomain);
        if (domain != null) {
            HashMap<String, Integer> hashMap = REQUEST_INTERVAL_MAP;
            synchronized (hashMap) {
                boolean notifyFlag = false;
                if (requestInterval <= 0) {
                    Integer existingRequestInterval = REQUEST_INTERVAL_MAP.remove(domain);
                    AtomicLong lastRequest = REQUESTTIME_MAP.remove(domain);
                    if (lastRequest != null) {
                        AtomicLong entryRequest;
                        long timeStamp = lastRequest.getAndSet(-1L);
                        Object[] nextLimitEntry = Browser.getValueFromMap(REQUESTTIME_MAP, domain);
                        if (nextLimitEntry != null && timeStamp > (entryRequest = (AtomicLong)nextLimitEntry[1]).get()) {
                            entryRequest.set(timeStamp);
                        }
                    }
                    notifyFlag = existingRequestInterval != null || lastRequest != null;
                } else {
                    Integer existingRequestInterval = REQUEST_INTERVAL_MAP.put(domain, requestInterval);
                    boolean bl = notifyFlag = existingRequestInterval == null || existingRequestInterval != requestInterval;
                }
                if (notifyFlag) {
                    REQUEST_INTERVAL_MAP.notifyAll();
                }
            }
        }
    }

    public static void setBurstRequestIntervalLimitGlobal(String host, int requestInterval, int burstRequests, int burstInterval) {
        Browser.setBurstRequestIntervalLimitGlobal(host, false, requestInterval, burstRequests, burstInterval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void setBurstRequestIntervalLimitGlobal(String host, boolean includeSubdomain, int requestInterval, int burstRequests, int burstInterval) {
        String domain = Browser.getHost(host, includeSubdomain);
        if (domain == null) {
            throw new WTFException("Browser.getHost(host) returned null:" + host);
        }
        HashMap<String, Integer> hashMap = REQUEST_INTERVAL_MAP;
        synchronized (hashMap) {
            Browser.setRequestIntervalLimitGlobal(domain, includeSubdomain, requestInterval);
            boolean notifyFlag = false;
            if (requestInterval <= 0 || burstRequests <= 0 || burstInterval <= 0) {
                notifyFlag = REQUESTS_BURST_INTERVAL_MAP.remove(domain) != null;
            } else {
                Integer existingBurstInterval = REQUESTS_BURST_INTERVAL_MAP.put(domain, burstInterval);
                notifyFlag = existingBurstInterval == null || existingBurstInterval != burstInterval;
                Vector<Long> vector = REQUESTS_BURST_REQUESTS_MAP.get(domain);
                if (vector == null) {
                    vector = new Vector(burstRequests);
                    REQUESTS_BURST_REQUESTS_MAP.put(domain, vector);
                } else if (vector.capacity() != burstRequests) {
                    vector.ensureCapacity(burstRequests);
                    notifyFlag = true;
                }
            }
            if (notifyFlag) {
                REQUEST_INTERVAL_MAP.notifyAll();
            }
        }
    }

    private static Object[] getValueFromMap(Map<String, ? extends Object> map, String host) {
        while (host.contains(".")) {
            Object value = map.get(host);
            if (value != null) {
                return new Object[]{host, value};
            }
            host = host.replaceFirst("(.*?)\\.", "");
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private static void waitForPageAccess(Browser browser, Request request) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 37[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Browser() {
        Thread currentThread = Thread.currentThread();
        if (currentThread != null && currentThread instanceof BrowserSettings) {
            BrowserSettings settings = (BrowserSettings)((Object)currentThread);
            this.setProxySelector(settings.getProxySelector());
            this.setDebug(settings.isDebug());
            this.setVerbose(settings.isVerbose());
            this.setLogger(settings.getLogger());
        }
    }

    private void checkContentLengthLimit(Request request) throws BrowserException {
        if (request != null && request.getHttpConnection() != null && !(request instanceof HeadRequest)) {
            int limit = this.getLoadLimit();
            request.setReadLimit(limit);
            long length = request.getHttpConnection().getLongContentLength();
            if (length >= 0L && length > (long)limit) {
                request.disconnect();
                throw new BrowserException("Content-length too big:" + length + ">" + limit, request, null);
            }
        }
    }

    public int getDefaultLoadLimit() {
        return 0x1000000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCookies(String url) {
        HashMap<String, Cookies> map;
        HashMap<String, Cookies> hashMap = map = this.getCookies();
        synchronized (hashMap) {
            if (url == null) {
                map.clear();
            } else {
                String host = Browser.getHost(url);
                Iterator it = map.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry next = it.next();
                    if (next.getKey() == null) {
                        it.remove();
                        continue;
                    }
                    if (!StringUtils.equalsIgnoreCase((String)((String)next.getKey()), (String)host)) continue;
                    ((Cookies)next.getValue()).clear();
                    break;
                }
            }
        }
    }

    public SSLSocketStreamOptionsModifier getSSLSocketStreamOptions() {
        return this.sslSocketStreamOptionsModifier;
    }

    public SSLSocketStreamOptionsModifier setSSLSocketStreamOptions(SSLSocketStreamOptionsModifier sslSocketStreamOptionsModifier) {
        SSLSocketStreamOptionsModifier ret = this.sslSocketStreamOptionsModifier;
        this.sslSocketStreamOptionsModifier = sslSocketStreamOptionsModifier;
        return ret;
    }

    public void clearHeaders() {
        if (this.headers != null) {
            this.headers.clear();
        }
    }

    public void clearAll() {
        this.clearAuthentications();
        this.clearCookies(null);
        this.clearHeaders();
    }

    public Browser createNewBrowserInstance() {
        return new Browser();
    }

    public Browser cloneBrowser() {
        Browser br = this.createNewBrowserInstance();
        return this.cloneBrowser(br);
    }

    public List<BlockedTypeInterface> getBlockedTypeInterfaces() {
        List<BlockedTypeInterface> ret = this.blockedTypeInterfaces;
        if (ret == null) {
            return new ArrayList<BlockedTypeInterface>(Arrays.asList(GenericSupportedBlockTypes.values()));
        }
        return ret;
    }

    public List<BlockedTypeInterface> setBlockedTypeInterfaces(List<BlockedTypeInterface> blockedTypeInterfaces) {
        List<BlockedTypeInterface> ret = this.blockedTypeInterfaces;
        this.blockedTypeInterfaces = blockedTypeInterfaces;
        return ret;
    }

    public Browser cloneBrowser(Browser br) {
        br.acceptLanguage = this.acceptLanguage;
        br.connectTimeout = this.connectTimeout;
        br.currentURL = this.currentURL;
        br.doRedirects = this.doRedirects;
        br.defaultSSLTrustALL = this.defaultSSLTrustALL;
        br.setCustomCharset(this.customCharset);
        br.getHeaders().putAll(this.getHeaders());
        br.limit = this.limit;
        br.sslSocketStreamOptionsModifier = this.sslSocketStreamOptionsModifier;
        br.readTimeout = this.readTimeout;
        br.request = this.getRequest();
        br.cookies = this.cookies;
        br.browserParentID = this.getBrowserID();
        br.getBrowserID();
        br.authentications = this.authentications;
        br.cookiesExclusive = this.cookiesExclusive;
        br.authenticationFactory = this.authenticationFactory;
        br.debug = this.debug;
        br.verbose = this.verbose;
        br.logger = this.logger;
        br.proxy = this.proxy;
        br.blockedTypeInterfaces = this.blockedTypeInterfaces;
        br.ipVersion = this.ipVersion;
        br.keepResponseContentBytes = this.keepResponseContentBytes;
        br.allowedResponseCodes = this.allowedResponseCodes;
        br.throwExceptionOnBlockedBy = this.throwExceptionOnBlockedBy;
        return br;
    }

    public boolean containsHTML(String regex) {
        return new Regex((Object)this, regex).matches();
    }

    public long getCurrentServerTime(long fallback) {
        return this.getCurrentServerTime("EEE, dd MMM yyyy HH:mm:ss z", fallback);
    }

    public long getCurrentServerTime(String formatter, long fallback) {
        String dateString;
        long serverTime = -1L;
        URLConnectionAdapter con = this.getHttpConnection();
        if (con != null && (dateString = con.getHeaderField("Date")) != null) {
            if (StringUtils.isNotEmpty((String)formatter)) {
                serverTime = TimeFormatter.getMilliSeconds((String)dateString, (String)formatter, (Locale)Locale.ENGLISH);
            }
            if (serverTime == -1L) {
                Date date = TimeFormatter.parseDateString((String)dateString);
                long l = serverTime = date != null ? date.getTime() : -1L;
            }
        }
        if (serverTime == -1L) {
            serverTime = fallback;
        }
        return serverTime;
    }

    public Request createFormRequest(Form form) throws IOException {
        String formAction;
        URL base = null;
        Request lRequest = this.getRequest();
        if (lRequest != null) {
            base = lRequest.getURL();
        }
        try {
            String baseTag = this.getRegex("<\\s*base\\s+[^>]*>").getMatch(-1);
            if (baseTag != null) {
                String sourceBase = new Regex(baseTag, "href\\s*=\\s*(\"|')(.+?)\\1").getMatch(1);
                if (sourceBase == null) {
                    sourceBase = new Regex(baseTag, "\\s+href\\s*=([^\\s]+)").getMatch(0);
                }
                if (sourceBase != null) {
                    URL sourceBaseURL = URLHelper.createURL((String)sourceBase.trim());
                    String domainHostBase = base != null ? Browser.getHost(Request.getLocation(base.toString(), lRequest)) : null;
                    String domainSourceBase = Browser.getHost(Request.getLocation(sourceBase, lRequest));
                    if (domainHostBase != null && domainSourceBase != null && domainHostBase.equals(domainSourceBase)) {
                        base = sourceBaseURL;
                    }
                }
            }
        }
        catch (Throwable baseTag) {
            // empty catch block
        }
        String string = formAction = lRequest != null ? form.getAction(lRequest.getURL()) : form.getAction(base);
        if (formAction == null) {
            throw new NullPointerException("no valid action url");
        }
        List requestVariables = form.getFormData();
        switch (form.getMethod()) {
            case GET: {
                String newVarString;
                String varString = form.getPropertyString();
                if (DebugMode.TRUE_IN_IDE_ELSE_FALSE && !StringUtils.equals((String)varString, (String)(newVarString = this.toURLQuery(form, requestVariables)))) {
                    throw new IOException("FixMe:" + varString + " != " + newVarString);
                }
                String getAction = varString != null && !varString.matches("[\\s]*") ? URLHelper.parseLocation((URL)URLHelper.createURL((String)formAction), (String)("&" + varString)) : formAction;
                return this.createGetRequest(getAction);
            }
            case POST: {
                if (form.getEncoding() == null || !form.getEncoding().toLowerCase().endsWith("form-data")) {
                    return this.createPostRequest(formAction, this.toKeyValueStringEntries(form, requestVariables), form.getEncoding());
                }
                PostFormDataRequest request = this.createPostFormDataRequest(formAction);
                if (form.getEncoding() != null) {
                    request.setEncodeType(form.getEncoding());
                }
                for (FormData variable : requestVariables) {
                    request.addFormData(variable);
                }
                return request;
            }
        }
        throw new IOException("Unsupported method:" + form.getMethod());
    }

    protected String toURLQuery(Form form, List<FormData> requestVariables) throws IOException {
        StringBuilder sb = new StringBuilder();
        block3: for (FormData variable : requestVariables) {
            switch (variable.getType()) {
                case VARIABLE: {
                    if (sb.length() > 0) {
                        sb.append("&");
                    }
                    sb.append(variable.getName());
                    sb.append("=");
                    sb.append(variable.getValue());
                    continue block3;
                }
            }
            if (!DebugMode.TRUE_IN_IDE_ELSE_FALSE) continue;
            throw new IOException("Cannot convert to KeyValueStringEntry:" + variable);
        }
        return sb.toString();
    }

    protected List<KeyValueStringEntry> toKeyValueStringEntries(Form form, List<FormData> requestVariables) throws IOException {
        ArrayList<KeyValueStringEntry> ret = new ArrayList<KeyValueStringEntry>();
        block3: for (FormData variable : requestVariables) {
            switch (variable.getType()) {
                case VARIABLE: {
                    ret.add(new KeyValueStringEntry(variable.getName(), variable.getValue()));
                    continue block3;
                }
            }
            if (!DebugMode.TRUE_IN_IDE_ELSE_FALSE) continue;
            throw new IOException("Cannot convert to KeyValueStringEntry:" + variable);
        }
        return ret;
    }

    public GetRequest createGetRequest(String url) throws IOException {
        return new GetRequest(this.getURL(url));
    }

    public HeadRequest createHeadRequest(String url) throws IOException {
        return new HeadRequest(this.getURL(url));
    }

    public PostFormDataRequest createPostFormDataRequest(String url) throws IOException {
        return new PostFormDataRequest(this.getURL(url));
    }

    @Deprecated
    public PostRequest createPostRequest(String url, List<KeyValueStringEntry> post, String encoding) throws IOException {
        return this.createPostRequest(url, UrlQuery.get(post), encoding);
    }

    public PostRequest createJSonPostRequest(String url, Map<String, Object> postdata) throws IOException {
        return this.createJSonPostRequest(url, JSonStorage.serializeToJson(postdata));
    }

    public PostRequest createJSonPostRequest(String url, String jsonPostString) throws IOException {
        PostRequest request = new PostRequest(this.getURL(url));
        request.setPostDataString(jsonPostString);
        request.setContentType("application/json; charset=UTF-8");
        return request;
    }

    public PostRequest createPostRequest(String url, UrlQuery post, String encoding) throws IOException {
        PostRequest request = new PostRequest(this.getURL(url));
        if (post != null) {
            request.addAll(post.list());
        }
        String requestContentType = encoding;
        RequestHeader lHeaders = this.headers;
        if (lHeaders != null) {
            HTTPHeader contentType = lHeaders.remove("Content-Type");
            if (requestContentType == null && contentType != null) {
                requestContentType = contentType.getValue();
            }
        }
        if (requestContentType == null) {
            requestContentType = "application/x-www-form-urlencoded; charset=UTF-8";
        }
        request.setContentType(requestContentType);
        return request;
    }

    public PostRequest createPostRequest(String url, UrlQuery post) throws IOException {
        return this.createPostRequest(url, post, null);
    }

    public boolean probeJSonContent(String post) {
        return post != null && post.matches("(?s)^\\s*\\{.*?\\}\\s*$");
    }

    public boolean probeJSonContent(byte[] post) {
        return post != null && post.length >= 2 && post[0] == 123 && post[post.length - 1] == 123;
    }

    public PostRequest createPostRequest(String url, String post) throws MalformedURLException, IOException {
        if (this.probeJSonContent(post)) {
            return this.createJSonPostRequest(url, post);
        }
        return this.createPostRequest(url, Request.parseQuery(post), null);
    }

    public String followRedirect() throws IOException {
        return this.followRedirect(false);
    }

    public String followRedirect(boolean followAllRedirects) throws IOException {
        Request lRequest = this.getRequest();
        if (lRequest == null) {
            throw new IllegalStateException("Request is null");
        }
        if (lRequest.getLocation() != null) {
            if (lRequest.getHtmlCode() == null) {
                this.loadConnection(lRequest.getHttpConnection());
            }
            Request redirectRequest = this.createRedirectFollowingRequest(this.request);
            return this.loadConnection(this.openRequestConnection(redirectRequest, followAllRedirects)).getHTMLSource();
        }
        if (lRequest.getHtmlCode() != null) {
            return lRequest.getHTMLSource();
        }
        return this.loadConnection(lRequest.getHttpConnection()).getHTMLSource();
    }

    public Request createRedirectFollowingRequest(Request request) throws IOException {
        Request newRequest;
        if (request == null) {
            throw new IllegalArgumentException("Request is null");
        }
        String location = request.getLocation();
        if (StringUtils.isEmpty((String)location)) {
            throw new IllegalStateException("Request does not contain a redirect");
        }
        URL newURL = this.getURL(location);
        int responseCode = request.getHttpConnection().getResponseCode();
        switch (responseCode) {
            case 200: 
            case 201: {
                if (request instanceof HeadRequest) {
                    newRequest = request.cloneRequest();
                    break;
                }
                newRequest = new GetRequest(request);
                break;
            }
            case 301: {
                if (request instanceof HeadRequest || request instanceof GetRequest) {
                    newRequest = request.cloneRequest();
                    break;
                }
                newRequest = new GetRequest(request);
                break;
            }
            case 302: 
            case 303: {
                if (request instanceof HeadRequest || request instanceof GetRequest) {
                    newRequest = request.cloneRequest();
                    break;
                }
                newRequest = new GetRequest(request);
                break;
            }
            case 307: 
            case 308: {
                newRequest = request.cloneRequest();
                break;
            }
            default: {
                LogInterface logger = this.getLogger();
                if (logger != null && this.isVerbose()) {
                    logger.log((Throwable)new IllegalStateException("ResponseCode " + responseCode + " is unsupported!"));
                }
                return null;
            }
        }
        newRequest.setURL(newURL);
        newRequest.setRedirectOrigin(request);
        return newRequest;
    }

    public Request createRequest(Form form) throws Exception {
        return this.createFormRequest(form);
    }

    public GetRequest createRequest(String downloadURL) throws Exception {
        return this.createGetRequest(downloadURL);
    }

    public void disconnect() {
        try {
            Request request = this.getRequest();
            if (request != null) {
                request.disconnect();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void downloadConnection(File file, URLConnectionAdapter con) throws IOException {
        if (con == null) {
            Browser.download(file, this.getHttpConnection());
        } else {
            Browser.download(file, con);
        }
    }

    public String followConnection(boolean ignoreResponseCode) throws IOException {
        Request request = this.getRequest();
        if (request == null) {
            throw new IllegalStateException("Request is null");
        }
        if (request.getHtmlCode() != null) {
            LogInterface logger = this.getLogger();
            if (logger != null) {
                logger.warning("Request has already been read");
            }
            return request.getHTMLSource();
        }
        URLConnectionAdapter httpConnection = request.getHttpConnection();
        if (httpConnection == null || !httpConnection.isConnected()) {
            LogInterface logger = this.getLogger();
            if (logger != null) {
                logger.warning("Request has already been read");
            }
            return request.toString();
        }
        if (ignoreResponseCode) {
            httpConnection.setAllResponseCodesAllowed(true);
        }
        return this.loadConnection(httpConnection).getHTMLSource();
    }

    public String followConnection() throws IOException {
        return this.followConnection(false);
    }

    public void forwardCookies(Request request) {
        String host;
        Cookies cookies;
        if (request != null && (cookies = this.getCookies(host = Browser.getHost(request.getURL()))) != null) {
            Cookies requestCookies = request.getCookies();
            for (Cookie cookie : cookies.getCookies()) {
                if (cookie.isExpired()) continue;
                requestCookies.add(cookie);
            }
        }
    }

    public String getAcceptLanguage() {
        return this.acceptLanguage;
    }

    public int[] getAllowedResponseCodes() {
        return this.allowedResponseCodes;
    }

    public String getBaseURL() throws MalformedURLException {
        Request lRequest = this.getRequest();
        if (lRequest != null) {
            return URLHelper.getBaseURL((URL)lRequest.getURL());
        }
        return null;
    }

    public int getConnectTimeout() {
        return this.connectTimeout < 0 ? TIMEOUT_CONNECT : this.connectTimeout;
    }

    public String getCookie(String url, String key, String pattern) {
        Cookies cookies = this.getCookies(url);
        Cookie cookie = cookies.get(key, pattern);
        return cookie != null ? cookie.getValue() : null;
    }

    public String getHostCookie(String key, String pattern) {
        return this.getCookie(this.getHost(), key, pattern);
    }

    public String getHostCookie(String key) {
        return this.getHostCookie(key, null);
    }

    public String getCookie(String url, String key) {
        return this.getCookie(url, key, null);
    }

    public HashMap<String, Cookies> getCookies() {
        return this.cookiesExclusive ? this.cookies : COOKIES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cookies getCookies(String url) {
        HashMap<String, Cookies> map;
        String host = Browser.getHost(url);
        HashMap<String, Cookies> hashMap = map = this.getCookies();
        synchronized (hashMap) {
            Cookies cookies = (Cookies)map.get(host);
            if (cookies == null) {
                cookies = new Cookies();
                map.put(host, cookies);
            }
            return cookies;
        }
    }

    @Deprecated
    public Cookies getCookiesWithUserAgent(String url) {
        Cookies cookies = this.getCookies(url);
        String userAgent = null;
        if (this.getRequest() != null && (userAgent = this.getHeaders().getValue("User-Agent")) != null) {
            cookies.setUserAgent(userAgent);
        }
        return cookies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getDownload(File file, String urlString) throws IOException {
        URLConnectionAdapter con = null;
        try {
            con = this.openGetConnection(urlString);
            Browser.download(file, con);
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
    }

    public Form getForm(int i) {
        Form[] forms = this.getForms();
        return forms.length <= i ? null : forms[i];
    }

    public Form getFormbyKey(String key) {
        for (Form f : this.getForms()) {
            if (!f.hasInputFieldByName(key)) continue;
            return f;
        }
        return null;
    }

    public Form getFormByInputFieldKeyValue(String key, String value) {
        for (Form f : this.getForms()) {
            for (InputField field : f.getInputFields()) {
                if (key == null || !key.equals(field.getKey())) continue;
                if (value == null && field.getValue() == null) {
                    return f;
                }
                if (value == null || !value.equals(field.getValue())) continue;
                return f;
            }
        }
        return null;
    }

    public Form getFormByInputFieldPropertyKeyValue(String key, String value) {
        for (Form f : this.getForms()) {
            for (InputField field : f.getInputFields()) {
                if (!field.containsPropertyKeyValue(key, value)) continue;
                return f;
            }
        }
        return null;
    }

    public Form getFormbyProperty(String property, String name) {
        for (Form form : this.getForms()) {
            if (form.getStringProperty(property) == null || !form.getStringProperty(property).equalsIgnoreCase(name)) continue;
            return form;
        }
        return null;
    }

    public final Form getFormbyAction(String action) {
        for (Form form : this.getForms()) {
            if (!action.equalsIgnoreCase(form.getAction())) continue;
            return form;
        }
        return null;
    }

    public final Form getFormbyActionRegex(String regex) {
        if (regex == null) {
            return null;
        }
        for (Form form : this.getForms()) {
            if (form.getAction() == null || !new Regex(form.getAction(), regex).matches()) continue;
            return form;
        }
        return null;
    }

    public Form getFormBySubmitvalue(String name) {
        for (Form form : this.getForms()) {
            try {
                form.setPreferredSubmit(name);
                return form;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        return null;
    }

    public Form[] getForms() {
        return Form.getForms((Object)this);
    }

    public Form[] getFormsByAction(String action) {
        ArrayList<Form> results = new ArrayList<Form>();
        for (Form form : this.getForms()) {
            if (!StringUtils.equalsIgnoreCase((String)form.getAction(), (String)action)) continue;
            results.add(form);
        }
        return results.toArray(new Form[results.size()]);
    }

    public Form[] getFormsByActionRegex(String action) {
        if (action == null) {
            return null;
        }
        ArrayList<Form> results = new ArrayList<Form>();
        for (Form form : this.getForms()) {
            if (form.getAction() == null || !new Regex(form.getAction(), action).matches()) continue;
            results.add(form);
        }
        return results.toArray(new Form[results.size()]);
    }

    public final Form getFormByRegex(String regex) {
        Form[] results = this.getFormsByRegex(regex);
        if (results != null && results.length > 0) {
            return results[0];
        }
        return null;
    }

    public final Form[] getFormsByRegex(String regex) {
        Form[] forms;
        if (regex == null) {
            return null;
        }
        ArrayList<Form> results = new ArrayList<Form>();
        for (Form form : forms = this.getForms()) {
            if (!form.containsHTML(regex)) continue;
            results.add(form);
        }
        return results.toArray(new Form[results.size()]);
    }

    public RequestHeader getHeaders() {
        RequestHeader lHeaders = this.headers;
        if (lHeaders == null) {
            this.headers = lHeaders = new RequestHeader();
        }
        return lHeaders;
    }

    public String getHost() {
        Request lRequest = this.getRequest();
        return lRequest == null ? null : Browser.getHost(lRequest.getURL(), false);
    }

    public String getHost(boolean subdomain) {
        Request lRequest = this.getRequest();
        return lRequest == null ? null : Browser.getHost(lRequest.getURL(), subdomain);
    }

    public URLConnectionAdapter getHttpConnection() {
        Request lRequest = this.getRequest();
        if (lRequest == null) {
            return null;
        }
        return lRequest.getHttpConnection();
    }

    public int getLoadLimit() {
        int ret = this.limit;
        if (ret == -1) {
            return this.getDefaultLoadLimit();
        }
        return ret;
    }

    public LogInterface getLogger() {
        LogInterface llogger = this.logger;
        if (llogger != null) {
            return llogger;
        }
        return LOGGER;
    }

    public String getMatch(String string) {
        return this.getRegex(string).getMatch(0);
    }

    public String getPage(String string) throws IOException {
        return this.getPage(this.createGetRequest(string));
    }

    public String getPage(Request request) throws IOException {
        Request con = this.loadConnection(this.openRequestConnection(request));
        return con.getHTMLSource();
    }

    public String getPage(URL url) throws IOException {
        return this.getPage(url.toString());
    }

    public ProxySelectorInterface getProxy() {
        return this.proxy;
    }

    public int getReadTimeout() {
        return this.readTimeout < 0 ? TIMEOUT_READ : this.readTimeout;
    }

    public String getRedirectLocation() {
        Request lRequest = this.getRequest();
        if (lRequest == null) {
            return null;
        }
        return lRequest.getLocation();
    }

    public Regex getRegex(Pattern compile) {
        return new Regex((Object)this, compile);
    }

    public Regex getRegex(String string) {
        return new Regex((Object)this, string);
    }

    public Request getRequest() {
        return this.request;
    }

    public ProxySelectorInterface getThreadProxy() {
        Thread currentThread = Thread.currentThread();
        if (currentThread != null && currentThread instanceof BrowserSettings) {
            BrowserSettings settings = (BrowserSettings)((Object)currentThread);
            return settings.getProxySelector();
        }
        return null;
    }

    public String getURL() {
        return this.getURL(false);
    }

    public String getURL(boolean withUserInfo) {
        Request lRequest = this.getRequest();
        return lRequest == null ? null : lRequest.getUrl(withUserInfo);
    }

    public URL _getURL() {
        return this._getURL(false);
    }

    public URL _getURL(boolean withUserInfo) {
        Request lRequest = this.getRequest();
        return lRequest == null ? null : lRequest.getURL(withUserInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getURL(String location) throws IOException {
        if (location == null) {
            location = this.getRedirectLocation();
        }
        if (location == null) {
            throw new IllegalArgumentException("location is null");
        }
        try {
            if (location.matches("^(https?|ftp)://.+")) {
                return URLHelper.fixPathTraversal((URL)URLHelper.createURL((String)location.replaceAll(" ", "%20")));
            }
            Request lRequest = this.getRequest();
            if (lRequest == null) {
                throw new IOException("No request available:" + location);
            }
            URL url = URLHelper.createURL((String)URLHelper.parseLocation((URL)lRequest.getURL(), (String)location));
            List<Object[]> list = this.LOCATION_MAP;
            synchronized (list) {
                this.getSourceLocationForURL(null);
                this.LOCATION_MAP.add(new Object[]{new WeakReference<URL>(url), location});
            }
            return url;
        }
        catch (MalformedURLException e) {
            Request lRequest = this.getRequest();
            if (lRequest == null) {
                throw new IOException("No request available:" + location, e);
            }
            URL url = URLHelper.createURL((String)URLHelper.parseLocation((URL)lRequest.getURL(), (String)location));
            List<Object[]> list = this.LOCATION_MAP;
            synchronized (list) {
                this.getSourceLocationForURL(null);
                this.LOCATION_MAP.add(new Object[]{new WeakReference<URL>(url), location});
            }
            return url;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSourceLocationForURL(URL url) {
        String source = null;
        List<Object[]> list = this.LOCATION_MAP;
        synchronized (list) {
            Iterator<Object[]> it = this.LOCATION_MAP.iterator();
            while (it.hasNext()) {
                Object[] next = it.next();
                URL dest = (URL)((Reference)next[0]).get();
                if (dest == null) {
                    it.remove();
                    continue;
                }
                if (dest != url) continue;
                source = (String)next[1];
            }
        }
        return source;
    }

    public boolean isCookiesExclusive() {
        return this.cookiesExclusive;
    }

    public boolean isDebug() {
        return this.debug || this.isVerbose();
    }

    public boolean isFollowingRedirects() {
        return this.doRedirects;
    }

    public boolean isKeepResponseContentBytes() {
        return this.keepResponseContentBytes;
    }

    public boolean isVerbose() {
        return VERBOSE || this.verbose;
    }

    public Request loadConnection(URLConnectionAdapter connection) throws IOException {
        Request requ = connection == null ? this.getRequest() : (connection.getRequest() != null ? connection.getRequest() : new Request(connection){

            @Override
            public long postRequest() throws IOException {
                return 0L;
            }

            @Override
            public void preRequest() throws IOException {
            }
        });
        try {
            Object llogger;
            if (requ == null) {
                throw new IOException("No request available");
            }
            this.checkContentLengthLimit(requ);
            this.prepareBlockDetectionBeforeLoadConnection(requ);
            requ.read(this.isKeepResponseContentBytes());
            if (this.isVerbose() && requ != null && (llogger = this.getLogger()) != null) {
                llogger.finest("\r\nBrowserID:" + requ.getBrowserID() + "|RequestID:" + requ.getRequestID() + "|URL:" + requ.getURL() + "\r\n----------------Request Content-------------\r\n" + requ.getHTMLSource() + "\r\n");
            }
            this.checkForBlockedByAfterLoadConnection(requ);
            llogger = requ;
            return llogger;
        }
        catch (BrowserException e) {
            throw e;
        }
        catch (IOException e) {
            throw new BrowserException(null, requ, e);
        }
        finally {
            if (requ != null) {
                requ.disconnect();
            }
        }
    }

    protected void mergeHeaders(Request request) {
        RequestHeader lHeaders = this.headers;
        if (request != null && lHeaders != null) {
            RequestHeader requestHeaders = request.getHeaders();
            if (lHeaders.isDominant()) {
                requestHeaders.clear();
            }
            requestHeaders.putAll(lHeaders);
        }
    }

    protected void autoCompleteHeaders(Request request) {
        RequestHeader requestHeaders;
        if (request != null && (requestHeaders = request.getHeaders()).getValue("Sec-Fetch-Site") == null) {
            String edgeVersionString;
            int edgeVersion;
            String operaVersionString;
            int operaVersion;
            String chromeVersionString;
            int chromeVersion;
            int firefoxVersion;
            boolean addSecFetchSite = false;
            String firefoxVersionString = new Regex(requestHeaders.getValue("User-Agent"), "FireFox/(\\d+)").getMatch(0);
            int n = firefoxVersion = firefoxVersionString != null ? Integer.parseInt(firefoxVersionString) : -1;
            if (firefoxVersion >= 90) {
                addSecFetchSite = true;
            }
            int n2 = chromeVersion = (chromeVersionString = new Regex(requestHeaders.getValue("User-Agent"), "Chrome/(\\d+)").getMatch(0)) != null ? Integer.parseInt(chromeVersionString) : -1;
            if (chromeVersion >= 76) {
                addSecFetchSite = true;
            }
            int n3 = operaVersion = (operaVersionString = new Regex(requestHeaders.getValue("User-Agent"), "OPR/(\\d+)").getMatch(0)) != null ? Integer.parseInt(operaVersionString) : -1;
            if (operaVersion >= 63) {
                addSecFetchSite = true;
            }
            int n4 = edgeVersion = (edgeVersionString = new Regex(requestHeaders.getValue("User-Agent"), "Edg/(\\d+)").getMatch(0)) != null ? Integer.parseInt(edgeVersionString) : -1;
            if (edgeVersion >= 79) {
                addSecFetchSite = true;
            }
            if (addSecFetchSite) {
                requestHeaders.put(new HTTPHeader("Sec-Fetch-Site", "same-origin"));
            }
        }
    }

    public URLConnectionAdapter openFormConnection(Form form) throws Exception {
        return this.openRequestConnection(this.createFormRequest(form));
    }

    public URLConnectionAdapter openGetConnection(String string) throws IOException {
        return this.openRequestConnection(this.createGetRequest(string));
    }

    public URLConnectionAdapter openHeadConnection(String string) throws IOException {
        return this.openRequestConnection(this.createHeadRequest(string));
    }

    @Deprecated
    public URLConnectionAdapter openPostConnection(String url, LinkedHashMap<String, String> post) throws IOException {
        return this.openPostConnection(url, UrlQuery.get(post));
    }

    @Deprecated
    public URLConnectionAdapter openPostConnection(String url, String post) throws IOException {
        return this.openRequestConnection(this.createPostRequest(url, post));
    }

    public URLConnectionAdapter openPostConnection(String url, UrlQuery query) throws IOException {
        return this.openRequestConnection(this.createPostRequest(url, query));
    }

    protected void setRequestProperties(Request sourceRequest, Request nextRequest, String refererURL) {
        if (nextRequest != null) {
            nextRequest.setSSLSocketStreamOptions(this.getSSLSocketStreamOptions());
            if (nextRequest.isSSLTrustALLSet() == null) {
                nextRequest.setSSLTrustALL(this.getDefaultSSLTrustALL());
            }
            this.forwardCookies(nextRequest);
            if (nextRequest.getCustomCharset() == null) {
                nextRequest.setCustomCharset(this.customCharset);
            }
            if (!nextRequest.getHeaders().contains("Accept-Language")) {
                nextRequest.getHeaders().put("Accept-Language", this.getAcceptLanguage());
            }
            nextRequest.setConnectTimeout(this.getConnectTimeout());
            nextRequest.setReadTimeout(this.getReadTimeout());
            boolean allowRefererURL = sourceRequest != null && StringUtils.startsWithCaseInsensitive((String)sourceRequest.getURL().getProtocol(), (String)"https") ? StringUtils.startsWithCaseInsensitive((String)nextRequest.getURL().getProtocol(), (String)"https") : true;
            if (allowRefererURL && refererURL != null && !nextRequest.getHeaders().contains("Referer")) {
                nextRequest.getHeaders().put("Referer", refererURL);
            }
            this.mergeHeaders(nextRequest);
            this.autoCompleteHeaders(nextRequest);
        }
    }

    public URLConnectionAdapter openRequestConnection(Request request) throws IOException {
        return this.openRequestConnection(request, this.isFollowingRedirects());
    }

    public static AuthenticationFactory getDefaultAuthenticationFactory() {
        return DEFAULTAUTHENTICATIONFACTORY;
    }

    public static void setDefaultAuthenticationFactory(AuthenticationFactory authenticationFactory) {
        DEFAULTAUTHENTICATIONFACTORY = authenticationFactory;
    }

    public AuthenticationFactory getCustomAuthenticationFactory() {
        return this.authenticationFactory;
    }

    public AuthenticationFactory getAuthenticationFactory() {
        AuthenticationFactory ret = this.getCustomAuthenticationFactory();
        if (ret != null) {
            return ret;
        }
        return Browser.getDefaultAuthenticationFactory();
    }

    public void setCustomAuthenticationFactory(AuthenticationFactory authenticationFactory) {
        this.authenticationFactory = authenticationFactory;
    }

    public void clearAuthentications() {
        this.authentications.clear();
    }

    public synchronized long getBrowserID() {
        if (this.browserID == -1L) {
            this.browserID = BROWSERIDS.incrementAndGet();
        }
        return this.browserID;
    }

    public long getBrowserParentID() {
        return this.browserParentID;
    }

    protected long getNextRequestID() {
        return this.requestID.incrementAndGet();
    }

    public boolean addAuthentication(Authentication authentication) {
        if (authentication != null) {
            return this.authentications.addIfAbsent(authentication);
        }
        return false;
    }

    public boolean removeAuthentication(Authentication authentication) {
        return authentication != null && this.authentications.remove(authentication);
    }

    public List<Authentication> getAuthentications() {
        return this.authentications;
    }

    protected Authentication applyAuthentication(Request request) throws IOException {
        Authentication authentication = request.getAuthentication();
        if (authentication == null) {
            Authentication authenticationByFactory;
            AuthenticationFactory authenticationFactory = this.getAuthenticationFactory();
            if (authenticationFactory != null && (authenticationByFactory = authenticationFactory.authorize(this, request)) != null) {
                request.setAuthentication(authenticationByFactory);
                return authenticationByFactory;
            }
            for (Authentication browserAuthentication : this.getAuthentications()) {
                if (!browserAuthentication.authorize(this, request)) continue;
                request.setAuthentication(browserAuthentication);
                return browserAuthentication;
            }
        } else if (authentication.authorize(this, request)) {
            return authentication;
        }
        return null;
    }

    protected boolean retryAuthentication(Request request) throws IOException {
        Authentication requestAuthentication = request.getAuthentication();
        AuthenticationFactory authenticationFactory = this.getAuthenticationFactory();
        if (requestAuthentication != null) {
            if (authenticationFactory != null) {
                return authenticationFactory.retry(requestAuthentication, this, request);
            }
            return requestAuthentication.retry(this, request);
        }
        if (requestAuthentication == null && authenticationFactory != null) {
            Authentication authentication = authenticationFactory.buildAuthentication(this, request);
            if (authentication != null) {
                request.setAuthentication(authentication);
            }
            return authentication != null;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URLConnectionAdapter openRequestConnection(Request request, boolean followRedirects) throws IOException {
        if (request == null) {
            throw new IllegalStateException("Request is null");
        }
        int redirectLoopPrevention = 0;
        Request originalRequest = request;
        String refererURL = this.getRefererURL(originalRequest);
        while (true) {
            this.setRequestProperties(originalRequest, request, refererURL);
            int connectRetryCounter = 0;
            while (true) {
                LogInterface llogger;
                try {
                    block25: {
                        URLConnectionAdapter connection;
                        while (true) {
                            try {
                                Browser.waitForPageAccess(this, request);
                            }
                            catch (InterruptedException e) {
                                throw new BrowserException("requestIntervalTime Exception", request, e);
                            }
                            try {
                                if (request.getProxy() == null) {
                                    List<HTTPProxy> proxies = this.selectProxies(request.getURL());
                                    request.setProxy(proxies.get(0));
                                }
                                this.applyAuthentication(request);
                                this.onBeforeRequestConnect(request);
                                connection = request.connect(this).getHttpConnection();
                                this.onAfterRequestConnect(request);
                                this.checkForBlockedByBeforeLoadConnection(request);
                            }
                            finally {
                                this.updateCookies(request);
                                if (this.isDebug() && (llogger = this.getLogger()) != null) {
                                    try {
                                        llogger.finest("\r\n" + request.printHeaders());
                                    }
                                    catch (Throwable e) {
                                        llogger.log(e);
                                    }
                                }
                            }
                            if (connection == null) break block25;
                            if (!this.retryAuthentication(request)) break;
                            this.loadConnection(connection);
                            request.resetConnection();
                        }
                        connection.setAllowedResponseCodes(this.getAllowedResponseCodes());
                        if (connection.getResponseCode() == 407) {
                            throw new ProxyAuthException(request.getProxy());
                        }
                        break;
                    }
                    throw new BrowserException("connection is null", request, null);
                }
                catch (BrowserException e) {
                    request.disconnect();
                    throw e;
                }
                catch (IOException e) {
                    request.disconnect();
                    llogger = this.getLogger();
                    if (llogger != null) {
                        llogger.log((Throwable)e);
                    }
                    if (this.reportConnectException(++connectRetryCounter, e, request) || e instanceof ProxyAuthException && this.updateProxy(connectRetryCounter, request)) {
                        if (llogger != null) {
                            llogger.info("Retry openRequestConnection(" + request.getUrl() + "):" + connectRetryCounter);
                        }
                        request.setProxy((ClonedProxy)null);
                        continue;
                    }
                    throw new BrowserException(null, request, e);
                }
                break;
            }
            String redirect = request.getLocation();
            if (!followRedirects || redirect == null) break;
            if (redirectLoopPrevention++ > 20) {
                request.disconnect();
                throw new BrowserException("Too many redirects!", originalRequest, null);
            }
            this.loadConnection(request.getHttpConnection());
            Request redirectRequest = this.createRedirectFollowingRequest(request);
            this.setRequest(request);
            if (redirectRequest == null) {
                return request.getHttpConnection();
            }
            request = redirectRequest;
        }
        this.setRequest(request);
        return request.getHttpConnection();
    }

    protected void onAfterRequestConnect(Request request) throws IOException {
    }

    protected void onBeforeRequestConnect(Request request) throws IOException {
    }

    private boolean reportConnectException(int proxyRetryCounter, IOException e, Request request) {
        ProxySelectorInterface selector = this.proxy != null ? this.proxy : GLOBAL_PROXY;
        return selector != null && selector.reportConnectException(request, proxyRetryCounter, e);
    }

    @Deprecated
    public String postPage(String url, LinkedHashMap<String, String> post) throws IOException {
        return this.postPage(url, UrlQuery.get(post));
    }

    @Deprecated
    public String postPage(String url, String post) throws IOException {
        PostRequest postRequest = this.createPostRequest(url, post);
        return this.getPage(postRequest);
    }

    public String postPage(String url, UrlQuery queryInfo) throws IOException {
        return this.getPage(this.createPostRequest(url, queryInfo));
    }

    public String postPageRaw(String url, byte[] post) throws IOException {
        PostRequest postRequest;
        if (this.probeJSonContent(post)) {
            postRequest = this.createJSonPostRequest(url, new String(post, "UTF-8"));
        } else {
            postRequest = this.createPostRequest(url, new ArrayList<KeyValueStringEntry>(), null);
            postRequest.setPostBytes(post);
        }
        return this.getPage(postRequest);
    }

    public String postPageRaw(String url, String post) throws IOException {
        PostRequest postRequest;
        if (this.probeJSonContent(post)) {
            postRequest = this.createJSonPostRequest(url, post);
        } else {
            postRequest = this.createPostRequest(url, new UrlQuery(), null);
            postRequest.setPostDataString(post);
        }
        return this.getPage(postRequest);
    }

    public List<HTTPProxy> selectProxies(URL url) throws IOException {
        List<HTTPProxy> list;
        ProxySelectorInterface selector = this.proxy != null ? this.proxy : GLOBAL_PROXY;
        if (selector == null) {
            ArrayList<HTTPProxy> ret = new ArrayList<HTTPProxy>();
            ret.add(HTTPProxy.NONE);
            return ret;
        }
        try {
            list = selector.getProxiesByURL(url);
        }
        catch (Throwable e) {
            throw new NoGateWayException(selector, "ProxySelector failed: " + url + "|Selector:" + selector, e);
        }
        if (list == null || list.size() == 0) {
            throw new NoGateWayException(selector, "No Gateway or Proxy Found: " + url + "|Selector:" + selector);
        }
        return list;
    }

    public void setAcceptLanguage(String acceptLanguage) {
        this.acceptLanguage = acceptLanguage;
    }

    public void setAllowedResponseCodes(int ... allowedResponseCodes) {
        this.allowedResponseCodes = allowedResponseCodes;
    }

    public boolean hasAllowedResponseCode(int input) {
        int[] original;
        for (int a : original = this.getAllowedResponseCodes()) {
            if (a != input) continue;
            return true;
        }
        return false;
    }

    public void addAllowedResponseCodes(int ... allowResponseCodes) {
        int[] outcome = Browser.buildAllowedResponseCodes(this.getAllowedResponseCodes(), allowResponseCodes);
        this.setAllowedResponseCodes(outcome);
    }

    protected static int[] buildAllowedResponseCodes(int[] allowedResponseCodes, int ... allowResponseCodes) {
        HashSet<Integer> dupe = new HashSet<Integer>();
        if (allowedResponseCodes != null) {
            for (int a : allowedResponseCodes) {
                dupe.add(a);
            }
        }
        for (int a : allowResponseCodes) {
            dupe.add(a);
        }
        int[] outcome = new int[dupe.size()];
        int index = 0;
        for (Integer i : dupe) {
            outcome[index++] = i;
        }
        return outcome;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setCookie(String url, String key, String value) {
        Cookies cookies = this.getCookies(url);
        cookies.add(new Cookie(Browser.getHost(url), key, value));
    }

    public void setCookie(Cookie cookie) {
        Cookies cookies = this.getCookies(cookie.getHost());
        cookies.add(cookie);
    }

    public void setCookies(String url, Cookies iCookies) {
        this.setCookies(url, iCookies, false);
        String userAgent = iCookies.getUserAgent();
        if (!StringUtils.isEmpty((String)userAgent)) {
            this.getHeaders().put("User-Agent", userAgent);
        }
    }

    public void setCookies(Cookies iCookies) {
        this.setCookies(null, iCookies, false);
        String userAgent = iCookies.getUserAgent();
        if (!StringUtils.isEmpty((String)userAgent)) {
            this.getHeaders().put("User-Agent", userAgent);
        }
    }

    public void setCookies(String url, Cookies iCookies, boolean replace) {
        if (url == null) {
            if (replace) {
                this.clearCookies(null);
            }
            List<Cookie> cookieArray = iCookies.getCookies();
            for (Cookie cookie : cookieArray) {
                this.setCookie(cookie);
            }
        } else {
            Cookies cookies = this.getCookies(url);
            if (replace) {
                cookies.clear();
                cookies.add(iCookies);
            } else {
                cookies.add(iCookies);
            }
        }
    }

    public boolean setCookiesExclusive(boolean b) {
        if (this.cookiesExclusive == b) {
            return false;
        }
        if (b) {
            this.cookies.clear();
            for (Map.Entry<String, Cookies> next : COOKIES.entrySet()) {
                Cookies tmp = new Cookies();
                this.cookies.put(next.getKey(), tmp);
                tmp.add(next.getValue());
            }
        } else {
            this.cookies.clear();
        }
        this.cookiesExclusive = b;
        return true;
    }

    public void setCurrentURL(String url) throws MalformedURLException {
        this.currentURL = url == null ? null : (StringUtils.isEmpty((String)url) ? "" : url);
    }

    private String getRefererURL(Request request) {
        String refererURLHeader;
        HTTPHeader referer = this.getHeaders().remove("Referer");
        String string = refererURLHeader = referer != null ? referer.getValue() : null;
        if (refererURLHeader == null) {
            Object lCurrentURL = this.currentURL;
            if (lCurrentURL != null && lCurrentURL instanceof String) {
                return (String)lCurrentURL;
            }
            if (lCurrentURL != null && lCurrentURL instanceof Request) {
                return ((Request)lCurrentURL).getUrl();
            }
            return this.getURL();
        }
        return refererURLHeader;
    }

    public void setCustomCharset(String charset) {
        this.customCharset = charset;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setFollowRedirects(boolean b) {
        this.doRedirects = b;
    }

    public void setHeader(String field, String value) {
        this.getHeaders().put(field, value);
    }

    public void setHeaders(RequestHeader h) {
        this.headers = h;
    }

    public void setKeepResponseContentBytes(boolean keepResponseContentBytes) {
        this.keepResponseContentBytes = keepResponseContentBytes;
    }

    public void setLoadLimit(int i) {
        this.limit = Math.max(-1, i);
    }

    public void setLogger(LogInterface logger) {
        this.logger = logger;
    }

    @Deprecated
    public void setProxy(HTTPProxy proxy2) {
        this.setProxySelector(new StaticProxySelector(proxy2));
    }

    @Deprecated
    public void setProxy(ProxySelectorInterface threadProxy) {
        this.setProxySelector(threadProxy);
    }

    public void setProxySelector(ProxySelectorInterface proxy) {
        LogInterface llogger;
        ProxySelectorInterface wished = proxy;
        if (proxy == null) {
            proxy = this.getThreadProxy();
        }
        if (proxy == this.proxy) {
            return;
        }
        this.proxy = proxy;
        if (this.isDebug() && (llogger = this.getLogger()) != null) {
            llogger.info("Use local proxy: " + proxy + " wished: " + wished);
        }
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setRequest(Request request) {
        this.currentURL = request == null ? null : request.getUrl();
        this.updateCookies(request);
        this.request = request;
    }

    public void setVerbose(boolean b) {
        this.verbose = b;
    }

    public String submitForm(Form form) throws IOException {
        return this.getPage(this.createFormRequest(form));
    }

    public String toString() {
        Request lRequest = this.getRequest();
        if (lRequest == null) {
            return "Browser. No request yet";
        }
        return lRequest.getHTMLSource();
    }

    public void updateCookies(Request request) {
        if (request != null && request.hasCookies()) {
            Cookies cookies = this.getCookies(Browser.getHost(request.getURL()));
            cookies.add(request.getCookies());
        }
    }

    protected boolean updateProxy(int proxyRetryCounter, Request request) {
        HTTPProxy proxy;
        HTTPProxy hTTPProxy = proxy = request != null ? request.getProxy() : null;
        if (proxy != null) {
            switch (proxy.getType()) {
                case SOCKS5: {
                    if (proxyRetryCounter <= 2) {
                        try {
                            Thread.sleep(5000 * Math.max(1, proxyRetryCounter));
                        }
                        catch (InterruptedException e) {
                            return false;
                        }
                    }
                    return true;
                }
            }
        }
        ProxySelectorInterface selector = this.proxy != null ? this.proxy : GLOBAL_PROXY;
        return selector != null && selector.updateProxy(request, proxyRetryCounter);
    }

    public void checkForBlockedByBeforeLoadConnection(Request request) throws IOException {
        BlockedTypeInterface blockedType;
        if (this.getThrowExceptionOnBlockedBy(request) && (blockedType = this.getBlockedType(request)) != null) {
            throw new BlockedByException(request, blockedType);
        }
    }

    protected void prepareBlockDetectionBeforeLoadConnection(Request request) throws IOException {
        block2: {
            List<BlockedTypeInterface> blockedTypeInterfaces;
            if (!this.getThrowExceptionOnBlockedBy(request)) break block2;
            List<BlockedTypeInterface> list = blockedTypeInterfaces = request != null ? this.getBlockedTypeInterfaces() : null;
            if (blockedTypeInterfaces != null) {
                for (BlockedTypeInterface blockedTypeInterface : blockedTypeInterfaces) {
                    if (Boolean.TRUE.equals(blockedTypeInterface.prepareBlockDetection(this, request))) break;
                }
            }
        }
    }

    public void checkForBlockedByAfterLoadConnection(Request request) throws IOException {
        BlockedTypeInterface blockedType;
        if (this.getThrowExceptionOnBlockedBy(request) && (blockedType = this.getBlockedType(request)) != null) {
            throw new BlockedByException(request, blockedType);
        }
    }

    protected static CloudflareBlockedType getCloudflareBlock(Browser browser, Request request) {
        boolean isTypicalCloudflareResponseCode;
        URLConnectionAdapter con;
        if (request == null || !request.isLoaded() || (con = request.getHttpConnection()) == null) {
            return null;
        }
        boolean isCloudflareServer = StringUtils.containsIgnoreCase((String)request.getResponseHeader("Server"), (String)"cloudflare");
        boolean bl = isTypicalCloudflareResponseCode = con.getResponseCode() == 403 || con.getResponseCode() == 502 || con.getResponseCode() == 503 || con.getResponseCode() == 429 || con.getResponseCode() == 522 || con.getResponseCode() == 523;
        if (isCloudflareServer && isTypicalCloudflareResponseCode) {
            boolean isCloudflareOtherHTML;
            boolean isCloudflareChallengeHTML = request.containsHTML("(?i)<title>\\s*Attention Required!(\\s*\\| Cloudflare)?\\s*</title>") || request.containsHTML("data-translate=\"challenge_headline\"") || request.containsHTML("<title>\\s*Just a moment\\.*\\s*</title>") && request.containsHTML("<form id\\s*=\\s*\"challenge-form\"");
            boolean bl2 = isCloudflareOtherHTML = request.containsHTML("(?i)<title>\\s*Access denied\\s*\\| [^<]* used Cloudflare to restrict access\\s*</title>") || request.containsHTML("class\\s*=\\s*\"(ray-id|cf-error-title)\"") || request.containsHTML("(class|id)\\s*=\\s*\"cf-error-details\"") || request.containsHTML("window\\._cf_chl_opt");
            if (isCloudflareChallengeHTML || isCloudflareOtherHTML) {
                String errorCode = request.getRegex("<span class\\s*=\\s*\"(?:cf-)?code-label\"\\s*>\\s*Error code\\s*(?:<span>)?(\\d+)(?:</span>)?\\s*</span>").getMatch(0);
                if (errorCode == null && (errorCode = request.getRegex("cloudflare\\.com[^\"]*\\?utm_source=(\\d+)_error").getMatch(0)) == null && (errorCode = request.getRegex("cloudflare\\.com[^\"]*\\?utm_source=errorcode_(\\d+)").getMatch(0)) == null) {
                    errorCode = request.getRegex("(?i)<p>Error code\\s*:\\s*(\\d+)</p>").getMatch(0);
                }
                String errorText = request.getRegex("<h1[^>]*>\\s*(.*?)\\s*</h1>").getMatch(0);
                browser.getLogger().info("Cloudflare parsed errormessage: " + errorText);
                if (errorCode != null) {
                    if (errorCode.matches("5\\d{2}")) {
                        return CloudflareBlockedType.CLOUDFLARE_SITE_OFFLINE;
                    }
                    if ("1020".equals(errorCode)) {
                        return CloudflareBlockedType.CLOUDFLARE_IP_BLOCK;
                    }
                }
                return CloudflareBlockedType.CLOUDFLARE_SITE;
            }
        }
        return null;
    }

    protected static Boolean prepareCloudflareBlockDetection(Browser browser, Request request) {
        URLConnectionAdapter con;
        if (request == null || !request.isRequested() || (con = request.getHttpConnection()) == null) {
            return null;
        }
        boolean isCloudflareServer = StringUtils.containsIgnoreCase((String)request.getResponseHeader("Server"), (String)"cloudflare");
        if (isCloudflareServer && !con.isOK()) {
            con.setAllowedResponseCodes(Browser.buildAllowedResponseCodes(con.getAllowedResponseCodes(), con.getResponseCode()));
            return Boolean.TRUE;
        }
        return null;
    }

    public BlockedTypeInterface getBlockedType(Request request) {
        List<BlockedTypeInterface> blockedTypeInterfaces;
        List<BlockedTypeInterface> list = blockedTypeInterfaces = request != null ? this.getBlockedTypeInterfaces() : null;
        if (blockedTypeInterfaces != null) {
            for (BlockedTypeInterface blockedTypeInterface : blockedTypeInterfaces) {
                BlockedTypeInterface block = blockedTypeInterface.isBlocked(this, request);
                if (block == null) continue;
                return block;
            }
        }
        return null;
    }

    public boolean isBlocked() {
        Request request = this.getRequest();
        return request != null && this.getBlockedType(request) != null;
    }

    public Boolean getDefaultSSLTrustALL() {
        return this.defaultSSLTrustALL;
    }

    public void setDefaultSSLTrustALL(Boolean defaultSSLTrustALL) {
        this.defaultSSLTrustALL = defaultSSLTrustALL;
    }

    public static enum GenericSupportedBlockTypes implements LabelInterface,
    BlockedTypeInterface
    {
        CLOUDFLARE{

            @Override
            public String getLabel() {
                return "Cloudflare";
            }

            @Override
            public BlockedTypeInterface isBlocked(Browser browser, Request request) {
                return Browser.getCloudflareBlock(browser, request);
            }

            @Override
            public BlockLevelType getBlockLevelType() {
                return BlockLevelType.SITE;
            }

            @Override
            public BlockSourceType getBlockSourceType() {
                return BlockSourceType.SERVICE;
            }

            @Override
            public Boolean prepareBlockDetection(Browser browser, Request request) {
                return Browser.prepareCloudflareBlockDetection(browser, request);
            }
        }
        ,
        DDOS_GUARD{

            @Override
            public String getLabel() {
                return "DDoS-GUARD";
            }

            @Override
            public BlockedTypeInterface isBlocked(Browser browser, Request request) {
                URLConnectionAdapter con;
                if (request == null || !request.isLoaded() || (con = request.getHttpConnection()) == null) {
                    return null;
                }
                if (con.getResponseCode() == 403 && StringUtils.containsIgnoreCase((String)request.getResponseHeader("Server"), (String)"ddos-guard") && (request.containsHTML("<title>\\s*DDoS-Guard\\s*</title>") || request.containsHTML("link\\s*=\\s*\"https?://ddos-guard\\.net/"))) {
                    return this;
                }
                return null;
            }

            @Override
            public BlockLevelType getBlockLevelType() {
                return BlockLevelType.SITE;
            }

            @Override
            public BlockSourceType getBlockSourceType() {
                return BlockSourceType.SERVICE;
            }

            @Override
            public Boolean prepareBlockDetection(Browser browser, Request request) {
                return null;
            }
        }
        ,
        DNSPROXY_ORG{

            @Override
            public String getLabel() {
                return "DNSProxy.org";
            }

            @Override
            public BlockedTypeInterface isBlocked(Browser browser, Request request) {
                if (request == null || !request.isLoaded() || request.getHttpConnection() == null) {
                    return null;
                }
                if (request.containsHTML("<title>Browser Check - DNSProxy\\.org</title>") && request.containsHTML("DNSProxy\\.org\\. All rights reserved\\.?<")) {
                    return this;
                }
                return null;
            }

            @Override
            public BlockLevelType getBlockLevelType() {
                return BlockLevelType.SITE;
            }

            @Override
            public BlockSourceType getBlockSourceType() {
                return BlockSourceType.SERVICE;
            }

            @Override
            public Boolean prepareBlockDetection(Browser browser, Request request) {
                return null;
            }
        }
        ,
        DNS_BLOCK_CUII{

            @Override
            public String getLabel() {
                return "DNS block by cuii.info";
            }

            @Override
            public BlockedTypeInterface isBlocked(Browser browser, Request request) {
                if (request == null || !request.isRequested()) {
                    return null;
                }
                String regex = "^(?i).+\\.cuii\\.info";
                if (request.getURL().getHost().matches("^(?i).+\\.cuii\\.info")) {
                    for (Request redirectOrigin = request.getRedirectOrigin(); redirectOrigin != null; redirectOrigin = redirectOrigin.getRedirectOrigin()) {
                        if (redirectOrigin.getURL().getHost().matches("^(?i).+\\.cuii\\.info")) continue;
                        return this;
                    }
                }
                return null;
            }

            @Override
            public BlockLevelType getBlockLevelType() {
                return BlockLevelType.DNS;
            }

            @Override
            public BlockSourceType getBlockSourceType() {
                return BlockSourceType.ISP;
            }

            @Override
            public Boolean prepareBlockDetection(Browser browser, Request request) {
                return null;
            }
        }
        ,
        SHIELD_SQUARE{

            @Override
            public String getLabel() {
                return "ShieldSquare";
            }

            @Override
            public BlockedTypeInterface isBlocked(Browser browser, Request request) {
                URLConnectionAdapter con;
                if (request == null || !request.isLoaded() || (con = request.getHttpConnection()) == null) {
                    return null;
                }
                if (con.getResponseCode() == 200 && request.containsHTML("(?i)<title>\\s*ShieldSquare Captcha\\s*</title>")) {
                    return this;
                }
                return null;
            }

            @Override
            public BlockLevelType getBlockLevelType() {
                return BlockLevelType.SITE;
            }

            @Override
            public BlockSourceType getBlockSourceType() {
                return BlockSourceType.SERVICE;
            }

            @Override
            public Boolean prepareBlockDetection(Browser browser, Request request) {
                return null;
            }
        }
        ,
        CLOUDFILT{

            @Override
            public String getLabel() {
                return "CloudFilt";
            }

            @Override
            public BlockedTypeInterface isBlocked(Browser browser, Request request) {
                URLConnectionAdapter con;
                if (request == null || !request.isLoaded() || (con = request.getHttpConnection()) == null) {
                    return null;
                }
                if (con.getResponseCode() == 200 && browser.getURL().contains("cloudfilt.com/stop-")) {
                    return this;
                }
                return null;
            }

            @Override
            public BlockLevelType getBlockLevelType() {
                return BlockLevelType.SITE;
            }

            @Override
            public BlockSourceType getBlockSourceType() {
                return BlockSourceType.SERVICE;
            }

            @Override
            public Boolean prepareBlockDetection(Browser browser, Request request) {
                return null;
            }
        }
        ,
        NETWORK_SECURITY_WIREFILTER{

            @Override
            public String getLabel() {
                return "WireFilter";
            }

            @Override
            public BlockedTypeInterface isBlocked(Browser browser, Request request) {
                URLConnectionAdapter con;
                if (request == null || !request.isRequested() || (con = request.getHttpConnection()) == null) {
                    return null;
                }
                if (con.getResponseCode() == 403 && StringUtils.containsIgnoreCase((String)request.getResponseHeader("Server"), (String)"Protected by WireFilter")) {
                    return this;
                }
                return null;
            }

            @Override
            public BlockLevelType getBlockLevelType() {
                return BlockLevelType.SITE;
            }

            @Override
            public BlockSourceType getBlockSourceType() {
                return BlockSourceType.SOFTWARE;
            }

            @Override
            public Boolean prepareBlockDetection(Browser browser, Request request) {
                return null;
            }
        }
        ,
        NETWORK_SECURITY_ZSCALER{

            @Override
            public String getLabel() {
                return "Zscaler";
            }

            @Override
            public BlockedTypeInterface isBlocked(Browser browser, Request request) {
                URLConnectionAdapter con;
                if (request == null || !request.isRequested() || (con = request.getHttpConnection()) == null) {
                    return null;
                }
                if (con.getResponseCode() == 403 && StringUtils.containsIgnoreCase((String)request.getResponseHeader("Server"), (String)"Zscaler/")) {
                    return this;
                }
                return null;
            }

            @Override
            public BlockLevelType getBlockLevelType() {
                return BlockLevelType.SITE;
            }

            @Override
            public BlockSourceType getBlockSourceType() {
                return BlockSourceType.SOFTWARE;
            }

            @Override
            public Boolean prepareBlockDetection(Browser browser, Request request) {
                return null;
            }
        }
        ,
        NETWORK_SECURITY_SUCURI{

            @Override
            public String getLabel() {
                return "Sucuri.net Website Firewall";
            }

            @Override
            public BlockedTypeInterface isBlocked(Browser browser, Request request) {
                URLConnectionAdapter con;
                if (request == null || !request.isRequested() || (con = request.getHttpConnection()) == null) {
                    return null;
                }
                if (con.getResponseCode() == 403 && request.getResponseHeader("X-Sucuri-Block") != null && request.getHtmlCode() != null && request.getHtmlCode().contains("sucuri.net")) {
                    return this;
                }
                return null;
            }

            @Override
            public BlockLevelType getBlockLevelType() {
                return BlockLevelType.SITE;
            }

            @Override
            public BlockSourceType getBlockSourceType() {
                return BlockSourceType.SERVICE;
            }

            @Override
            public Boolean prepareBlockDetection(Browser browser, Request request) {
                return null;
            }
        }
        ,
        FIREWALL_BITDEFENDER{

            @Override
            public String getLabel() {
                return "Firewall Bitdefender";
            }

            @Override
            public BlockedTypeInterface isBlocked(Browser browser, Request request) {
                URLConnectionAdapter con;
                if (request == null || !request.isRequested() || (con = request.getHttpConnection()) == null) {
                    return null;
                }
                if (con.getResponseCode() == 403 && StringUtils.containsIgnoreCase((String)con.getResponseMessage(), (String)"Blocked by Bitdefender")) {
                    return this;
                }
                return null;
            }

            @Override
            public BlockLevelType getBlockLevelType() {
                return BlockLevelType.SITE;
            }

            @Override
            public BlockSourceType getBlockSourceType() {
                return BlockSourceType.SOFTWARE;
            }

            @Override
            public Boolean prepareBlockDetection(Browser browser, Request request) {
                return null;
            }
        }
        ,
        FIREWALL_ESET_NOD32{

            @Override
            public String getLabel() {
                return "Firewall ESET NOD32";
            }

            @Override
            public BlockedTypeInterface isBlocked(Browser browser, Request request) {
                if (request == null || !request.isLoaded() || request.getHttpConnection() == null) {
                    return null;
                }
                return null;
            }

            @Override
            public BlockLevelType getBlockLevelType() {
                return BlockLevelType.SITE;
            }

            @Override
            public BlockSourceType getBlockSourceType() {
                return BlockSourceType.SOFTWARE;
            }

            @Override
            public Boolean prepareBlockDetection(Browser browser, Request request) {
                return null;
            }
        }
        ,
        FIREWALL_ESET_INTERNET_SECURITY{

            @Override
            public String getLabel() {
                return "Firewall ESET Internet Security";
            }

            @Override
            public BlockedTypeInterface isBlocked(Browser browser, Request request) {
                URLConnectionAdapter con;
                if (request == null || !request.isRequested() || (con = request.getHttpConnection()) == null) {
                    return null;
                }
                if (con.getResponseCode() == 403 && StringUtils.containsIgnoreCase((String)con.getResponseMessage(), (String)"Blocked by ESET Security")) {
                    return this;
                }
                return null;
            }

            @Override
            public BlockLevelType getBlockLevelType() {
                return BlockLevelType.SITE;
            }

            @Override
            public BlockSourceType getBlockSourceType() {
                return BlockSourceType.SOFTWARE;
            }

            @Override
            public Boolean prepareBlockDetection(Browser browser, Request request) {
                return null;
            }
        }
        ,
        FIREWALL_WEBGUARD{

            @Override
            public String getLabel() {
                return "Firewall WebGuard";
            }

            @Override
            public BlockedTypeInterface isBlocked(Browser browser, Request request) {
                URLConnectionAdapter con;
                if (request == null || !request.isRequested() || (con = request.getHttpConnection()) == null) {
                    return null;
                }
                if (con.getResponseCode() == 403 && StringUtils.containsIgnoreCase((String)request.getResponseHeader("Server"), (String)"WebGuard")) {
                    return this;
                }
                return null;
            }

            @Override
            public BlockLevelType getBlockLevelType() {
                return BlockLevelType.SITE;
            }

            @Override
            public BlockSourceType getBlockSourceType() {
                return BlockSourceType.SOFTWARE;
            }

            @Override
            public Boolean prepareBlockDetection(Browser browser, Request request) {
                return null;
            }
        }
        ,
        COVENANTEYES{

            @Override
            public String getLabel() {
                return "CovenantEyesVPN";
            }

            @Override
            public BlockedTypeInterface isBlocked(Browser browser, Request request) {
                URLConnectionAdapter con;
                if (request == null || !request.isLoaded() || (con = request.getHttpConnection()) == null) {
                    return null;
                }
                if (con.getResponseCode() == 200 && request.getResponseHeader("x-ce-page") != null) {
                    if (request.containsHTML("(?i)<title>\\s*Domain Blocked:")) {
                        return this;
                    }
                    if (request.containsHTML("(?i)>\\s*Contact your Filter Guardian if you wish")) {
                        return this;
                    }
                }
                return null;
            }

            @Override
            public BlockLevelType getBlockLevelType() {
                return BlockLevelType.SITE;
            }

            @Override
            public BlockSourceType getBlockSourceType() {
                return BlockSourceType.SERVICE;
            }

            @Override
            public Boolean prepareBlockDetection(Browser browser, Request request) {
                return null;
            }
        }
        ,
        AMAZON_AWS_WAF_WEB_APPLICATION_FIREWALL{

            @Override
            public String getLabel() {
                return "Amazon AWS Web Application Firewall";
            }

            @Override
            public BlockedTypeInterface isBlocked(Browser browser, Request request) {
                URLConnectionAdapter con;
                if (request == null || !request.isLoaded() || (con = request.getHttpConnection()) == null) {
                    return null;
                }
                if (con.getResponseCode() == 202 && request.getResponseHeader("x-amzn-waf-action") != null && StringUtils.containsIgnoreCase((String)request.getResponseHeader("server"), (String)"awselb")) {
                    return this;
                }
                return null;
            }

            @Override
            public BlockLevelType getBlockLevelType() {
                return BlockLevelType.SITE;
            }

            @Override
            public BlockSourceType getBlockSourceType() {
                return BlockSourceType.SERVICE;
            }

            @Override
            public Boolean prepareBlockDetection(Browser browser, Request request) {
                return null;
            }
        };

    }

    public static enum CloudflareBlockedType implements LabelInterface,
    BlockedTypeInterface
    {
        CLOUDFLARE_SITE_OFFLINE{

            @Override
            public String getLabel() {
                return "Cloudflare Site Offline";
            }

            @Override
            public BlockedTypeInterface isBlocked(Browser browser, Request request) {
                if (Browser.getCloudflareBlock(browser, request) == this) {
                    return this;
                }
                return null;
            }

            @Override
            public BlockLevelType getBlockLevelType() {
                return BlockLevelType.DOWN;
            }

            @Override
            public BlockSourceType getBlockSourceType() {
                return BlockSourceType.SERVICE;
            }

            @Override
            public Boolean prepareBlockDetection(Browser browser, Request request) {
                return Browser.prepareCloudflareBlockDetection(browser, request);
            }
        }
        ,
        CLOUDFLARE_GEO_BLOCK{

            @Override
            public String getLabel() {
                return "Cloudflare GEO-block";
            }

            @Override
            public BlockedTypeInterface isBlocked(Browser browser, Request request) {
                if (Browser.getCloudflareBlock(browser, request) == this) {
                    return this;
                }
                return null;
            }

            @Override
            public BlockLevelType getBlockLevelType() {
                return BlockLevelType.GEO;
            }

            @Override
            public BlockSourceType getBlockSourceType() {
                return BlockSourceType.SERVICE;
            }

            @Override
            public Boolean prepareBlockDetection(Browser browser, Request request) {
                return null;
            }
        }
        ,
        CLOUDFLARE_IP_BLOCK{

            @Override
            public String getLabel() {
                return "Cloudflare IP-block";
            }

            @Override
            public BlockedTypeInterface isBlocked(Browser browser, Request request) {
                if (Browser.getCloudflareBlock(browser, request) == this) {
                    return this;
                }
                return null;
            }

            @Override
            public BlockLevelType getBlockLevelType() {
                return BlockLevelType.IP;
            }

            @Override
            public BlockSourceType getBlockSourceType() {
                return BlockSourceType.SERVICE;
            }

            @Override
            public Boolean prepareBlockDetection(Browser browser, Request request) {
                return null;
            }
        }
        ,
        CLOUDFLARE_SITE{

            @Override
            public String getLabel() {
                return "Cloudflare Site-Protection";
            }

            @Override
            public BlockedTypeInterface isBlocked(Browser browser, Request request) {
                if (Browser.getCloudflareBlock(browser, request) == this) {
                    return this;
                }
                return null;
            }

            @Override
            public BlockLevelType getBlockLevelType() {
                return BlockLevelType.SITE;
            }

            @Override
            public BlockSourceType getBlockSourceType() {
                return BlockSourceType.SERVICE;
            }

            @Override
            public Boolean prepareBlockDetection(Browser browser, Request request) {
                return null;
            }
        };

    }

    public class BrowserException
    extends IOException {
        private static final long serialVersionUID = 1509988898224037320L;
        private Request request;

        public BrowserException(String message, Request request, Exception e) {
            super(message, e);
            this.request = null;
            this.request = request;
        }

        @Override
        public String getMessage() {
            Request request = this.getRequest();
            if (request != null) {
                StringBuilder sb = new StringBuilder();
                try {
                    sb.append(request.printHeaders());
                }
                catch (Exception e) {
                    Exceptions.getStackTrace((StringBuilder)sb, (Throwable)e);
                }
                String message = super.getMessage();
                if (StringUtils.isNotEmpty((String)message)) {
                    sb.append("\r\n");
                    sb.append(message);
                }
                return sb.toString();
            }
            return super.getMessage();
        }

        public Request removeRequest() {
            Request ret = this.request;
            this.request = null;
            return ret;
        }

        public String getSuperMessage() {
            return super.getMessage();
        }

        public Request getRequest() {
            return this.request;
        }
    }

    public class BlockedByException
    extends BrowserException {
        private static final long serialVersionUID = 9215538386994469323L;
        private final BlockedTypeInterface blockedBy;

        public BlockedTypeInterface getBlockedBy() {
            return this.blockedBy;
        }

        public BlockedByException(Request request, BlockedTypeInterface blockedBy) {
            super(blockedBy.getLabel(), request, null);
            this.blockedBy = blockedBy;
        }
    }
}

