/*
 * Decompiled with CFR 0.152.
 */
package jd.http;

import java.util.Iterator;
import java.util.Map;
import org.appwork.utils.net.HTTPHeader;
import org.appwork.utils.net.HeaderCollection;

public class RequestHeader
implements Iterable<HTTPHeader> {
    private boolean dominant = false;
    private final HeaderCollection headers = new HeaderCollection();

    public RequestHeader() {
        this.headers.getAllowedDuplicatedKeys().clear();
    }

    public RequestHeader(Map<String, String> headers) {
        this();
        this.putAll(headers);
    }

    public RequestHeader(RequestHeader requestHeader) {
        this();
        if (requestHeader != null) {
            this.putAll(requestHeader);
            this.dominant = requestHeader.dominant;
        }
    }

    public void clear() {
        this.headers.clear();
    }

    public RequestHeader clone() {
        return new RequestHeader(this);
    }

    public boolean contains(String key) {
        return this.headers.get(key) != null;
    }

    public String getValue(String key) {
        HTTPHeader header = this.headers.get(key);
        if (header != null) {
            return header.getValue();
        }
        return null;
    }

    @Deprecated
    public String get(String key) {
        return this.getValue(key);
    }

    public HTTPHeader getHeader(String key) {
        return this.headers.get(key);
    }

    public int indexOf(HTTPHeader header) {
        return this.headers.indexOf(header);
    }

    public boolean isDominant() {
        return this.dominant;
    }

    @Override
    public Iterator<HTTPHeader> iterator() {
        return this.headers.iterator();
    }

    public void put(HTTPHeader header) {
        this.headers.add(header);
    }

    public void put(String key, String value) {
        this.put(new HTTPHeader(key, value));
    }

    public void putAll(Map<String, String> properties) {
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void putAll(RequestHeader headers) {
        for (HTTPHeader header : headers) {
            this.put(header);
        }
    }

    public HTTPHeader remove(HTTPHeader header) {
        return this.headers.remove(header);
    }

    public HTTPHeader remove(String key) {
        return this.headers.remove(key);
    }

    public void setDominant(boolean dominant) {
        this.dominant = dominant;
    }

    public int size() {
        return this.headers.size();
    }

    public String toString() {
        return this.headers.toString();
    }
}

