/*
 * Decompiled with CFR 0.152.
 */
package jd.http.requests;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import jd.http.Request;
import jd.http.URLConnectionAdapter;
import jd.http.requests.FormData;
import org.appwork.utils.StringUtils;
import org.appwork.utils.net.CountingOutputStream;
import org.appwork.utils.net.NullOutputStream;
import org.appwork.utils.net.httpconnection.HTTPConnection;

public class PostFormDataRequest
extends Request {
    protected final String boundary;
    protected final List<FormData> formDatas = new ArrayList<FormData>();
    protected String encodeType = "multipart/form-data";
    protected static final String NEWLINE = "\r\n";

    public String getBoundary() {
        return this.boundary;
    }

    public PostFormDataRequest(String url) throws IOException {
        super(url);
        this.boundary = this.generateBoundary();
    }

    public PostFormDataRequest(URL url) throws IOException {
        super(url);
        this.boundary = this.generateBoundary();
    }

    protected PostFormDataRequest(PostFormDataRequest request) {
        super(request);
        this.boundary = this.generateBoundary();
    }

    public void addFormData(FormData fd) throws IOException {
        if (fd != null) {
            switch (fd.getType()) {
                case DATA: 
                case FILE: 
                case STREAM: 
                case VARIABLE: {
                    this.formDatas.add(fd);
                    break;
                }
                default: {
                    throw new IOException("Unsupported FormData type:" + (Object)((Object)fd.getType()));
                }
            }
        }
    }

    protected List<FormData> getFormData() {
        return this.formDatas;
    }

    protected String generateBoundary() {
        long range = 899999999999999L;
        long rand = (long)(Math.random() * 8.99999999999999E14) + 100000000000000L;
        return "---------------------" + System.currentTimeMillis() + "" + rand + "" + System.nanoTime();
    }

    public String getEncodeType() {
        return this.encodeType;
    }

    public String getPostDataString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.formDatas.size(); ++i) {
            this.write(this.formDatas.get(i), sb);
        }
        sb.append(this.getBoundary());
        sb.append("--");
        sb.append(NEWLINE);
        return sb.toString();
    }

    private long postContent(URLConnectionAdapter httpConnection) throws IOException {
        CountingOutputStream output = httpConnection != null && httpConnection.getOutputStream() != null ? new CountingOutputStream((OutputStream)httpConnection.getOutputStream()) : new CountingOutputStream((OutputStream)new NullOutputStream());
        for (int i = 0; i < this.formDatas.size(); ++i) {
            this.write(this.formDatas.get(i), (OutputStream)output);
        }
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)output, "UTF-8");
        writer.write(this.getBoundary());
        writer.write("--");
        writer.write(NEWLINE);
        writer.flush();
        output.flush();
        return output.transferedBytes();
    }

    @Override
    public Request cloneRequest() {
        PostFormDataRequest ret = new PostFormDataRequest(this);
        ret.getFormData().addAll(this.getFormData());
        return ret;
    }

    @Override
    public long postRequest() throws IOException {
        this.httpConnection.connect();
        return this.postContent(this.httpConnection);
    }

    @Override
    public HTTPConnection.RequestMethod getRequestMethod() {
        return HTTPConnection.RequestMethod.POST;
    }

    @Override
    public void preRequest() throws IOException {
        this.httpConnection.setRequestMethod(this.getRequestMethod());
        this.httpConnection.setRequestProperty("Content-Type", this.encodeType + "; boundary=" + this.getBoundary().substring(2));
        this.httpConnection.setRequestProperty("Content-Length", this.postContent(null) + "");
    }

    public void setEncodeType(String encodeType) {
        this.encodeType = encodeType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void write(FormData formData, OutputStream output) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(output);
        writer.write(this.getBoundary());
        writer.write(NEWLINE);
        String value = StringUtils.valueOrEmpty((String)formData.getValue());
        switch (formData.getType()) {
            case VARIABLE: {
                writer.write("Content-Disposition: form-data; name=\"" + formData.getName() + "\"");
                writer.write(NEWLINE);
                writer.write(NEWLINE);
                writer.write(value);
                writer.write(NEWLINE);
                break;
            }
            case DATA: {
                writer.write("Content-Disposition: form-data; name=\"" + formData.getName() + "\"; filename=\"" + value + "\"");
                byte[] data = formData.getData();
                writer.write(NEWLINE);
                writer.write("Content-Type: " + formData.getDataType());
                writer.write(NEWLINE);
                writer.write("Content-Length: " + data.length);
                writer.write(NEWLINE);
                writer.write(NEWLINE);
                writer.flush();
                output.write(data);
                output.flush();
                writer.write(NEWLINE);
                writer.flush();
                break;
            }
            case FILE: {
                writer.write("Content-Disposition: form-data; name=\"" + formData.getName() + "\"; filename=\"" + value + "\"");
                writer.write(NEWLINE);
                writer.write("Content-Type: " + formData.getDataType());
                writer.write(NEWLINE);
                writer.write("Content-Length: " + formData.getFile().length());
                writer.write(NEWLINE);
                writer.write(NEWLINE);
                writer.flush();
                FileInputStream in = new FileInputStream(formData.getFile());
                try {
                    byte[] buf = new byte[1024];
                    int n = -1;
                    while ((n = ((InputStream)in).read(buf)) > -1) {
                        if (n <= 0) continue;
                        output.write(buf, 0, n);
                    }
                }
                finally {
                    ((InputStream)in).close();
                }
                output.flush();
                writer.write(NEWLINE);
                writer.flush();
                break;
            }
            case STREAM: {
                writer.write("Content-Disposition: form-data; name=\"" + formData.getName() + "\"; filename=\"" + value + "\"");
                writer.write(NEWLINE);
                writer.write("Content-Type: " + formData.getDataType());
                writer.write(NEWLINE);
                writer.write(NEWLINE);
                writer.flush();
                FormData.FormDataOutputStream stream = formData.getStream();
                try {
                    try {
                        stream.writeTo(output);
                    }
                    finally {
                        stream.onClosed();
                    }
                }
                catch (IOException e) {
                    stream.onIOException(e);
                }
                output.flush();
                writer.write(NEWLINE);
                writer.flush();
            }
        }
        writer.flush();
        output.flush();
    }

    private void write(FormData formData, StringBuffer sb) {
        sb.append(this.getBoundary());
        sb.append(NEWLINE);
        String value = StringUtils.valueOrEmpty((String)formData.getValue());
        switch (formData.getType()) {
            case VARIABLE: {
                sb.append("Content-Disposition: form-data; name=\"").append(formData.getName()).append("\"");
                sb.append("\r\n\r\n");
                sb.append(value);
                sb.append(NEWLINE);
                break;
            }
            case DATA: {
                sb.append("Content-Disposition: form-data; name=\"").append(formData.getName()).append("\"; filename=\"").append(value).append("\"");
                byte[] data = formData.getData();
                sb.append("\r\nContent-Type: " + formData.getDataType());
                sb.append("\r\nContent-Length: " + data.length);
                sb.append("\r\n\r\n[.....").append(data.length).append(" ByteArray DATA....]\r\n");
                break;
            }
            case FILE: {
                sb.append("Content-Disposition: form-data; name=\"").append(formData.getName()).append("\"; filename=\"").append(value).append("\"");
                sb.append("\r\nContent-Type: ").append(formData.getDataType());
                sb.append("\r\nContent-Length: " + formData.getFile().length());
                sb.append("\r\n\r\n[.....").append(formData.getFile().length()).append(" FileByte DATA....]\r\n");
                break;
            }
            case STREAM: {
                sb.append("Content-Disposition: form-data; name=\"").append(formData.getName()).append("\"; filename=\"").append(value).append("\"");
                sb.append("\r\nContent-Type: ").append(formData.getDataType());
                sb.append("\r\n\r\n[....").append("Stream DATA....]\r\n");
            }
        }
    }
}

