/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.protocol.sync;

import java.util.logging.Logger;
import org.fourthline.cling.UpnpService;
import org.fourthline.cling.model.gena.CancelReason;
import org.fourthline.cling.model.gena.RemoteGENASubscription;
import org.fourthline.cling.model.message.StreamRequestMessage;
import org.fourthline.cling.model.message.StreamResponseMessage;
import org.fourthline.cling.model.message.UpnpResponse;
import org.fourthline.cling.model.message.gena.OutgoingUnsubscribeRequestMessage;
import org.fourthline.cling.model.meta.RemoteService;
import org.fourthline.cling.protocol.SendingSync;
import org.fourthline.cling.transport.RouterException;

public class SendingUnsubscribe
extends SendingSync<OutgoingUnsubscribeRequestMessage, StreamResponseMessage> {
    private static final Logger log = Logger.getLogger(SendingUnsubscribe.class.getName());
    protected final RemoteGENASubscription subscription;

    public SendingUnsubscribe(UpnpService upnpService, RemoteGENASubscription subscription) {
        super(upnpService, new OutgoingUnsubscribeRequestMessage(subscription, upnpService.getConfiguration().getEventSubscriptionHeaders((RemoteService)subscription.getService())));
        this.subscription = subscription;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected StreamResponseMessage executeSync() throws RouterException {
        log.fine("Sending unsubscribe request: " + this.getInputMessage());
        StreamResponseMessage response = null;
        try {
            StreamResponseMessage streamResponseMessage = response = this.getUpnpService().getRouter().send((StreamRequestMessage)this.getInputMessage());
            this.onUnsubscribe(response);
            return streamResponseMessage;
        }
        catch (Throwable throwable) {
            this.onUnsubscribe(response);
            throw throwable;
        }
    }

    protected void onUnsubscribe(final StreamResponseMessage response) {
        this.getUpnpService().getRegistry().removeRemoteSubscription(this.subscription);
        this.getUpnpService().getConfiguration().getRegistryListenerExecutor().execute(new Runnable(){

            @Override
            public void run() {
                if (response == null) {
                    log.fine("Unsubscribe failed, no response received");
                    SendingUnsubscribe.this.subscription.end(CancelReason.UNSUBSCRIBE_FAILED, null);
                } else if (((UpnpResponse)response.getOperation()).isFailed()) {
                    log.fine("Unsubscribe failed, response was: " + response);
                    SendingUnsubscribe.this.subscription.end(CancelReason.UNSUBSCRIBE_FAILED, (UpnpResponse)response.getOperation());
                } else {
                    log.fine("Unsubscribe successful, response was: " + response);
                    SendingUnsubscribe.this.subscription.end(null, (UpnpResponse)response.getOperation());
                }
            }
        });
    }
}

