# Screenshot Script

## Overview
Custom screenshot script that provides macOS-like functionality on Hyprland. Takes a screenshot, saves the image to clipboard first, then replaces clipboard content with the file path for easy terminal pasting.

## Features
- Saves screenshot to `~/Pictures/Screenshots/` with timestamp filename
- First saves image to clipboard (accessible via cliphist)
- Then saves file path to clipboard (for terminal pasting)
- Sends desktop notification with file path
- Works with cliphist for clipboard history

## Usage
```bash
./screenshot-script <mode>
```

### Modes
- `region` - Select area to screenshot
- `output` - Screenshot entire monitor
- `window` - Screenshot specific window

## Installation
1. Copy script to `~/.local/bin/screenshot-script`
2. Make executable: `chmod +x ~/.local/bin/screenshot-script`
3. Add to Hyprland config:
   ```
   bind = ALT SHIFT, S, exec, ~/.local/bin/screenshot-script region
   bind = ALT SHIFT, A, exec, ~/.local/bin/screenshot-script output
   bind = ALT SHIFT, W, exec, ~/.local/bin/screenshot-script window
   ```

## Dependencies
- `hyprshot` - Screenshot tool for Hyprland
- `wl-clipboard` - Wayland clipboard utilities
- `libnotify` - Desktop notifications
- `cliphist` - Clipboard history manager

## Workflow
1. Take screenshot with keybinding
2. Image is saved to file and initially copied to clipboard
3. File path replaces image in clipboard for terminal use
4. Use `Super+V` (cliphist) to access image or previous clipboard items
5. Paste file path in terminal with `Ctrl+Shift+V`