#!/bin/bash

# Configuration
export RESTIC_REPOSITORY="/mnt/synology/homes/jannick/backups/orangepi/restic"
export RESTIC_PASSWORD_FILE="/home/orangepi/.restic-password"
LOG_FILE="/home/orangepi/restic-backup.log"

# Start backup log
echo "=== Backup started at $(date) ===" > $LOG_FILE

# Check if repository is accessible
if ! restic snapshots &>/dev/null; then
  echo "ERROR: Cannot access repository. Check if NAS is mounted." >> $LOG_FILE
  exit 1
fi

# Backup system configuration
echo "Backing up system files..." >> $LOG_FILE
restic backup /etc >> $LOG_FILE 2>&1

# Backup home directory (which includes all Docker services)
echo "Backing up home directory..." >> $LOG_FILE
restic backup /home/orangepi --exclude="/home/orangepi/.cache" \
                            --exclude="/home/orangepi/Downloads" \
                            --exclude="/home/orangepi/node_modules" \
                            --exclude="/home/orangepi/.npm" \
                            --exclude="*.log" >> $LOG_FILE 2>&1

# Cleanup old snapshots
echo "Cleaning up old snapshots..." >> $LOG_FILE
restic forget --keep-daily 7 --keep-weekly 4 --keep-monthly 6 --prune >> $LOG_FILE 2>&1

echo "=== Backup completed at $(date) ===" >> $LOG_FILE
