/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.support.model.dlna;

import org.fourthline.cling.model.types.InvalidValueException;
import org.fourthline.cling.support.avtransport.lastchange.AVTransportVariable;
import org.fourthline.cling.support.model.dlna.DLNAAttribute;
import org.fourthline.cling.support.model.dlna.InvalidDLNAProtocolAttributeException;

public class DLNAPlaySpeedAttribute
extends DLNAAttribute<AVTransportVariable.TransportPlaySpeed[]> {
    public DLNAPlaySpeedAttribute() {
        this.setValue(new AVTransportVariable.TransportPlaySpeed[0]);
    }

    public DLNAPlaySpeedAttribute(AVTransportVariable.TransportPlaySpeed[] speeds) {
        this.setValue(speeds);
    }

    public DLNAPlaySpeedAttribute(String[] speeds) {
        AVTransportVariable.TransportPlaySpeed[] sp = new AVTransportVariable.TransportPlaySpeed[speeds.length];
        try {
            for (int i = 0; i < speeds.length; ++i) {
                sp[i] = new AVTransportVariable.TransportPlaySpeed(speeds[i]);
            }
        }
        catch (InvalidValueException invalidValueException) {
            throw new InvalidDLNAProtocolAttributeException("Can't parse DLNA play speeds.");
        }
        this.setValue(sp);
    }

    @Override
    public void setString(String s, String cf) throws InvalidDLNAProtocolAttributeException {
        AVTransportVariable.TransportPlaySpeed[] value = null;
        if (s != null && s.length() != 0) {
            String[] speeds = s.split(",");
            try {
                value = new AVTransportVariable.TransportPlaySpeed[speeds.length];
                for (int i = 0; i < speeds.length; ++i) {
                    value[i] = new AVTransportVariable.TransportPlaySpeed(speeds[i]);
                }
            }
            catch (InvalidValueException invalidValueException) {
                value = null;
            }
        }
        if (value == null) {
            throw new InvalidDLNAProtocolAttributeException("Can't parse DLNA play speeds from: " + s);
        }
        this.setValue(value);
    }

    @Override
    public String getString() {
        String s = "";
        for (AVTransportVariable.TransportPlaySpeed speed : (AVTransportVariable.TransportPlaySpeed[])this.getValue()) {
            if (((String)speed.getValue()).equals("1")) continue;
            s = s + (s.length() == 0 ? "" : ",") + speed;
        }
        return s;
    }
}

