/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.model.types;

import java.math.BigInteger;
import java.net.InetAddress;
import java.security.MessageDigest;
import java.util.UUID;
import java.util.logging.Logger;
import org.fourthline.cling.model.ModelUtil;

public class UDN {
    private static final Logger log = Logger.getLogger(UDN.class.getName());
    public static final String PREFIX = "uuid:";
    private String identifierString;

    public UDN(String identifierString) {
        this.identifierString = identifierString;
    }

    public UDN(UUID uuid) {
        this.identifierString = uuid.toString();
    }

    public boolean isUDA11Compliant() {
        try {
            UUID.fromString(this.identifierString);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public String getIdentifierString() {
        return this.identifierString;
    }

    public static UDN valueOf(String udnString) {
        return new UDN(udnString.startsWith(PREFIX) ? udnString.substring(PREFIX.length()) : udnString);
    }

    public static UDN uniqueSystemIdentifier(String salt) {
        StringBuilder systemSalt = new StringBuilder();
        if (!ModelUtil.ANDROID_RUNTIME) {
            try {
                InetAddress i = InetAddress.getLocalHost();
                systemSalt.append(i.getHostName()).append(i.getHostAddress());
            }
            catch (Exception ex) {
                try {
                    systemSalt.append(new String(ModelUtil.getFirstNetworkInterfaceHardwareAddress(), "UTF-8"));
                }
                catch (Throwable ex1) {
                    log.severe("Couldn't get host/network interface information on this machine, generated UDN might not be unique!");
                }
            }
        } else {
            throw new RuntimeException("This method does not create a unique identifier on Android, see the Javadoc and use new UDN(UUID) instead!");
        }
        systemSalt.append(System.getProperty("os.name"));
        systemSalt.append(System.getProperty("os.version"));
        try {
            byte[] hash = MessageDigest.getInstance("MD5").digest(systemSalt.toString().getBytes("UTF-8"));
            return new UDN(new UUID(new BigInteger(-1, hash).longValue(), salt.hashCode()));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public String toString() {
        return PREFIX + this.getIdentifierString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof UDN)) {
            return false;
        }
        UDN udn = (UDN)o;
        return this.identifierString.equals(udn.identifierString);
    }

    public int hashCode() {
        return this.identifierString.hashCode();
    }
}

