/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.registry;

import java.net.URI;
import java.util.Collection;
import org.fourthline.cling.UpnpService;
import org.fourthline.cling.UpnpServiceConfiguration;
import org.fourthline.cling.model.DiscoveryOptions;
import org.fourthline.cling.model.ServiceReference;
import org.fourthline.cling.model.gena.LocalGENASubscription;
import org.fourthline.cling.model.gena.RemoteGENASubscription;
import org.fourthline.cling.model.meta.Device;
import org.fourthline.cling.model.meta.LocalDevice;
import org.fourthline.cling.model.meta.RemoteDevice;
import org.fourthline.cling.model.meta.RemoteDeviceIdentity;
import org.fourthline.cling.model.meta.Service;
import org.fourthline.cling.model.resource.Resource;
import org.fourthline.cling.model.types.DeviceType;
import org.fourthline.cling.model.types.ServiceType;
import org.fourthline.cling.model.types.UDN;
import org.fourthline.cling.protocol.ProtocolFactory;
import org.fourthline.cling.registry.RegistrationException;
import org.fourthline.cling.registry.RegistryListener;

public interface Registry {
    public UpnpService getUpnpService();

    public UpnpServiceConfiguration getConfiguration();

    public ProtocolFactory getProtocolFactory();

    public void shutdown();

    public void pause();

    public void resume();

    public boolean isPaused();

    public void addListener(RegistryListener var1);

    public void removeListener(RegistryListener var1);

    public Collection<RegistryListener> getListeners();

    public boolean notifyDiscoveryStart(RemoteDevice var1);

    public void notifyDiscoveryFailure(RemoteDevice var1, Exception var2);

    public void addDevice(LocalDevice var1) throws RegistrationException;

    public void addDevice(LocalDevice var1, DiscoveryOptions var2) throws RegistrationException;

    public void setDiscoveryOptions(UDN var1, DiscoveryOptions var2);

    public DiscoveryOptions getDiscoveryOptions(UDN var1);

    public void addDevice(RemoteDevice var1) throws RegistrationException;

    public boolean update(RemoteDeviceIdentity var1);

    public boolean removeDevice(LocalDevice var1);

    public boolean removeDevice(RemoteDevice var1);

    public boolean removeDevice(UDN var1);

    public void removeAllLocalDevices();

    public void removeAllRemoteDevices();

    public Device getDevice(UDN var1, boolean var2);

    public LocalDevice getLocalDevice(UDN var1, boolean var2);

    public RemoteDevice getRemoteDevice(UDN var1, boolean var2);

    public Collection<LocalDevice> getLocalDevices();

    public Collection<RemoteDevice> getRemoteDevices();

    public Collection<Device> getDevices();

    public Collection<Device> getDevices(DeviceType var1);

    public Collection<Device> getDevices(ServiceType var1);

    public Service getService(ServiceReference var1);

    public void addResource(Resource var1);

    public void addResource(Resource var1, int var2);

    public boolean removeResource(Resource var1);

    public Resource getResource(URI var1) throws IllegalArgumentException;

    public <T extends Resource> T getResource(Class<T> var1, URI var2) throws IllegalArgumentException;

    public Collection<Resource> getResources();

    public <T extends Resource> Collection<T> getResources(Class<T> var1);

    public void addLocalSubscription(LocalGENASubscription var1);

    public LocalGENASubscription getLocalSubscription(String var1);

    public boolean updateLocalSubscription(LocalGENASubscription var1);

    public boolean removeLocalSubscription(LocalGENASubscription var1);

    public void addRemoteSubscription(RemoteGENASubscription var1);

    public RemoteGENASubscription getRemoteSubscription(String var1);

    public void updateRemoteSubscription(RemoteGENASubscription var1);

    public void removeRemoteSubscription(RemoteGENASubscription var1);

    public void registerPendingRemoteSubscription(RemoteGENASubscription var1);

    public void unregisterPendingRemoteSubscription(RemoteGENASubscription var1);

    public RemoteGENASubscription getWaitRemoteSubscription(String var1);

    public void advertiseLocalDevices();
}

