/*
 * Decompiled with CFR 0.152.
 */
package jd.nutils;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.appwork.utils.JDK8BufferHelper;
import org.jdownloader.logging.LogController;

public class DynByteBuffer {
    private ByteBuffer buffer;

    public DynByteBuffer(int l) {
        this.buffer = ByteBuffer.allocateDirect(l);
    }

    public void put(byte[] buffer, int read) {
        this.checkBufferSize(read);
        this.buffer.put(buffer);
    }

    public void put(byte b) {
        this.checkBufferSize(1);
        this.buffer.put(b);
    }

    public void put(byte[] bytes, int off, int len) {
        this.checkBufferSize(len);
        this.buffer.put(bytes, off, len);
    }

    public void clear() {
        JDK8BufferHelper.clear((Buffer)this.buffer);
    }

    public String toString() {
        return new String(this.getLast(this.buffer.position()));
    }

    public byte[] toByteArray() {
        return this.getLast(this.buffer.position());
    }

    public String toString(String codepage) {
        try {
            return new String(this.getLast(this.buffer.position()), codepage);
        }
        catch (UnsupportedEncodingException e) {
            LogController.CL().log((Throwable)e);
            return new String(this.getLast(this.buffer.position()));
        }
    }

    public int capacity() {
        return this.buffer.capacity();
    }

    public int limit() {
        return this.buffer.limit();
    }

    public int position() {
        return this.buffer.position();
    }

    private void checkBufferSize(int read) {
        ByteBuffer newbuffer;
        if (this.buffer.remaining() < read) {
            newbuffer = ByteBuffer.allocateDirect(this.buffer.capacity() * 2);
            JDK8BufferHelper.flip((Buffer)this.buffer);
            newbuffer.put(this.buffer);
            this.buffer = newbuffer;
        }
        if (this.buffer.remaining() < read) {
            newbuffer = ByteBuffer.allocateDirect(this.buffer.capacity() + read);
            JDK8BufferHelper.flip((Buffer)this.buffer);
            newbuffer.put(this.buffer);
            this.buffer = newbuffer;
        }
    }

    public byte get() {
        return this.buffer.get();
    }

    public Buffer flip() {
        return JDK8BufferHelper.flip((Buffer)this.buffer);
    }

    public ByteBuffer compact() {
        return this.buffer.compact();
    }

    public byte[] getLast(int num) {
        int posi = this.buffer.position();
        num = Math.min(posi, num);
        JDK8BufferHelper.position((Buffer)this.buffer, (int)(posi - num));
        this.buffer.position();
        byte[] b = new byte[num];
        this.buffer.get(b);
        JDK8BufferHelper.position((Buffer)this.buffer, (int)posi);
        return b;
    }

    public byte[] getSub(int start, int end) {
        int posi = this.buffer.position();
        JDK8BufferHelper.position((Buffer)this.buffer, (int)start);
        byte[] b = new byte[end - start];
        this.buffer.get(b);
        JDK8BufferHelper.position((Buffer)this.buffer, (int)posi);
        return b;
    }

    public static PrintStream PrintStreamforDynByteBuffer(int l) {
        final OutputStream buf = DynByteBuffer.OutputStreamforDynByteBuffer(l);
        return new PrintStream(buf){

            public synchronized String toString() {
                return buf.toString();
            }
        };
    }

    public static OutputStream OutputStreamforDynByteBuffer(int l) {
        final DynByteBuffer buf = new DynByteBuffer(l);
        return new OutputStream(){

            @Override
            public synchronized void write(int b) throws IOException {
                buf.put((byte)b);
            }

            @Override
            public synchronized void write(byte[] bytes, int off, int len) throws IOException {
                buf.put(bytes, off, len);
            }

            public synchronized String toString() {
                return buf.toString();
            }
        };
    }
}

