/*
 * Decompiled with CFR 0.152.
 */
package jd.nutils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import jd.nutils.DynByteBuffer;
import jd.nutils.ProcessListener;
import org.appwork.utils.StringUtils;
import org.appwork.utils.processes.ProcessBuilderFactory;

public class Executer
extends Thread
implements Runnable {
    private boolean debug = true;
    private Logger logger;
    private String codepage = null;
    public static int LISTENER_ERRORSTREAM = 1;
    public static int LISTENER_STDSTREAM = 2;
    private String command;
    private List<String> parameter;
    private String runIn;
    private final DynByteBuffer inputStreamBuffer;
    private final DynByteBuffer errorStreamBuffer;
    private final List<ProcessListener> listener = new ArrayList<ProcessListener>();
    private final List<ProcessListener> elistener = new ArrayList<ProcessListener>();
    private int waitTimeout = 60;
    private int exitValue = -1;
    private boolean gotInterrupted = false;
    private Process process;
    private StreamObserver sbeObserver;
    private StreamObserver sboObserver;
    private Exception exception = null;

    private static boolean isWindows() {
        String osName = System.getProperty("os.name");
        if (osName != null) {
            String os = osName.toLowerCase(Locale.ENGLISH);
            if (os.contains("windows")) {
                return true;
            }
            if (os.contains("nt")) {
                return true;
            }
        }
        return false;
    }

    public Executer(String command) {
        super("Executer: " + command);
        this.command = command;
        this.parameter = new ArrayList<String>();
        this.inputStreamBuffer = new DynByteBuffer(4096);
        this.errorStreamBuffer = new DynByteBuffer(4096);
    }

    public void addParameter(String par) {
        this.parameter.add(par);
    }

    public void addParameters(String[] par) {
        if (par != null && par.length > 0) {
            for (String p : par) {
                this.parameter.add(p);
            }
        }
    }

    public void addProcessListener(ProcessListener listener, int flag) {
        this.removeProcessListener(listener, flag);
        if ((flag & LISTENER_STDSTREAM) > 0) {
            this.listener.add(listener);
        }
        if ((flag & LISTENER_ERRORSTREAM) > 0) {
            this.elistener.add(listener);
        }
    }

    private void fireEvent(DynByteBuffer buffer, int read, int flag) {
        if (!this.isInterrupted()) {
            if ((flag & LISTENER_STDSTREAM) > 0) {
                for (ProcessListener listener : this.listener) {
                    listener.onBufferChanged(this, buffer, read);
                }
            }
            if ((flag & LISTENER_ERRORSTREAM) > 0) {
                for (ProcessListener elistener : this.elistener) {
                    elistener.onBufferChanged(this, buffer, read);
                }
            }
        }
    }

    private void fireEvent(String line, DynByteBuffer sb, int flag) {
        if ((flag & LISTENER_STDSTREAM) > 0) {
            for (ProcessListener listener : this.listener) {
                listener.onProcess(this, line, sb);
            }
        }
        if ((flag & LISTENER_ERRORSTREAM) > 0) {
            for (ProcessListener elistener : this.elistener) {
                elistener.onProcess(this, line, sb);
            }
        }
    }

    public String getCodepage() {
        String codepage = this.codepage;
        if (codepage == null) {
            return Executer.isWindows() ? "ISO-8859-1" : "UTF-8";
        }
        return codepage;
    }

    public String getCommand() {
        return this.command;
    }

    public String getErrorStream() {
        return this.errorStreamBuffer.toString(this.getCodepage());
    }

    public DynByteBuffer getErrorStreamBuffer() {
        return this.errorStreamBuffer;
    }

    public Exception getException() {
        return this.exception;
    }

    public int getExitValue() {
        return this.exitValue;
    }

    public DynByteBuffer getInputStreamBuffer() {
        return this.inputStreamBuffer;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public String getOutputStream() {
        return this.inputStreamBuffer.toString(this.getCodepage());
    }

    public List<String> getParameter() {
        return this.parameter;
    }

    public Process getProcess() {
        return this.process;
    }

    public String getRunin() {
        return this.runIn;
    }

    public int getWaitTimeout() {
        return this.waitTimeout;
    }

    public boolean gotInterrupted() {
        return this.gotInterrupted;
    }

    @Override
    public void interrupt() {
        try {
            this.gotInterrupted = true;
            super.interrupt();
            if (this.sbeObserver != null) {
                this.sbeObserver.requestInterrupt();
            }
            if (this.sboObserver != null) {
                this.sboObserver.requestInterrupt();
            }
        }
        finally {
            this.process.destroy();
        }
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void removeProcessListener(ProcessListener listener, int flag) {
        if ((flag & LISTENER_STDSTREAM) > 0) {
            this.listener.remove(listener);
        }
        if ((flag & LISTENER_ERRORSTREAM) > 0) {
            this.elistener.remove(listener);
        }
    }

    private void log(String message) {
        Logger logger = this.getLogger();
        if (logger != null) {
            logger.severe(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        File check;
        if (this.command == null || this.command.trim().length() == 0) {
            this.log("Execute Parameter error: No Command");
            return;
        }
        ArrayList<String> params = new ArrayList<String>();
        params.add(this.getCommand());
        params.addAll(this.getParameter());
        ProcessBuilder pb = ProcessBuilderFactory.create((String[])params.toArray(new String[0]));
        String runIn = this.getRunin();
        File file = check = StringUtils.isNotEmpty((String)runIn) ? new File(runIn) : null;
        if (check == null || !check.exists()) {
            check = new File((String)params.get(0)).getParentFile();
        }
        if (check != null && check.exists()) {
            if (check.isFile()) {
                check = check.getParentFile();
            }
            runIn = check.getAbsolutePath();
            pb.directory(check);
        } else {
            this.log("Working directory " + runIn + " does not exist!");
            runIn = null;
        }
        if (this.isDebug()) {
            StringBuilder out = new StringBuilder();
            for (String p : params) {
                out.append(p);
                out.append(' ');
            }
            this.log("Execute: " + out + " in " + (runIn != null ? runIn : "default"));
        }
        try {
            Thread timeoutThread;
            this.process = pb.start();
            if (this.waitTimeout == 0) {
                timeoutThread = null;
                return;
            }
            OutputStream outputStream = this.process.getOutputStream();
            this.sbeObserver = new StreamObserver(this.process, this.process.getErrorStream(), this.errorStreamBuffer);
            this.sbeObserver.setName(this.getName() + " ERRstreamobserver");
            this.sboObserver = new StreamObserver(this.process, this.process.getInputStream(), this.inputStreamBuffer);
            this.sboObserver.setName(this.getName() + " STDstreamobserver");
            this.sbeObserver.start();
            this.sboObserver.start();
            if (this.waitTimeout > 0) {
                timeoutThread = new Thread(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(Executer.this.waitTimeout * 1000);
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        finally {
                            Executer.this.interrupt();
                        }
                    }
                };
                timeoutThread.start();
            } else {
                timeoutThread = null;
            }
            try {
                this.process.waitFor();
                this.exitValue = this.process.exitValue();
            }
            catch (InterruptedException e) {
                this.process.destroy();
                this.gotInterrupted = true;
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    outputStream.close();
                }
                catch (Throwable e) {}
                this.log("Process returned");
            }
            if (this.sboObserver != null && this.sboObserver.isIdle()) {
                this.sboObserver.requestInterrupt();
                this.log("sbo idle - interrupt");
            }
            if (this.sbeObserver != null && this.sbeObserver.isIdle()) {
                this.sbeObserver.requestInterrupt();
                this.log("sbe idle - interrupt");
            }
            long returnTime = System.currentTimeMillis();
            Thread.interrupted();
            while (this.sbeObserver != null && this.sbeObserver.isAlive() || this.sboObserver != null && this.sboObserver.isAlive()) {
                Thread.sleep(50L);
                if (System.currentTimeMillis() - returnTime <= 60000L) continue;
                this.log("Executer Error. REPORT THIS BUG INCL. THIS LOG to jd support");
                if (this.sboObserver != null) {
                    this.sboObserver.requestInterrupt();
                }
                if (this.sbeObserver == null) break;
                this.sbeObserver.requestInterrupt();
                break;
            }
            if (timeoutThread != null) {
                timeoutThread.interrupt();
            }
            this.log("Stream observer closed");
        }
        catch (IOException e) {
            this.exception = e;
        }
        catch (InterruptedException e) {
            this.exception = e;
        }
    }

    public void setCodepage(String codepage) {
        this.codepage = codepage;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setLogger(Logger logger) {
        if (this.logger == null || logger != null) {
            this.logger = logger;
        }
    }

    public void setParameter(List<String> parameter) {
        this.parameter = parameter;
    }

    public void setRunin(String runin) {
        this.runIn = runin;
    }

    public void setWaitTimeout(int waitTimeout) {
        this.waitTimeout = waitTimeout;
    }

    public void waitTimeout() {
        while (this.isAlive()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private class StreamObserver
    extends Thread
    implements Runnable {
        private final DynByteBuffer dynbuf;
        private volatile boolean started;
        private volatile boolean idle = true;
        private boolean endOfFileReceived = false;
        private final InputStream stream;
        private volatile boolean isClosed = false;
        private final Object LOCK = new Object();
        private final Process process;
        private final int type;

        public StreamObserver(Process process, InputStream stream, DynByteBuffer buffer) {
            this.process = process;
            this.stream = stream;
            this.dynbuf = buffer;
            this.type = Executer.this.errorStreamBuffer == buffer ? LISTENER_ERRORSTREAM : LISTENER_STDSTREAM;
        }

        public boolean isIdle() {
            return this.idle;
        }

        public boolean isProcessRunning() {
            try {
                this.process.exitValue();
                return false;
            }
            catch (IllegalThreadStateException e) {
                return true;
            }
        }

        public boolean isStarted() {
            return this.started;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int readLine() throws IOException, InterruptedException {
            int i = 0;
            byte[] buffer = new byte[1];
            Object object = this.LOCK;
            synchronized (object) {
                this.idle = false;
            }
            boolean waitFlag = false;
            while (true) {
                if (this.isInterrupted()) {
                    throw new InterruptedException();
                }
                int read = this.stream.available() > 0 ? this.stream.read(buffer) : (this.isProcessRunning() || !waitFlag ? 0 : -1);
                if (read == -1) {
                    this.endOfFileReceived = true;
                    return i;
                }
                if (read > 0) {
                    i += read;
                    this.dynbuf.put(buffer, read);
                    if (buffer[0] == 8 || buffer[0] == 13 || buffer[0] == 10) {
                        return i;
                    }
                    Executer.this.fireEvent(this.dynbuf, read, this.type);
                    continue;
                }
                Thread.sleep(100L);
                waitFlag = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestInterrupt() {
            try {
                Object object = this.LOCK;
                synchronized (object) {
                    if (!this.isClosed && this.idle && this.stream.available() > 0) {
                        return;
                    }
                }
                this.isClosed = true;
                super.interrupt();
                this.stream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.started = true;
            try {
                Executer.this.fireEvent(this.dynbuf, 0, this.type);
                Thread.sleep(150L);
                for (int x = 0; this.isInterrupted() || this.stream.available() <= 0 || x == 10; ++x) {
                    if (this.isInterrupted()) {
                        return;
                    }
                    Thread.sleep(150L);
                }
                Object object = this.LOCK;
                synchronized (object) {
                    this.idle = false;
                }
                String codePage = Executer.this.getCodepage();
                while (!this.endOfFileReceived) {
                    int num = this.readLine();
                    if (num == -1) continue;
                    byte[] lastNumBytes = this.dynbuf.getLast(num);
                    String line = null;
                    if (codePage != null) {
                        try {
                            line = new String(lastNumBytes, codePage).trim();
                        }
                        catch (UnsupportedEncodingException e) {
                            e.printStackTrace();
                            codePage = null;
                        }
                    }
                    if (line == null) {
                        line = new String(lastNumBytes).trim();
                    }
                    if (line.length() <= 0) continue;
                    if (Executer.this.isDebug()) {
                        System.out.println(this + ": " + line + "");
                    }
                    Executer.this.fireEvent(line, this.dynbuf, this.type);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                try {
                    this.stream.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

