/*
 * Decompiled with CFR 0.152.
 */
package jd.nutils.io;

import java.io.File;
import java.io.FileFilter;
import java.util.regex.Pattern;

public class JDFileFilter
extends javax.swing.filechooser.FileFilter
implements FileFilter {
    private final boolean acceptDirectories;
    private final String description;
    private final String[] extension;
    private final Pattern pattern;

    public JDFileFilter(String description, String extension, boolean acceptDirectories) {
        this.description = description != null ? description : "Container files";
        this.extension = extension.split("\\|");
        this.pattern = null;
        this.acceptDirectories = acceptDirectories;
    }

    public JDFileFilter(String description, Pattern pattern, boolean acceptDirectories) {
        this.description = description != null ? description : "Container files";
        this.pattern = pattern;
        this.extension = null;
        this.acceptDirectories = acceptDirectories;
    }

    @Override
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return this.acceptDirectories;
        }
        if (this.pattern != null) {
            return this.pattern.matcher(f.getName()).matches();
        }
        String check = f.getName().toLowerCase();
        for (String element : this.extension) {
            if (!check.endsWith(element)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

