/*
 * Decompiled with CFR 0.152.
 */
package jd.nutils.zip;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jdownloader.controlling.FileCreationManager;
import org.jdownloader.logging.LogController;

public class UnZip {
    public boolean autoDelete = false;
    protected byte[] b = new byte[8092];
    protected SortedSet<String> dirsMade;
    private File targetPath = null;
    protected boolean warnedMkDir = false;
    protected ZipFile zipF;
    private File zipFile = null;
    private boolean overwrite = true;

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public UnZip(File zipFile) {
        this(zipFile, null);
    }

    public UnZip(File zipFile, File targetPath) {
        this.zipFile = zipFile;
        this.targetPath = targetPath == null ? zipFile.getParentFile() : targetPath;
    }

    public File[] extract() throws Exception {
        this.dirsMade = new TreeSet<String>();
        this.zipF = new ZipFile(this.zipFile);
        Enumeration<? extends ZipEntry> all = this.zipF.entries();
        LinkedList<File> ret = new LinkedList<File>();
        while (all.hasMoreElements()) {
            File file = this.getFile(all.nextElement());
            if (file == null) continue;
            ret.add(file);
        }
        this.zipF.close();
        if (this.autoDelete) {
            FileCreationManager.getInstance().delete(this.zipFile, null);
        }
        return ret.toArray(new File[ret.size()]);
    }

    protected File getFile(ZipEntry e) throws IOException {
        File d;
        String dirName;
        String zipName = e.getName();
        if (zipName.startsWith("/")) {
            if (!this.warnedMkDir) {
                System.out.println("Ignoring absolute paths");
            }
            this.warnedMkDir = true;
            zipName = zipName.substring(1);
        }
        if (zipName.endsWith("/")) {
            return null;
        }
        int ix = zipName.lastIndexOf(47);
        if (!(ix <= 0 || this.dirsMade.contains(dirName = zipName.substring(0, ix)) || (d = new File(this.targetPath, dirName)).exists() && d.isDirectory())) {
            if (!FileCreationManager.getInstance().mkdir(d)) {
                System.err.println("Warning: unable to mkdir " + dirName);
            }
            this.dirsMade.add(dirName);
        }
        File toExtract = new File(this.targetPath, zipName);
        if (!this.overwrite && toExtract.exists()) {
            System.out.println("Exists skip " + zipName);
            return null;
        }
        FileCreationManager.getInstance().delete(toExtract, null);
        FileOutputStream os = new FileOutputStream(toExtract);
        InputStream is = this.zipF.getInputStream(e);
        int n = 0;
        while ((n = is.read(this.b)) > 0) {
            os.write(this.b, 0, n);
        }
        is.close();
        os.close();
        return toExtract;
    }

    public String[] listFiles() {
        try {
            this.zipF = new ZipFile(this.zipFile);
            Enumeration<? extends ZipEntry> all = this.zipF.entries();
            LinkedList<String> ret = new LinkedList<String>();
            while (all.hasMoreElements()) {
                ret.add(all.nextElement().getName());
            }
            return ret.toArray(new String[ret.size()]);
        }
        catch (IOException err) {
            LogController.CL().log((Throwable)err);
            return null;
        }
    }
}

