/*
 * Decompiled with CFR 0.152.
 */
package jd.nutils.zip;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.appwork.utils.Regex;
import org.jdownloader.controlling.FileCreationManager;

public class Zip {
    private File destinationFile;
    public LinkedList<File> excludeFiles = new LinkedList();
    private Pattern excludeFilter;
    public int fillSize = 0;
    private File[] srcFiles;
    private boolean deleteAfterPack;

    public Zip(File srcFile, File destinationFile) {
        this(new File[]{srcFile}, destinationFile);
    }

    public Zip(File[] srcFiles, File destinationFile) {
        this.srcFiles = srcFiles;
        this.destinationFile = destinationFile;
    }

    private List<File> addFileToZip(String path, String srcFile, ZipOutputStream zip) throws Exception {
        ArrayList<File> ret = new ArrayList<File>();
        if (srcFile.endsWith("Thumbs.db")) {
            return null;
        }
        if (this.excludeFilter != null && Regex.matches((Object)srcFile, (Pattern)this.excludeFilter)) {
            System.out.println("Filtered: " + srcFile);
            return ret;
        }
        File folder = new File(srcFile);
        if (this.excludeFiles != null && this.excludeFiles.contains(folder)) {
            return ret;
        }
        if (folder.isDirectory()) {
            ret.addAll(this.addFolderToZip(path, srcFile, zip));
            if (this.deleteAfterPack) {
                FileCreationManager.getInstance().delete(new File(srcFile), null);
            }
        } else {
            int len;
            byte[] buf = new byte[1024];
            FileInputStream in = new FileInputStream(srcFile);
            if (path == null || path.trim().length() == 0) {
                zip.putNextEntry(new ZipEntry(folder.getName()));
            } else {
                zip.putNextEntry(new ZipEntry(path + "/" + folder.getName()));
            }
            while ((len = in.read(buf)) > 0) {
                zip.write(buf, 0, len);
            }
            in.close();
            if (this.deleteAfterPack) {
                FileCreationManager.getInstance().delete(new File(srcFile), null);
            }
            ret.add(new File(srcFile));
        }
        return ret;
    }

    private List<File> addFolderToZip(String path, String srcFolder, ZipOutputStream zip) throws Exception {
        ArrayList<File> ret = new ArrayList<File>();
        File folder = new File(srcFolder);
        if (this.excludeFiles.contains(folder)) {
            return ret;
        }
        for (String fileName : folder.list()) {
            if (this.excludeFilter != null && Regex.matches((Object)fileName, (Pattern)this.excludeFilter)) {
                System.out.println("Filtered: " + fileName);
                continue;
            }
            if (path.equals("")) {
                ret.addAll(this.addFileToZip(folder.getName(), srcFolder + "/" + fileName, zip));
                continue;
            }
            ret.addAll(this.addFileToZip(path + "/" + folder.getName(), srcFolder + "/" + fileName, zip));
        }
        return ret;
    }

    public void setExcludeFilter(Pattern compile) {
        this.excludeFilter = compile;
    }

    public List<File> zip() throws Exception {
        ArrayList<File> ret = new ArrayList<File>();
        ZipOutputStream zip = null;
        FileOutputStream fileWriter = null;
        fileWriter = new FileOutputStream(this.destinationFile);
        zip = new ZipOutputStream(fileWriter);
        for (File element : this.srcFiles) {
            if (element.isDirectory()) {
                ret.addAll(this.addFolderToZip("", element.getAbsolutePath(), zip));
                continue;
            }
            if (!element.isFile()) continue;
            ret.addAll(this.addFileToZip("", element.getAbsolutePath(), zip));
        }
        zip.flush();
        zip.close();
        int toFill = (int)((long)this.fillSize - this.destinationFile.length());
        if (toFill > 0) {
            int c;
            byte[] sig = new byte[]{80, 75, 3, 4, 20, 0, 8, 0, 8, 0};
            FileInputStream in = new FileInputStream(this.destinationFile);
            File newTarget = new File(this.destinationFile.getAbsolutePath() + ".jd");
            FileOutputStream out = new FileOutputStream(newTarget);
            out.write(sig);
            out.write(new byte[toFill -= sig.length]);
            while ((c = in.read()) != -1) {
                out.write(c);
            }
            in.close();
            out.close();
            FileCreationManager.getInstance().delete(this.destinationFile, null);
            newTarget.renameTo(this.destinationFile);
        }
        return ret;
    }

    public void setDeleteAfterPack(boolean b) {
        this.deleteAfterPack = b;
    }
}

