/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.Vector;
import org.freedesktop.dbus.AbstractConnection;
import org.freedesktop.dbus.Gettext;
import org.freedesktop.dbus.Marshalling;
import org.freedesktop.dbus.exceptions.DBusException;

public class Variant<T> {
    private final T o;
    private final Type type;
    private final String sig;

    public Variant(T t) throws IllegalArgumentException {
        if (null == t) {
            throw new IllegalArgumentException(Gettext._("Can't wrap Null in a Variant"));
        }
        this.type = t.getClass();
        try {
            String[] stringArray = Marshalling.getDBusType(t.getClass(), true);
            if (stringArray.length != 1) {
                throw new IllegalArgumentException(Gettext._("Can't wrap a multi-valued type in a Variant: ") + this.type);
            }
            this.sig = stringArray[0];
        }
        catch (DBusException dBusException) {
            if (AbstractConnection.EXCEPTION_DEBUG) {
                // empty if block
            }
            throw new IllegalArgumentException(MessageFormat.format(Gettext._("Can't wrap {0} in an unqualified Variant ({1})."), t.getClass(), dBusException.getMessage()));
        }
        this.o = t;
    }

    public Variant(T t, Type type) throws IllegalArgumentException {
        if (null == t) {
            throw new IllegalArgumentException(Gettext._("Can't wrap Null in a Variant"));
        }
        this.type = type;
        try {
            String[] stringArray = Marshalling.getDBusType(type);
            if (stringArray.length != 1) {
                throw new IllegalArgumentException(Gettext._("Can't wrap a multi-valued type in a Variant: ") + type);
            }
            this.sig = stringArray[0];
        }
        catch (DBusException dBusException) {
            if (AbstractConnection.EXCEPTION_DEBUG) {
                // empty if block
            }
            throw new IllegalArgumentException(MessageFormat.format(Gettext._("Can't wrap {0} in an unqualified Variant ({1})."), type, dBusException.getMessage()));
        }
        this.o = t;
    }

    public Variant(T t, String string) throws IllegalArgumentException {
        if (null == t) {
            throw new IllegalArgumentException(Gettext._("Can't wrap Null in a Variant"));
        }
        this.sig = string;
        try {
            Vector<Type> vector = new Vector<Type>();
            Marshalling.getJavaType(string, vector, 1);
            if (vector.size() != 1) {
                throw new IllegalArgumentException(Gettext._("Can't wrap multiple or no types in a Variant: ") + string);
            }
            this.type = vector.get(0);
        }
        catch (DBusException dBusException) {
            if (AbstractConnection.EXCEPTION_DEBUG) {
                // empty if block
            }
            throw new IllegalArgumentException(MessageFormat.format(Gettext._("Can't wrap {0} in an unqualified Variant ({1})."), string, dBusException.getMessage()));
        }
        this.o = t;
    }

    public T getValue() {
        return this.o;
    }

    public Type getType() {
        return this.type;
    }

    public String getSig() {
        return this.sig;
    }

    public String toString() {
        return "[" + this.o + "]";
    }

    public boolean equals(Object object) {
        if (null == object) {
            return false;
        }
        if (!(object instanceof Variant)) {
            return false;
        }
        return this.o.equals(((Variant)object).o);
    }
}

