/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.extraction;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.packagecontroller.AbstractPackageChildrenNode;
import jd.plugins.DownloadLink;
import org.appwork.shutdown.ShutdownController;
import org.appwork.shutdown.ShutdownEvent;
import org.appwork.shutdown.ShutdownRequest;
import org.appwork.storage.JSonStorage;
import org.appwork.utils.Application;
import org.appwork.utils.Hash;
import org.appwork.utils.IO;
import org.appwork.utils.logging2.LogSource;
import org.jdownloader.extensions.extraction.Archive;
import org.jdownloader.extensions.extraction.ArchiveFactory;
import org.jdownloader.extensions.extraction.ArchiveFile;
import org.jdownloader.extensions.extraction.ArchiveSettings;
import org.jdownloader.extensions.extraction.BooleanStatus;
import org.jdownloader.extensions.extraction.bindings.crawledlink.CrawledLinkArchiveFile;
import org.jdownloader.extensions.extraction.bindings.downloadlink.DownloadLinkArchiveFile;
import org.jdownloader.logging.LogController;

public class ArchiveController {
    private static final ArchiveController INSTANCE = new ArchiveController();
    private final HashMap<String, ArchiveSettings> map = new HashMap();
    private final LogSource logger = LogController.getInstance().getLogger(ArchiveController.class.getName());

    public static ArchiveController getInstance() {
        return INSTANCE;
    }

    private ArchiveController() {
        ShutdownController.getInstance().addShutdownEvent(new ShutdownEvent(){
            {
                this.setHookPriority(2147483548);
                this.setMaxDuration(180000L);
            }

            public void onShutdown(ShutdownRequest shutdownRequest) {
                ArchiveController.this.save();
            }

            public String toString() {
                return "ShutdownEvent: Save ArchiveController";
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void save() {
        HashMap<String, ArchiveSettings> hashMap = this.map;
        synchronized (hashMap) {
            for (Map.Entry<String, ArchiveSettings> e : this.map.entrySet()) {
                try {
                    File path = this.getPathByID(e.getKey());
                    ArchiveSettings settings = e.getValue();
                    Boolean exists = settings._exists();
                    if (exists == null) {
                        // empty if block
                    }
                    if (Boolean.FALSE.equals(exists)) {
                        if (path.isFile()) {
                            this.logger.info("Archive (" + settings._getArchiveID() + "/" + path + ") no longer exists: removed:" + path.delete());
                            continue;
                        }
                        this.logger.info("Archive (" + settings._getArchiveID() + "/" + path + ") no longer exists");
                        continue;
                    }
                    if (settings._needsSaving()) {
                        this.logger.info("Archive (" + settings._getArchiveID() + "/" + path + ") " + (exists == null ? "maybe" : "still") + " exits and changes must be saved");
                        IO.secureWrite((File)path, (byte[])JSonStorage.serializeToJson((Object)e.getValue()).getBytes("UTF-8"));
                        continue;
                    }
                    this.logger.info("Archive (" + settings._getArchiveID() + "/" + path + ") " + (exists == null ? "maybe" : "still") + " exits but no changes");
                }
                catch (Throwable e1) {
                    this.logger.log(e1);
                }
            }
        }
    }

    protected File getPathByID(String internalID) {
        return Application.getResource((String)("cfg/archives/v2_" + internalID + ".json"));
    }

    public ArchiveSettings getArchiveSettings(String archiveID, ArchiveFactory archiveFactory) {
        return this.getArchiveSettings(archiveID, null, archiveFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArchiveSettings getArchiveSettings(String archiveID, Archive archive, ArchiveFactory archiveFactory) {
        if (archiveID != null) {
            HashMap<String, ArchiveSettings> hashMap = this.map;
            synchronized (hashMap) {
                String internalID = Hash.getSHA256((String)archiveID);
                ArchiveSettings ret = this.map.get(internalID);
                if (ret != null) {
                    return ret;
                }
                ret = this.createSettingsObject(archiveID, internalID, archiveFactory != null && archiveFactory.isDeepExtraction());
                if (archiveFactory != null) {
                    BooleanStatus defaultAuto = BooleanStatus.get(archiveFactory.getDefaultAutoExtract());
                    if (BooleanStatus.UNSET.equals((Object)ret.getAutoExtract()) && !ret.getAutoExtract().equals((Object)defaultAuto)) {
                        ret.setAutoExtract(defaultAuto);
                    }
                }
                if (archive != null) {
                    ret._getAssignedLinks().size();
                    for (ArchiveFile archiveFile : archive.getArchiveFiles()) {
                        if (archiveFile instanceof DownloadLinkArchiveFile) {
                            for (DownloadLink downloadLink : ((DownloadLinkArchiveFile)archiveFile).getDownloadLinks()) {
                                ret._getAssignedLinks().put((AbstractPackageChildrenNode<?>)downloadLink, null);
                            }
                            continue;
                        }
                        if (!(archiveFile instanceof CrawledLinkArchiveFile)) continue;
                        for (CrawledLink crawledLink : ((CrawledLinkArchiveFile)archiveFile).getLinks()) {
                            DownloadLink downloadLink = crawledLink.getDownloadLink();
                            if (downloadLink != null) {
                                ret._getAssignedLinks().put((AbstractPackageChildrenNode<?>)downloadLink, null);
                            }
                            ret._getAssignedLinks().put((AbstractPackageChildrenNode<?>)crawledLink, null);
                        }
                    }
                }
                this.map.put(internalID, ret);
                return ret;
            }
        }
        return null;
    }

    private ArchiveSettings createSettingsObject(String archiveID, String internalID, boolean isDeepExtract) {
        if (isDeepExtract) {
            ArchiveSettings instance = new ArchiveSettings(){

                @Override
                public boolean _needsSaving() {
                    return false;
                }
            };
            instance.assignController(this, archiveID, internalID);
            return instance;
        }
        try {
            File path = this.getPathByID(internalID);
            if (path.exists()) {
                ArchiveSettings instance = (ArchiveSettings)JSonStorage.restoreFromString((String)IO.readFileToString((File)path), ArchiveSettings.TYPE_REF);
                instance.assignController(this, archiveID, internalID);
                return instance;
            }
        }
        catch (Throwable e) {
            this.logger.log(e);
        }
        ArchiveSettings instance = new ArchiveSettings();
        instance.assignController(this, archiveID, internalID);
        return instance;
    }

    public void update(ArchiveSettings archiveSettings) {
    }
}

