/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.extraction;

import java.io.File;
import jd.plugins.DownloadLink;
import org.jdownloader.extensions.extraction.ArchiveFile;
import org.jdownloader.extensions.extraction.MissingArchiveFile;
import org.jdownloader.extensions.extraction.bindings.crawledlink.CrawledLinkArchiveFile;
import org.jdownloader.extensions.extraction.bindings.downloadlink.DownloadLinkArchiveFile;
import org.jdownloader.extensions.extraction.bindings.file.FileArchiveFile;

public class DummyArchiveFile {
    private final String name;
    private final boolean missing;
    private final ArchiveFile archiveFile;

    public ArchiveFile getArchiveFile() {
        return this.archiveFile;
    }

    public Boolean isIncomplete() {
        if (this.archiveFile == null) {
            return Boolean.TRUE;
        }
        Boolean complete = this.archiveFile.isComplete();
        if (complete == null) {
            return null;
        }
        return complete != false ? Boolean.FALSE : Boolean.TRUE;
    }

    public boolean isMissing() {
        return this.missing;
    }

    public DummyArchiveFile(String miss, File folder) {
        this.name = miss;
        this.missing = true;
        this.archiveFile = null;
    }

    public String toString() {
        if (this.archiveFile != null) {
            return this.archiveFile.toString();
        }
        return this.name;
    }

    public DummyArchiveFile(ArchiveFile af) {
        this.name = af.getName();
        this.missing = af instanceof MissingArchiveFile;
        this.archiveFile = af;
    }

    public String getName() {
        return this.name;
    }

    public DownloadLink.AvailableStatus getOnlineStatus() {
        if (this.archiveFile != null) {
            if (this.archiveFile instanceof CrawledLinkArchiveFile) {
                return ((CrawledLinkArchiveFile)this.archiveFile).getAvailableStatus();
            }
            if (this.archiveFile instanceof DownloadLinkArchiveFile) {
                return ((DownloadLinkArchiveFile)this.archiveFile).getAvailableStatus();
            }
            if (this.archiveFile instanceof FileArchiveFile) {
                if (((FileArchiveFile)this.archiveFile).exists()) {
                    return DownloadLink.AvailableStatus.TRUE;
                }
                return DownloadLink.AvailableStatus.FALSE;
            }
        }
        return DownloadLink.AvailableStatus.UNCHECKED;
    }

    public boolean isLocalFileAvailable() {
        return this.archiveFile != null && this.archiveFile.exists();
    }
}

