/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.extraction;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.appwork.utils.StringUtils;
import org.appwork.utils.logging2.LogSource;
import org.jdownloader.extensions.extraction.Archive;
import org.jdownloader.extensions.extraction.ArchiveFactory;
import org.jdownloader.extensions.extraction.ArchiveFile;
import org.jdownloader.extensions.extraction.DummyArchive;
import org.jdownloader.extensions.extraction.ExtractionConfig;
import org.jdownloader.extensions.extraction.ExtractionController;
import org.jdownloader.extensions.extraction.ExtractionException;
import org.jdownloader.extensions.extraction.ExtractionExtension;
import org.jdownloader.extensions.extraction.multi.ArchiveException;
import org.jdownloader.extensions.extraction.multi.CheckException;

public abstract class IExtraction {
    private ExtractionController controller;
    protected LogSource logger;
    private ExtractionConfig config;
    private Exception exception;
    private ArchiveFile lastAccessedArchiveFile;
    private List<Matcher> filters = new ArrayList<Matcher>();

    protected void initFilters() {
        String[] patternStrings = this.getConfig().getBlacklistPatterns();
        ArrayList<Matcher> filters = new ArrayList<Matcher>();
        if (patternStrings != null && patternStrings.length > 0) {
            for (String patternString : patternStrings) {
                try {
                    if (!StringUtils.isNotEmpty((String)patternString) || patternString.startsWith("##")) continue;
                    filters.add(Pattern.compile(patternString).matcher(""));
                }
                catch (Throwable e) {
                    this.getLogger().log(e);
                }
            }
        }
        this.filters = filters;
    }

    protected Matcher isFiltered(String path) {
        String check = "/".concat(path);
        for (Matcher regex : this.filters) {
            try {
                if (!regex.reset(check).matches()) continue;
                return regex;
            }
            catch (Throwable e) {
                this.getLogger().log(e);
            }
        }
        return null;
    }

    public void setLastAccessedArchiveFile(ArchiveFile lastAccessedArchiveFile) {
        this.lastAccessedArchiveFile = lastAccessedArchiveFile;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    protected final void setExtractionController(ExtractionController controller) {
        this.controller = controller;
    }

    protected final ExtractionController getExtractionController() {
        return this.controller;
    }

    public final void setConfig(ExtractionConfig extractionConfig) {
        this.config = extractionConfig;
    }

    public final ExtractionConfig getConfig() {
        return this.config;
    }

    public final void setLogger(LogSource logger) {
        this.logger = logger;
    }

    public final LogSource getLogger() {
        return this.logger;
    }

    public abstract Archive buildArchive(ArchiveFactory var1, boolean var2) throws ArchiveException;

    public abstract boolean findPassword(ExtractionController var1, String var2, boolean var3) throws ExtractionException;

    public abstract void extract(ExtractionController var1);

    public abstract boolean isAvailable(ExtractionExtension var1);

    public abstract int getCrackProgress();

    public abstract boolean prepare() throws ExtractionException;

    public abstract Boolean isSupported(ArchiveFactory var1, boolean var2);

    public abstract void close();

    public abstract DummyArchive checkComplete(Archive var1) throws CheckException;

    public ArchiveFile getLastAccessedArchiveFile() {
        return this.lastAccessedArchiveFile;
    }
}

