/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.extraction.bindings.downloadlink;

import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import jd.controlling.downloadcontroller.DownloadController;
import jd.controlling.downloadcontroller.DownloadWatchDog;
import jd.controlling.packagecontroller.AbstractPackageNode;
import jd.plugins.DownloadLink;
import jd.plugins.DownloadLinkProperty;
import jd.plugins.FilePackage;
import jd.plugins.FilePackageView;
import jd.plugins.LinkInfo;
import jd.plugins.PluginProgress;
import org.appwork.utils.StringUtils;
import org.appwork.utils.event.queue.QueueAction;
import org.appwork.utils.logging2.LogSource;
import org.jdownloader.controlling.FileCreationManager;
import org.jdownloader.controlling.FileStateManager;
import org.jdownloader.extensions.extraction.Archive;
import org.jdownloader.extensions.extraction.ArchiveFile;
import org.jdownloader.extensions.extraction.ExtractionController;
import org.jdownloader.extensions.extraction.ExtractionProgress;
import org.jdownloader.extensions.extraction.ExtractionStatus;
import org.jdownloader.plugins.FinalLinkState;
import org.jdownloader.plugins.SkipReason;
import org.jdownloader.settings.CleanAfterDownloadAction;
import org.jdownloader.settings.staticreferences.CFG_GENERAL;

public class DownloadLinkArchiveFile
implements ArchiveFile {
    private final List<DownloadLink> downloadLinks;
    private final String name;
    private final String filePath;
    private volatile long size;
    private final int hashCode;
    private final AtomicReference<Boolean> exists = new AtomicReference<Object>(null);
    private boolean fileArchiveFileExists = false;
    private volatile ExtractionStatus status = null;

    public boolean isFileArchiveFileExists() {
        return this.fileArchiveFileExists;
    }

    public void setFileArchiveFileExists(boolean fileArchiveFileExists) {
        if (fileArchiveFileExists) {
            this.fileArchiveFileExists = true;
            this.setExists(true);
        } else {
            this.invalidateExists();
        }
    }

    @Override
    public LinkInfo getLinkInfo() {
        return this.getDownloadLinks().get(0).getLinkInfo();
    }

    public DownloadLinkArchiveFile(DownloadLink link) {
        this.downloadLinks = new CopyOnWriteArrayList<DownloadLink>();
        this.downloadLinks.add(link);
        this.filePath = link.getFileOutput(false, true);
        this.name = new File(this.getFilePath()).getName();
        this.size = link.getView().getBytesTotalEstimated();
        this.hashCode = (this.getClass() + this.name).hashCode();
    }

    public String toString() {
        return "DownloadLink:" + this.getFilePath() + "|Complete:" + this.isComplete();
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean contains(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null) {
            if (obj instanceof String) {
                return this.getFilePath().equals(obj);
            }
            if (obj instanceof ArchiveFile && StringUtils.equals((String)this.getFilePath(), (String)((ArchiveFile)obj).getFilePath())) {
                return true;
            }
            if (obj instanceof DownloadLinkArchiveFile) {
                for (DownloadLink dl : ((DownloadLinkArchiveFile)obj).getDownloadLinks()) {
                    if (!this.getDownloadLinks().contains(dl)) continue;
                    return true;
                }
            } else if (obj instanceof DownloadLink && this.getDownloadLinks().contains(obj)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Boolean isComplete() {
        if (this.isFileArchiveFileExists() && this.exists()) {
            return Boolean.TRUE;
        }
        for (DownloadLink downloadLink : this.getDownloadLinks()) {
            if (!SkipReason.FILE_EXISTS.equals((Object)downloadLink.getSkipReason()) && !FinalLinkState.FAILED_EXISTS.equals((Object)downloadLink.getFinalLinkState()) && !FinalLinkState.CheckFinished((FinalLinkState)downloadLink.getFinalLinkState())) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public String getFilePath() {
        return this.filePath;
    }

    @Override
    public void deleteFile(FileCreationManager.DeleteOption option) {
        DownloadWatchDog.getInstance().delete(new ArrayList<DownloadLink>(this.getDownloadLinks()), option, true);
        this.setFileArchiveFileExists(false);
    }

    public List<DownloadLink> getDownloadLinks() {
        return this.downloadLinks;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setStatus(ExtractionController controller, ExtractionStatus status) {
        this.status = status;
        for (DownloadLink downloadLink : this.getDownloadLinks()) {
            PluginProgress progress;
            if (FilePackage.isDefaultFilePackage((AbstractPackageNode)downloadLink.getFilePackage())) continue;
            downloadLink.setExtractionStatus(status);
            if (status == null || (progress = downloadLink.getPluginProgress()) == null || !(progress instanceof ExtractionProgress)) continue;
            ((ExtractionProgress)progress).setMessage(status.getExplanation());
        }
    }

    @Override
    public ExtractionStatus getStatus() {
        ExtractionStatus status = this.status;
        if (status != null) {
            return status;
        }
        String archiveID = this.getArchiveID();
        for (DownloadLink downloadLink : this.getDownloadLinks()) {
            if (!StringUtils.equals((String)archiveID, (String)downloadLink.getArchiveID()) || (status = downloadLink.getExtractionStatus()) == null) continue;
            return status;
        }
        return ExtractionStatus.NA;
    }

    @Override
    public void setMessage(ExtractionController controller, String text) {
        for (DownloadLink downloadLink : this.getDownloadLinks()) {
            PluginProgress progress;
            if (FilePackage.isDefaultFilePackage((AbstractPackageNode)downloadLink.getFilePackage()) || (progress = downloadLink.getPluginProgress()) == null || !(progress instanceof ExtractionProgress)) continue;
            ((ExtractionProgress)progress).setMessage(text);
        }
    }

    @Override
    public void setProgress(ExtractionController controller, long value, long max, Color color) {
        ExtractionProgress progress = controller.getExtractionProgress();
        progress.updateValues(value, max);
        progress.setColor(color);
        for (DownloadLink downloadLink : this.getDownloadLinks()) {
            FilePackageView view;
            if (FilePackage.isDefaultFilePackage((AbstractPackageNode)downloadLink.getFilePackage())) continue;
            if (value <= 0L && max <= 0L) {
                downloadLink.addPluginProgress((PluginProgress)progress);
                continue;
            }
            if (!downloadLink.hasPluginProgress((PluginProgress)progress)) {
                downloadLink.addPluginProgress((PluginProgress)progress);
            }
            if (downloadLink.getPluginProgress() != progress || (view = downloadLink.getParentNode().getView()) == null) continue;
            view.requestUpdate();
        }
    }

    @Override
    public long getFileSize() {
        if (this.exists()) {
            return Math.max(new File(this.getFilePath()).length(), this.size);
        }
        return Math.max(0L, this.size);
    }

    public void addMirror(DownloadLink link) {
        this.getDownloadLinks().add(link);
        this.size = Math.max(link.getView().getBytesTotal(), this.size);
    }

    public DownloadLink.AvailableStatus getAvailableStatus() {
        DownloadLink.AvailableStatus ret = null;
        for (DownloadLink downloadLink : this.getDownloadLinks()) {
            switch (downloadLink.getAvailableStatus()) {
                case TRUE: {
                    return downloadLink.getAvailableStatus();
                }
                case UNCHECKED: {
                    ret = DownloadLink.AvailableStatus.UNCHECKED;
                    break;
                }
                case UNCHECKABLE: {
                    if (ret == DownloadLink.AvailableStatus.UNCHECKED) break;
                    ret = DownloadLink.AvailableStatus.UNCHECKABLE;
                    break;
                }
                case FALSE: {
                    if (ret != null) break;
                    ret = DownloadLink.AvailableStatus.FALSE;
                }
            }
        }
        return ret;
    }

    @Override
    public void onCleanedUp(final ExtractionController controller) {
        if (controller.isSuccessful()) {
            List<ExtractionController> controllers = controller.getExtension().getExtractionControllers(controller.getArchive().getFactory());
            if (controllers.size() > 1 || controllers.size() == 1 && controllers.get(0) != controller) {
                controller.getLogger().info("skip cleanup of " + this.getName() + " because there are other controllers sharing same archive files!");
                return;
            }
            final CleanAfterDownloadAction cleanupCFG = CFG_GENERAL.CFG.getCleanupAfterDownloadAction();
            final CleanAfterDownloadAction cleanup = controller.getExtension().isRemoveDownloadLinksAfterExtractEnabled(controller.getArchive()) ? CleanAfterDownloadAction.CLEANUP_IMMEDIATELY : cleanupCFG;
            switch (cleanup) {
                case CLEANUP_IMMEDIATELY: {
                    DownloadController.getInstance().getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

                        protected Void run() throws RuntimeException {
                            ArrayList<DownloadLink> ask = new ArrayList<DownloadLink>();
                            for (DownloadLink downloadLink : DownloadLinkArchiveFile.this.getDownloadLinks()) {
                                if (DownloadController.getInstance() != downloadLink.getFilePackage().getControlledBy()) continue;
                                ask.add(downloadLink);
                            }
                            if (ask.size() > 0) {
                                List response = DownloadController.getInstance().askForRemoveVetos((Object)controller, ask);
                                if (response.size() > 0) {
                                    for (DownloadLink downloadLink : response) {
                                        controller.getLogger().info(cleanup + ":" + cleanupCFG + ":" + downloadLink.getView().getDisplayName() + "|" + downloadLink.getHost());
                                    }
                                    DownloadController.getInstance().removeChildren(response);
                                    DownloadLinkArchiveFile.this.invalidateExists();
                                }
                                ask.removeAll(response);
                                for (DownloadLink downloadLink : ask) {
                                    controller.getLogger().info(cleanup + ":" + cleanupCFG + ":" + downloadLink.getView().getDisplayName() + "|" + downloadLink.getHost() + " failed because of removeVetos!");
                                }
                            }
                            return null;
                        }
                    });
                    break;
                }
                case CLEANUP_AFTER_PACKAGE_HAS_FINISHED: {
                    DownloadController.getInstance().getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

                        protected Void run() throws RuntimeException {
                            HashSet<FilePackage> fps = new HashSet<FilePackage>();
                            for (DownloadLink downloadLink : DownloadLinkArchiveFile.this.getDownloadLinks()) {
                                if (DownloadController.getInstance() != downloadLink.getFilePackage().getControlledBy()) continue;
                                fps.add(downloadLink.getFilePackage());
                            }
                            for (FilePackage fp : fps) {
                                DownloadController.removePackageIfFinished((Object)((Object)controller), (LogSource)controller.getLogger(), (FilePackage)fp);
                            }
                            DownloadLinkArchiveFile.this.invalidateExists();
                            return null;
                        }
                    });
                    break;
                }
                case CLEANUP_ONCE_AT_STARTUP: 
                case NEVER: {
                    controller.getLogger().info(cleanupCFG + ":" + this.getName());
                }
            }
        }
    }

    @Override
    public void setArchive(Archive archive) {
        if (archive != null) {
            String archiveID = archive.getArchiveID();
            boolean mergeSourcePasswords = false;
            for (DownloadLink downloadLink : this.getDownloadLinks()) {
                downloadLink.setArchiveID(archiveID);
                if (downloadLink.getSourcePluginPasswordList() == null) continue;
                mergeSourcePasswords = true;
            }
            if (mergeSourcePasswords) {
                List<String> existingPasswords = archive.getSettings().getPasswords();
                ArrayList<String> newPasswords = new ArrayList<String>();
                String finalPassword = archive.getSettings().getFinalPassword();
                if (StringUtils.isNotEmpty((String)finalPassword) && (existingPasswords == null || !existingPasswords.contains(finalPassword))) {
                    newPasswords.add(finalPassword);
                }
                for (DownloadLink downloadLink : this.getDownloadLinks()) {
                    List sourcePluginPasswords = downloadLink.getSourcePluginPasswordList();
                    if (sourcePluginPasswords == null) continue;
                    for (String sourcePluginPassword : sourcePluginPasswords) {
                        if (!StringUtils.isNotEmpty((String)sourcePluginPassword) || existingPasswords != null && existingPasswords.contains(sourcePluginPassword)) continue;
                        newPasswords.add(sourcePluginPassword);
                    }
                }
                if (newPasswords.size() > 0) {
                    if (existingPasswords != null) {
                        newPasswords.addAll(existingPasswords);
                    }
                    archive.getSettings().setPasswords(newPasswords);
                }
            }
        }
    }

    @Override
    public String getArchiveID() {
        List<DownloadLink> links = this.getDownloadLinks();
        if (links.size() == 0) {
            return null;
        }
        if (links.size() == 1) {
            return links.get(0).getArchiveID();
        }
        HashMap<String, ArchiveFile.ArchiveID> scores = new HashMap<String, ArchiveFile.ArchiveID>();
        for (DownloadLink downloadLink : this.getDownloadLinks()) {
            String archiveID = downloadLink.getArchiveID();
            if (archiveID == null) continue;
            ArchiveFile.ArchiveID score = (ArchiveFile.ArchiveID)scores.get(archiveID);
            if (score == null) {
                score = new ArchiveFile.ArchiveID(archiveID);
                scores.put(archiveID, score);
            }
            score.increaseScore();
        }
        if (scores.size() == 0) {
            return null;
        }
        if (scores.size() == 1) {
            return ((ArchiveFile.ArchiveID)scores.values().iterator().next()).getArchiveID();
        }
        ArchiveFile.ArchiveID ret = null;
        for (ArchiveFile.ArchiveID score : scores.values()) {
            if (ret != null && ret.getScore() >= score.getScore()) continue;
            ret = score;
        }
        return ret.getArchiveID();
    }

    @Override
    public boolean exists() {
        return this.exists(false);
    }

    @Override
    public boolean exists(boolean ignoreCache) {
        Boolean ret;
        File file = new File(this.getFilePath());
        if (FileStateManager.getInstance().hasFileState(file, FileStateManager.FILESTATE.WRITE_EXCLUSIVE)) {
            return false;
        }
        Boolean bl = ret = ignoreCache ? null : this.exists.get();
        if (ret == null) {
            ret = file.isFile();
            this.exists.compareAndSet(null, ret);
        }
        return ret;
    }

    protected void setExists(boolean b) {
        this.exists.set(b);
    }

    @Override
    public void notifyChanges(Object type) {
        for (DownloadLink link : this.getDownloadLinks()) {
            link.firePropertyChanged(DownloadLinkProperty.Property.ARCHIVE, type);
        }
    }

    @Override
    public void removePluginProgress(ExtractionController controller) {
        for (DownloadLink downloadLink : this.getDownloadLinks()) {
            downloadLink.removePluginProgress((PluginProgress)controller.getExtractionProgress());
        }
    }

    @Override
    public void invalidateExists() {
        this.fileArchiveFileExists = false;
        this.exists.set(null);
    }

    @Override
    public void setPartOfAnArchive(Boolean b) {
        for (DownloadLink link : this.getDownloadLinks()) {
            link.setPartOfAnArchive(b);
        }
    }

    @Override
    public Boolean isPartOfAnArchive() {
        Boolean ret = null;
        for (DownloadLink link : this.getDownloadLinks()) {
            Boolean newRet = link.isPartOfAnArchive();
            if (newRet == null) continue;
            if (Boolean.TRUE.equals(newRet)) {
                return newRet;
            }
            if (ret != null) continue;
            ret = newRet;
        }
        return ret;
    }
}

