/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.extraction.bindings.file;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import jd.plugins.DownloadLink;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.Application;
import org.appwork.utils.StringUtils;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.appwork.utils.os.CrossSystem;
import org.jdownloader.extensions.extraction.Archive;
import org.jdownloader.extensions.extraction.ArchiveFactory;
import org.jdownloader.extensions.extraction.ArchiveFile;
import org.jdownloader.extensions.extraction.BooleanStatus;
import org.jdownloader.extensions.extraction.bindings.downloadlink.DownloadLinkArchiveFactory;
import org.jdownloader.extensions.extraction.bindings.file.FileArchiveFactoryNIO;
import org.jdownloader.extensions.extraction.bindings.file.FileArchiveFile;
import org.jdownloader.extensions.extraction.multi.ArchiveType;
import org.jdownloader.extensions.extraction.split.SplitType;
import org.jdownloader.settings.GeneralSettings;

public class FileArchiveFactory
extends FileArchiveFile
implements ArchiveFactory {
    private final Archive origin;

    public FileArchiveFactory(File archiveStartFile) {
        this(archiveStartFile, null);
    }

    public FileArchiveFactory(File archiveStartFile, Archive origin) {
        super(archiveStartFile);
        this.origin = origin;
    }

    @Override
    public boolean isDeepExtraction() {
        return this.origin != null;
    }

    protected List<File> findFiles(Pattern pattern, File directory) {
        String[] directoryFiles;
        if (Application.getJavaVersion() >= Application.JAVA17) {
            try {
                return FileArchiveFactoryNIO.findFiles(pattern, directory);
            }
            catch (IOException e) {
                LoggerFactory.getDefaultLogger().log((Throwable)e);
            }
        }
        ArrayList<File> ret = new ArrayList<File>();
        if (pattern != null && directory != null && directory.isDirectory() && (directoryFiles = directory.list()) != null) {
            String absoluteDirectoryPath = directory.getAbsolutePath();
            for (String directoryFile : directoryFiles) {
                File dFile;
                String directoryFilePath = absoluteDirectoryPath + File.separator + directoryFile;
                if (!pattern.matcher(directoryFilePath).matches() || !(dFile = new File(directory, directoryFile)).isFile()) continue;
                ret.add(dFile);
            }
        }
        return ret;
    }

    @Override
    public List<ArchiveFile> createPartFileList(String file, String patternString) {
        Pattern pattern = Pattern.compile(patternString, CrossSystem.isWindows() ? 2 : 0);
        ArrayList<ArchiveFile> ret = new ArrayList<ArchiveFile>();
        for (File foundFile : this.findFiles(pattern, this.getFile().getParentFile())) {
            ret.add(new FileArchiveFile(foundFile));
        }
        return ret;
    }

    @Override
    public Archive createArchive(SplitType splitType) {
        if (this.origin == null) {
            return new Archive((ArchiveFactory)this, splitType);
        }
        return new Archive(this, splitType){

            @Override
            public Archive getParentArchive() {
                return FileArchiveFactory.this.origin;
            }
        };
    }

    @Override
    public Archive createArchive(ArchiveType archiveType) {
        if (this.origin == null) {
            return new Archive((ArchiveFactory)this, archiveType);
        }
        return new Archive(this, archiveType){

            @Override
            public Archive getParentArchive() {
                return FileArchiveFactory.this.origin;
            }
        };
    }

    @Override
    public Collection<? extends String> getGuessedPasswordList(Archive archive) {
        HashSet<String> ret = new HashSet<String>();
        ret.add(new File(archive.getArchiveFiles().get(0).getFilePath()).getName());
        return ret;
    }

    @Override
    public void fireArchiveAddedToQueue(Archive archive) {
    }

    @Override
    public String createDefaultExtractToPath(Archive archive) {
        return this.getFile().getParent();
    }

    @Override
    public String createExtractSubPath(String path, Archive archiv) {
        try {
            String ret;
            DownloadLink downloadLink = DownloadLinkArchiveFactory.getFirstDownloadLinkPart(archiv);
            if (downloadLink != null && (ret = new DownloadLinkArchiveFactory(downloadLink).createExtractSubPath(path, archiv)) != null) {
                return ret;
            }
        }
        catch (Throwable downloadLink) {
            // empty catch block
        }
        ArchiveFile firstArchiveFile = archiv.getArchiveFiles().get(0);
        try {
            String dif;
            if (path.contains("%PACKAGENAME%")) {
                path = path.replace("%PACKAGENAME%", "");
                LoggerFactory.getDefaultLogger().severe("Could not set packagename for " + firstArchiveFile.getFilePath());
            }
            if (path.contains("%ARCHIVENAME%")) {
                if (!StringUtils.isEmpty((String)archiv.getName())) {
                    path = path.replace("%ARCHIVENAME%", archiv.getName());
                } else {
                    path = path.replace("%ARCHIVENAME%", "");
                    LoggerFactory.getDefaultLogger().severe("Could not set archivename for " + firstArchiveFile.getFilePath());
                }
            }
            if (path.contains("%HOSTER%")) {
                path = path.replace("%HOSTER%", "");
                LoggerFactory.getDefaultLogger().severe("Could not set hoster for " + firstArchiveFile.getFilePath());
            }
            if (path.contains("$DATE:")) {
                int end;
                int start = path.indexOf("$DATE:");
                for (end = start + 6; end < path.length() && path.charAt(end) != '$'; ++end) {
                }
                try {
                    SimpleDateFormat format = new SimpleDateFormat(path.substring(start + 6, end));
                    path = path.replace(path.substring(start, end + 1), format.format(new Date()));
                }
                catch (Exception e) {
                    path = path.replace(path.substring(start, end + 1), "");
                    LoggerFactory.getDefaultLogger().severe("Could not set extraction date. Maybe pattern is wrong. For " + firstArchiveFile.getFilePath());
                }
            }
            if (new File(dif = new File(((GeneralSettings)JsonConfig.create(GeneralSettings.class)).getDefaultDownloadFolder()).getAbsolutePath().replace(this.getFile().getParent(), "")).isAbsolute()) {
                dif = "";
            }
            path = path.replace("%SUBFOLDER%", dif);
            return CrossSystem.fixPathSeparators((String)path);
        }
        catch (Exception e) {
            LoggerFactory.getDefaultLogger().log((Throwable)e);
            return null;
        }
    }

    @Override
    public File toFile(String path) {
        return new File(path);
    }

    @Override
    public File getFolder() {
        return this.getFile().getParentFile();
    }

    @Override
    public BooleanStatus getDefaultAutoExtract() {
        return BooleanStatus.UNSET;
    }
}

