/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.extraction.split;

import org.jdownloader.extensions.extraction.Archive;
import org.jdownloader.extensions.extraction.ArchiveFactory;
import org.jdownloader.extensions.extraction.ArchiveFile;
import org.jdownloader.extensions.extraction.DummyArchive;
import org.jdownloader.extensions.extraction.DummyArchiveFile;
import org.jdownloader.extensions.extraction.ExtractionController;
import org.jdownloader.extensions.extraction.ExtractionControllerException;
import org.jdownloader.extensions.extraction.ExtractionExtension;
import org.jdownloader.extensions.extraction.IExtraction;
import org.jdownloader.extensions.extraction.multi.ArchiveException;
import org.jdownloader.extensions.extraction.multi.CheckException;
import org.jdownloader.extensions.extraction.split.SplitType;
import org.jdownloader.extensions.extraction.split.SplitUtil;

public class UnixSplit
extends IExtraction {
    private final SplitType splitType = SplitType.UNIX_SPLIT;
    private final ExtractionExtension extension;

    public UnixSplit(ExtractionExtension extension) {
        this.extension = extension;
    }

    @Override
    public Archive buildArchive(ArchiveFactory link, boolean allowDeepInspection) throws ArchiveException {
        return SplitType.createArchive(link, this.splitType, allowDeepInspection);
    }

    @Override
    public boolean findPassword(ExtractionController controller, String password, boolean optimized) {
        return true;
    }

    @Override
    public void extract(ExtractionController ctrl) {
        Archive archive = this.getExtractionController().getArchive();
        ArchiveFile firstArchiveFile = archive.getArchiveFiles().get(0);
        String[] matches = this.splitType.getMatches(firstArchiveFile.getName());
        if (matches != null) {
            try {
                if (SplitUtil.merge(this.getExtractionController(), matches[0], 0, this.getConfig())) {
                    archive.setExitCode(0);
                } else if (archive.getExitCode() == -1) {
                    archive.setExitCode(2);
                }
                return;
            }
            catch (ExtractionControllerException e) {
                this.setException(e);
                archive.setExitCode(e.getExitCode());
            }
        } else {
            archive.setExitCode(2);
        }
    }

    @Override
    public boolean isAvailable(ExtractionExtension extractionExtension) {
        return true;
    }

    @Override
    public int getCrackProgress() {
        return 100;
    }

    @Override
    public boolean prepare() {
        return true;
    }

    @Override
    public void close() {
    }

    @Override
    public DummyArchive checkComplete(Archive archive) throws CheckException {
        if (archive.getSplitType() == this.splitType) {
            try {
                DummyArchive dummyArchive = new DummyArchive(archive, this.splitType);
                for (ArchiveFile archiveFile : archive.getArchiveFiles()) {
                    dummyArchive.add(new DummyArchiveFile(archiveFile));
                }
                if (dummyArchive.isComplete()) {
                    ArchiveFile firstFile = archive.getArchiveFiles().get(0);
                    String firstArchiveFile = firstFile.getFilePath();
                    String partNumberOfFirstArchiveFile = this.splitType.getPartNumberString(firstArchiveFile);
                    if (this.splitType.getFirstPartIndex() != this.splitType.getPartNumber(partNumberOfFirstArchiveFile)) {
                        throw new CheckException("Wrong firstArchiveFile(" + firstArchiveFile + ") for Archive(" + archive.getName() + ")");
                    }
                    SplitUtil.checkComplete(this.extension, archive, dummyArchive);
                }
                return dummyArchive;
            }
            catch (CheckException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new CheckException("Cannot check Archive(" + archive.getName() + ")", e);
            }
        }
        return null;
    }

    @Override
    public Boolean isSupported(ArchiveFactory factory, boolean allowDeepInspection) {
        if (this.splitType.matches(factory.getFilePath())) {
            try {
                Archive archive = SplitType.createArchive(factory, this.splitType, true);
                return archive != null;
            }
            catch (ArchiveException e) {
                this.getLogger().log((Throwable)e);
            }
        }
        return false;
    }
}

